/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import com.gensee.pdu.AbsAnno;

public class AnnoCircle
extends AbsAnno {
    private int color;
    private byte linesize;
    private int left;
    private int top;
    private int right;
    private int bottom;
    private Paint mPaint;

    public AnnoCircle() {
        this.setType(5);
    }

    @Override
    public void resetAnno(AbsAnno anno) {
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix) {
        if (canvas != null && matrix != null) {
            float tbottom;
            float ttop;
            float temp;
            if (this.mPaint == null) {
                if (this.argbColor == -1) {
                    this.argbColor = this.agbrToArgb(this.color);
                }
                this.mPaint = new Paint();
                this.mPaint.setColor(this.argbColor);
                this.mPaint.setStrokeWidth((float)this.linesize);
                this.mPaint.setAntiAlias(true);
                this.mPaint.setDither(true);
                this.mPaint.setStyle(Paint.Style.STROKE);
                this.mPaint.setStrokeJoin(Paint.Join.ROUND);
                this.mPaint.setStrokeCap(Paint.Cap.ROUND);
            }
            float[] values = new float[9];
            matrix.getValues(values);
            float tleft = this.getScaleX(this.left, values);
            float tright = this.getScaleX(this.right, values);
            if (tleft > tright) {
                temp = tleft;
                tleft = tright;
                tright = temp;
            }
            if ((ttop = this.getScaleY(this.top, values)) > (tbottom = this.getScaleY(this.bottom, values))) {
                temp = ttop;
                ttop = tbottom;
                tbottom = temp;
            }
            RectF oval = new RectF(tleft, ttop, tright, tbottom);
            canvas.drawOval(oval, this.mPaint);
        }
    }

    private float getScaleY(long yResource, float[] values) {
        return (float)yResource * values[4] + values[5];
    }

    private float getScaleX(long xResource, float[] values) {
        return (float)xResource * values[0] + values[2];
    }

    @Override
    public boolean contain(float x, float y) {
        float tl = this.left;
        float tt = this.top;
        float tr = this.right;
        float tb = this.bottom;
        if (this.left > this.right) {
            tl = this.right;
            tr = this.left;
        }
        if (this.top > this.bottom) {
            tt = this.bottom;
            tb = this.top;
        }
        if (x >= tl - 32.0f && x <= tr + 32.0f && y >= tt - 32.0f && y <= tb + 32.0f) {
            float cx = (tl + tr) / 2.0f;
            float cy = (tt + tb) / 2.0f;
            float dx = tr - tl;
            float dy = tb - tt;
            float a = dx / 2.0f;
            float b = dy / 2.0f;
            if (a <= 32.0f || b <= 32.0f) {
                return true;
            }
            return (x - cx) / (a - 32.0f) * ((x - cx) / (a - 32.0f)) + (y - cy) / (b - 32.0f) * ((y - cy) / (b - 32.0f)) > 1.0f && (x - cx) / (a + 32.0f) * ((x - cx) / (a + 32.0f)) + (y - cy) / (b + 32.0f) * ((y - cy) / (b + 32.0f)) < 1.0f;
        }
        return false;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int setArgbColor(int argb) {
        this.argbColor = argb;
        this.color = super.setArgbColor(argb);
        return this.color;
    }

    public byte getLinesize() {
        return this.linesize;
    }

    public void setLinesize(byte linesize) {
        this.linesize = linesize;
    }

    public int getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getRight() {
        return this.right;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public int getBottom() {
        return this.bottom;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnoCircle other = (AnnoCircle)obj;
        return this.id == other.id;
    }

    @Override
    public String toString() {
        return "AnnoCircle [id=" + this.id + ", filehandle=" + this.docId + ", blockhandle=" + this.pageId + ", owner=" + this.owner + ", color=" + this.color + ", linesize=" + this.linesize + ", left=" + this.left + ", top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + super.toString() + "]";
    }
}

