/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import com.gensee.pdu.AbsAnno;

public class AnnoPointer
extends AbsAnno {
    private static final int RADIUS = 15;
    protected long x;
    protected long y;

    public AnnoPointer() {
        this.setType(1);
    }

    public long getX() {
        return this.x;
    }

    public void setX(long x) {
        this.x = x;
    }

    public long getY() {
        return this.y;
    }

    public void setY(long y) {
        this.y = y;
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix) {
        float[] values = new float[9];
        matrix.getValues(values);
        long tx = (long)((float)this.x * values[0] + values[2]);
        long ty = (long)((float)this.y * values[4] + values[5]);
        tx += 15L;
        ty += 15L;
        Paint p = new Paint();
        p.setDither(true);
        p.setAntiAlias(true);
        p.setColor(-16776961);
        p.setStyle(Paint.Style.STROKE);
        p.setStrokeCap(Paint.Cap.ROUND);
        p.setStrokeWidth(4.0f);
        canvas.drawCircle((float)tx, (float)ty, 15.0f, p);
        canvas.drawLine((float)(tx - 20L), (float)ty, (float)(tx + 20L), (float)ty, p);
        canvas.drawLine((float)tx, (float)(ty - 20L), (float)tx, (float)(ty + 20L), p);
        p.setColor(-65536);
        p.setStyle(Paint.Style.FILL);
        canvas.drawCircle((float)tx, (float)ty, 7.0f, p);
    }

    @Override
    public boolean contain(float x, float y) {
        return (x - (float)this.x) * (x - (float)this.x) + (y - (float)this.y) * (y - (float)this.y) <= 225.0f;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnoPointer other = (AnnoPointer)obj;
        return this.id == other.id;
    }

    @Override
    public String toString() {
        return "AnnoPointer [id=" + this.id + ", filehandle=" + this.docId + ", blockhandle=" + this.pageId + ", owner=" + this.owner + ", x=" + this.x + ", y=" + this.y + super.toString() + "]";
    }
}

