/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import com.gensee.pdu.AnnoPointer;

public class AnnoPointerEx
extends AnnoPointer {
    public static final short ANNO_POINTER_HAND = 0;
    public static final short ANNO_POINTER_ARROW = 1;
    private static BitmapDrawable pointerCircleDrawable;
    private static BitmapDrawable pointerCrossDrawable;
    private byte pointerType;

    public AnnoPointerEx() {
        this.setType(9);
        this.pointerType = 1;
    }

    public byte getPointerType() {
        return this.pointerType;
    }

    public void setPointerType(byte pointerType) {
        this.pointerType = pointerType;
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix) {
        if (0 == this.pointerType) {
            this.drawDrawable(canvas, matrix, pointerCrossDrawable);
        } else {
            this.drawCrossDrawable(canvas, matrix, pointerCircleDrawable);
        }
    }

    private void drawDrawable(Canvas canvas, Matrix matrix, BitmapDrawable drawable) {
        if (drawable == null) {
            super.draw(canvas, matrix);
        } else {
            Bitmap bitmap = drawable.getBitmap();
            if (bitmap == null) {
                super.draw(canvas, matrix);
            } else {
                float[] values = new float[9];
                matrix.getValues(values);
                long tx = (long)((float)this.getX() * values[0] + values[2]);
                long ty = (long)((float)this.getY() * values[4] + values[5]);
                canvas.drawBitmap(bitmap, (float)(tx - (long)(bitmap.getWidth() / 2)), (float)(ty - (long)(bitmap.getHeight() / 2)), new Paint());
            }
        }
    }

    private void drawCrossDrawable(Canvas canvas, Matrix matrix, BitmapDrawable drawable) {
        if (drawable == null) {
            super.draw(canvas, matrix);
        } else {
            Bitmap bitmap = drawable.getBitmap();
            if (bitmap == null) {
                super.draw(canvas, matrix);
            } else {
                float[] values = new float[9];
                matrix.getValues(values);
                long tx = (long)((float)this.getX() * values[0] + values[2]);
                long ty = (long)((float)this.getY() * values[4] + values[5]);
                canvas.drawBitmap(bitmap, (float)tx, (float)ty, new Paint());
            }
        }
    }

    public static BitmapDrawable getPointerCircleDrawable() {
        return pointerCircleDrawable;
    }

    public static void setPointerCircleDrawable(BitmapDrawable pointerCircleDrawable) {
        AnnoPointerEx.pointerCircleDrawable = pointerCircleDrawable;
    }

    public static BitmapDrawable getPointerCrossDrawable() {
        return pointerCrossDrawable;
    }

    public static void setPointerCrossDrawable(BitmapDrawable pointerCrossDrawable) {
        AnnoPointerEx.pointerCrossDrawable = pointerCrossDrawable;
    }

    @Override
    public String toString() {
        return "AnnoPointerEx [pointerType=" + this.pointerType + " " + super.toString() + "]";
    }
}

