/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import com.gensee.pdu.AbsAnno;

public class AnnoRect
extends AbsAnno {
    private int color;
    private byte linesize;
    private int left;
    private int top;
    private int right;
    private int bottom;
    Paint mPaint;
    Path mPath;

    public AnnoRect() {
        this.setType(6);
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix) {
        if (this.mPaint == null) {
            if (this.argbColor == -1) {
                this.argbColor = this.agbrToArgb(this.color);
            }
            this.mPaint = new Paint();
            this.mPaint.setColor(this.argbColor);
            this.mPaint.setStrokeWidth((float)this.linesize);
            this.mPaint.setAntiAlias(true);
            this.mPaint.setDither(true);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeJoin(Paint.Join.ROUND);
            this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        }
        if (this.mPath == null) {
            this.mPath = new Path();
            this.mPath.moveTo((float)this.left, (float)this.top);
            this.mPath.lineTo((float)this.right, (float)this.top);
            this.mPath.lineTo((float)this.right, (float)this.bottom);
            this.mPath.lineTo((float)this.left, (float)this.bottom);
            this.mPath.close();
        }
        Path p = new Path(this.mPath);
        p.transform(matrix);
        canvas.drawPath(p, this.mPaint);
    }

    @Override
    public boolean contain(float x, float y) {
        int tl = this.left;
        int tt = this.top;
        int tr = this.right;
        int tb = this.bottom;
        if (this.left > this.right) {
            tl = this.right;
            tr = this.left;
        }
        if (this.top > this.bottom) {
            tt = this.bottom;
            tb = this.top;
        }
        if (x >= (float)tl - 32.0f && x <= (float)tl + 32.0f || x >= (float)tr - 32.0f && x <= (float)tr + 32.0f) {
            return y >= (float)tt && y <= (float)tb;
        }
        if (y >= (float)tt - 32.0f && y <= (float)tt + 32.0f || y >= (float)tb - 32.0f && y <= (float)tb + 32.0f) {
            return x >= (float)tl && x <= (float)tr;
        }
        return false;
    }

    @Override
    public void setPath(Path p) {
        this.mPath = p;
    }

    public long getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public int setArgbColor(int argb) {
        this.argbColor = argb;
        this.color = super.setArgbColor(argb);
        return this.color;
    }

    public short getLinesize() {
        return this.linesize;
    }

    public void setLinesize(byte linesize) {
        this.linesize = linesize;
    }

    public long getLeft() {
        return this.left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getRight() {
        return this.right;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public int getBottom() {
        return this.bottom;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnoRect other = (AnnoRect)obj;
        return this.id == other.id;
    }

    @Override
    public String toString() {
        return "AnnoRect [color=" + this.color + ", linesize=" + this.linesize + ", left=" + this.left + ", top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + ", mPaint=" + this.mPaint + ", mPath=" + this.mPath + "," + super.toString() + "]";
    }
}

