/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.pdu;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.Environment;
import com.gensee.pdu.AbsAnno;
import com.gensee.pdu.AnnoCleaner;
import com.gensee.pdu.AnnoFreepenEx;
import com.gensee.pdu.PduBase;
import com.gensee.utils.GenseeLog;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class PduPage
extends PduBase {
    public static final int RT_SDK_TYPE = 0;
    public static final int PLAYER_SDK_TYPE = 1;
    public static final int VOD_SDK_TYPE = 2;
    public static final int ANNO_SUCCESS = 0;
    public static final int ANNO_FAILURE = -1;
    public static final int ANNO_REPLACE = 1;
    public static final String FILE_DIR = Environment.getExternalStorageDirectory().getPath() + "/gensee/rtsdk/";
    private static final String TAG = "PduPage";
    public static final int SHOW_NONE = 0;
    public static final int SHOW_SOURCE = 1;
    public static final int SHOW_ADAPT = 2;
    private static String fileDir;
    private int nSdkType = 0;
    private SoftReference<Bitmap> reference;
    private String path = null;
    private String animationPath = null;
    private String pageName;
    private int pageId;
    private int docId;
    private char imgBitCount;
    private short imgWidth;
    private short imgHeight;
    private String thumbData;
    private String fullText;
    private String titleText;
    private String linkUrl;
    private String aniCfg;
    private int aniStep;
    private List<AbsAnno> annos = new ArrayList<AbsAnno>(0);
    private Matrix matrix = new Matrix();
    private int showMode = 0;
    private boolean bRefreshAnnos = false;
    private int nFrameCount;

    public int getFrameCount() {
        return this.nFrameCount;
    }

    public void setFrameCount(int nFrameCount) {
        this.nFrameCount = nFrameCount;
    }

    public void setRefreshAnnos(boolean bRefreshAnnos) {
        this.bRefreshAnnos = bRefreshAnnos;
    }

    public boolean isRefreshAnnos() {
        return this.bRefreshAnnos;
    }

    public static void setFileDir(String dir) {
        fileDir = dir;
    }

    public static String getFileDir() {
        return fileDir == null ? FILE_DIR : fileDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAnnos(AbsAnno[] annos) {
        if (annos != null) {
            List<AbsAnno> list = this.annos;
            synchronized (list) {
                for (int i = 0; i < annos.length; ++i) {
                    this.annos.add(annos[i]);
                }
            }
        }
    }

    protected AbsAnno[] getAnnos() {
        if (this.annos.size() > 0) {
            AbsAnno[] arr = new AbsAnno[this.annos.size()];
            return this.annos.toArray(arr);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawAnno(Canvas canvas) {
        if (canvas == null) {
            GenseeLog.w((String)TAG, (String)"drawAnno canvas is null!");
            return;
        }
        CopyOnWriteArrayList<AbsAnno> cowaList = null;
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            try {
                cowaList = new CopyOnWriteArrayList<AbsAnno>(this.annos);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (cowaList != null) {
            canvas.save();
            for (AbsAnno anno : cowaList) {
                if (anno != null) {
                    anno.draw(canvas, this.matrix);
                    continue;
                }
                GenseeLog.w((String)TAG, (String)"drawAnno anno is null!");
            }
            canvas.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAnno(AbsAnno anno, boolean isLocalAdd) {
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            int index = this.annos.indexOf(anno);
            if (index == -1) {
                int nStepType;
                AbsAnno tmpAnno;
                int size = this.annos.size();
                if (size > 0 && (tmpAnno = this.annos.get(size - 1)) instanceof AnnoFreepenEx && (nStepType = ((AnnoFreepenEx)tmpAnno).getStepType()) != 3 && nStepType != 0) {
                    ((AnnoFreepenEx)tmpAnno).setStepType(3);
                }
                return this.annos.add(anno) ? 0 : -1;
            }
            try {
                if (16 == anno.getType()) {
                    AnnoFreepenEx src = (AnnoFreepenEx)this.annos.get(index);
                    if (src.getStepType() == 3 && this.nSdkType == 0) {
                        return -1;
                    }
                    return src.appendEX((AnnoFreepenEx)anno) ? 0 : -1;
                }
                AbsAnno anno2 = this.annos.remove(index);
                anno2.clean();
                this.annos.add(index, anno);
                return 1;
            }
            catch (Exception e) {
                GenseeLog.e((String)TAG, (String)e.toString());
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delAnno(long annoId) {
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            AbsAnno remove = null;
            for (AbsAnno anno : this.annos) {
                if (anno == null || anno.getId() != annoId) continue;
                remove = anno;
                break;
            }
            return this.annos.remove(remove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delAnno(AbsAnno cleaner) {
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            if (0L == ((AnnoCleaner)cleaner).getRemovedId()) {
                this.annos.clear();
                return true;
            }
            AbsAnno remove = null;
            for (AbsAnno anno : this.annos) {
                if (anno == null || anno.getId() != ((AnnoCleaner)cleaner).getRemovedId()) continue;
                remove = anno;
                break;
            }
            return this.annos.remove(remove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changePoint(AbsAnno point) {
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            int size = this.annos.size();
            AbsAnno anno = null;
            int removeIndex = -1;
            for (int i = size - 1; i >= 0; --i) {
                anno = this.annos.get(i);
                if (anno == null || anno.getType() != 17 && anno.getType() != 9 && anno.getType() != 1) continue;
                removeIndex = i;
                break;
            }
            if (removeIndex >= 0 && removeIndex < size) {
                this.annos.remove(removeIndex);
            }
            return this.annos.add(point);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbsAnno cleanAnno(float mX, float mY) {
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            int size = this.annos.size();
            AbsAnno anno = null;
            for (int i = size - 1; i >= 0; --i) {
                anno = this.annos.get(i);
                if (anno == null || !anno.contain(mX, mY)) continue;
                return anno;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbsAnno cleanLastOwnAnno(long ownerId) {
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            AbsAnno lastOwn = null;
            for (int i = this.annos.size() - 1; i >= 0; --i) {
                lastOwn = this.annos.get(i);
                if (lastOwn == null || lastOwn.getOwner() != ownerId) continue;
                return lastOwn;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanAllAnno() {
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            this.annos.clear();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawBitmap(Canvas canvas, Context c, int defColor) {
        if (canvas == null) {
            return;
        }
        String string = TAG;
        synchronized (TAG) {
            Bitmap b = this.getBitmap();
            canvas.drawColor(defColor);
            if (b == null || b.isRecycled()) {
                GenseeLog.e((String)TAG, (String)("drawBitmap canvas =" + canvas + " reference = " + this.reference));
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            canvas.drawBitmap(b, this.matrix, new Paint());
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public int getBitmapW() {
        return this.imgWidth;
    }

    public int getBitmapH() {
        return this.imgHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            List<AbsAnno> list = this.annos;
            synchronized (list) {
                for (AbsAnno anno : this.annos) {
                    anno.clean();
                }
                this.annos.clear();
            }
        }
        catch (Exception e) {
            GenseeLog.w((String)TAG, (String)("clear " + e.getMessage()));
        }
        this.matrix.reset();
        this.showMode = 0;
        this.recycle();
    }

    public void initBitmap(int w, int h) {
        this.getBitmap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        String string = TAG;
        synchronized (TAG) {
            if (this.reference != null) {
                Bitmap b = this.reference.get();
                GenseeLog.d((String)TAG, (String)("recycle Bitmap = " + b));
                if (b != null) {
                    b.recycle();
                }
                this.reference.clear();
                this.reference = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void saveBitmap(Bitmap bitmap) {
        File fdir = new File(PduPage.getFileDir());
        if (!fdir.exists()) {
            boolean ret = fdir.mkdirs();
            GenseeLog.d((String)TAG, (String)("save page make dir ok = " + ret + PduPage.getFileDir()));
            if (!ret) {
                GenseeLog.w((String)"save page make dir fail");
            }
        }
        String fileName = this.getPageFileName();
        File imgFile = new File(fdir, fileName);
        try {
            imgFile.createNewFile();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(imgFile);
            bitmap.compress(Bitmap.CompressFormat.PNG, 80, (OutputStream)outputStream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (outputStream != null) {
            try {
                outputStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                ((OutputStream)outputStream).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getPageName() {
        return this.pageName;
    }

    public void setPageName(String pageName) {
        this.pageName = pageName;
    }

    public int getPageId() {
        return this.pageId;
    }

    public void setPageId(int pageId) {
        this.pageId = pageId;
    }

    public int getDocId() {
        return this.docId;
    }

    public void setDocId(int docId) {
        this.docId = docId;
    }

    public char getImgBitCount() {
        return this.imgBitCount;
    }

    public void setImgBitCount(char imgBitCount) {
        this.imgBitCount = imgBitCount;
    }

    public short getImgWidth() {
        return this.imgWidth;
    }

    public void setImgWidth(short imgWidth) {
        this.imgWidth = imgWidth;
    }

    public short getImgHeight() {
        return this.imgHeight;
    }

    public void setImgHeight(short imgHeight) {
        this.imgHeight = imgHeight;
    }

    public String getThumbData() {
        return this.thumbData;
    }

    public void setThumbData(String thumbData) {
        this.thumbData = thumbData;
    }

    public String getFullText() {
        return this.fullText;
    }

    public void setFullText(String fullText) {
        this.fullText = fullText;
    }

    public String getTitleText() {
        return this.titleText;
    }

    public void setTitleText(String titleText) {
        this.titleText = titleText;
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public String getAniCfg() {
        return this.aniCfg;
    }

    public void setAniCfg(String aniCfg) {
        this.aniCfg = aniCfg;
    }

    public int getAniStep() {
        return this.aniStep;
    }

    public void setAniStep(int aniStep) {
        this.aniStep = aniStep;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        if (this.nSdkType == 0) {
            return this.getPageSwfFilePath();
        }
        return this.path;
    }

    public void setSdkType(int nSdkType) {
        this.nSdkType = nSdkType;
    }

    public void setAnimationPath(String animationPath) {
        this.animationPath = animationPath;
    }

    public String getAnimationPath() {
        if (this.nSdkType == 0) {
            return this.getPageSwfXmlFilePath();
        }
        return this.animationPath;
    }

    public Bitmap getBitmap() {
        if (this.reference == null || this.reference.get() == null) {
            Bitmap docBitmap = null;
            if (this.path != null) {
                Bitmap temp = null;
                try {
                    temp = BitmapFactory.decodeFile((String)this.path);
                }
                catch (OutOfMemoryError e) {
                    GenseeLog.e((String)TAG, (String)e.toString());
                }
                docBitmap = this.cropImg(temp);
            } else {
                File f = new File(PduPage.getFileDir() + this.getPageFileName());
                if (f.exists()) {
                    try {
                        docBitmap = BitmapFactory.decodeFile((String)f.getPath());
                    }
                    catch (OutOfMemoryError e) {
                        GenseeLog.e((String)TAG, (String)e.toString());
                    }
                }
            }
            if (docBitmap != null) {
                this.reference = new SoftReference<Bitmap>(docBitmap);
            }
        }
        return this.reference == null ? null : this.reference.get();
    }

    private Bitmap cropImg(Bitmap temp) {
        Bitmap docBitmap = null;
        if (temp != null) {
            int bw = temp.getWidth();
            int bh = temp.getHeight();
            if (this.imgWidth > 3000 || this.imgHeight > 3000) {
                GenseeLog.w((String)("PduPage pageWidth = " + this.imgWidth + " bw = " + bw + " bh = " + bh + " pageHeight = " + this.imgHeight));
                this.imgWidth = (short)bw;
                this.imgHeight = (short)bh;
                return temp;
            }
            if (bw != this.imgWidth || bh != this.imgHeight) {
                float scallX = (float)this.imgWidth / (float)bw;
                float scallY = (float)this.imgHeight / (float)bh;
                Matrix m = new Matrix();
                m.postScale(scallX, scallY);
                try {
                    docBitmap = Bitmap.createBitmap((Bitmap)temp, (int)0, (int)0, (int)bw, (int)bh, (Matrix)m, (boolean)true);
                }
                catch (OutOfMemoryError e) {
                    GenseeLog.e((String)TAG, (String)e.toString());
                }
                temp.recycle();
            } else {
                return temp;
            }
        }
        return docBitmap;
    }

    @Override
    public String toString() {
        return "PudPage [pageName=" + this.pageName + ", pageId=" + this.pageId + ", docId=" + this.docId + " w = " + this.imgWidth + " h = " + this.imgHeight + " annos =" + (this.annos == null ? 0 : this.annos.size()) + "]";
    }

    private String getPageFileName() {
        return "" + this.getDocId() + '_' + this.getPageId() + ".png";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.docId;
        result = 31 * result + this.pageId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PduPage other = (PduPage)obj;
        if (this.docId != other.docId) {
            return false;
        }
        return this.pageId == other.pageId;
    }

    public void onContent(byte[] data, boolean isShowing, int docId) {
        this.docId = docId;
        File f = new File(PduPage.getFileDir() + this.getPageFileName());
        if (f.exists()) {
            return;
        }
        if (this.reference == null || this.reference.get() == null) {
            Bitmap temp = null;
            try {
                temp = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
            }
            catch (OutOfMemoryError e) {
                GenseeLog.e((String)TAG, (String)e.toString());
            }
            Bitmap docBitmap = this.cropImg(temp);
            if (docBitmap != null) {
                this.saveBitmap(docBitmap);
                if (!isShowing) {
                    this.recycle();
                } else {
                    this.reference = new SoftReference<Bitmap>(docBitmap);
                }
            } else {
                GenseeLog.w((String)"onContent page  decode fail");
            }
        }
    }

    public boolean isPrepare() {
        if (this.isSwfPrepare()) {
            return true;
        }
        File f = new File(PduPage.getFileDir() + this.getPageFileName());
        return f.exists() || this.getBitmap() != null;
    }

    public void initBitmap() {
    }

    public int getShowMode() {
        return this.showMode;
    }

    public void setShowMode(int showMode) {
        this.showMode = showMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUndoAnno(long userId) {
        List<AbsAnno> list = this.annos;
        synchronized (list) {
            for (AbsAnno anno : this.annos) {
                if (null == anno || anno.getOwner() != userId) continue;
                anno.setOwner(0L);
            }
        }
    }

    public boolean isGlPrepare() {
        if (!this.isSwfPrepare()) {
            return false;
        }
        File swfXmlFile = new File(this.getPageSwfXmlFilePath());
        return swfXmlFile.exists();
    }

    public boolean isSwfPrepare() {
        String path = this.getPath();
        if (null == path) {
            return false;
        }
        File swfFile = new File(path);
        return swfFile.exists();
    }

    private String getPageSwfFilePath() {
        return PduPage.getFileDir() + this.getPageSwfFileName();
    }

    private String getPageSwfXmlFilePath() {
        return PduPage.getFileDir() + this.getPageSwfXmlFileName();
    }

    private String getPageSwfFileName() {
        return "" + this.getDocId() + '_' + this.getPageId() + ".swf";
    }

    private String getPageSwfXmlFileName() {
        return "" + this.getDocId() + '_' + this.getPageId() + ".xml";
    }

    public void onGlContent(byte[] data, boolean isShowing, int docId) {
        boolean ret;
        this.docId = docId;
        File fdir = new File(PduPage.getFileDir());
        if (!fdir.exists() && !(ret = fdir.mkdirs())) {
            GenseeLog.w((String)("onGlContent save page make dir fail" + fdir.getAbsolutePath()));
            return;
        }
        File f = new File(this.getPageSwfFilePath());
        if (!f.exists()) {
            this.writeToFile(f, data);
        }
        if (null == this.aniCfg || "".equals(this.aniCfg)) {
            return;
        }
        File aniCfgFile = new File(this.getPageSwfXmlFilePath());
        if (!aniCfgFile.exists()) {
            this.writeToFile(aniCfgFile, this.aniCfg.getBytes());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(File f, byte[] data) {
        FilterOutputStream stream = null;
        try {
            f.createNewFile();
            FileOutputStream fstream = new FileOutputStream(f);
            stream = new BufferedOutputStream(fstream);
            stream.write(data);
            ((BufferedOutputStream)stream).flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

