/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.gensee.pdu.GSDocTextureView;
import com.gensee.pdu.IGSDocZoom;
import com.gensee.pdu.PduPage;
import com.gensee.view.GSDocViewEx;

public class GSPduTextureView
extends GSDocTextureView
implements GSDocViewEx.IDocExInterface {
    private IGSDocZoom mZoomer;

    public GSPduTextureView(Context context) {
        this(context, null);
    }

    public GSPduTextureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GSPduTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setBackgroundColor(0);
    }

    public void setDocZoomer(IGSDocZoom zoom) {
        this.mZoomer = zoom;
    }

    @Override
    public void setBackgroundColor(int color) {
        super.setBackgroundColor(0);
    }

    @Override
    public void drawDocPage(PduPage pduPage, Canvas mCanvas, int bgColor) {
        if (pduPage != null) {
            String path = pduPage.getPath();
            if (path != null && (path.endsWith("png") || path.endsWith("png.1"))) {
                super.drawDocPage(pduPage, mCanvas, bgColor);
            } else {
                mCanvas.drawColor(bgColor, PorterDuff.Mode.CLEAR);
            }
        } else {
            mCanvas.drawColor(bgColor, PorterDuff.Mode.CLEAR);
        }
    }

    @Override
    public void onDocBound(RectF rectF, int w, int h) {
        this.mZoomer.onDocBound(rectF, w, h);
    }

    @Override
    public boolean isDrawAnnos() {
        PduPage docPage = this.docViewImpl.getDocPage();
        if (null != docPage) {
            String path = docPage.getPath();
            if (path != null && (path.endsWith("png") || path.endsWith("png.1"))) {
                return true;
            }
            if (docPage.isRefreshAnnos()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void onDocOpenComplete() {
        this.drawAnnos();
    }
}

