/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.offline;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.gensee.common.GenseeConfig;
import com.gensee.common.PlayerEnv;
import com.gensee.common.ServiceType;
import com.gensee.entity.AccVodResEntity;
import com.gensee.entity.ChatMsg;
import com.gensee.entity.InitParam;
import com.gensee.entity.QAMsg;
import com.gensee.entity.VodParam;
import com.gensee.entity.VodPlayParam;
import com.gensee.entity.VoteMsg;
import com.gensee.media.AVConfig;
import com.gensee.net.AbsHandler;
import com.gensee.net.AbsHttpAction;
import com.gensee.net.IHttpHandler;
import com.gensee.net.StringRes;
import com.gensee.net.VodHttpHandler;
import com.gensee.offline.OnHistoryErrCodeListener;
import com.gensee.parse.MsgParse;
import com.gensee.parse.VodAttrParse;
import com.gensee.parse.VodChatParse;
import com.gensee.taskret.OnTaskRet;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import com.gensee.utils.upload.LogProperty;
import com.gensee.vod.VodMr;
import com.gensee.vod.VodSite;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GSOLComp
extends AbsHttpAction {
    public static final String SP_NAME = "gsol";
    public static final String SP_SITE_ID = "siteId";
    public static final String SP_USER_ID = "userId";
    public static final String SP_USER_NAME = "userName";
    public static final String SP_ALB_ADDRESS = "albAddress";
    public static final String SP_SERVICE_TYPE = "serviceType";
    private static final String SP_VIDEO_TYPE = "videoType";
    private static final String ACCESSVOD = "%s/%s/site/accessVodInfo";
    private static final String LOGINVOD = "%s/%s/site/loginVod";
    private static final String LOGINVOD_ENHANCED = "%s/%s/site/loginVodEnhanced";
    protected static final String XMLAPI = "%s/xmlapi/apichannel";
    public static final String CLIENTAPI = "%s/clientapi/apichannel?sc=%s";
    private static final String QA_HISTORY = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><qaHistory live=\"false\" confid=\"%s\" userid=\"%s\" siteid=\"%s\" page=\"%d\"/>";
    private static final String CHAT_HISTORY = "<?xml version=\"1.0\" encoding=\"utf-8\"?><chatHistory live=\"false\" confid=\"%s\" userid=\"%s\" siteid=\"%s\" page=\"%d\"/>";
    private static final String RESULT_OK = "<result>ok</result>";
    private static final String TAG = "GSOLComp";
    private InitParam initParam;
    private Context context;
    private OnVodListener mListener;
    private boolean isFromVodSite = false;

    public GSOLComp(Context context) {
        this(context, false);
    }

    private GSOLComp(IHttpHandler httpHandler, boolean isFromVod) {
        super(httpHandler);
        if (isFromVod) {
            ((VodHttpHandler)httpHandler).setErrListener(new AbsHandler.OnErrListener(){

                public void onErr(int arg0) {
                    if (GSOLComp.this.mListener != null) {
                        GSOLComp.this.mListener.onOlErr(arg0);
                    }
                }
            });
        }
    }

    public GSOLComp(Context context, boolean isFromVodSite) {
        this((IHttpHandler)new VodHttpHandler(context), isFromVodSite);
        this.isFromVodSite = isFromVodSite;
        this.context = context;
    }

    public int answerVote(Context context, VodPlayParam param, VoteMsg vote) {
        if (param == null || vote == null) {
            return -1;
        }
        VodParam p = (VodParam)param;
        vote.setConfId(p.getVodId());
        vote.settId(p.getTid());
        vote.setUserId(p.getUserId());
        vote.setSiteId(p.getSiteId());
        vote.setName(p.getNickName());
        return this.submitVote(p.getDomain(), vote.getData());
    }

    private int submitVote(String domain, String data) {
        String url = String.format(GenseeConfig.getScheme() + XMLAPI, domain);
        String param = data;
        this.doPostRequest(url, param, new StringRes(){

            public void onConnectError(int errorType, String errorInfo) {
                GSOLComp.this.mHttpHandler.sendBroadCast("gs.action.rec.msg.vote.submit", (Serializable)((Object)"connect"));
            }

            public void onRes(String result) {
                if (result != null && result.contains(GSOLComp.RESULT_OK)) {
                    GSOLComp.this.mHttpHandler.sendBroadCast("gs.action.rec.msg.vote.submit", (Serializable)((Object)"1"));
                } else {
                    GSOLComp.this.mHttpHandler.sendBroadCast("gs.action.rec.msg.vote.submit", (Serializable)((Object)"err"));
                }
            }
        });
        return -1;
    }

    public void setVodListener(OnVodListener listener) {
        this.mListener = listener;
    }

    public void getQaHistory(VodParam vodParam, int pageIndex, OnHistoryErrCodeListener errCodeListener) {
        if (vodParam == null) {
            GenseeLog.w((String)"getQaHistory vodParam is null");
        } else {
            this.getQAList(null, vodParam, false, pageIndex < 1 ? 1 : pageIndex, errCodeListener);
        }
    }

    public void getChatHistory(VodParam vodParam, int pageIndex) {
        if (vodParam == null) {
            GenseeLog.w((String)"getChatHistory vodParam is null");
        } else {
            int index;
            pageIndex = pageIndex < 1 ? 1 : pageIndex;
            String chatFile = "chat.xml";
            String vodDir = vodParam.getXmlUrl();
            if (vodDir != null && (index = vodDir.lastIndexOf("/")) > 0) {
                vodDir = vodDir.substring(0, index + 1);
            }
            if (vodParam.hasDetail()) {
                chatFile = vodParam.getChatFile();
                if (TextUtils.isEmpty((CharSequence)chatFile)) {
                    this.getChatHistory(null, vodParam, pageIndex);
                } else {
                    this.reqChatFile(vodDir, chatFile, vodParam, false, pageIndex);
                }
            } else {
                this.reqChatFile(vodDir, chatFile, vodParam, true, pageIndex);
            }
        }
    }

    private void getQAList(String oldVodId, VodParam vodParam, boolean isReadChat, int pageIndex) {
        this.getQAList(oldVodId, vodParam, isReadChat, pageIndex, null);
    }

    private void getQAList(String oldVodId, VodParam vodParam, final boolean isReadChat, int pageIndex, final OnHistoryErrCodeListener errCodeListener) {
        final String vodId = StringUtil.isEmpty((String)oldVodId) ? vodParam.getVodId() : oldVodId;
        String domain = vodParam.getDomain();
        String url = String.format(GenseeConfig.getScheme() + CLIENTAPI, domain, String.valueOf(vodParam.getSc()));
        String param = String.format(QA_HISTORY, vodId, vodParam.getUserId(), vodParam.getSiteId(), pageIndex);
        this.doPostRequest(url, param, new StringRes(){

            public void onConnectError(int errorType, String errorInfo) {
                if (null != errCodeListener) {
                    errCodeListener.onErrCode(errorType);
                }
            }

            public void onRes(String result) {
                if (!StringUtil.isEmpty((String)result) && result.contains(GSOLComp.RESULT_OK)) {
                    MsgParse parse = new MsgParse();
                    ArrayList<QAMsg> qaMsgs = parse.parseQa(result);
                    if (isReadChat) {
                        ArrayList chatHistory = parse.getChatMsgs();
                        if (chatHistory == null) {
                            chatHistory = new ArrayList(0);
                        }
                        GSOLComp.this.onChatHistory(vodId, chatHistory, parse.getPageIndex(), parse.isMore());
                    } else {
                        if (qaMsgs == null) {
                            qaMsgs = new ArrayList<QAMsg>(0);
                            GenseeLog.w((String)"GSOLComp qa history is empty");
                        }
                        if (GSOLComp.this.mListener != null) {
                            GSOLComp.this.mListener.onQaHistory(vodId, qaMsgs, parse.getPageIndex(), parse.isMore());
                        }
                    }
                }
            }
        });
    }

    private void onChatHistory(String vodId, List<ChatMsg> chatHistory, int pageIndex, boolean more) {
        if (this.mListener != null) {
            this.mListener.onChatHistory(vodId, chatHistory, pageIndex, more);
        }
    }

    private void getChatHistory(final String oldVodId, final VodParam vodParam, final int pageIndex) {
        final String vodId = StringUtil.isEmpty((String)oldVodId) ? vodParam.getVodId() : oldVodId;
        String url = String.format(GenseeConfig.getScheme() + CLIENTAPI, vodParam.getDomain(), String.valueOf(vodParam.getSc()));
        String param = String.format(CHAT_HISTORY, vodId, vodParam.getUserId(), vodParam.getSiteId(), pageIndex);
        this.doPostRequest(url, param, new StringRes(){

            public void onConnectError(int errorType, String errorInfo) {
            }

            public void onRes(String result) {
                ArrayList chatHistory = null;
                if (!StringUtil.isEmpty((String)result) && result.contains(GSOLComp.RESULT_OK)) {
                    MsgParse parse = new MsgParse();
                    parse.parseQa(result);
                    chatHistory = parse.getChatMsgs();
                    if (chatHistory == null) {
                        chatHistory = new ArrayList(0);
                        GenseeLog.w((String)"GSOLComp getChatHistory history is empty");
                    }
                    GSOLComp.this.onChatHistory(vodId, chatHistory, parse.getPageIndex(), parse.isMore());
                } else if (pageIndex == 1) {
                    GSOLComp.this.getQAList(oldVodId, vodParam, true, pageIndex);
                }
            }
        });
    }

    private void reqChatFile(final String dir, String chatFile, final VodParam vodParam, final boolean isDefChatFile, final int index) {
        GSOLComp.getStream((String)(dir + chatFile), (IHttpHandler.StreamResponse)new IHttpHandler.StreamResponse(){

            public void onRes(InputStream inputStream) {
                VodChatParse p = new VodChatParse();
                p.parse(inputStream);
                List<ChatMsg> msgs = p.getChatMsgs();
                GSOLComp.this.onChatHistory(vodParam.getVodId(), msgs, 0, false);
            }

            public void onConnectError(int errorType, String errorInfo) {
                if (errorType == 404 && isDefChatFile) {
                    GSOLComp.getStream((String)vodParam.getXmlUrl(), (IHttpHandler.StreamResponse)new IHttpHandler.StreamResponse(){

                        public void onConnectError(int errorType, String errorInfo) {
                            GSOLComp.this.onChatHistory(vodParam.getVodId(), new ArrayList(0), 1, false);
                        }

                        public void onRes(InputStream inputStream) {
                            if (inputStream != null) {
                                VodAttrParse parse = new VodAttrParse();
                                parse.vodParse(inputStream, vodParam);
                                String chatRealFile = vodParam.getChatFile();
                                if (TextUtils.isEmpty((CharSequence)chatRealFile)) {
                                    GSOLComp.this.getChatHistory(vodParam.getVodId(), vodParam, index);
                                } else {
                                    GSOLComp.this.reqChatFile(dir, chatRealFile, vodParam, false, index);
                                }
                            }
                        }
                    });
                } else {
                    GSOLComp.this.onChatHistory(vodParam.getVodId(), new ArrayList(0), 1, false);
                }
            }
        });
    }

    public void initVod(InitParam initParam) {
        VodSite.startTime = System.currentTimeMillis();
        if (GenseeConfig.isTwoStep) {
            this.accessVod(initParam);
        } else {
            this.loginVod(initParam);
        }
    }

    private void loginVod(InitParam vodParam) {
        if (vodParam != null && vodParam.isValid()) {
            this.initParam = vodParam;
            boolean entryByCode = false;
            String vodId = vodParam.getLiveId();
            if (StringUtil.isEmpty((String)vodId)) {
                if (!GenseeConfig.thirdCertificationAuth) {
                    this.accessVod(vodParam.getDomain(), vodParam.getNumber(), vodParam.getVodSType());
                    return;
                }
                vodId = vodParam.getNumber();
                entryByCode = true;
            }
            this.loginVod(vodId, this.initParam.getVodDomain(), this.initParam.getVodLoginName(), this.initParam.getVodLoginPwd(), this.initParam.getVodNickName(), this.initParam.getVodPwd(), this.initParam.getVodSType(), this.initParam.getDeviceType(), this.initParam.getK(), entryByCode);
        } else {
            GenseeLog.e((String)TAG, (String)"vodParam is invalid!");
            this.mHttpHandler.sendError("-107");
        }
    }

    private void accessVod(InitParam vodParam) {
        if (vodParam != null && vodParam.isValid()) {
            this.initParam = vodParam;
            String liveId = vodParam.getLiveId();
            if (!StringUtil.isEmpty((String)liveId)) {
                this.loginVod(liveId);
            } else {
                this.accessVod(vodParam.getVodDomain(), vodParam.getVodNumber(), vodParam.getVodSType());
            }
        } else {
            GenseeLog.e((String)TAG, (String)"vodParam is invalid!");
            this.mHttpHandler.sendError("-107");
        }
    }

    private void accessVod(String domain, String number, ServiceType serviceType) {
        if (!this.mHttpHandler.isNetConneced()) {
            this.mHttpHandler.sendError("-104");
            return;
        }
        String strUrl = String.format(GenseeConfig.getScheme() + ACCESSVOD, domain, serviceType.getValue());
        String[] darr = domain.split(":");
        if (darr != null && darr.length > 0) {
            domain = darr[0];
        }
        this.doPostRequest(strUrl, "number=" + number + "&domain=" + domain, new StringRes(){

            public void onRes(String result) {
                AccVodResEntity accessResEntity = (AccVodResEntity)GSOLComp.this.mHttpHandler.onAccessVod(result);
                GSOLComp.this.onAccessResult(accessResEntity);
            }

            public void onConnectError(int errorType, String errorInfo) {
                GSOLComp.this.mHttpHandler.onConnectError(errorType, errorInfo);
            }
        });
    }

    protected void onAccessResult(AccVodResEntity accessResEntity) {
        if (accessResEntity != null) {
            this.loginVod(accessResEntity.getVodId());
        }
    }

    private void loginVod(String vodId) {
        if (!this.mHttpHandler.isNetConneced()) {
            this.mHttpHandler.sendError("-104");
            return;
        }
        this.loginVod(vodId, this.initParam.getVodDomain(), this.initParam.getVodLoginName(), this.initParam.getVodLoginPwd(), this.initParam.getVodNickName(), this.initParam.getVodPwd(), this.initParam.getVodSType(), this.initParam.getDeviceType(), this.initParam.getK(), false);
    }

    private void loginVod(String vodId, final String domain, String account, String loginPwd, String nickName, String vodPwd, ServiceType st, int deviceType, String k, boolean entryByCode) {
        String strUrl = String.format(GenseeConfig.getScheme() + (GenseeConfig.thirdCertificationAuth ? LOGINVOD_ENHANCED : LOGINVOD), domain, st.getValue());
        account = StringUtil.urlEncode((String)account);
        nickName = StringUtil.urlEncode((String)nickName);
        k = StringUtil.urlEncode((String)k);
        long customUserId = AbsHandler.verifyUserId((long)this.initParam.getUserId(), (long)0L);
        String paramUid = customUserId == 0L ? "" : "&uid=" + customUserId;
        String param = "vodId=" + vodId + "&loginPassword=" + (loginPwd == null ? "" : loginPwd) + "&password=" + (vodPwd == null ? "" : vodPwd) + "&loginName=" + account + "&nickName=" + nickName + "&device=" + deviceType + "&k=" + k + paramUid + "&download=" + this.initParam.isDownload() + "&entryByCode=" + entryByCode;
        this.doPostRequest(strUrl, param, new StringRes(){

            public void onRes(String result) {
                final VodParam vodParam = (VodParam)GSOLComp.this.mHttpHandler.onLoginVod(result);
                if (vodParam != null) {
                    String number;
                    vodParam.setDomain(domain);
                    if (vodParam.getSc() == -1) {
                        vodParam.setSc(GSOLComp.this.initParam.getServiceType().getValue().equals(ServiceType.WEBCAST.getValue()) ? 0 : 1);
                    }
                    if ((number = GSOLComp.this.initParam.getNumber()) != null && !"".equals(number)) {
                        vodParam.setNumber(number);
                    }
                    SharedPreferences sp = GSOLComp.this.context.getSharedPreferences(GSOLComp.SP_NAME, 0);
                    int preSc = sp.getInt(GSOLComp.SP_SERVICE_TYPE, 0);
                    long preSite = sp.getLong(GSOLComp.SP_SITE_ID, 0L);
                    long siteId = 0L;
                    try {
                        siteId = Long.valueOf(vodParam.getSiteId());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    int preVideoType = sp.getInt(GSOLComp.SP_VIDEO_TYPE, -1);
                    int videoType = GenseeConfig.isPVHardDecode ? 255 : 1;
                    boolean needInitEnv = siteId != preSite || vodParam.getSc() != preSc || preVideoType != videoType || !PlayerEnv.isHBInited();
                    GSOLComp.this.saveSource(vodParam, siteId, videoType);
                    if (needInitEnv) {
                        GSOLComp.initOfflineComp(GSOLComp.this.context, new OnTaskRet(){

                            public void onTaskRet(boolean ret, int iret, String desc) {
                                if (ret) {
                                    this.onVodRes(vodParam);
                                } else {
                                    GSOLComp.this.mHttpHandler.sendError("14");
                                }
                            }
                        });
                    } else {
                        this.onVodRes(vodParam);
                    }
                }
            }

            public void onConnectError(int errorType, String errorInfo) {
                GSOLComp.this.mHttpHandler.onConnectError(-102, "");
            }

            private void onVodRes(VodParam vodParam) {
                if (GSOLComp.this.mListener != null) {
                    GSOLComp.this.mListener.onVodInited(vodParam);
                }
                if (!GSOLComp.this.isFromVodSite) {
                    GSOLComp.this.getRecord(vodParam);
                }
            }
        });
    }

    private void getRecord(final VodParam vodParam) {
        String recordAddr = vodParam.getXmlUrl();
        if (StringUtil.isEmpty((String)recordAddr)) {
            this.mHttpHandler.onVodInitEnd((Serializable)vodParam);
            return;
        }
        GSOLComp.getStream((String)recordAddr, (IHttpHandler.StreamResponse)new IHttpHandler.StreamResponse(){

            public void onConnectError(int errorType, String errorInfo) {
                GSOLComp.this.mHttpHandler.onVodInitEnd((Serializable)vodParam);
            }

            public void onRes(InputStream inputStream) {
                if (inputStream != null) {
                    VodAttrParse parse = new VodAttrParse();
                    parse.vodParse(inputStream, vodParam);
                }
                GSOLComp.this.mHttpHandler.onVodInitEnd((Serializable)vodParam);
            }
        });
    }

    private void saveSource(VodParam p, long siteId, int videoType) {
        try {
            SharedPreferences.Editor editor = this.context.getSharedPreferences(SP_NAME, 0).edit();
            String alb = StringUtil.getHttpAlbAddr((String)p.getConnectSvr());
            String nickName = p.getNickName();
            long userId = Long.valueOf(p.getUserId());
            editor.putLong(SP_SITE_ID, siteId);
            editor.putLong(SP_USER_ID, userId);
            editor.putString(SP_USER_NAME, nickName);
            editor.putString(SP_ALB_ADDRESS, alb);
            ServiceType s = this.initParam.getServiceType();
            int service = 0;
            if (ServiceType.TRAINING.getValue().equals(s.getValue())) {
                service = 1;
            }
            editor.putInt(SP_SERVICE_TYPE, service);
            editor.putInt(SP_VIDEO_TYPE, videoType);
            LogProperty.getIns().setProperty(this.context, nickName, p.getVodId(), userId, siteId, "VodSDK");
            editor.commit();
        }
        catch (Exception exception) {
            GenseeLog.w((String)("saveSource " + exception.toString()));
        }
    }

    public static boolean initOfflineComp(Context context, OnTaskRet ret) {
        VodMr.getIns().initCachDir(context);
        SharedPreferences sp = context.getSharedPreferences(SP_NAME, 0);
        int sampleSize = AVConfig.getSampleRate((Context)context);
        long userId = sp.getLong(SP_USER_ID, 0L);
        String albAddress = sp.getString(SP_ALB_ADDRESS, "");
        int serviceType = sp.getInt(SP_SERVICE_TYPE, 0);
        if (userId == 0L || "".equals(albAddress)) {
            GenseeLog.w((String)TAG, (String)"initOfflineComp fail that no source");
        }
        if (!"".equals(albAddress) && !albAddress.contains("http://")) {
            albAddress = "http://" + albAddress;
        }
        return PlayerEnv.init((boolean)true, (int)serviceType, (int)sampleSize, (Context)context, (OnTaskRet)ret);
    }

    public static void destroyOfflineComp() {
        PlayerEnv.release();
    }

    public static void setTcpProxy(PlayerEnv.IProxy proxy) {
        PlayerEnv.setTcpProxy((PlayerEnv.IProxy)proxy);
    }

    public void setBox(boolean isBox) {
        ((VodHttpHandler)this.mHttpHandler).setBox(true);
    }

    public static interface OnVodListener {
        public void onChatHistory(String var1, List<ChatMsg> var2, int var3, boolean var4);

        public void onQaHistory(String var1, List<QAMsg> var2, int var3, boolean var4);

        public void onOlErr(int var1);

        public void onVodInited(VodParam var1);
    }
}

