/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.parse;

import com.gensee.entity.VodParam;
import com.gensee.entity.VoteMsg;
import com.gensee.entity.VoteQuest;
import com.gensee.entity.VoteQuestItem;
import com.gensee.parse.PullBase;
import com.gensee.utils.DateUtil;
import com.gensee.utils.GenseeLog;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class VodAttrParse
extends PullBase {
    private static final String TAG = "VodParse";
    private static final String TAG_CONF = "conf";
    private static final String TAG_MODULE = "module";
    private static final String TAG_MULTIRECORD = "multirecord";
    private static final String TAG_COMMAND = "command";
    private static final String TAG_SUBJECT = "subject";
    private static final String TAG_QUESTION = "question";
    private static final String TAG_ITEM = "item";
    private boolean hasStorageField = true;
    private String moduleName;
    private VoteMsg voteMsg;
    private VoteQuest voteQuest;
    private VodParam vodParam;

    public VodParam vodParse(InputStream inputStream, VodParam vodParam) {
        this.vodParam = vodParam;
        XmlPullParser parser = this.builXmlPullParser(inputStream);
        if (parser != null) {
            this.parser(parser);
        }
        return vodParam;
    }

    protected void onStartTag(String nodeName, XmlPullParser parser) {
        if (TAG_CONF.equals(nodeName)) {
            this.startConf(parser);
        } else if (TAG_MODULE.equals(nodeName)) {
            this.moduleName = this.getAttrStrValue(parser, "name");
        } else if (TAG_COMMAND.equals(nodeName)) {
            if ("vote".equals(this.moduleName)) {
                this.voteMsg = new VoteMsg();
                this.startVote(parser);
            }
        } else if (TAG_MULTIRECORD.equals(nodeName)) {
            if (!this.hasStorageField) {
                try {
                    this.startMultirecord(parser);
                    parser.nextTag();
                }
                catch (XmlPullParserException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (TAG_SUBJECT.equals(nodeName)) {
            this.parseSubject(parser);
        } else if (TAG_QUESTION.equals(nodeName)) {
            this.parseQuestion(parser);
        } else if (TAG_ITEM.equals(nodeName)) {
            this.parseQuestItem(parser);
        }
    }

    protected void onStartText(XmlPullParser parser) {
    }

    private void startConf(XmlPullParser parser) {
        this.vodParam.setDuration(this.getAttrLongMcValue(parser, "duration"));
        this.vodParam.setEndTime(this.getDateLong(this.getAttrStrValue(parser, "endtime")));
        this.vodParam.setHaveVideo(!this.getAttrStrBoolValue(parser, "novideo"));
        this.vodParam.setStartTime(this.getDateLong(this.getAttrStrValue(parser, "starttime")));
        this.vodParam.setVideoWidth((int)this.getAttrShortValue(parser, "videowidth"));
        this.vodParam.setVideoHeight((int)this.getAttrShortValue(parser, "videoheight"));
        int storage = this.getAttrIntValue(parser, "storage");
        this.vodParam.setStorage((long)storage);
        this.vodParam.setChatFile(this.getAttrStrValue(parser, "chatfile"));
        this.hasStorageField = storage > 0;
    }

    private long getDateLong(String strDate) {
        Date d = null;
        try {
            d = DateUtil.strToDateLong((String)strDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return d == null ? 0L : d.getTime();
    }

    private void startMultirecord(XmlPullParser parser) {
        int fileSize = this.getAttrIntValue(parser, "filesize");
        if (this.vodParam != null) {
            long nowSize = (long)fileSize + this.vodParam.getStorage();
            this.vodParam.setStorage(nowSize);
        }
    }

    private void startVote(XmlPullParser parser) {
        this.voteMsg.setId(this.getAttrStrValue(parser, "id"));
        this.voteMsg.setConfId(this.vodParam.getVodId());
        this.voteMsg.setVersion(this.getAttrStrValue(parser, "version"));
        this.voteMsg.setVoteType(this.getAttrStrValue(parser, "type"));
        this.voteMsg.setSkip(this.getAttrStrBoolValue(parser, "skip"));
        this.voteMsg.setTimestamp(this.getAttrLongMcValue(parser, "timestamp"));
    }

    private void parseSubject(XmlPullParser parser) {
        if (this.nextEventType(parser) == 4) {
            String subject = parser.getText();
            String string = subject = subject == null ? "" : subject.trim();
            if (this.voteQuest != null) {
                this.voteQuest.setSubject(subject);
            } else if (this.voteMsg != null) {
                this.voteMsg.setSubject(subject);
            }
        } else {
            GenseeLog.e((String)TAG, (String)"parseSubject parsetype is not text!");
        }
    }

    private void parseQuestion(XmlPullParser parser) {
        this.voteQuest = new VoteQuest();
        this.voteQuest.setId(this.getAttrStrValue(parser, "id"));
        this.voteQuest.setType(this.getAttrStrValue(parser, "type"));
        this.voteQuest.setAnswer(this.getAttrStrValue(parser, "answer"));
        this.voteQuest.setScore(this.getAttrIntValue(parser, "score"));
    }

    private void parseQuestItem(XmlPullParser parser) {
        ArrayList<VoteQuestItem> items;
        VoteQuestItem questItem = new VoteQuestItem();
        questItem.setId(this.getAttrStrValue(parser, "id"));
        questItem.setCorrect(this.getAttrStrBoolValue(parser, "correct"));
        if (this.nextEventType(parser) == 4) {
            String content = parser.getText();
            questItem.setContent(content == null ? "" : content.trim());
        }
        if ((items = this.voteQuest.getQuestItems()) == null) {
            items = new ArrayList<VoteQuestItem>(1);
            this.voteQuest.setQuestItems(items);
        }
        items.add(questItem);
    }

    protected void onEndTag(String nodeName, XmlPullParser parser) {
        if (TAG_QUESTION.equals(nodeName)) {
            ArrayList<VoteQuest> quests = this.voteMsg.getQuests();
            if (quests == null) {
                quests = new ArrayList<VoteQuest>(1);
                this.voteMsg.setQuests(quests);
            }
            quests.add(this.voteQuest);
            this.voteQuest = null;
        } else if (TAG_COMMAND.equals(nodeName)) {
            if ("vote".equals(this.moduleName)) {
                ArrayList<VoteMsg> voteMsgs = this.vodParam.getVoteMsgs();
                if (voteMsgs == null) {
                    voteMsgs = new ArrayList<VoteMsg>(1);
                    this.vodParam.setVoteMsgs(voteMsgs);
                }
                voteMsgs.add(this.voteMsg);
                this.voteMsg = null;
            }
        } else if (TAG_MODULE.equals(nodeName)) {
            this.moduleName = null;
        }
    }

    protected void onEndDoc(XmlPullParser parser) {
    }

    protected void onStartDoc(XmlPullParser parser) {
    }

    public <T> T toParse(InputStream inputStream) {
        return null;
    }
}

