/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.parse;

import android.text.TextUtils;
import com.gensee.entity.ChatMsg;
import com.gensee.parse.PullBase;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;

public class VodChatParse
extends PullBase {
    public static final String TAG_CHAT = "chat";
    private static final String TAG_EMS = "ems";
    private static final String TAG_RICH = "richtext";
    public static final String TAG_CHATCENSOR = "chatcensor";
    private List<ChatMsg> chatMsgs;
    private String type = "";
    private long ts;
    private ChatMsg msg = null;
    private String xmlType = "";

    public String getXmlType() {
        return this.xmlType;
    }

    public void parse(String xml) {
        XmlPullParser parser = this.builXmlPullParser(xml);
        this.parser(parser);
    }

    public void parse(InputStream stream) {
        XmlPullParser parser = this.builXmlPullParser(stream);
        this.parser(parser);
    }

    protected void onStartTag(String nodeName, XmlPullParser parser) {
        if (TAG_CHAT.equals(nodeName)) {
            this.ts = this.getAttrLongMcValue(parser, "timestamp");
        } else if (TAG_EMS.equals(nodeName)) {
            this.type = this.getAttrStrValue(parser, "type");
            this.xmlType = TAG_CHAT;
            if (TAG_CHAT.equals(this.type)) {
                this.msg = new ChatMsg();
                if (this.chatMsgs == null) {
                    this.chatMsgs = new ArrayList<ChatMsg>();
                }
                this.chatMsgs.add(this.msg);
                this.msg.setGroup("1".equals(this.getAttrStrValue(parser, "group")));
                this.msg.setSender(this.getAttrStrValue(parser, "sender"));
                this.msg.setId(this.getAttrStrValue(parser, "id"));
                long senderId = this.getAttrLongValue(parser, "senderId");
                String senderid = this.getAttrStrValue(parser, "senderid");
                this.msg.setSenderid(senderid);
                if (senderId == 0L) {
                    try {
                        senderId = Long.parseLong(senderid);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.msg.setSenderId(senderId);
                this.msg.setTimeStamp(this.ts);
                int role = this.getAttrIntValue(parser, "senderRole");
                this.msg.setSenderRole(role);
                if (4 == this.nextEventType(parser)) {
                    String content = parser.getText();
                    content = content == null ? "" : content.trim();
                    this.msg.setContent(content);
                }
            }
        } else if (TAG_RICH.equals(nodeName)) {
            if (4 == this.nextEventType(parser)) {
                String rich = parser.getText();
                rich = rich == null ? "" : rich.trim();
                this.msg.setRichText(rich);
            }
        } else if (TAG_CHATCENSOR.equals(nodeName)) {
            this.type = this.getAttrStrValue(parser, "type");
            this.xmlType = TAG_CHATCENSOR;
            String id = this.getAttrStrValue(parser, "id");
            this.msg = new ChatMsg();
            this.msg.setType(TAG_CHATCENSOR);
            this.msg.setTimeStamp(this.ts);
            this.msg.setId(id);
            this.msg.setCensorType(this.type);
            if (this.chatMsgs != null) {
                this.chatCensor(this.type, id);
            }
        }
    }

    protected void onStartText(XmlPullParser parser) {
    }

    protected void onEndTag(String nodeName, XmlPullParser parser) {
        this.type = "";
    }

    protected void onEndDoc(XmlPullParser parser) {
    }

    protected void onStartDoc(XmlPullParser parser) {
    }

    public <T> T toParse(InputStream inputStream) {
        return null;
    }

    public List<ChatMsg> getChatMsgs() {
        return this.chatMsgs;
    }

    public ChatMsg getCensor() {
        ChatMsg tmp = this.msg;
        this.msg = null;
        return tmp;
    }

    private void chatCensor(String type, String id) {
        if (TextUtils.isEmpty((CharSequence)type) || TextUtils.isEmpty((CharSequence)id)) {
            return;
        }
        try {
            int size = this.chatMsgs.size();
            if ("msg".equals(type)) {
                int index = -1;
                for (int i = 0; i < size; ++i) {
                    ChatMsg msg = this.chatMsgs.get(i);
                    if (msg == null || !id.equals(msg.getId())) continue;
                    index = i;
                    break;
                }
                this.chatMsgs.remove(index);
            } else if ("user".equals(type)) {
                long userId = Long.valueOf(id);
                ArrayList<ChatMsg> delList = new ArrayList<ChatMsg>();
                for (ChatMsg msg : this.chatMsgs) {
                    if (msg == null || msg.getSenderId() != userId) continue;
                    delList.add(msg);
                }
                this.chatMsgs.removeAll(delList);
                delList.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

