/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.common;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import com.gensee.common.GenseeConstant;
import com.gensee.entity.LoginResEntity;

public class GenseeConfig {
    private static final int LIVE_DEVICE_TYPE_DEF = 0;
    public static final int LIVE_DEVICE_TYPE_PHONE = 1;
    public static final int LIVE_DEVICE_TYPE_PAD = 2;
    public static final int LIVE_DEVICE_TYPE_TV = 3;
    private static final String UA_NAME = "GenseeSDK";
    private static BitmapDrawable arrowDrawable;
    private static String clientAppName;
    public static final long MIN_CUSTOM_USER_ID = 1000000000L;
    public static final String SCHEME_HTTP = "http://";
    public static final String SCHEME_HTTPS = "https://";
    public static boolean isUIDVerification;
    public static boolean isDocDataPng;
    public static boolean isTls;
    @Deprecated
    public static boolean thirdCertificationAuth;
    public static boolean isNeedChatMsg;
    public static boolean isTV;
    public static boolean isCloseSpeakerDefault;
    public static boolean isPVHardDecode;
    public static String uaName;
    public static String uaVer;
    public static boolean isTwoStep;
    private static boolean videoDefaultBackCamera;
    private LoginResEntity loginResEntity;
    private static int deviceType;
    private static GenseeConfig ins;

    private GenseeConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GenseeConfig getIns() {
        if (ins != null) return ins;
        Class<GenseeConfig> clazz = GenseeConfig.class;
        synchronized (GenseeConfig.class) {
            if (ins != null) return ins;
            ins = new GenseeConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ins;
        }
    }

    public static String getUA() {
        return (uaName == null ? UA_NAME : uaName) + '/' + (uaVer == null ? GenseeConfig.getSDKVersion() : uaVer) + GenseeConstant.GENSEE_USER_AGENT;
    }

    public static String getSDKVersionInfo() {
        return "\n|*****************************|\n|*------  GENSEE SDK   ------*|\n|*-----   Version  " + GenseeConfig.getSDKVersion() + " ----*|\n" + "|*- EXPORT 2017-11-03 13:15 -*|\n" + "|*--for FastSDK & Anno upg --*|\n" + "|*****************************|\n";
    }

    public static String getSDKVersion() {
        return "3.6.2";
    }

    public static String getAppName() {
        return clientAppName;
    }

    public static void setAppName(String appName) {
        clientAppName = appName;
    }

    public static void initDrawable(Context context, int resId) {
        arrowDrawable = (BitmapDrawable)context.getResources().getDrawable(resId);
    }

    public static BitmapDrawable getArrowDrawable() {
        return arrowDrawable;
    }

    public static String getScheme() {
        return isTls ? SCHEME_HTTPS : SCHEME_HTTP;
    }

    public static int getDeviceType() {
        return deviceType;
    }

    public static void setDeviceType(int deviceType) {
        if (deviceType > 0 && deviceType < 4) {
            GenseeConfig.deviceType = deviceType;
        }
    }

    public static boolean isVideoDefaultBackCamera() {
        return videoDefaultBackCamera;
    }

    public static void setVideoDefaultBackCamera(boolean videoDefaultBackCamera) {
        GenseeConfig.videoDefaultBackCamera = videoDefaultBackCamera;
    }

    public LoginResEntity getLoginResEntity() {
        return this.loginResEntity;
    }

    public void setLoginResEntity(LoginResEntity loginResEntity) {
        this.loginResEntity = loginResEntity;
    }

    public void clean() {
        this.loginResEntity = null;
    }

    static {
        isUIDVerification = true;
        isDocDataPng = false;
        isTls = false;
        thirdCertificationAuth = true;
        isNeedChatMsg = false;
        isTV = false;
        isCloseSpeakerDefault = false;
        isPVHardDecode = false;
        uaName = UA_NAME;
        isTwoStep = false;
        videoDefaultBackCamera = false;
        deviceType = 0;
    }
}

