/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.gensee.db.DatabaseContext;
import com.gensee.db.PlayerChatDataBaseHelper;
import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.entity.chat.HongbaoMessage;
import com.gensee.entity.chat.PrivateMessage;
import com.gensee.entity.chat.PublicMessage;
import com.gensee.entity.chat.SysMessage;
import com.gensee.entity.chat.TipMessage;
import com.gensee.entity.chat.VodChatMessage;
import com.gensee.utils.GenseeLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PlayerChatDataBaseManager {
    private PlayerChatDataBaseHelper dataBaseHelper;
    private SQLiteDatabase mDatabase;
    boolean isClosed = false;

    private boolean isDbClose() {
        return this.isClosed;
    }

    public PlayerChatDataBaseManager(Context context) {
        DatabaseContext context1 = new DatabaseContext(context.getApplicationContext());
        try {
            context1.deleteDatabase("GsPlayerChat.db");
        }
        catch (Exception e) {
            GenseeLog.w("deleteDatabase chatdb exception or not exist");
        }
        try {
            this.dataBaseHelper = new PlayerChatDataBaseHelper((Context)context1);
            this.mDatabase = this.dataBaseHelper.getWritableDatabase();
        }
        catch (Exception e) {
            this.mDatabase = null;
            GenseeLog.e("PlayerChatDb Create Failure");
        }
        if (null == this.mDatabase) {
            GenseeLog.e("PlayerChatDataBaseManager", "mDatabase is null");
            this.isClosed = true;
        } else {
            this.isClosed = false;
            this.getChatTableName(this.mDatabase);
        }
    }

    private String getChatTableName(SQLiteDatabase db) {
        String tableName = "table_player_chat";
        try {
            db.execSQL("CREATE TABLE IF NOT EXISTS " + tableName + " (_id INTEGER PRIMARY KEY AUTOINCREMENT,colTime TEXT,colText TEXT,colChatType TEXT,colSendUserName TEXT,colSendUserId INTEGER,colRich TEXT,colReceiveName TEXT,colMsgId TEXT,colChatId INTEGER,colReceiveUserId INTEGER,colReadFlag INTEGER,colSendRole INTEGER,colReserved1 INTEGER,colReserved2 INTEGER,colReserved3 TEXT,colReserved4 TEXT);");
            db.execSQL("CREATE TABLE IF NOT EXISTS android_metadata (locale TEXT DEFAULT 'zh_CN')");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.closeDb();
            GenseeLog.e("getChatTableName e = " + (null != e ? e.getMessage() : "error"));
        }
        return tableName;
    }

    private ContentValues _insert(AbsChatMessage entity, ContentValues values) {
        if (null == values) {
            values = new ContentValues();
        } else {
            values.clear();
        }
        values.put("colReserved1", Integer.valueOf(0));
        values.put("colReserved2", Integer.valueOf(0));
        values.put("colReserved3", "");
        values.put("colReserved4", "");
        values.put("colMsgId", "");
        values.put("colSendRole", Integer.valueOf(entity.getSenderRole()));
        values.put("colChatId", Integer.valueOf(entity.getChatId()));
        if (entity instanceof PrivateMessage) {
            values.put("colChatType", "private");
            values.put("colReceiveUserId", Long.valueOf(entity.getReceiveUserId()));
            values.put("colReceiveName", ((PrivateMessage)entity).getReceiveName());
            values.put("colMsgId", entity.getId());
        } else if (entity instanceof PublicMessage) {
            values.put("colChatType", "public");
            values.put("colMsgId", entity.getId());
        } else if (entity instanceof SysMessage) {
            values.put("colChatType", "sys");
        } else if (entity instanceof HongbaoMessage) {
            values.put("colChatType", "hongbao");
        } else if (entity instanceof TipMessage) {
            values.put("colChatType", "tip");
        } else if (entity instanceof VodChatMessage) {
            values.put("colChatType", "vodmsg");
            values.put("colReserved1", Long.valueOf(((VodChatMessage)entity).getRelativeTime()));
            values.put("colReserved2", Integer.valueOf(((VodChatMessage)entity).getSendRole()));
        }
        values.put("colSendUserId", Long.valueOf(entity.getSendUserId()));
        values.put("colSendUserName", entity.getSendUserName());
        values.put("colRich", entity.getRich());
        values.put("colText", entity.getText());
        values.put("colTime", Long.valueOf(entity.getTime()));
        values.put("colReadFlag", Integer.valueOf(entity.getReadFlag()));
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertValues(List<AbsChatMessage> msgList) {
        if (this.isDbClose()) {
            return;
        }
        String sTableName = this.getChatTableName(this.mDatabase);
        try {
            this.mDatabase.beginTransaction();
            ContentValues values = new ContentValues();
            for (int i = 0; i < msgList.size(); ++i) {
                AbsChatMessage entity = msgList.get(i);
                this._insert(entity, values);
                this.mDatabase.insert(sTableName, null, values);
            }
            this.mDatabase.setTransactionSuccessful();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mDatabase.endTransaction();
        }
    }

    private AbsChatMessage dataToObject(Cursor cursor) {
        String msgType = cursor.getString(cursor.getColumnIndex("colChatType"));
        AbsChatMessage msg = null;
        if ("private".equals(msgType)) {
            msg = new PrivateMessage();
            msg.setReceiveUserId(cursor.getLong(cursor.getColumnIndex("colReceiveUserId")));
            ((PrivateMessage)msg).setReceiveName(cursor.getString(cursor.getColumnIndex("colReceiveName")));
        } else if ("public".equals(msgType)) {
            msg = new PublicMessage();
        } else if ("sys".equals(msgType)) {
            msg = new SysMessage();
        } else if ("hongbao".equals(msgType)) {
            msg = new HongbaoMessage();
        } else if ("tip".equals(msgType)) {
            msg = new TipMessage();
        } else if ("vodmsg".equals(msgType)) {
            msg = new VodChatMessage();
            ((VodChatMessage)msg).setRelativeTime(cursor.getLong(cursor.getColumnIndex("colReserved1")));
            ((VodChatMessage)msg).setSendRole(cursor.getInt(cursor.getColumnIndex("colReserved2")));
        }
        if (null != msg) {
            msg.setReadFlag(cursor.getInt(cursor.getColumnIndex("colReadFlag")));
            msg.setId(cursor.getString(cursor.getColumnIndex("colMsgId")));
            msg.setSendUserId(cursor.getLong(cursor.getColumnIndex("colSendUserId")));
            msg.setSendUserName(cursor.getString(cursor.getColumnIndex("colSendUserName")));
            msg.setRich(cursor.getString(cursor.getColumnIndex("colRich")));
            msg.setText(cursor.getString(cursor.getColumnIndex("colText")));
            msg.setTime(cursor.getLong(cursor.getColumnIndex("colTime")));
            msg.setSenderRole(cursor.getInt(cursor.getColumnIndex("colSendRole")));
            msg.setChatId(cursor.getInt(cursor.getColumnIndex("colChatId")));
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbsChatMessage getLatestMsg() {
        Cursor cursor = null;
        AbsChatMessage msg = null;
        if (this.isDbClose()) {
            return null;
        }
        try {
            String sTableName = this.getChatTableName(this.mDatabase);
            String sql = "";
            sql = "select * from " + sTableName + " order by " + "colTime" + " desc limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{"1"});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                AbsChatMessage entity;
                msg = entity = this.dataToObject(cursor);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbsChatMessage getSelfLatestMsg(long selfId) {
        Cursor cursor = null;
        AbsChatMessage msg = null;
        if (this.isDbClose()) {
            return null;
        }
        try {
            String sTableName = this.getChatTableName(this.mDatabase);
            String sql = "";
            sql = "select * from " + sTableName + " where " + "colReceiveUserId" + "=? or " + "colSendUserId" + "=?" + " order by " + "colTime" + " desc limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{selfId + "", selfId + "", "1"});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                AbsChatMessage entity;
                msg = entity = this.dataToObject(cursor);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbsChatMessage> getLatestMsgsList(int limit) {
        Cursor cursor = null;
        ArrayList<AbsChatMessage> msgList = new ArrayList<AbsChatMessage>();
        if (this.isDbClose()) {
            return msgList;
        }
        try {
            String sTableName = this.getChatTableName(this.mDatabase);
            String sql = "";
            sql = "select * from " + sTableName + " order by " + "colTime" + " desc limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{limit + ""});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                AbsChatMessage entity = this.dataToObject(cursor);
                msgList.add(entity);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        Collections.reverse(msgList);
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbsChatMessage> getMsgsByOwnerId(long msgOwnerId) {
        Cursor cursor = null;
        ArrayList<AbsChatMessage> msgList = new ArrayList<AbsChatMessage>();
        if (this.isDbClose()) {
            return msgList;
        }
        try {
            String sql = "";
            String sTableName = this.getChatTableName(this.mDatabase);
            sql = "select * from " + sTableName + " where " + "colReceiveUserId" + "=?" + " or " + "colSendUserId" + "=?" + " order by " + "colTime";
            cursor = this.mDatabase.rawQuery(sql, new String[]{msgOwnerId + "", msgOwnerId + ""});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                AbsChatMessage entity = this.dataToObject(cursor);
                msgList.add(entity);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbsChatMessage> queryChatMsgsLimitNext(int limit, long timeMillions) {
        Cursor cursor = null;
        ArrayList<AbsChatMessage> msgList = new ArrayList<AbsChatMessage>();
        if (this.isDbClose()) {
            return msgList;
        }
        try {
            String sTableName = this.getChatTableName(this.mDatabase);
            String sql = "";
            sql = "select * from " + sTableName + " where " + "colTime" + ">?" + " order by " + "colTime" + " limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{timeMillions + "", limit + ""});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                AbsChatMessage entity = this.dataToObject(cursor);
                msgList.add(entity);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbsChatMessage> queryChatMsgsLimitPre(int limit, long timeMillions) {
        ArrayList<AbsChatMessage> msgList = new ArrayList<AbsChatMessage>();
        if (this.isDbClose()) {
            return msgList;
        }
        Cursor cursor = null;
        try {
            String sql = "";
            String sTableName = this.getChatTableName(this.mDatabase);
            sql = "select * from " + sTableName + " where " + "colTime" + "<?" + " order by " + "colTime" + " desc limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{timeMillions + "", limit + ""});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                AbsChatMessage entity = this.dataToObject(cursor);
                msgList.add(entity);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        Collections.reverse(msgList);
        return msgList;
    }

    public void removeAllChatMsgs() {
        if (this.isDbClose()) {
            return;
        }
        String sTableName = this.getChatTableName(this.mDatabase);
        this.mDatabase.delete(sTableName, null, null);
    }

    public int removeChatMsgByUUID(String UUID) {
        Integer nReturnValue = 0;
        if (this.isDbClose()) {
            return nReturnValue;
        }
        String sTableName = this.getChatTableName(this.mDatabase);
        String sCondition = "colTime=?";
        nReturnValue = this.mDatabase.delete(sTableName, sCondition, new String[]{UUID});
        return nReturnValue;
    }

    public void dropChatTable() {
        if (this.isDbClose()) {
            return;
        }
        this.mDatabase.execSQL("DROP TABLE IF EXISTS table_player_chat");
    }

    public void closeDb() {
        if (null != this.mDatabase && this.mDatabase.isOpen()) {
            this.mDatabase.close();
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbsChatMessage> getLatestMsgsByOwnerId(int limit, long msgOwnerId) {
        Cursor cursor = null;
        ArrayList<AbsChatMessage> msgList = new ArrayList<AbsChatMessage>();
        if (this.isDbClose()) {
            return msgList;
        }
        try {
            String sql = "";
            String sTableName = this.getChatTableName(this.mDatabase);
            sql = "select * from " + sTableName + " where " + "colReceiveUserId" + "=?" + " or " + "colSendUserId" + "=?" + " order by " + "colTime" + " desc limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{msgOwnerId + "", msgOwnerId + "", limit + ""});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                AbsChatMessage entity = this.dataToObject(cursor);
                msgList.add(entity);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        Collections.reverse(msgList);
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbsChatMessage> queryChatMsgsByOwnerIdLimitNext(long ownerId, int limit, long timeMillions) {
        Cursor cursor = null;
        ArrayList<AbsChatMessage> msgList = new ArrayList<AbsChatMessage>();
        if (this.isDbClose()) {
            return msgList;
        }
        try {
            String sTableName = this.getChatTableName(this.mDatabase);
            String sql = "";
            sql = "select * from " + sTableName + " where (" + "colReceiveUserId" + "=?" + " or " + "colSendUserId" + "=?)" + " and " + "colTime" + ">?" + " order by " + "colTime" + " limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{ownerId + "", ownerId + "", timeMillions + "", limit + ""});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                AbsChatMessage entity = this.dataToObject(cursor);
                msgList.add(entity);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbsChatMessage> queryChatMsgsByOwnerIdLimitPre(long ownerId, int limit, long timeMillions) {
        ArrayList<AbsChatMessage> msgList = new ArrayList<AbsChatMessage>();
        if (this.isDbClose()) {
            return msgList;
        }
        Cursor cursor = null;
        try {
            String sql = "";
            String sTableName = this.getChatTableName(this.mDatabase);
            sql = "select * from " + sTableName + " where (" + "colReceiveUserId" + "=?" + " or " + "colSendUserId" + "=?)" + " and " + "colTime" + "<?" + " order by " + "colTime" + " desc limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{ownerId + "", ownerId + "", timeMillions + "", limit + ""});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                AbsChatMessage entity = this.dataToObject(cursor);
                msgList.add(entity);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        Collections.reverse(msgList);
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbsChatMessage> getPrivateLatestMsgsByOwnerId(int limit, long msgOwnerId, long selfId) {
        Cursor cursor = null;
        ArrayList<AbsChatMessage> msgList = new ArrayList<AbsChatMessage>();
        if (this.isDbClose()) {
            return msgList;
        }
        try {
            String sql = "";
            String sTableName = this.getChatTableName(this.mDatabase);
            sql = "select * from " + sTableName + " where " + "(" + "colReceiveUserId" + "=?" + " and " + "colSendUserId" + "=?)" + " or " + "(" + "colReceiveUserId" + "=?" + " and " + "colSendUserId" + "=?)" + " order by " + "colTime" + " desc limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{msgOwnerId + "", selfId + "", selfId + "", msgOwnerId + "", limit + ""});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                AbsChatMessage entity = this.dataToObject(cursor);
                msgList.add(entity);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        Collections.reverse(msgList);
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbsChatMessage> queryPrivateChatMsgsByOwnerIdLimitNext(long selfId, long toUserId, int limit, long timeMillions) {
        Cursor cursor = null;
        ArrayList<AbsChatMessage> msgList = new ArrayList<AbsChatMessage>();
        if (this.isDbClose()) {
            return msgList;
        }
        try {
            String sTableName = this.getChatTableName(this.mDatabase);
            String sql = "";
            sql = "select * from " + sTableName + " where " + "((" + "colReceiveUserId" + "=?" + " and " + "colSendUserId" + "=?)" + " or " + "(" + "colReceiveUserId" + "=?" + " and " + "colSendUserId" + "=?)) " + " and " + "colTime" + ">?" + " order by " + "colTime" + " limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{selfId + "", toUserId + "", toUserId + "", selfId + "", timeMillions + "", limit + ""});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                AbsChatMessage entity = this.dataToObject(cursor);
                msgList.add(entity);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbsChatMessage> queryPrivateChatMsgsByOwnerIdLimitPre(long selfId, long toUserId, int limit, long timeMillions) {
        ArrayList<AbsChatMessage> msgList = new ArrayList<AbsChatMessage>();
        if (this.isDbClose()) {
            return msgList;
        }
        Cursor cursor = null;
        try {
            String sql = "";
            String sTableName = this.getChatTableName(this.mDatabase);
            sql = "select * from " + sTableName + " where " + "((" + "colReceiveUserId" + "=?" + " and " + "colSendUserId" + "=?)" + " or " + "(" + "colReceiveUserId" + "=?" + " and " + "colSendUserId" + "=?))" + " and " + "colTime" + "<?" + " order by " + "colTime" + " desc limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{selfId + "", toUserId + "", toUserId + "", selfId + "", timeMillions + "", limit + ""});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                AbsChatMessage entity = this.dataToObject(cursor);
                msgList.add(entity);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        Collections.reverse(msgList);
        return msgList;
    }

    public int updateRtChatMsgReadFlag(long time) {
        if (this.isDbClose()) {
            return -1;
        }
        String tableName = this.getChatTableName(this.mDatabase);
        ContentValues values = new ContentValues();
        values.put("colReadFlag", Integer.valueOf(0));
        String sCondition = "colReadFlag=? and colTime<=?";
        int nCount = this.mDatabase.update(tableName, values, sCondition, new String[]{"1", time + ""});
        return nCount;
    }

    public int queryRtChatMsgNewsByMsgId(String msgId) {
        if (this.isDbClose()) {
            return -1;
        }
        String tableName = this.getChatTableName(this.mDatabase);
        Cursor cursor = null;
        String sCondition = "";
        sCondition = "colMsgId=? and colReadFlag=?";
        String sql = "select * from " + tableName + " where " + sCondition;
        cursor = this.mDatabase.rawQuery(sql, new String[]{msgId, "1"});
        if (null != cursor) {
            return cursor.getCount();
        }
        return 0;
    }

    public int removeRtChatMsgByMsgId(String msgId) {
        if (this.isDbClose()) {
            return -1;
        }
        String tableName = this.getChatTableName(this.mDatabase);
        Integer nReturnValue = 0;
        String sCondition = "";
        sCondition = "colMsgId=?";
        nReturnValue = this.mDatabase.delete(tableName, sCondition, new String[]{msgId});
        return nReturnValue;
    }

    public int queryRtChatMsgNewsByUserId(long userId, long timeMillions) {
        if (this.isDbClose()) {
            return -1;
        }
        String tableName = this.getChatTableName(this.mDatabase);
        Cursor cursor = null;
        String sCondition = "";
        sCondition = "colSendUserId=? and colReadFlag=? and colTime<=?";
        String sql = "select * from " + tableName + " where " + sCondition;
        cursor = this.mDatabase.rawQuery(sql, new String[]{userId + "", "1", timeMillions + ""});
        if (null != cursor) {
            return cursor.getCount();
        }
        return 0;
    }

    public int removeRtChatMsgByUserId(long userId, long timeMillions) {
        if (this.isDbClose()) {
            return -1;
        }
        String tableName = this.getChatTableName(this.mDatabase);
        Integer nReturnValue = 0;
        String sCondition = "";
        sCondition = "colSendUserId=? and colTime<=? and colChatType=?";
        nReturnValue = this.mDatabase.delete(tableName, sCondition, new String[]{userId + "", timeMillions + "", "public"});
        return nReturnValue;
    }
}

