/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.gensee.db.DatabaseContext;
import com.gensee.db.PlayerQaDataBaseHelper;
import com.gensee.entity.qa.RtQaMsg;
import com.gensee.utils.GenseeLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PlayerQaDataBaseManager {
    private PlayerQaDataBaseHelper dataBaseHelper;
    private SQLiteDatabase mDatabase;
    boolean isClosed = false;

    private boolean isDbClose() {
        return this.isClosed;
    }

    public PlayerQaDataBaseManager(Context context) {
        DatabaseContext context1 = new DatabaseContext(context.getApplicationContext());
        try {
            context1.deleteDatabase("GsPlayerQa.db");
        }
        catch (Exception e) {
            GenseeLog.w("deleteDatabase qadb exception or not exist");
        }
        try {
            this.dataBaseHelper = new PlayerQaDataBaseHelper((Context)context1);
            this.mDatabase = this.dataBaseHelper.getWritableDatabase();
        }
        catch (Exception e) {
            GenseeLog.e("PlayerQaDb Create Failure");
            e.printStackTrace();
        }
        if (null == this.mDatabase) {
            GenseeLog.e("PlayerQaDataBaseManager", "mDatabase is null");
            this.isClosed = true;
        } else {
            this.isClosed = false;
            this.getQaTableName(this.mDatabase);
        }
    }

    private String getQaTableName(SQLiteDatabase db) {
        String tableName = "table_player_qa";
        try {
            db.execSQL("CREATE TABLE IF NOT EXISTS " + tableName + " (_id INTEGER PRIMARY KEY AUTOINCREMENT,colTimestamp INTEGER,colQId TEXT,colQuestTimgstamp INTEGER,colQuestOwnerName TEXT,colQuestOwnerId INTEGER,colQuestion TEXT,colAnswerOwner TEXT,colAnswerId TEXT,colAnswerTimestamp INTEGER,colReadFlag INTEGER,colAnswer TEXT);");
            db.execSQL("CREATE TABLE IF NOT EXISTS android_metadata (locale TEXT DEFAULT 'zh_CN')");
        }
        catch (Exception e) {
            this.closeDb();
            e.printStackTrace();
            GenseeLog.d("getQaTableName e = " + (null != e ? e.getMessage() : "error"));
        }
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertQaMsgList(List<RtQaMsg> qaMsgList) {
        if (this.isDbClose()) {
            return;
        }
        String tableName = this.getQaTableName(this.mDatabase);
        try {
            this.mDatabase.beginTransaction();
            ContentValues values = new ContentValues();
            for (int i = 0; i < qaMsgList.size(); ++i) {
                RtQaMsg entity = qaMsgList.get(i);
                this._insertQa(entity, values);
                this.mDatabase.insert(tableName, null, values);
            }
            this.mDatabase.setTransactionSuccessful();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mDatabase.endTransaction();
        }
    }

    private ContentValues _insertQa(RtQaMsg msg, ContentValues cv) {
        if (null == cv) {
            cv = new ContentValues();
        } else {
            cv.clear();
        }
        cv.put("colQId", msg.getQuestId());
        cv.put("colTimestamp", Long.valueOf(msg.getTimestamp()));
        cv.put("colQuestion", msg.getQuestion());
        cv.put("colQuestTimgstamp", Long.valueOf(msg.getQuestTimgstamp()));
        cv.put("colQuestOwnerName", msg.getQuestOwnerName());
        cv.put("colQuestOwnerId", Long.valueOf(msg.getQuestOwnerId()));
        cv.put("colAnswerId", msg.getAnswerId());
        cv.put("colAnswer", msg.getAnswer());
        cv.put("colAnswerOwner", msg.getAnswerOwner());
        cv.put("colAnswerTimestamp", Long.valueOf(msg.getAnswerTimestamp()));
        cv.put("colReadFlag", Integer.valueOf(msg.getReadFlag()));
        return cv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtQaMsg getLatestQaMsg() {
        if (this.isDbClose()) {
            return null;
        }
        String tableName = this.getQaTableName(this.mDatabase);
        Cursor cursor = null;
        RtQaMsg msg = null;
        try {
            String sql = "";
            sql = "select * from " + tableName + " order by " + "colTimestamp" + " desc limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{"1"});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                RtQaMsg entity;
                msg = entity = this.dataToQaObject(cursor);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RtQaMsg> getLatestQaMsgsList(int limit) {
        Cursor cursor = null;
        ArrayList<RtQaMsg> msgList = new ArrayList<RtQaMsg>();
        if (this.isDbClose()) {
            return msgList;
        }
        try {
            String tableName = this.getQaTableName(this.mDatabase);
            String sql = "";
            sql = "select * from " + tableName + " order by " + "colTimestamp" + " desc limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{limit + ""});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                RtQaMsg entity = this.dataToQaObject(cursor);
                msgList.add(entity);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        Collections.reverse(msgList);
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RtQaMsg> queryQaMsgsLimitPre(int limit, long timeMillions) {
        ArrayList<RtQaMsg> msgList = new ArrayList<RtQaMsg>();
        if (this.isDbClose()) {
            return msgList;
        }
        Cursor cursor = null;
        try {
            String tableName = this.getQaTableName(this.mDatabase);
            String sql = "select * from " + tableName + " where " + "colTimestamp" + "<?" + " order by " + "colTimestamp" + " desc limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{timeMillions + "", limit + ""});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                RtQaMsg entity = this.dataToQaObject(cursor);
                msgList.add(entity);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        Collections.reverse(msgList);
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RtQaMsg> queryQaMsgsLimitNext(int limit, long timeMillions) {
        Cursor cursor = null;
        ArrayList<RtQaMsg> msgList = new ArrayList<RtQaMsg>();
        if (this.isDbClose()) {
            return msgList;
        }
        try {
            String sql = "";
            String tableName = this.getQaTableName(this.mDatabase);
            sql = "select * from " + tableName + " where " + "colTimestamp" + ">?" + " order by " + "colTimestamp" + " limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{timeMillions + "", limit + ""});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                RtQaMsg entity = this.dataToQaObject(cursor);
                msgList.add(entity);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RtQaMsg> queryQaMsgsByOwnerId(long qaOwnerId) {
        Cursor cursor = null;
        ArrayList<RtQaMsg> msgList = new ArrayList<RtQaMsg>();
        if (this.isDbClose()) {
            return msgList;
        }
        try {
            String tableName = this.getQaTableName(this.mDatabase);
            String sql = "";
            sql = "select * from " + tableName + " where " + "colQuestOwnerId" + "=?" + " order by " + "colTimestamp";
            cursor = this.mDatabase.rawQuery(sql, new String[]{qaOwnerId + ""});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                RtQaMsg entity = this.dataToQaObject(cursor);
                msgList.add(entity);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return msgList;
    }

    public void removeAllQaMsgs() {
        if (this.isDbClose()) {
            return;
        }
        String tableName = this.getQaTableName(this.mDatabase);
        this.mDatabase.delete(tableName, null, null);
    }

    private RtQaMsg dataToQaObject(Cursor cursor) {
        RtQaMsg msg = new RtQaMsg();
        msg.setAnswer(cursor.getString(cursor.getColumnIndex("colAnswer")));
        msg.setAnswerId(cursor.getString(cursor.getColumnIndex("colAnswerId")));
        msg.setAnswerOwner(cursor.getString(cursor.getColumnIndex("colAnswerOwner")));
        msg.setAnswerTimestamp(cursor.getLong(cursor.getColumnIndex("colAnswerTimestamp")));
        msg.setQuestId(cursor.getString(cursor.getColumnIndex("colQId")));
        msg.setQuestion(cursor.getString(cursor.getColumnIndex("colQuestion")));
        msg.setQuestOwnerId(cursor.getLong(cursor.getColumnIndex("colQuestOwnerId")));
        msg.setQuestOwnerName(cursor.getString(cursor.getColumnIndex("colQuestOwnerName")));
        msg.setQuestTimgstamp(cursor.getLong(cursor.getColumnIndex("colQuestTimgstamp")));
        msg.setTimestamp(cursor.getLong(cursor.getColumnIndex("colTimestamp")));
        return msg;
    }

    public int updateRtQaMsgReadFlag(long time) {
        if (this.isDbClose()) {
            return -1;
        }
        String tableName = this.getQaTableName(this.mDatabase);
        ContentValues values = new ContentValues();
        values.put("colReadFlag", Integer.valueOf(0));
        String sCondition = "colReadFlag=? and colTimestamp<=?";
        int nCount = this.mDatabase.update(tableName, values, sCondition, new String[]{"1", time + ""});
        return nCount;
    }

    public int queryRtQaMsgNewsByUUId(String UUID, boolean bSelf, long cancelTime) {
        if (this.isDbClose()) {
            return -1;
        }
        String tableName = this.getQaTableName(this.mDatabase);
        Cursor cursor = null;
        String sCondition = "";
        if (bSelf) {
            sCondition = "colQId=? and colAnswer<>? and colTimestamp<=? and colReadFlag=?";
            String sql = "select * from " + tableName + " where " + sCondition;
            cursor = this.mDatabase.rawQuery(sql, new String[]{UUID, "", cancelTime + "", "1"});
        } else {
            sCondition = "colQId=? and colTimestamp<=? and colReadFlag=?";
            String sql = "select * from " + tableName + " where " + sCondition;
            cursor = this.mDatabase.rawQuery(sql, new String[]{UUID, cancelTime + "", "1"});
        }
        if (null != cursor) {
            return cursor.getCount();
        }
        return 0;
    }

    public int removeRtQaMsgByUUID(String UUID, boolean bSelf, long cancelTime) {
        if (this.isDbClose()) {
            return -1;
        }
        String tableName = this.getQaTableName(this.mDatabase);
        Integer nReturnValue = 0;
        String sCondition = "";
        if (bSelf) {
            sCondition = "colQId=? and colAnswer<>? and colTimestamp<=?";
            nReturnValue = this.mDatabase.delete(tableName, sCondition, new String[]{UUID, "", cancelTime + ""});
        } else {
            sCondition = "colQId=? and colTimestamp<=?";
            nReturnValue = this.mDatabase.delete(tableName, sCondition, new String[]{UUID, cancelTime + ""});
        }
        return nReturnValue;
    }

    public void dropQaTable() {
        if (this.isDbClose()) {
            return;
        }
        this.mDatabase.execSQL("DROP TABLE IF EXISTS table_player_qa");
    }

    public void closeDb() {
        if (null != this.mDatabase && this.mDatabase.isOpen()) {
            this.mDatabase.close();
            this.isClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RtQaMsg> getLatestQaMsgsByOwnerId(int limit, long msgOwnerId) {
        Cursor cursor = null;
        ArrayList<RtQaMsg> msgList = new ArrayList<RtQaMsg>();
        if (this.isDbClose()) {
            return msgList;
        }
        try {
            String sql = "";
            String sTableName = this.getQaTableName(this.mDatabase);
            sql = "select * from " + sTableName + " where " + "colQuestOwnerId" + "=?" + " order by " + "colTimestamp" + " desc limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{msgOwnerId + "", limit + ""});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                RtQaMsg entity = this.dataToQaObject(cursor);
                msgList.add(entity);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        Collections.reverse(msgList);
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RtQaMsg> queryQaMsgsByOwnerIdLimitPre(long ownerId, int limit, long timeMillions) {
        ArrayList<RtQaMsg> msgList = new ArrayList<RtQaMsg>();
        if (this.isDbClose()) {
            return msgList;
        }
        Cursor cursor = null;
        try {
            String sql = "";
            String sTableName = this.getQaTableName(this.mDatabase);
            sql = "select * from " + sTableName + " where " + "colQuestOwnerId" + "=?" + " and " + "colTimestamp" + "<?" + " order by " + "colTimestamp" + " desc limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{ownerId + "", timeMillions + "", limit + ""});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                RtQaMsg entity = this.dataToQaObject(cursor);
                msgList.add(entity);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        Collections.reverse(msgList);
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RtQaMsg> queryQaMsgsByOwnerIdLimitNext(long ownerId, int limit, long timeMillions) {
        Cursor cursor = null;
        ArrayList<RtQaMsg> msgList = new ArrayList<RtQaMsg>();
        if (this.isDbClose()) {
            return msgList;
        }
        try {
            String sTableName = this.getQaTableName(this.mDatabase);
            String sql = "";
            sql = "select * from " + sTableName + " where " + "colQuestOwnerId" + "=?" + " and " + "colTimestamp" + ">?" + " order by " + "colTimestamp" + " limit ?";
            cursor = this.mDatabase.rawQuery(sql, new String[]{ownerId + "", timeMillions + "", limit + ""});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                RtQaMsg entity = this.dataToQaObject(cursor);
                msgList.add(entity);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
        }
        return msgList;
    }
}

