/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.holder.chat.impl;

import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.holder.chat.impl.MsgQueue;
import com.gensee.utils.GenseeLog;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class AbstractChatImpl {
    public static final int NEW_DELAY_TIME = 1000;
    private Thread chatMsgThread = null;
    private AtomicBoolean bRunning = new AtomicBoolean(false);
    private List<AbsChatMessage> chatMsgList = new ArrayList<AbsChatMessage>();
    private Object object = new Object();
    private Object objChatList = new Object();
    private long nStartTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMessage(AbsChatMessage absChatMessage) {
        this.addMsg(absChatMessage);
        if (null == this.chatMsgThread || !this.bRunning.get()) {
            this.bRunning.set(true);
            this.chatMsgThread = new ChatMsgThread();
            this.chatMsgThread.start();
        }
        Object object = this.object;
        synchronized (object) {
            this.object.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMsg(AbsChatMessage msg) {
        Object object = this.objChatList;
        synchronized (object) {
            this.chatMsgList.add(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AbsChatMessage> getAndClearMsgs() {
        ArrayList msg = null;
        Object object = this.objChatList;
        synchronized (object) {
            msg = new ArrayList(this.chatMsgList);
            this.chatMsgList.clear();
        }
        return null == msg ? new ArrayList() : msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMsg() {
        long nEndTime = Calendar.getInstance().getTimeInMillis();
        long nTimelong = nEndTime - this.nStartTime;
        if (nTimelong >= 1000L) {
            this.nStartTime = nEndTime;
            List<AbsChatMessage> msgList = null;
            Object object = this.object;
            synchronized (object) {
                int nCount = this.chatMsgList.size();
                GenseeLog.d("ChatImpl", "handleMsg chat nCount = " + nCount);
                if (nCount > 0) {
                    msgList = this.getAndClearMsgs();
                } else {
                    try {
                        this.object.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            if (null != msgList && msgList.size() > 0) {
                MsgQueue.getIns().addMsgList(msgList);
            }
        } else {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public void release() {
        if (null != this.chatMsgList) {
            this.chatMsgList.clear();
        }
        if (null != this.chatMsgThread) {
            this.chatMsgThread.interrupt();
        }
        this.bRunning.set(false);
        MsgQueue.getIns().clear();
        MsgQueue.getIns().closedb();
    }

    private class ChatMsgThread
    extends Thread {
        private ChatMsgThread() {
        }

        @Override
        public void run() {
            while (AbstractChatImpl.this.bRunning.get()) {
                AbstractChatImpl.this.handleMsg();
            }
        }
    }
}

