/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.holder.chat.impl;

import com.gensee.db.PlayerChatDataBaseManager;
import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.entity.chat.PrivateMessage;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MsgQueue {
    protected ReentrantReadWriteLock mLock;
    private PlayerChatDataBaseManager dataBaseManager;
    public static final int READ_PER_COUNT = 200;
    private static MsgQueue msgManager = null;
    private static final int QUEUE_MAX_LENGH = 200;
    private List<AbsChatMessage> msgList = new ArrayList<AbsChatMessage>();
    private List<AbsChatMessage> privateMsgList = new ArrayList<AbsChatMessage>();
    private List<AbsChatMessage> selfMsgList = new ArrayList<AbsChatMessage>();
    private boolean bPublicLatest = true;
    private boolean bPrivateLatest = true;
    private boolean bSelfLatest = true;
    private OnPublicChatHolderListener onPublicChatHolderListener;
    private OnPrivateChatHolderListener onPrivateChatHolderListener;
    private long toUserId = -1L;
    private long selfUserId = -1L;
    private int nMsgCount = 0;
    private Map<Long, Long> cancelUserIdList = new HashMap<Long, Long>();
    private Map<String, String> cancelMsgIdList = new HashMap<String, String>();

    public void setMsgCount(int nMsgCount) {
        this.nMsgCount = nMsgCount;
    }

    public int getMsgCount() {
        return this.nMsgCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MsgQueue getIns() {
        Class<MsgQueue> clazz = MsgQueue.class;
        synchronized (MsgQueue.class) {
            if (null == msgManager) {
                msgManager = new MsgQueue();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return msgManager;
        }
    }

    public MsgQueue() {
        this.mLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMsg(long userId, String msgId) {
        this.mLock.writeLock().lock();
        try {
            if (userId != 0L) {
                this.cancelUserIdList.put(userId, Calendar.getInstance().getTimeInMillis());
                this.processRemoveByUserId(userId);
            } else if (!"".equals(msgId)) {
                this.cancelMsgIdList.put(msgId, msgId);
                this.processRemoveByMsgId(msgId);
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    private void processRemoveByUserId(long userId) {
        if (null != this.dataBaseManager) {
            long timeMillion = null == this.cancelUserIdList.get(userId) ? Calendar.getInstance().getTimeInMillis() : this.cancelUserIdList.get(userId).longValue();
            int nCount = this.dataBaseManager.queryRtChatMsgNewsByUserId(userId, timeMillion);
            this.nMsgCount -= nCount;
            this.processNewMsg(0);
            this.dataBaseManager.removeRtChatMsgByUserId(userId, timeMillion);
            this.cancelMsg(userId, "");
        }
    }

    private void processRemoveByMsgId(String msgId) {
        if (null != this.dataBaseManager) {
            int nCount = this.dataBaseManager.queryRtChatMsgNewsByMsgId(msgId);
            this.nMsgCount -= nCount;
            this.processNewMsg(0);
            this.dataBaseManager.removeRtChatMsgByMsgId(msgId);
            this.cancelMsg(0L, msgId);
        }
    }

    private void cancelMsg(long userId, String msgId) {
        int count = 0;
        ArrayList<AbsChatMessage> cancelDeleteList = new ArrayList<AbsChatMessage>();
        for (AbsChatMessage msg : this.msgList) {
            if ((null == this.cancelUserIdList.get(msg.getSendUserId()) && null == this.cancelUserIdList.get(msg.getReceiveUserId()) || msg.getTime() >= this.cancelUserIdList.get(msg.getSendUserId())) && (null == this.cancelMsgIdList.get(msg.getId()) || !msg.getId().equals(this.cancelMsgIdList.get(msg.getId())))) continue;
            ++count;
            cancelDeleteList.add(msg);
        }
        this.msgList.removeAll(cancelDeleteList);
        if (count > 0) {
            int nSize = this.msgList.size();
            int nReadSize = 200 - nSize;
            if (nSize <= 0) {
                this.msgList = this.dataBaseManager.getLatestMsgsList(200);
                this.bPublicLatest = true;
            } else {
                List<AbsChatMessage> tmpList = this._queryChatMsgsListNext(this.msgList.get(nSize - 1).getTime(), nReadSize);
                this.msgList.addAll(tmpList);
                if (tmpList.size() < nReadSize) {
                    this.bPublicLatest = true;
                } else {
                    AbsChatMessage newMsg = tmpList.get(tmpList.size() - 1);
                    AbsChatMessage latestMsg = this.dataBaseManager.getLatestMsg();
                    this.bPublicLatest = null != latestMsg ? latestMsg.getTime() == newMsg.getTime() : true;
                }
            }
        }
        if (null != this.onPublicChatHolderListener) {
            this.onPublicChatHolderListener.onCancelMsg(this.msgList, this.bPublicLatest);
        }
        if (this.selfUserId > 0L) {
            this.cancelSelfMsg(userId, msgId);
        }
    }

    private void cancelSelfMsg(long userId, String msgId) {
        int count = 0;
        ArrayList<AbsChatMessage> cancelDeleteList = new ArrayList<AbsChatMessage>();
        for (AbsChatMessage msg : this.selfMsgList) {
            if ((null == this.cancelUserIdList.get(msg.getSendUserId()) && null == this.cancelUserIdList.get(msg.getReceiveUserId()) || msg.getTime() >= this.cancelUserIdList.get(msg.getSendUserId())) && (null == this.cancelMsgIdList.get(msg.getId()) || !msg.getId().equals(this.cancelMsgIdList.get(msg.getId())))) continue;
            ++count;
            cancelDeleteList.add(msg);
        }
        this.selfMsgList.removeAll(cancelDeleteList);
        if (count > 0) {
            int nSize = this.selfMsgList.size();
            int nReadSize = 200 - nSize;
            if (nSize <= 0) {
                this.selfMsgList = this.dataBaseManager.getLatestMsgsByOwnerId(200, this.selfUserId);
                this.bSelfLatest = true;
            } else {
                List<AbsChatMessage> tmpList = this.dataBaseManager.queryChatMsgsByOwnerIdLimitNext(this.selfUserId, nReadSize, this.selfMsgList.get(nSize - 1).getTime());
                this.selfMsgList.addAll(tmpList);
                if (tmpList.size() < nReadSize) {
                    this.bSelfLatest = true;
                } else {
                    AbsChatMessage newMsg = tmpList.get(tmpList.size() - 1);
                    AbsChatMessage latestMsg = this.dataBaseManager.getSelfLatestMsg(this.selfUserId);
                    this.bSelfLatest = null != latestMsg ? latestMsg.getTime() == newMsg.getTime() : true;
                }
            }
        }
        if (null != this.onPublicChatHolderListener) {
            this.onPublicChatHolderListener.onSelfCancelMsg(this.selfMsgList, this.bSelfLatest);
        }
    }

    public void updateRtChatMsgReadFlag(long time) {
        this.mLock.writeLock().lock();
        try {
            if (null != this.dataBaseManager) {
                this.dataBaseManager.updateRtChatMsgReadFlag(time);
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    public void initMsgDbHelper(PlayerChatDataBaseManager playerDataBaseManager) {
        this.dataBaseManager = playerDataBaseManager;
        this.nMsgCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMsgList(List<AbsChatMessage> dataList) {
        this.mLock.writeLock().lock();
        try {
            boolean bBottom;
            ArrayList<AbsChatMessage> cancelDeleteList = new ArrayList<AbsChatMessage>();
            for (AbsChatMessage msg : dataList) {
                if ((null == this.cancelUserIdList.get(msg.getSendUserId()) || msg.getTime() >= this.cancelUserIdList.get(msg.getSendUserId())) && (null == this.cancelMsgIdList.get(msg.getId()) || !msg.getId().equals(this.cancelMsgIdList.get(msg.getId())))) continue;
                cancelDeleteList.add(msg);
            }
            dataList.removeAll(cancelDeleteList);
            if (this.toUserId > 0L || this.selfUserId > 0L) {
                ArrayList<AbsChatMessage> toUserList = new ArrayList<AbsChatMessage>();
                ArrayList<AbsChatMessage> selfUserList = new ArrayList<AbsChatMessage>();
                for (AbsChatMessage chatMessage : dataList) {
                    if (this.toUserId > 0L && chatMessage instanceof PrivateMessage && (chatMessage.getSendUserId() == this.toUserId || chatMessage.getReceiveUserId() == this.toUserId)) {
                        toUserList.add(chatMessage);
                    }
                    if (this.selfUserId <= 0L || chatMessage.getSendUserId() != this.selfUserId && chatMessage.getReceiveUserId() != this.selfUserId) continue;
                    selfUserList.add(chatMessage);
                }
                if (toUserList.size() > 0) {
                    this.processToUserList(toUserList);
                }
                if (selfUserList.size() > 0) {
                    this.processSelfList(selfUserList);
                }
            }
            int nSize = dataList.size();
            boolean bl = bBottom = null != this.onPublicChatHolderListener && this.onPublicChatHolderListener.isLvBottom();
            if (this.bPublicLatest) {
                if (nSize >= 200) {
                    if (bBottom) {
                        int index = nSize - 200;
                        this.msgList.clear();
                        for (int i = index; i < nSize; ++i) {
                            this.msgList.add(dataList.get(i));
                        }
                    } else {
                        int otherSize = 200 - this.msgList.size();
                        for (int i = 0; i < otherSize; ++i) {
                            this.msgList.add(dataList.get(i));
                        }
                        this.bPublicLatest = false;
                    }
                } else {
                    int nTotalSize = nSize + this.msgList.size();
                    if (nTotalSize < 200) {
                        this.msgList.addAll(dataList);
                    } else if (bBottom) {
                        int nOtherSize = nTotalSize - 200;
                        ArrayList<AbsChatMessage> deleteList = new ArrayList<AbsChatMessage>();
                        for (int i = 0; i < nOtherSize; ++i) {
                            deleteList.add(this.msgList.get(i));
                        }
                        this.msgList.removeAll(deleteList);
                        this.msgList.addAll(dataList);
                    } else {
                        int otherSize = 200 - this.msgList.size();
                        for (int i = 0; i < otherSize; ++i) {
                            this.msgList.add(dataList.get(i));
                        }
                        this.bPublicLatest = false;
                    }
                }
            }
            if (!this.bPublicLatest || !bBottom) {
                for (AbsChatMessage msg : dataList) {
                    msg.setReadFlag(1);
                }
            }
            if (this.dataBaseManager != null) {
                this.dataBaseManager.insertValues(dataList);
            }
            this.processNewMsg(dataList.size());
            this.refreshMsg();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    private void processNewMsg(int nCount) {
        if (null != this.onPublicChatHolderListener) {
            this.nMsgCount = this.bPublicLatest && this.onPublicChatHolderListener.isLvBottom() ? 0 : (this.nMsgCount += nCount);
            this.onPublicChatHolderListener.onNewMsgCount(this.nMsgCount);
        }
    }

    private void processToUserList(List<AbsChatMessage> toUserList) {
        boolean bBottom;
        int nSize = toUserList.size();
        boolean bl = bBottom = null != this.onPrivateChatHolderListener && this.onPrivateChatHolderListener.isLvBottom();
        if (this.bPrivateLatest) {
            if (nSize >= 200) {
                if (bBottom) {
                    int index = nSize - 200;
                    this.privateMsgList.clear();
                    for (int i = index; i < nSize; ++i) {
                        this.privateMsgList.add(toUserList.get(i));
                    }
                } else {
                    int otherSize = 200 - this.privateMsgList.size();
                    for (int i = 0; i < otherSize; ++i) {
                        this.privateMsgList.add(toUserList.get(i));
                    }
                    this.bPrivateLatest = false;
                }
            } else {
                int nTotalSize = nSize + this.privateMsgList.size();
                if (nTotalSize <= 200) {
                    this.privateMsgList.addAll(toUserList);
                } else if (bBottom) {
                    int nOtherSize = nTotalSize - 200;
                    ArrayList<AbsChatMessage> deleteList = new ArrayList<AbsChatMessage>();
                    for (int i = 0; i < nOtherSize; ++i) {
                        deleteList.add(this.privateMsgList.get(i));
                    }
                    this.privateMsgList.removeAll(deleteList);
                    this.privateMsgList.addAll(toUserList);
                } else {
                    int otherSize = 200 - this.privateMsgList.size();
                    for (int i = 0; i < otherSize; ++i) {
                        this.privateMsgList.add(toUserList.get(i));
                    }
                    this.bPrivateLatest = false;
                }
            }
        }
        if (null != this.onPrivateChatHolderListener) {
            this.onPrivateChatHolderListener.refreshMsg(this.privateMsgList, this.bPrivateLatest, this.toUserId);
        }
    }

    private void processSelfList(List<AbsChatMessage> selfUserList) {
        boolean bBottom;
        int nSize = selfUserList.size();
        boolean bl = bBottom = null != this.onPublicChatHolderListener && this.onPublicChatHolderListener.isSelfLvBottom();
        if (this.bSelfLatest) {
            if (nSize >= 200) {
                if (bBottom) {
                    int index = nSize - 200;
                    this.selfMsgList.clear();
                    for (int i = index; i < nSize; ++i) {
                        this.selfMsgList.add(selfUserList.get(i));
                    }
                } else {
                    int otherSize = 200 - this.selfMsgList.size();
                    for (int i = 0; i < otherSize; ++i) {
                        this.selfMsgList.add(selfUserList.get(i));
                    }
                    this.bSelfLatest = false;
                }
            } else {
                int nTotalSize = nSize + this.selfMsgList.size();
                if (nTotalSize <= 200) {
                    this.selfMsgList.addAll(selfUserList);
                } else if (bBottom) {
                    int nOtherSize = nTotalSize - 200;
                    ArrayList<AbsChatMessage> deleteList = new ArrayList<AbsChatMessage>();
                    for (int i = 0; i < nOtherSize; ++i) {
                        deleteList.add(this.selfMsgList.get(i));
                    }
                    this.selfMsgList.removeAll(deleteList);
                    this.selfMsgList.addAll(selfUserList);
                } else {
                    int otherSize = 200 - this.selfMsgList.size();
                    for (int i = 0; i < otherSize; ++i) {
                        this.selfMsgList.add(selfUserList.get(i));
                    }
                    this.bSelfLatest = false;
                }
            }
        }
        if (null != this.onPublicChatHolderListener && this.selfUserId > 0L) {
            this.onPublicChatHolderListener.refreshSelfMsg(this.selfMsgList, this.bSelfLatest);
        }
    }

    public AbsChatMessage getLatestMsg() {
        AbsChatMessage absChatMessage = null;
        this.mLock.readLock().lock();
        try {
            if (this.dataBaseManager != null) {
                absChatMessage = this.dataBaseManager.getLatestMsg();
            }
        }
        finally {
            this.mLock.readLock().unlock();
        }
        return absChatMessage;
    }

    public AbsChatMessage getSelfLatestMsg() {
        AbsChatMessage absChatMessage = null;
        this.mLock.readLock().lock();
        try {
            if (this.dataBaseManager != null) {
                absChatMessage = this.dataBaseManager.getSelfLatestMsg(this.selfUserId);
            }
        }
        finally {
            this.mLock.readLock().unlock();
        }
        return absChatMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMsg(AbsChatMessage msg) {
        this.mLock.writeLock().lock();
        try {
            int nSize = this.msgList.size();
            for (int i = 0; i < nSize; ++i) {
                AbsChatMessage tmpMsg = this.msgList.get(i);
                if (tmpMsg.getTime() != msg.getTime()) continue;
                this.msgList.remove(i);
                break;
            }
            if (this.dataBaseManager != null) {
                this.dataBaseManager.removeChatMsgByUUID(msg.getTime() + "");
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    public void getLatestMsgsList() {
        this.mLock.writeLock().lock();
        try {
            if (this.dataBaseManager != null) {
                this.msgList.clear();
                this.msgList.addAll(this.dataBaseManager.getLatestMsgsList(200));
                this.bPublicLatest = true;
                this.processNewMsg(this.nMsgCount);
                this.refreshMsg();
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbsChatMessage> getAllMsgsListNext(long timeMillions) {
        List<AbsChatMessage> returnList = null;
        this.mLock.readLock().lock();
        try {
            returnList = this._queryChatMsgsListNext(timeMillions);
        }
        finally {
            this.mLock.readLock().unlock();
        }
        return returnList;
    }

    private List<AbsChatMessage> _queryChatMsgsListNext(long timeMillions, int limit) {
        ArrayList<AbsChatMessage> returnList = new ArrayList<AbsChatMessage>();
        if (null != this.dataBaseManager) {
            returnList.addAll(this.dataBaseManager.queryChatMsgsLimitNext(limit, timeMillions));
        }
        return returnList;
    }

    private List<AbsChatMessage> _queryChatMsgsListNext(long timeMillions) {
        ArrayList<AbsChatMessage> returnList = new ArrayList<AbsChatMessage>();
        if (null != this.dataBaseManager) {
            returnList.addAll(this.dataBaseManager.queryChatMsgsLimitNext(200, timeMillions));
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbsChatMessage> getAllMsgsListPre(long timeMillions) {
        List<AbsChatMessage> returnList = null;
        this.mLock.readLock().lock();
        try {
            if (this.dataBaseManager != null) {
                returnList = this.dataBaseManager.queryChatMsgsLimitPre(200, timeMillions);
            }
        }
        finally {
            this.mLock.readLock().unlock();
        }
        return returnList;
    }

    private void refreshMsg() {
        if (null != this.onPublicChatHolderListener) {
            this.onPublicChatHolderListener.refreshMsg(new ArrayList<AbsChatMessage>(this.msgList), this.bPublicLatest);
        }
    }

    public void getMsgList() {
        this.mLock.writeLock().lock();
        try {
            this.refreshMsg();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageFresh() {
        this.mLock.writeLock().lock();
        try {
            int nMsgSize = this.msgList.size();
            if (nMsgSize > 0) {
                AbsChatMessage firstMsg = this.msgList.get(0);
                List<AbsChatMessage> tmpList = MsgQueue.getIns().getAllMsgsListPre(firstMsg.getTime());
                int tempSize = tmpList.size();
                if (nMsgSize + tempSize > 200) {
                    int nDeleteCount = nMsgSize + tempSize - 200;
                    ArrayList<AbsChatMessage> deleteList = new ArrayList<AbsChatMessage>();
                    for (int i = nMsgSize - 1; i >= nMsgSize - nDeleteCount; --i) {
                        deleteList.add(this.msgList.get(i));
                    }
                    this.msgList.removeAll(deleteList);
                    deleteList.clear();
                    deleteList = null;
                    this.bPublicLatest = false;
                }
                this.msgList.addAll(0, tmpList);
                Object var3_3 = null;
            }
            if (null != this.onPublicChatHolderListener) {
                this.onPublicChatHolderListener.onPullMsg(this.msgList, this.bPublicLatest);
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessageLoadMore() {
        this.mLock.writeLock().lock();
        try {
            int nMsgSize = this.msgList.size();
            if (nMsgSize > 0) {
                AbsChatMessage lastMsg = this.msgList.get(nMsgSize - 1);
                List<AbsChatMessage> tmpList = MsgQueue.getIns().getAllMsgsListNext(lastMsg.getTime());
                int tempSize = tmpList.size();
                if (tempSize < 200) {
                    this.bPublicLatest = true;
                } else if (tempSize == 200) {
                    boolean bTrue = false;
                    AbsChatMessage nCurLatestMsg = tmpList.get(tempSize - 1);
                    AbsChatMessage nDbLatestMsg = MsgQueue.getIns().getLatestMsg();
                    bTrue = nDbLatestMsg == null ? true : nCurLatestMsg.getTime() == nDbLatestMsg.getTime();
                    this.bPublicLatest = bTrue;
                }
                if (nMsgSize + tempSize > 200) {
                    int nDeleteCount = nMsgSize + tempSize - 200;
                    ArrayList<AbsChatMessage> deleteList = new ArrayList<AbsChatMessage>();
                    for (int i = 0; i < nDeleteCount; ++i) {
                        deleteList.add(this.msgList.get(i));
                    }
                    this.msgList.removeAll(deleteList);
                    deleteList.clear();
                    deleteList = null;
                }
                this.msgList.addAll(tmpList);
            }
            if (null != this.onPublicChatHolderListener) {
                this.onPublicChatHolderListener.onLoadMsg(this.msgList, this.bPublicLatest);
                this.processNewMsg(0);
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbsChatMessage> getMsgsByOwnerId(long msgOwnerId) {
        List<AbsChatMessage> returnList = null;
        this.mLock.readLock().lock();
        try {
            returnList = this.dataBaseManager.getMsgsByOwnerId(msgOwnerId);
        }
        finally {
            this.mLock.readLock().unlock();
        }
        return returnList;
    }

    public void clear() {
        this.mLock.writeLock().lock();
        try {
            this.msgList.clear();
            this.selfMsgList.clear();
            this.privateMsgList.clear();
            this.bPublicLatest = true;
            this.bPrivateLatest = true;
            this.bSelfLatest = true;
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    public void closedb() {
        this.mLock.writeLock().lock();
        try {
            if (this.dataBaseManager != null) {
                this.dataBaseManager.closeDb();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSelfLatestMsg(long selfUserId) {
        this.mLock.writeLock().lock();
        try {
            if (this.dataBaseManager != null) {
                this.selfUserId = selfUserId;
                this.selfMsgList.clear();
                this.selfMsgList.addAll(this.dataBaseManager.getLatestMsgsByOwnerId(200, selfUserId));
                this.bSelfLatest = true;
                this.refreshSelfMsg();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    private void refreshSelfMsg() {
        if (null != this.onPublicChatHolderListener && this.selfUserId > 0L) {
            this.onPublicChatHolderListener.refreshSelfMsg(this.selfMsgList, this.bSelfLatest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSelfMessageFresh(long selfId) {
        this.mLock.writeLock().lock();
        try {
            int nMsgSize = this.selfMsgList.size();
            if (nMsgSize > 0) {
                int tempSize;
                AbsChatMessage firstMsg = this.selfMsgList.get(0);
                List<AbsChatMessage> tmpList = null;
                if (this.dataBaseManager != null) {
                    tmpList = this.dataBaseManager.queryChatMsgsByOwnerIdLimitPre(selfId, 200, firstMsg.getTime());
                }
                int n = tempSize = tmpList == null ? 0 : tmpList.size();
                if (nMsgSize + tempSize > 200) {
                    int nDeleteCount = nMsgSize + tempSize - 200;
                    ArrayList<AbsChatMessage> deleteList = new ArrayList<AbsChatMessage>();
                    for (int i = nMsgSize - 1; i >= nMsgSize - nDeleteCount; --i) {
                        deleteList.add(this.selfMsgList.get(i));
                    }
                    this.selfMsgList.removeAll(deleteList);
                    deleteList.clear();
                    deleteList = null;
                    this.bSelfLatest = false;
                }
                if (tmpList != null) {
                    this.selfMsgList.addAll(0, tmpList);
                    tmpList.clear();
                    tmpList = null;
                }
            }
            if (null != this.onPublicChatHolderListener && this.selfUserId > 0L) {
                this.onPublicChatHolderListener.onPullSelfMsg(this.selfMsgList, this.bSelfLatest);
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSelfMessageLoadMore(long selfId) {
        this.mLock.writeLock().lock();
        try {
            int nMsgSize = this.selfMsgList.size();
            if (nMsgSize > 0) {
                int tempSize;
                AbsChatMessage lastMsg = this.selfMsgList.get(nMsgSize - 1);
                List<AbsChatMessage> tmpList = null;
                if (this.dataBaseManager != null) {
                    tmpList = this.dataBaseManager.queryChatMsgsByOwnerIdLimitNext(selfId, 200, lastMsg.getTime());
                }
                int n = tempSize = tmpList == null ? 0 : tmpList.size();
                if (tempSize < 200) {
                    this.bSelfLatest = true;
                } else if (tempSize == 200) {
                    boolean bTrue = false;
                    AbsChatMessage nCurLatestMsg = tmpList.get(tempSize - 1);
                    AbsChatMessage nDbLatestMsg = MsgQueue.getIns().getSelfLatestMsg();
                    bTrue = nDbLatestMsg == null ? true : nCurLatestMsg.getTime() == nDbLatestMsg.getTime();
                    this.bSelfLatest = bTrue;
                }
                if (nMsgSize + tempSize > 200) {
                    int nDeleteCount = nMsgSize + tempSize - 200;
                    ArrayList<AbsChatMessage> deleteList = new ArrayList<AbsChatMessage>();
                    for (int i = 0; i < nDeleteCount; ++i) {
                        deleteList.add(this.selfMsgList.get(i));
                    }
                    this.selfMsgList.removeAll(deleteList);
                    deleteList.clear();
                    deleteList = null;
                }
                if (tmpList != null) {
                    this.selfMsgList.addAll(tmpList);
                }
            }
            if (null != this.onPublicChatHolderListener && this.selfUserId > 0L) {
                this.onPublicChatHolderListener.onLoadSelfMsg(this.selfMsgList, this.bSelfLatest);
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPrivateLatestMsg(long selfId, long toUserId) {
        this.mLock.writeLock().lock();
        try {
            if (this.dataBaseManager != null) {
                this.toUserId = toUserId;
                this.privateMsgList.clear();
                this.privateMsgList.addAll(this.dataBaseManager.getPrivateLatestMsgsByOwnerId(200, toUserId, selfId));
                this.bPrivateLatest = true;
                this.refreshPrivateMsg(toUserId);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    private void refreshPrivateMsg(long ownerId) {
        if (null != this.onPrivateChatHolderListener && this.toUserId > 0L && this.toUserId == ownerId) {
            this.onPrivateChatHolderListener.refreshMsg(this.privateMsgList, this.bPrivateLatest, ownerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPrivateMessageFresh(long selfId, long toUserId) {
        this.mLock.writeLock().lock();
        try {
            int nMsgSize = this.privateMsgList.size();
            if (nMsgSize > 0) {
                int tempSize;
                AbsChatMessage firstMsg = this.privateMsgList.get(0);
                List<AbsChatMessage> tmpList = null;
                if (this.dataBaseManager != null) {
                    tmpList = this.dataBaseManager.queryPrivateChatMsgsByOwnerIdLimitPre(selfId, toUserId, 200, firstMsg.getTime());
                }
                int n = tempSize = tmpList == null ? 0 : tmpList.size();
                if (nMsgSize + tempSize > 200) {
                    int nDeleteCount = nMsgSize + tempSize - 200;
                    ArrayList<AbsChatMessage> deleteList = new ArrayList<AbsChatMessage>();
                    for (int i = nMsgSize - 1; i >= nMsgSize - nDeleteCount; --i) {
                        deleteList.add(this.privateMsgList.get(i));
                    }
                    this.privateMsgList.removeAll(deleteList);
                    deleteList.clear();
                    deleteList = null;
                    this.bPrivateLatest = false;
                }
                if (tmpList != null) {
                    this.privateMsgList.addAll(0, tmpList);
                    tmpList = null;
                }
            }
            if (null != this.onPrivateChatHolderListener && this.toUserId > 0L && this.toUserId == toUserId) {
                this.onPrivateChatHolderListener.onPullMsg(this.privateMsgList, this.bPrivateLatest, toUserId);
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPrivateMessageLoadMore(long selfId, long ownerId) {
        this.mLock.writeLock().lock();
        try {
            int nMsgSize = this.privateMsgList.size();
            if (nMsgSize > 0) {
                int tempSize;
                AbsChatMessage lastMsg = this.privateMsgList.get(nMsgSize - 1);
                List<AbsChatMessage> tmpList = null;
                if (this.dataBaseManager != null) {
                    tmpList = this.dataBaseManager.queryPrivateChatMsgsByOwnerIdLimitNext(selfId, ownerId, 200, lastMsg.getTime());
                }
                int n = tempSize = tmpList == null ? 0 : tmpList.size();
                if (tempSize < 200) {
                    this.bPrivateLatest = true;
                } else if (tempSize == 200) {
                    boolean bTrue = false;
                    AbsChatMessage nCurLatestMsg = tmpList.get(tempSize - 1);
                    AbsChatMessage nDbLatestMsg = MsgQueue.getIns().getLatestMsg();
                    bTrue = nDbLatestMsg == null ? true : nCurLatestMsg.getTime() == nDbLatestMsg.getTime();
                    this.bPrivateLatest = bTrue;
                }
                if (nMsgSize + tempSize > 200) {
                    int nDeleteCount = nMsgSize + tempSize - 200;
                    ArrayList<AbsChatMessage> deleteList = new ArrayList<AbsChatMessage>();
                    for (int i = 0; i < nDeleteCount; ++i) {
                        deleteList.add(this.privateMsgList.get(i));
                    }
                    this.privateMsgList.removeAll(deleteList);
                    deleteList.clear();
                    deleteList = null;
                }
                if (tmpList != null) {
                    this.privateMsgList.addAll(tmpList);
                }
            }
            if (null != this.onPrivateChatHolderListener && this.toUserId > 0L && this.toUserId == ownerId) {
                this.onPrivateChatHolderListener.onLoadMsg(this.privateMsgList, this.bPrivateLatest, ownerId);
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    public void resetSelfList() {
        this.selfUserId = -1L;
    }

    public void resetToUserList() {
        this.toUserId = -1L;
    }

    public void setOnPublicChatHolderListener(OnPublicChatHolderListener onPublicChatHolderListener) {
        this.onPublicChatHolderListener = onPublicChatHolderListener;
    }

    public void setOnPrivateChatHolderListener(OnPrivateChatHolderListener onPrivateChatHolderListener) {
        this.onPrivateChatHolderListener = onPrivateChatHolderListener;
    }

    public boolean isPublicLatest() {
        this.mLock.readLock().lock();
        try {
            boolean bl = this.bPublicLatest;
            return bl;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    public boolean isSelfLatest() {
        this.mLock.readLock().lock();
        try {
            boolean bl = this.bSelfLatest;
            return bl;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    public boolean isPrivateLatest() {
        this.mLock.readLock().lock();
        try {
            boolean bl = this.bPrivateLatest;
            return bl;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    public long getSelfUserId() {
        this.mLock.readLock().lock();
        try {
            long l = this.selfUserId;
            return l;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    public static interface OnPrivateChatHolderListener {
        public boolean isLvBottom();

        public void refreshMsg(List<AbsChatMessage> var1, boolean var2, long var3);

        public void onPullMsg(List<AbsChatMessage> var1, boolean var2, long var3);

        public void onLoadMsg(List<AbsChatMessage> var1, boolean var2, long var3);
    }

    public static interface OnPublicChatHolderListener {
        public boolean isLvBottom();

        public boolean isSelfLvBottom();

        public void refreshSelfMsg(List<AbsChatMessage> var1, boolean var2);

        public void onPullSelfMsg(List<AbsChatMessage> var1, boolean var2);

        public void onLoadSelfMsg(List<AbsChatMessage> var1, boolean var2);

        public void onSelfCancelMsg(List<AbsChatMessage> var1, boolean var2);

        public void refreshMsg(List<AbsChatMessage> var1, boolean var2);

        public void onPullMsg(List<AbsChatMessage> var1, boolean var2);

        public void onLoadMsg(List<AbsChatMessage> var1, boolean var2);

        public void onNewMsgCount(int var1);

        public void onCancelMsg(List<AbsChatMessage> var1, boolean var2);
    }
}

