/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.gensee.common.GenseeConfig;
import com.gensee.entity.LoginResEntity;
import com.gensee.entity.MainIdc;
import com.gensee.entity.PingEntity;
import com.gensee.net.IHttpHandler;
import com.gensee.utils.GenseeLog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbsHandler
implements IHttpHandler {
    protected Context context;
    private OnErrListener errListener;
    protected boolean isBox = false;

    public AbsHandler(Context context) {
        this.context = context;
    }

    public void setErrListener(OnErrListener errListener) {
        this.errListener = errListener;
    }

    public void setBox(boolean isBox) {
        this.isBox = isBox;
    }

    private int getInt(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            GenseeLog.w("value = " + value);
            return -1;
        }
    }

    @Override
    public void sendError(String result) {
        if (this.errListener != null) {
            this.errListener.onErr(this.getInt(result));
            return;
        }
    }

    protected static void parseMainIDC(LoginResEntity entity, JSONObject jsonObject) {
        if (jsonObject != null) {
            MainIdc mainIdc = new MainIdc();
            mainIdc.setCode(AbsHandler.getJsonString(jsonObject, "code"));
            entity.setAblPort(AbsHandler.getJsonString(jsonObject, "albPort"));
            mainIdc.setAlbProxyPort(AbsHandler.getJsonString(jsonObject, "albProxyPort"));
            mainIdc.setChoosePriorNetwork(AbsHandler.getJsonString(jsonObject, "choosePriorNetwork"));
            mainIdc.setDiagnoseUploadUrl(AbsHandler.getJsonString(jsonObject, "diagnoseUploadUrl"));
            mainIdc.setPingRequired(AbsHandler.getJsonString(jsonObject, "pingRequired"));
            mainIdc.setPingThreshold(AbsHandler.getJsonString(jsonObject, "pingThreshold"));
            mainIdc.setPingUrl(AbsHandler.getJsonString(jsonObject, "pingUrl"));
            mainIdc.setId(AbsHandler.getJsonString(jsonObject, "id"));
            entity.setMainIdc(mainIdc);
        }
    }

    protected static List<PingEntity> getPingArray(JSONArray jsonArray) {
        if (jsonArray == null || jsonArray.length() == 0) {
            return null;
        }
        int len = jsonArray.length();
        ArrayList<PingEntity> entities = new ArrayList<PingEntity>();
        PingEntity entity = null;
        for (int i = 0; i < len; ++i) {
            JSONObject jsonObject = AbsHandler.getJSONObj(jsonArray, i);
            if (jsonObject == null) continue;
            entity = new PingEntity();
            entity.setCode(AbsHandler.getJsonString(jsonObject, "code"));
            entity.setDescription(AbsHandler.getJsonString(jsonObject, "description"));
            entity.setId(AbsHandler.getJsonString(jsonObject, "id"));
            entity.setName(AbsHandler.getJsonString(jsonObject, "name"));
            entity.setPingUrl(AbsHandler.getJsonString(jsonObject, "pingUrl"));
            entity.setSupported(AbsHandler.getJsonString(jsonObject, "supported"));
            entities.add(entity);
        }
        return entities;
    }

    @Override
    public void sendBroadCast(String action, Serializable value) {
    }

    public void sendError(String action, int value) {
        if (this.errListener != null) {
            this.errListener.onErr(value);
            return;
        }
    }

    @Override
    public void onConnectError(int errorType, String errorInfo) {
        this.sendError("errorconnected", errorType);
    }

    @Override
    public boolean isNetConneced() {
        return AbsHandler.isNetConneced(this.context);
    }

    public static boolean isNetConneced(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo info = manager.getActiveNetworkInfo();
        if (info != null) {
            return info.isConnected();
        }
        return false;
    }

    public static JSONObject converToJson(String info) {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(info.toString());
        }
        catch (JSONException e) {
            GenseeLog.e(e);
        }
        return jsonObject;
    }

    public static JSONObject getJSONObj(JSONObject source, String name) {
        if (source != null) {
            try {
                return source.getJSONObject(name);
            }
            catch (JSONException e) {
                GenseeLog.e("getJSONObj " + e.toString());
            }
        }
        return null;
    }

    public static JSONObject getJSONObj(JSONArray array, int idx) {
        if (array != null) {
            try {
                return array.getJSONObject(idx);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static JSONArray getArray(JSONObject jsonObject, String name) {
        try {
            return jsonObject.getJSONArray(name);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getJsonString(JSONObject jsonObject, String name) {
        String value;
        block3: {
            value = "";
            if (jsonObject.has(name)) {
                try {
                    value = jsonObject.getString(name);
                }
                catch (JSONException e) {
                    if ("data".equals(name)) break block3;
                    GenseeLog.i("getJsonString name = " + name);
                    GenseeLog.e(e);
                }
            }
        }
        return value;
    }

    public static JSONObject getJsonObj(JSONArray jsonArray, int i) {
        try {
            return (JSONObject)jsonArray.get(i);
        }
        catch (JSONException e) {
            GenseeLog.d("getJsonObj", e.toString());
            return null;
        }
    }

    public static JSONArray getJsonArray(String data) {
        JSONArray array = null;
        try {
            array = new JSONArray(data);
        }
        catch (JSONException e) {
            GenseeLog.e(e);
        }
        return array;
    }

    public static long getJsonLong(JSONObject jsonObject, String name) {
        if (jsonObject.has(name)) {
            try {
                return jsonObject.getLong(name);
            }
            catch (JSONException e) {
                GenseeLog.e(e);
            }
        }
        return 0L;
    }

    public static int getJsonInt(JSONObject jsonObject, String name) {
        if (jsonObject.has(name)) {
            try {
                return jsonObject.getInt(name);
            }
            catch (JSONException e) {
                GenseeLog.e(e);
            }
        }
        return -1;
    }

    public static boolean getJsonBool(JSONObject jsonObject, String name) {
        if (jsonObject.has(name)) {
            try {
                return jsonObject.getBoolean(name);
            }
            catch (JSONException e) {
                GenseeLog.e(e);
            }
        }
        return false;
    }

    public static long verifyUserId(long customUserId, long gsUserId) {
        if (GenseeConfig.isUIDVerification ? customUserId > 1000000000L : customUserId != 0L && customUserId != -1L) {
            return customUserId;
        }
        return gsUserId;
    }

    public static interface OnErrListener {
        public void onErr(int var1);
    }
}

