/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.net;

import android.content.Context;
import com.gensee.common.GenseeConfig;
import com.gensee.common.ServiceType;
import com.gensee.entity.AccessResEntity;
import com.gensee.entity.InitParam;
import com.gensee.entity.LoginResEntity;
import com.gensee.net.AbsHandler;
import com.gensee.net.AbsRtAction;
import com.gensee.net.AbsRtHandler;
import com.gensee.net.StringRes;
import com.gensee.report.ReportInfo;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import com.gensee.utils.upload.LogProperty;
import org.json.JSONObject;

public abstract class AbsRoomSite
extends AbsRtAction {
    private String accessAddr = "%s/%s/site/accessInfo";
    private String loginAddr = "%s/%s/site/loginInfo";
    private String loginAddrEnhanced = "%s/%s/site/loginInfoEnhanced";
    String domain = "";
    String number = "";
    private long userId = -1L;
    private String userName = "";
    private String watchWord = "";
    private String password = "";
    private String nickName = "";
    private ServiceType serviceType;
    private String userData = "";
    private String k = "";
    private boolean bAttendeeOnly = false;
    private boolean bHostJoinOnly = false;
    private boolean isPannistOnly = false;

    public boolean isbAttendeeOnly() {
        return this.bAttendeeOnly;
    }

    public void setbAttendeeOnly(boolean bAttendeeOnly) {
        this.bAttendeeOnly = bAttendeeOnly;
    }

    public boolean isHostJoinOnly() {
        return this.bHostJoinOnly;
    }

    public void setHostJoinOnly(boolean bHostJoinOnly) {
        this.bHostJoinOnly = bHostJoinOnly;
    }

    public boolean isPannistOnly() {
        return this.isPannistOnly;
    }

    public void setPannistOnly(boolean isPannistOnly) {
        this.isPannistOnly = isPannistOnly;
    }

    public void initWithGensee(InitParam p) {
        if (p == null || !p.isValid()) {
            this.onErr(-107);
            return;
        }
        this.initLog(null);
        this.userId = p.getUserId();
        this.userName = p.getLoginAccount();
        this.userName = this.userName == null ? "" : this.userName;
        this.password = p.getLoginPwd();
        this.nickName = p.getNickName();
        this.nickName = this.nickName == null ? "" : this.nickName;
        this.watchWord = p.getJoinPwd();
        this.domain = p.getDomain();
        this.number = p.getNumber();
        this.serviceType = p.getServiceType();
        this.userData = p.getUserData();
        this.k = p.getK();
        String liveId = p.getLiveId();
        if (GenseeConfig.isTwoStep || !GenseeConfig.thirdCertificationAuth) {
            if (!StringUtil.isEmpty(this.number)) {
                this.accessInfo(this.domain, this.number);
            } else if (!StringUtil.isEmpty(liveId)) {
                this.login(this.domain, this.userName, this.password, this.nickName, this.watchWord, liveId, p.getK());
            }
        } else {
            this.loginOneStep(this.domain, this.number, this.userName, this.password, this.nickName, this.watchWord, liveId, p.getK());
        }
    }

    private void loginOneStep(String domain, String number, String account, String password, String nickName, String watchword, String webcastId, String k) {
        if (!this.mHttpHandler.is3GOrWifi()) {
            this.onErr(-104);
            return;
        }
        String strUrl = String.format(GenseeConfig.getScheme() + (GenseeConfig.thirdCertificationAuth ? this.loginAddrEnhanced : this.loginAddr), domain, this.serviceType.getValue());
        account = StringUtil.urlEncode(account);
        nickName = StringUtil.urlEncode(nickName);
        k = StringUtil.urlEncode(k);
        nickName = StringUtil.isEmpty(nickName) ? account : nickName;
        boolean entryByCode = false;
        if (StringUtil.isEmpty(webcastId)) {
            webcastId = number;
            entryByCode = true;
        }
        password = password == null ? "" : password;
        watchword = watchword == null ? "" : watchword;
        String param = "login=" + account + "&password=" + password + "&watchword=" + watchword + "&webcastId=" + webcastId + "&nickName=" + nickName + "&k=" + k + "&entryByCode=" + entryByCode + "&role=";
        String role = this.isbAttendeeOnly() ? (ServiceType.TRAINING.getValue().equals(this.serviceType.getValue()) ? "7" : "8") : (this.isHostJoinOnly() ? "3" : (this.isPannistOnly() ? "4" : ""));
        this.doPostRequest(strUrl, param + role, new StringRes(){

            @Override
            public void onRes(String result) {
                LoginResEntity loginResEntity = AbsRoomSite.this.mHttpHandler.onLoginInfoRes(result, true);
                if (loginResEntity != null) {
                    if ("10".equals(loginResEntity.getResult())) {
                        AbsRoomSite.this.onErr(-108);
                        return;
                    }
                    int role = loginResEntity.getRole();
                    if (role == 8 && ServiceType.TRAINING.getValue().equals(AbsRoomSite.this.serviceType.getValue())) {
                        AbsRoomSite.this.onErr(-108);
                        return;
                    }
                    switch (role) {
                        case 3: {
                            loginResEntity.setRole(7);
                            break;
                        }
                        case 4: {
                            loginResEntity.setRole(4);
                            break;
                        }
                        case 7: {
                            loginResEntity.setRole(8);
                            break;
                        }
                        case 8: {
                            loginResEntity.setRole(8);
                            break;
                        }
                    }
                    AbsRoomSite.this.onVerifyUserId(loginResEntity);
                    AbsRoomSite.this.mHttpHandler.onLoginFinish(loginResEntity);
                }
            }

            @Override
            public void onConnectError(int errorType, String errorInfo) {
                AbsRoomSite.this.mHttpHandler.onError(errorType, errorInfo);
            }
        });
    }

    @Deprecated
    public void initWithGensee(String domain, String number, String loginAccount, String loginPwd, String nickName, String joinPwd, ServiceType serviceType) {
        this.accessInfo(domain, number, -1L, loginAccount, loginPwd, nickName, joinPwd, serviceType);
    }

    public AbsRoomSite(AbsRtHandler httpHandler) {
        super(httpHandler);
    }

    public AbsRoomSite(Context context) {
        super((AbsRtHandler)null);
        GenseeLog.reportInfo = new ReportInfo(context);
        this.mHttpHandler = new AbsRtHandler(context){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected AccessResEntity onAccessInfoRes(String info) {
                JSONObject jsonObject = AbsHandler.converToJson(info);
                if (null != jsonObject) {
                    int result = AbsHandler.getJsonInt(jsonObject, "result");
                    if (1 == result) {
                        boolean isSurportMobile = true;
                        if (!this.isBox && jsonObject.has("ipad")) {
                            String spi = AbsHandler.getJsonString(jsonObject, "ipad");
                            isSurportMobile = "true".equalsIgnoreCase(spi);
                        }
                        if (!isSurportMobile) {
                            AbsRoomSite.this.onErr(18);
                            return null;
                        }
                        AccessResEntity resEntity = new AccessResEntity();
                        String webcastId = AbsHandler.getJsonString(jsonObject, "webcastId");
                        String loginTag = AbsHandler.getJsonString(jsonObject, "login");
                        String watchword = AbsHandler.getJsonString(jsonObject, "watchword");
                        String subject = AbsHandler.getJsonString(jsonObject, "subject");
                        String webOnly = "false";
                        if (jsonObject.has("webonly")) {
                            webOnly = AbsHandler.getJsonString(jsonObject, "webonly");
                        }
                        long startTime = AbsHandler.getJsonLong(jsonObject, "startTime");
                        boolean bLiveEnable = false;
                        if (jsonObject.has("liveEnable")) {
                            bLiveEnable = "true".equalsIgnoreCase(AbsHandler.getJsonString(jsonObject, "liveEnable"));
                        }
                        resEntity.setWebcastId(webcastId);
                        resEntity.setLoginTag(loginTag);
                        resEntity.setWatchword(watchword);
                        resEntity.setSubject(subject);
                        resEntity.setResult(result + "");
                        resEntity.setWebOnly(webOnly);
                        resEntity.setStartTime(startTime);
                        resEntity.setLiveEnable(bLiveEnable);
                        if (!"1".equals(webOnly)) return resEntity;
                        AbsRoomSite.this.onErr(7);
                        return null;
                    } else if (0 == result) {
                        AbsRoomSite.this.onErr(0);
                        return null;
                    } else if (3 == result) {
                        AbsRoomSite.this.onErr(8);
                        return null;
                    } else {
                        AbsRoomSite.this.onErr(result);
                    }
                    return null;
                } else {
                    AbsRoomSite.this.onErr(-1);
                }
                return null;
            }

            @Override
            protected void onError(int err, String desc) {
                AbsRoomSite.this.onErr(err);
            }

            @Override
            protected AccessResEntity onAccessUrlInfoRes(String result) {
                return null;
            }

            @Override
            protected LoginResEntity onLoginInfoRes(String loginInfo, boolean needSendErr) {
                JSONObject jsonObject = AbsHandler.converToJson(loginInfo);
                LoginResEntity entity = null;
                if (null != jsonObject) {
                    int result = AbsHandler.getJsonInt(jsonObject, "result");
                    if (1 == result) {
                        entity = new LoginResEntity();
                        entity.setResult(result + "");
                        entity.setSiteId(AbsHandler.getJsonLong(jsonObject, "siteId"));
                        entity.setUserId(AbsHandler.getJsonLong(jsonObject, "userId"));
                        entity.setWebcastId(AbsHandler.getJsonString(jsonObject, "webcastId"));
                        entity.setWebcastSubject(AbsHandler.getJsonString(jsonObject, "webcastSubject"));
                        entity.setServicetype(AbsHandler.getJsonString(jsonObject, "servicetype"));
                        entity.setIpowner(AbsHandler.getJsonString(jsonObject, "ipowner"));
                        entity.setConfpassword(AbsHandler.getJsonString(jsonObject, "confpassword"));
                        entity.setResponsetype(AbsHandler.getJsonString(jsonObject, "responsetype"));
                        entity.setJoinType(AbsHandler.getJsonString(jsonObject, "joinType"));
                        entity.setNickName(AbsHandler.getJsonString(jsonObject, "nickName"));
                        entity.setMainIdcCode(AbsHandler.getJsonString(jsonObject, "mainIdcCode"));
                        entity.setAlbServer(AbsHandler.getJsonString(jsonObject, "ablServer"));
                        entity.setWebUrl(AbsHandler.getJsonString(jsonObject, "webUrl"));
                        if (jsonObject.has("clientApi")) {
                            entity.setClientApi(AbsHandler.getJsonString(jsonObject, "clientApi"));
                        }
                        entity.setIsNeedVisitALB(AbsHandler.getJsonString(jsonObject, "isNeedVisitALB"));
                        entity.setChoosePriorNetwork(AbsHandler.getJsonString(jsonObject, "choosePriorNetwork"));
                        entity.setIpLibEnabled(AbsHandler.getJsonString(jsonObject, "ipLibEnabled"));
                        entity.setGcDomain(AbsHandler.getJsonString(jsonObject, "gcDomain"));
                        entity.setGcPort(AbsHandler.getJsonString(jsonObject, "gcPort"));
                        entity.setPingArray(AbsHandler.getPingArray(AbsHandler.getArray(jsonObject, "array")));
                        entity.setSiteId(AbsHandler.getJsonLong(jsonObject, "siteId"));
                        entity.setUserId(AbsHandler.getJsonLong(jsonObject, "userId"));
                        entity.setWebcastId(AbsHandler.getJsonString(jsonObject, "webcastId"));
                        entity.setWebcastSubject(AbsHandler.getJsonString(jsonObject, "webcastSubject"));
                        entity.setServicetype(AbsHandler.getJsonString(jsonObject, "servicetype"));
                        entity.setIpowner(AbsHandler.getJsonString(jsonObject, "ipowner"));
                        entity.setConfpassword(AbsHandler.getJsonString(jsonObject, "confpassword"));
                        entity.setResponsetype(AbsHandler.getJsonString(jsonObject, "responsetype"));
                        entity.setJoinType(AbsHandler.getJsonString(jsonObject, "joinType"));
                        entity.setNickName(AbsHandler.getJsonString(jsonObject, "nickName"));
                        entity.setMainIdcCode(AbsHandler.getJsonString(jsonObject, "mainIdcCode"));
                        entity.setAlbServer(AbsHandler.getJsonString(jsonObject, "ablServer"));
                        entity.setIsNeedVisitALB(AbsHandler.getJsonString(jsonObject, "isNeedVisitALB"));
                        entity.setIpLibEnabled(AbsHandler.getJsonString(jsonObject, "ipLibEnabled"));
                        entity.setGcDomain(AbsHandler.getJsonString(jsonObject, "gcDomain"));
                        entity.setGcPort(AbsHandler.getJsonString(jsonObject, "gcPort"));
                        entity.setPingArray(AbsHandler.getPingArray(AbsHandler.getArray(jsonObject, "array")));
                        AbsHandler.parseMainIDC(entity, AbsHandler.getJSONObj(jsonObject, "mainIDC"));
                        entity.setHttpMode(AbsHandler.getJsonBool(jsonObject, "httpMode"));
                        entity.setRole(AbsHandler.getJsonInt(jsonObject, "role"));
                        entity.setPayNotifyUrl(AbsHandler.getJsonString(jsonObject, "payNotifyUrl"));
                        entity.setWxPaySupport(AbsHandler.getJsonBool(jsonObject, "wxPaySupport"));
                        entity.setAliPaySupport(AbsHandler.getJsonBool(jsonObject, "aliPaySupport"));
                        entity.setBarrageEnabled(AbsHandler.getJsonBool(jsonObject, "barrageEnabled"));
                        entity.setUploadCtrlServerUrl(AbsHandler.getJsonString(jsonObject, "uploadCtrlServerUrl"));
                        entity.setAudioCodec(AbsHandler.getJsonString(jsonObject, "audioCoding"));
                        entity.setScheduleInfo(AbsHandler.getJsonString(jsonObject, "arrangement"));
                        entity.setSpeakerInfo(AbsHandler.getJsonString(jsonObject, "speaker"));
                        entity.setDescription(AbsHandler.getJsonString(jsonObject, "content"));
                        entity.setRewardConfig(AbsHandler.getJsonString(jsonObject, "rewardConfig"));
                        return entity;
                    }
                    if (result == 10) {
                        entity = new LoginResEntity();
                        entity.setResult(String.valueOf(result));
                    } else if (needSendErr) {
                        AbsRoomSite.this.onErr(result);
                    }
                } else if (needSendErr) {
                    AbsRoomSite.this.onErr(-1);
                }
                return entity;
            }

            @Override
            protected void onLoginFinish(Object object) {
                LoginResEntity entity = (LoginResEntity)object;
                if (GenseeLog.isInited() && null != GenseeLog.reportInfo) {
                    GenseeLog.reportInfo.setLoginEntityInfo(entity);
                    String userName = "";
                    String confId = "";
                    long userId = 0L;
                    long siteId = 0L;
                    if (entity != null) {
                        userName = entity.getNickName();
                        confId = entity.getWebcastId();
                        userId = entity.getUserId();
                        siteId = entity.getSiteId();
                    }
                    LogProperty.getIns().setProperty(this.context, userName, confId, userId, siteId, null);
                }
                entity.setUserData(AbsRoomSite.this.userData);
                GenseeConfig.getIns().setLoginResEntity(entity);
                AbsRoomSite.this.onLoginEnd(entity);
            }
        };
    }

    protected void accessInfo(String domain, String number, long userId, String userName, String pwd, String nickName, String watchWord, ServiceType serviceType) {
        this.userId = userId;
        this.userName = userName == null ? "" : userName;
        this.password = pwd;
        this.nickName = nickName;
        this.watchWord = watchWord;
        this.domain = domain;
        this.number = number;
        this.serviceType = serviceType;
        this.accessInfo(domain, number);
    }

    protected void accessInfo(String domain, String number) {
        if (!this.mHttpHandler.is3GOrWifi()) {
            this.onErr(-104);
            return;
        }
        String strUrl = String.format(GenseeConfig.getScheme() + this.accessAddr, domain, this.serviceType.getValue());
        this.doPostRequest(strUrl, "number=" + number + "&domain=" + domain, new StringRes(){

            @Override
            public void onRes(String result) {
                AccessResEntity accessResEntity = AbsRoomSite.this.mHttpHandler.onAccessInfoRes(result);
                if (accessResEntity != null) {
                    AbsRoomSite.this.onAccessResult(accessResEntity);
                }
            }

            @Override
            public void onConnectError(int errorType, String errorInfo) {
                AbsRoomSite.this.mHttpHandler.onError(errorType, errorInfo);
            }
        });
    }

    protected void login(AccessResEntity accessResEntity, InitParam p) {
        this.login(p.getDomain(), p.getLoginAccount(), p.getLoginPwd(), p.getNickName(), p.getJoinPwd(), accessResEntity.getWebcastId(), p.getK());
    }

    private void login(AccessResEntity accessResEntity) {
        this.login(this.domain, this.userName, this.password, this.nickName, this.watchWord, accessResEntity.getWebcastId(), this.k);
    }

    protected void login(String domain, String account, String password, String nickName, String watchword, String webcastId, String k) {
        if (!this.mHttpHandler.is3GOrWifi()) {
            this.onErr(-104);
            return;
        }
        String strUrl = String.format(GenseeConfig.getScheme() + (GenseeConfig.thirdCertificationAuth ? this.loginAddrEnhanced : this.loginAddr), domain, this.serviceType.getValue());
        account = StringUtil.urlEncode(account);
        nickName = StringUtil.urlEncode(nickName);
        k = StringUtil.urlEncode(k);
        nickName = StringUtil.isEmpty(nickName) ? account : nickName;
        password = password == null ? "" : password;
        watchword = watchword == null ? "" : watchword;
        String param = "login=" + account + "&password=" + password + "&watchword=" + watchword + "&webcastId=" + webcastId + "&nickName=" + nickName + "&k=" + k + "&role=";
        if (this.bHostJoinOnly) {
            this.loginHost(strUrl, param);
        } else {
            this.loginAttende(strUrl, param);
        }
    }

    private void loginHost(final String strUrl, final String param) {
        int role = 3;
        this.doPostRequest(strUrl, param + role, new StringRes(){

            @Override
            public void onRes(String result) {
                LoginResEntity loginResEntity = AbsRoomSite.this.mHttpHandler.onLoginInfoRes(result, AbsRoomSite.this.bHostJoinOnly);
                if (loginResEntity != null) {
                    if ("10".equals(loginResEntity.getResult())) {
                        AbsRoomSite.this.onErr(-108);
                        return;
                    }
                    loginResEntity.setRole(7);
                    AbsRoomSite.this.onVerifyUserId(loginResEntity);
                    AbsRoomSite.this.mHttpHandler.onLoginFinish(loginResEntity);
                } else if (!AbsRoomSite.this.bHostJoinOnly) {
                    AbsRoomSite.this.loginPanist(strUrl, param);
                }
            }

            @Override
            public void onConnectError(int errorType, String errorInfo) {
                AbsRoomSite.this.mHttpHandler.onError(errorType, errorInfo);
            }
        });
    }

    private void loginPanist(String strUrl, String param) {
        int role = 4;
        this.doPostRequest(strUrl, param + 4, new StringRes(){

            @Override
            public void onRes(String result) {
                LoginResEntity loginResEntity = AbsRoomSite.this.mHttpHandler.onLoginInfoRes(result, true);
                if (loginResEntity != null) {
                    if ("10".equals(loginResEntity.getResult())) {
                        AbsRoomSite.this.onErr(-108);
                        return;
                    }
                    loginResEntity.setRole(4);
                    AbsRoomSite.this.onVerifyUserId(loginResEntity);
                    AbsRoomSite.this.mHttpHandler.onLoginFinish(loginResEntity);
                }
            }

            @Override
            public void onConnectError(int errorType, String errorInfo) {
                AbsRoomSite.this.mHttpHandler.onError(errorType, errorInfo);
            }
        });
    }

    private void loginAttende(final String strUrl, final String param) {
        int role = 8;
        if (ServiceType.TRAINING.getValue().equals(this.serviceType.getValue())) {
            role = 7;
        }
        this.doPostRequest(strUrl, param + role, new StringRes(){

            @Override
            public void onRes(String result) {
                LoginResEntity loginResEntity = AbsRoomSite.this.mHttpHandler.onLoginInfoRes(result, AbsRoomSite.this.bAttendeeOnly);
                if (loginResEntity != null) {
                    if ("10".equals(loginResEntity.getResult())) {
                        AbsRoomSite.this.onErr(-108);
                        return;
                    }
                    loginResEntity.setRole(8);
                    AbsRoomSite.this.onVerifyUserId(loginResEntity);
                    AbsRoomSite.this.mHttpHandler.onLoginFinish(loginResEntity);
                } else if (!AbsRoomSite.this.bAttendeeOnly) {
                    AbsRoomSite.this.loginHost(strUrl, param);
                }
            }

            @Override
            public void onConnectError(int errorType, String errorInfo) {
                AbsRoomSite.this.mHttpHandler.onError(errorType, errorInfo);
            }
        });
    }

    private void onVerifyUserId(LoginResEntity loginResEntity) {
        loginResEntity.setUserId(AbsHandler.verifyUserId(this.userId, loginResEntity.getUserId()));
    }

    protected boolean onAccessResult(AccessResEntity accessResEntity) {
        if (accessResEntity != null) {
            this.login(accessResEntity);
        }
        return false;
    }

    protected void initLog(Context c) {
        GenseeLog.initLog();
    }

    protected abstract void onLoginEnd(LoginResEntity var1);

    protected abstract void onErr(int var1);

    public void setBox(boolean isBox) {
        this.mHttpHandler.setBox(isBox);
    }
}

