/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.net;

import com.gensee.entity.LoginResEntity;
import com.gensee.entity.Reward;
import com.gensee.net.AbsRtAction;
import com.gensee.net.AbsRtHandler;
import com.gensee.net.StringRes;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;

public class RewardAction
extends AbsRtAction {
    public RewardAction() {
        super((AbsRtHandler)null);
    }

    public boolean reward(Reward reward, LoginResEntity entity, StringRes res) {
        if (reward == null) {
            return false;
        }
        int money = reward.getMoney();
        GenseeLog.d("AbsHttpAction", "reward money = " + reward);
        if (money <= 0 || money >= Integer.MAX_VALUE || entity == null) {
            GenseeLog.w("AbsHttpAction", "reward:money is invalid or you are not join the live room");
            return false;
        }
        String addr = entity.getPayNotifyUrl();
        if (StringUtil.isEmpty(addr)) {
            GenseeLog.w("AbsHttpAction", "reward service not support,Asking for help from sales!");
            return false;
        }
        String url = entity.getPayNotifyUrl() + "/newOrder";
        StringBuilder sb = new StringBuilder(url).append('?').append("siteid=").append(entity.getSiteId()).append("&confid=").append(entity.getWebcastId()).append("&servicetype=").append(entity.getServicetype()).append("&alb=").append(StringUtil.getHttpAlbAddr(entity.getAlbServer())).append("&userid=").append(entity.getUserId()).append("&username=").append(StringUtil.urlEncode(entity.getNickName())).append("&comment=").append(StringUtil.urlEncode(reward.getComment())).append("&tippaytype=").append(reward.getPayType().getValue()).append("&agenttype=").append("appsdk").append("&amount=").append(money).append("&expire=").append(reward.getExpire()).append("&desc=").append(StringUtil.urlEncode(reward.getDesc()));
        this.doGetRequest(sb.toString(), res);
        return true;
    }
}

