/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.report;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.gensee.entity.LoginResEntity;
import com.gensee.utils.GenseeLog;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportInfo {
    private String time;
    private String app;
    private Conf conf;
    private User user;

    public ReportInfo(Context context) {
        SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date now = new Date();
        this.time = "\"time\":\"" + timeFormat.format(now) + "\",";
        this.app = this.getAppInfo(context);
        this.conf = new Conf();
        this.user = new User();
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public Conf getConf() {
        return this.conf;
    }

    public void setConf(Conf conf) {
        this.conf = conf;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    private String getUserInfo() {
        HashMap<String, String> userInfo = new HashMap<String, String>();
        if (null != this.user) {
            userInfo.put("id", this.user.getId());
            userInfo.put("name", this.user.getName());
            userInfo.put("role", this.user.getRole());
        }
        JSONObject o = new JSONObject(userInfo);
        return "\"user\":" + o.toString();
    }

    private String getConfJsonInfo() {
        HashMap<String, String> confInfo = new HashMap<String, String>();
        if (null != this.conf) {
            confInfo.put("id", this.conf.getId());
            confInfo.put("name", this.conf.getName());
            confInfo.put("siteid", this.conf.getSiteid());
            confInfo.put("sitename", this.conf.getSitename());
        }
        JSONObject o = new JSONObject(confInfo);
        return "\"conf\":" + o.toString() + ",";
    }

    private String getAppInfo(Context context) {
        HashMap<String, String> app = new HashMap<String, String>();
        if (null == context) {
            return "";
        }
        app.put("name", context.getPackageName());
        app.put("version", this.getAppVersionName(context));
        JSONObject o = new JSONObject(app);
        return "\"app\":" + o.toString() + ",";
    }

    private String getAppVersionName(Context context) {
        String versionName = "";
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            versionName = packageInfo.versionName;
            if ("".equals(versionName)) {
                return "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return versionName;
    }

    private String getOs() {
        HashMap<String, String> os = new HashMap<String, String>();
        os.put("type", "Android");
        os.put("version", Build.VERSION.RELEASE);
        os.put("apilevel", Build.VERSION.SDK_INT + "");
        JSONObject o = new JSONObject(os);
        return "\"os\":" + o.toString() + ",";
    }

    private String hardWareJsonInfo() {
        String mem;
        HashMap<String, String> hardware = new HashMap<String, String>();
        hardware.put("device", Build.MODEL);
        String cpu = ReportInfo.getCpuName();
        if (cpu != null) {
            hardware.put("cpu", cpu);
        }
        if ((mem = this.getTotalMemory()) != null) {
            hardware.put("mem", mem);
        }
        JSONObject o = new JSONObject(hardware);
        try {
            Log.d((String)"", (String)("diagnose " + o.toString(2)));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return "\"hardware\":" + o.toString() + ",";
    }

    public static String getCpuName() {
        BufferedReader br = null;
        String cpu = "no info";
        try {
            FileReader fr = new FileReader("/proc/cpuinfo");
            br = new BufferedReader(fr);
            String text = br.readLine();
            if (text != null) {
                String[] array = text.split(":\\s+", 2);
                cpu = array != null ? (array.length > 1 ? array[1] : array[0]) : text;
                do {
                    GenseeLog.d("ReportInfo", " cpu info:" + text);
                } while ((text = br.readLine()) != null);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return cpu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTotalMemory() {
        String str1 = "/proc/meminfo";
        String str2 = null;
        FileReader fr = null;
        BufferedReader localBufferedReader = null;
        try {
            fr = new FileReader(str1);
            if (fr != null && (str2 = (localBufferedReader = new BufferedReader(fr, 8192)).readLine()) != null) {
                // empty if block
            }
        }
        catch (IOException e) {
        }
        finally {
            if (localBufferedReader != null) {
                try {
                    localBufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return str2;
    }

    public void setLoginEntityInfo(LoginResEntity entity) {
        this.conf.setId(entity.getWebcastId());
        this.conf.setName(entity.getWebcastSubject());
        this.conf.setSiteid(entity.getSiteId() + "");
        this.conf.setSitename(entity.getWebUrl());
        this.user.setId(entity.getUserId() + "");
        this.user.setName(entity.getNickName());
        this.user.setRole(entity.getRole() + "");
        this.writeInfo();
    }

    public void writeInfo() {
        String jsonStr = "{\"report\":{" + this.time + this.hardWareJsonInfo() + this.getOs() + this.app + this.getConfJsonInfo() + this.getUserInfo() + "}}";
        GenseeLog.writeAppInfo(jsonStr);
    }

    public class User {
        private String id;
        private String name;
        private String role;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public String toString() {
            return "User [id=" + this.id + ", name=" + this.name + ", role=" + this.role + "]";
        }
    }

    public class Conf {
        private String id;
        private String name;
        private String siteid;
        private String sitename;

        public String toString() {
            return "Conf [id=" + this.id + ", name=" + this.name + ", siteid=" + this.siteid + ", sitename=" + this.sitename + "]";
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSiteid() {
            return this.siteid;
        }

        public void setSiteid(String siteid) {
            this.siteid = siteid;
        }

        public String getSitename() {
            return this.sitename;
        }

        public void setSitename(String sitename) {
            this.sitename = sitename;
        }
    }

    public class App {
        private String name;
        private String version;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String toString() {
            return "App [name=" + this.name + ", version=" + this.version + "]";
        }
    }

    public class Os {
        private String type;
        private String version;
        private String apilevel;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getApilevel() {
            return this.apilevel;
        }

        public void setApilevel(String apilevel) {
            this.apilevel = apilevel;
        }

        public String toString() {
            return "Os [type=" + this.type + ", version=" + this.version + ", apilevel=" + this.apilevel + "]";
        }
    }

    public class HardWare {
        private String device;
        private String cpu;
        private String mem;

        public String getDevice() {
            return this.device;
        }

        public void setDevice(String device) {
            this.device = device;
        }

        public String getCpu() {
            return this.cpu;
        }

        public void setCpu(String cpu) {
            this.cpu = cpu;
        }

        public String getMem() {
            return this.mem;
        }

        public void setMem(String mem) {
            this.mem = mem;
        }

        public String toString() {
            return "HardWare [device=" + this.device + ", cpu=" + this.cpu + ", mem=" + this.mem + "]";
        }
    }
}

