/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.routine;

import com.gensee.common.RoleType;
import com.gensee.utils.StringUtil;
import java.io.Serializable;

public class UserInfo
implements Serializable {
    private static final long serialVersionUID = -5529950640501956365L;
    public static final long LOD_USER_ID = 0x7F00000000000000L;
    private long id;
    private String name;
    private int role;
    private long pri;
    private int status;
    private int clientType;
    private String strUserData;
    private long order;
    private int chatId;
    private int result;
    private int time;

    public UserInfo() {
        this.order = 0L;
        this.clientType = 0;
        this.role = 8;
        this.pri = 0L;
        this.id = 0L;
        this.status = 0;
        this.order = 0L;
    }

    public UserInfo(long userId, String name, int role, int chatId) {
        this.id = userId;
        this.name = name;
        this.role = role;
        this.chatId = chatId;
    }

    public UserInfo(int result, long userId, String name, int role, String userData, int time) {
        this(userId, name, role, 0);
        this.strUserData = userData;
        this.time = time;
        this.result = result;
    }

    public void update(UserInfo info) {
        if (info != null && info.getId() == this.id) {
            this.name = info.getName();
            this.role = info.getRole();
            this.chatId = info.getChatId();
            this.status = info.getStatus();
            this.strUserData = info.getStrUserData();
            this.clientType = info.getClientType();
            this.order = info.getOrder();
            this.pri = info.getPri();
        }
    }

    public long getUserId() {
        return this.getId();
    }

    public long getId() {
        return this.id;
    }

    public void setUserId(int userId) {
        this.setId(userId);
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getRole() {
        return this.role;
    }

    public void setRole(int role) {
        this.role = role;
    }

    public long getPri() {
        return this.pri;
    }

    public void setPri(long pri) {
        this.pri = pri;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getClientType() {
        return this.clientType;
    }

    public void setClientType(int clientType) {
        this.clientType = clientType;
    }

    public String getStrUserData() {
        if (StringUtil.isEmpty(this.strUserData)) {
            return "";
        }
        return StringUtil.hexStr2Str(this.strUserData);
    }

    public String getUserData() {
        return this.getStrUserData();
    }

    public void setStrUserData(String strUserData) {
        this.strUserData = strUserData;
    }

    public long getOrder() {
        return this.order;
    }

    public void setOrder(long order) {
        this.order = order;
    }

    public int getChatId() {
        return this.chatId;
    }

    public void setChatId(int chatId) {
        this.chatId = chatId;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public String toString() {
        return "UserInfo [id=" + this.id + ", name=" + this.name + ", role=" + this.role + ", pri=" + this.pri + ", status=" + this.status + ", clientType=" + this.clientType + ", strUserData=" + this.strUserData + ", order=" + this.order + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserInfo other = (UserInfo)obj;
        return this.id == other.id;
    }

    public boolean IsPcClient() {
        return this.clientType == 0;
    }

    public boolean IsMacClient() {
        return this.clientType == 11;
    }

    public boolean IsWebClient() {
        return this.clientType == 1 || this.clientType == 16 || this.clientType == 17;
    }

    public boolean IsWebHttpClient() {
        return this.clientType == 2;
    }

    public boolean IsIPadWebClient() {
        return this.clientType == 3;
    }

    public boolean IsIPhoneWebClient() {
        return this.clientType == 4;
    }

    public boolean IsAndroidPadWebClient() {
        return this.clientType == 5;
    }

    public boolean IsAndroidPhoneWebClient() {
        return this.clientType == 6;
    }

    public boolean IsIPadClient() {
        return this.clientType == 7;
    }

    public boolean IsAndroidPadClient() {
        return this.clientType == 9;
    }

    public boolean IsAndroidPhoneClient() {
        return this.clientType == 10;
    }

    public boolean IsMobileClient() {
        return this.clientType == 237;
    }

    public boolean IsIPhoneClient() {
        return this.clientType == 8;
    }

    public boolean IsRoleGreater(int otherUserRole) {
        return RoleType.isRoleGreater(otherUserRole, this.role);
    }

    @Deprecated
    public boolean IsHost() {
        return this.isHost();
    }

    public boolean isHost() {
        return RoleType.isHost(this.role);
    }

    public boolean isPresenter() {
        return RoleType.isPresentor(this.role);
    }

    @Deprecated
    public boolean IsPresentor() {
        return this.isPresenter();
    }

    public boolean IsPanelist() {
        return RoleType.isPanelist(this.role);
    }

    public boolean isAssistant() {
        return this.IsPanelist();
    }

    public boolean isAttendee() {
        return this.IsAttendee();
    }

    public boolean IsAttendee() {
        return RoleType.isAttendee(this.role);
    }

    public boolean isAttendeeWeb() {
        return this.IsAttendeeWeb();
    }

    public boolean IsAttendeeWeb() {
        return RoleType.isAttendeeWeb(this.role);
    }

    public boolean IsLodUser() {
        return RoleType.isLodUser(this.role);
    }

    public boolean hasAVDevice() {
        return this.hasAudioDevice() || this.hasVideoDevice();
    }

    public boolean isAVOpen() {
        return this.IsAudioOpen() || this.IsVideoOpen();
    }

    public boolean hasAudioDevice() {
        return (this.status & 1) == 1;
    }

    public boolean hasVideoDevice() {
        return (this.status & 2) == 2;
    }

    public boolean IsAudioOpen() {
        return (this.status & 4) == 4;
    }

    public boolean IsAudioMute() {
        return (this.status & 0x10) == 16;
    }

    public boolean IsVideoOpen() {
        return (this.status & 8) == 8;
    }

    public boolean IsVideoActived() {
        return (this.status & 0x2000) == 8192;
    }

    public boolean IsRequestUpgrade() {
        return (this.status & 0x40) == 64;
    }

    public boolean IsChatMute() {
        return (this.status & 0x80) == 128;
    }

    public boolean IsHandup() {
        return (this.status & 0x8000) == 32768;
    }

    public boolean IsRollcall_1() {
        return (this.status & 0x200) == 512;
    }

    public boolean IsRollcall_2() {
        return (this.status & 0x400) == 1024;
    }

    public boolean IsWebAudioInvite() {
        return (this.status & 0x800) == 2048;
    }

    public boolean IsWebAudio() {
        return (this.status & 0x1000) == 4096;
    }

    public boolean IsRequestVoice() {
        return (this.status & 0x4000) == 16384;
    }

    public boolean can_be_asker() {
        return this.clientType == 0 || this.clientType == 1 || this.clientType == 7 || this.clientType == 8 || this.clientType == 9 || this.clientType == 10 || this.clientType == 11;
    }

    public boolean can_be_rostrum() {
        return this.clientType == 0 || this.clientType == 7 || this.clientType == 8 || this.clientType == 9 || this.clientType == 10 || this.clientType == 11;
    }

    public boolean can_doc_create() {
        return (this.pri & 1L) == 1L;
    }

    public boolean can_doc_anno() {
        return (this.pri & 2L) == 2L;
    }

    public boolean can_doc_sync_page() {
        return (this.pri & 4L) == 4L;
    }

    public boolean can_video_open_self() {
        return (this.pri & 8L) == 8L;
    }

    public boolean can_video_set_main() {
        return (this.pri & 0x10L) == 16L;
    }

    public boolean can_audio_open_self() {
        return (this.pri & 0x20L) == 32L;
    }

    public boolean can_as_open() {
        return (this.pri & 0x40L) == 64L;
    }

    public boolean can_chat_public() {
        return (this.pri & 0x80L) == 128L;
    }

    public boolean can_chat_private() {
        return (this.pri & 0x100L) == 256L;
    }

    public boolean can_vote_create_del() {
        return (this.pri & 0x200L) == 512L;
    }

    public boolean can_vote_publish() {
        return (this.pri & 0x400L) == 1024L;
    }

    public boolean can_vote_publish_result() {
        return (this.pri & 0x800L) == 2048L;
    }

    public boolean can_vote_vote() {
        return (this.pri & 0x1000L) == 4096L;
    }

    public boolean can_vote_publish_popup() {
        return (this.pri & 0x2000L) == 8192L;
    }

    public boolean can_qa_reply() {
        return (this.pri & 0x4000L) == 16384L;
    }

    public boolean can_qa_publish() {
        return (this.pri & 0x8000L) == 32768L;
    }

    public boolean can_lvod_begin_end() {
        return (this.pri & 0x10000L) == 65536L;
    }

    public boolean can_user_show_overview() {
        return (this.pri & 0x20000L) == 131072L;
    }

    public boolean can_user_ctrl_other_media() {
        return (this.pri & 0x40000L) == 262144L;
    }

    public boolean can_user_grant_role() {
        return (this.pri & 0x80000L) == 524288L;
    }

    public boolean can_user_allow_upgrade_from_web() {
        return (this.pri & 0x100000L) == 0x100000L;
    }

    public boolean can_user_kickout() {
        return (this.pri & 0x200000L) == 0x200000L;
    }

    public boolean can_global_ctrl_broadcast() {
        return (this.pri & 0x400000L) == 0x400000L;
    }

    public boolean can_global_ctrl_record() {
        return (this.pri & 0x800000L) == 0x800000L;
    }

    public boolean can_global_switch_layout_on_web() {
        return (this.pri & 0x1000000L) == 0x1000000L;
    }

    public boolean can_global_livetext() {
        return (this.pri & 0x2000000L) == 0x2000000L;
    }

    public boolean can_global_message() {
        return (this.pri & 0x4000000L) == 0x4000000L;
    }

    public boolean can_global_lottery() {
        return (this.pri & 0x8000000L) == 0x8000000L;
    }

    public boolean can_video_watch_wall() {
        return (this.pri & 0x10000000L) == 0x10000000L;
    }

    public boolean can_qa_dispatch_question() {
        return (this.pri & 0x20000000L) == 0x20000000L;
    }

    public boolean can_doc_change_page() {
        return (this.pri & 0x40000000L) == 0x40000000L;
    }

    public boolean can_voice_chat() {
        return (this.pri & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    public void copyUser(UserInfo userInfo) {
        if (!this.name.equals(userInfo.name)) {
            this.name = userInfo.name;
        }
        if (this.role != userInfo.role) {
            this.role = userInfo.role;
        }
        if (this.pri != userInfo.pri) {
            this.pri = userInfo.pri;
        }
        if (this.status != userInfo.status) {
            this.status = userInfo.status;
        }
        if (this.clientType != userInfo.clientType) {
            this.clientType = userInfo.clientType;
        }
        if (!this.strUserData.equals(userInfo.strUserData)) {
            this.strUserData = userInfo.strUserData;
        }
        if (this.order != userInfo.order) {
            this.order = userInfo.order;
        }
    }

    public boolean isStudentRole() {
        return !this.IsHost() && !this.IsPanelist();
    }

    public static interface Privilege {
        public static final int CAN_DOC_CREATE = 1;
        public static final int CAN_DOC_ANNO = 2;
        public static final int CAN_DOC_SYNC_PAGE = 4;
        public static final int CAN_VIDEO_OPEN_SELF = 8;
        public static final int CAN_VIDEO_SET_MAIN = 16;
        public static final int CAN_AUDIO_OPEN_SELF = 32;
        public static final int CAN_AS_OPEN = 64;
        public static final int CAN_CHAT_PUBLIC = 128;
        public static final int CAN_CHAT_PRIVATE = 256;
        public static final int CAN_VOTE_CREATE_DEL = 512;
        public static final int CAN_VOTE_PUBLISH = 1024;
        public static final int CAN_VOTE_PUBLISH_RESULT = 2048;
        public static final int CAN_VOTE_VOTE = 4096;
        public static final int CAN_VOTE_PUBLISH_POPUP = 8192;
        public static final int CAN_QA_REPLY = 16384;
        public static final int CAN_QA_PUBLISH = 32768;
        public static final int CAN_LVOD_BEGIN_END = 65536;
        public static final int CAN_USER_SHOW_OVERVIEW = 131072;
        public static final int CAN_USER_CTRL_OTHER_MEDIA = 262144;
        public static final int CAN_USER_GRANT_ROLE = 524288;
        public static final int CAN_USER_ALLOW_UPGRADE_FROM_WEB = 0x100000;
        public static final int CAN_USER_KICKOUT = 0x200000;
        public static final int CAN_GLOBAL_CTRL_BROADCAST = 0x400000;
        public static final int CAN_GLOBAL_CTRL_RECORD = 0x800000;
        public static final int CAN_GLOBAL_SWITCH_LAYOUT_ON_WEB = 0x1000000;
        public static final int CAN_GLOBAL_LIVETEXT = 0x2000000;
        public static final int CAN_GLOBAL_MESSAGE = 0x4000000;
        public static final int CAN_GLOBAL_LOTTERY = 0x8000000;
        public static final int CAN_VIDEO_WATCH_WALL = 0x10000000;
        public static final int CAN_QA_DISPATCH_QUESTION = 0x20000000;
        public static final int CAN_DOC_CHANGE_PAGE = 0x40000000;
        public static final int CAN_VOICE_CHAT = Integer.MIN_VALUE;
    }

    public static final class OtherType {
        public static final int RT_HAVE_AUDIO = 1;
        public static final int RT_HAVE_VIDEO = 2;
        public static final int RT_OPEN_AUDIO = 4;
        public static final int RT_OPEN_VIDEO = 8;
        public static final int RT_MUTE_AUDIO = 16;
        public static final int RT_MUTE_VIDEO = 32;
        public static final int RT_REQUEST_UPGRADE = 64;
        public static final int RT_MUTE_CHAT = 128;
        public static final int RT_ATTENTION = 256;
        public static final int RT_ROLLCALL1 = 512;
        public static final int RT_ROLLCALL2 = 1024;
        public static final int RT_WEB_AUDIO_INVITING = 2048;
        public static final int RT_WEB_AUDIO = 4096;
        public static final int RT_ACTIVED_VIDEO = 8192;
        public static final int RT_REQUEST_WEBVOICE = 16384;
        public static final int RT_HANDUP = 32768;
        public static final int RT_APPLY_MASK = -65536;
    }

    public static final class UserType {
        public static final int USER_CLIENT = 0;
        public static final int USER_WEB = 1;
        public static final int USER_WEB_HTTP = 2;
        public static final int USER_IPAD_WEB = 3;
        public static final int USER_IPHONE_WEB = 4;
        public static final int USER_ANDRIODPAD_WEB = 5;
        public static final int USER_ANDRIODPHONE_WEB = 6;
        public static final int USER_CLIENT_IPAD = 7;
        public static final int USER_CLIENT_IPHONE = 8;
        public static final int USER_CLIENT_ANDRIOD_PAD = 9;
        public static final int USER_CLIENT_ANDRIOD_PHONE = 10;
        public static final int USER_CLIENT_MAC = 11;
        public static final int USER_CLIENT_TEL = 12;
        public static final int USER_CLIENT_FLASH = 13;
        public static final int USER_CLIENT_MOBILE_SDK = 14;
        public static final int USER_CLIENT_PC_SDK = 15;
        public static final int USER_IOS_PLAYERSDK = 16;
        public static final int USER_ANDROID_PLAYERSDK = 17;
        public static final int USER_MOBILE = 237;
    }
}

