/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.utils;

import android.content.Context;
import android.os.Environment;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    private static final int TIME_OUT = 10000;
    private static final String CHARSET = "utf-8";
    private static final String TAG = "FileUtil";

    public static String getSDCardPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zip(File fileOrDirectory, ZipOutputStream out) {
        try {
            if (fileOrDirectory.isFile()) {
                FileUtil.zipFileOrDirectory(out, fileOrDirectory, "");
            } else {
                File[] entries = fileOrDirectory.listFiles();
                for (int i = 0; i < entries.length; ++i) {
                    FileUtil.zipFileOrDirectory(out, entries[i], "");
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFileOrDirectory(ZipOutputStream out, File fileOrDirectory, String curPath) throws IOException {
        FileInputStream in = null;
        try {
            if (!fileOrDirectory.isDirectory()) {
                int bytes_read;
                fileOrDirectory.getName();
                byte[] buffer = new byte[4096];
                in = new FileInputStream(fileOrDirectory);
                ZipEntry entry = new ZipEntry(curPath + fileOrDirectory.getName());
                out.putNextEntry(entry);
                while ((bytes_read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytes_read);
                }
                out.closeEntry();
            } else {
                File[] entries = fileOrDirectory.listFiles();
                for (int i = 0; i < entries.length; ++i) {
                    FileUtil.zipFileOrDirectory(out, entries[i], curPath + fileOrDirectory.getName() + "/");
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void unzip(String zipFileName, String outputDirectory) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zipFileName);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            ZipEntry zipEntry = null;
            File dest = new File(outputDirectory);
            dest.mkdirs();
            while (e.hasMoreElements()) {
                zipEntry = e.nextElement();
                String entryName = zipEntry.getName();
                InputStream in = null;
                FileOutputStream out = null;
                try {
                    int c;
                    File df;
                    File f;
                    if (zipEntry.isDirectory()) {
                        String name = zipEntry.getName();
                        name = name.substring(0, name.length() - 1);
                        f = new File(outputDirectory + File.separator + name);
                        f.mkdirs();
                        continue;
                    }
                    int index = entryName.lastIndexOf("\\");
                    if (index != -1) {
                        df = new File(outputDirectory + File.separator + entryName.substring(0, index));
                        df.mkdirs();
                    }
                    if ((index = entryName.lastIndexOf("/")) != -1) {
                        df = new File(outputDirectory + File.separator + entryName.substring(0, index));
                        df.mkdirs();
                    }
                    f = new File(outputDirectory + File.separator + zipEntry.getName());
                    in = zipFile.getInputStream(zipEntry);
                    out = new FileOutputStream(f);
                    byte[] by = new byte[1024];
                    while ((c = in.read(by)) != -1) {
                        out.write(by, 0, c);
                    }
                    out.flush();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    throw new IOException("unzip fail" + ex.toString());
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ex) {}
                    }
                    if (out == null) continue;
                    try {
                        out.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new IOException("unzip fail" + ex.toString());
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static String uploadFile(File file, String requestURL) {
        String result = null;
        String boundary = UUID.randomUUID().toString();
        String prefix = "--";
        String line_end = "\r\n";
        String content_type = "multipart/form-data";
        try {
            URL url = new URL(requestURL);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(10000);
            conn.setConnectTimeout(10000);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Charset", CHARSET);
            conn.setRequestProperty("connection", "keep-alive");
            conn.setRequestProperty("Content-Type", content_type + ";boundary=" + boundary);
            if (file != null) {
                int ss;
                DataOutputStream dos = new DataOutputStream(conn.getOutputStream());
                StringBuffer sb = new StringBuffer();
                sb.append(prefix);
                sb.append(boundary);
                sb.append(line_end);
                sb.append("Content-Disposition: form-data; name=\"img\"; filename=\"" + file.getName() + "\"" + line_end);
                sb.append("Content-Type: application/octet-stream; charset=utf-8" + line_end);
                sb.append(line_end);
                dos.write(sb.toString().getBytes());
                FileInputStream is = new FileInputStream(file);
                byte[] bytes = new byte[1024];
                int len = 0;
                while ((len = ((InputStream)is).read(bytes)) != -1) {
                    dos.write(bytes, 0, len);
                }
                ((InputStream)is).close();
                dos.write(line_end.getBytes());
                byte[] end_data = (prefix + boundary + prefix + line_end).getBytes();
                dos.write(end_data);
                dos.flush();
                int res = conn.getResponseCode();
                GenseeLog.e(TAG, "response code:" + res);
                GenseeLog.e(TAG, "request success");
                InputStream input = conn.getInputStream();
                StringBuffer sb1 = new StringBuffer();
                while ((ss = input.read()) != -1) {
                    sb1.append((char)ss);
                }
                result = sb1.toString();
                GenseeLog.e(TAG, "result : " + result);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void deleteFile(File file) {
        if (file == null) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (file.isDirectory()) {
            File[] childFiles = file.listFiles();
            if (childFiles != null && childFiles.length > 0) {
                for (int i = 0; i < childFiles.length; ++i) {
                    FileUtil.deleteFile(childFiles[i]);
                }
            }
            file.delete();
        }
    }

    public static void deleteFile(String filePath) {
        if (StringUtil.isEmpty(filePath)) {
            return;
        }
        FileUtil.deleteFile(new File(filePath));
    }

    public static void deleteFileByTime(File file, long millisNow, long millisAgo) {
        File[] childFiles;
        if (file == null) {
            return;
        }
        if (file.isFile()) {
            long lastTime = file.lastModified();
            if (millisNow - lastTime >= millisAgo) {
                file.delete();
            }
        } else if (file.isDirectory() && (childFiles = file.listFiles()) != null && childFiles.length > 0) {
            for (int i = 0; i < childFiles.length; ++i) {
                FileUtil.deleteFileByTime(childFiles[i], millisNow, millisAgo);
            }
        }
    }

    public static String getCachDir(Context context, String childDir) {
        String dir;
        File dirFile;
        File f = null;
        if ("mounted".equals(Environment.getExternalStorageState())) {
            try {
                f = context.getExternalCacheDir();
            }
            catch (Exception e) {
                GenseeLog.w(TAG, e);
            }
            if (null == f) {
                f = context.getCacheDir();
            }
        } else {
            f = context.getCacheDir();
        }
        if (!(dirFile = new File(dir = f.getAbsolutePath() + File.separator + "gensee" + (childDir == null ? "" : File.separator + childDir))).exists()) {
            dirFile.mkdirs();
        }
        return dirFile.getAbsolutePath() + File.separator;
    }

    public static String getFileDir(Context context, String childDir) {
        String dir;
        File dirFile;
        File f = null;
        if ("mounted".equals(Environment.getExternalStorageState())) {
            try {
                f = context.getExternalFilesDir(Environment.DIRECTORY_MOVIES);
            }
            catch (Exception e) {
                GenseeLog.w(TAG, e);
            }
            if (null == f) {
                f = context.getFilesDir();
            }
        } else {
            f = context.getFilesDir();
        }
        if (!(dirFile = new File(dir = f.getAbsolutePath() + File.separator + "gensee" + (childDir == null ? "" : File.separator + childDir))).exists()) {
            dirFile.mkdirs();
        }
        return dirFile.getAbsolutePath() + File.separator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String saveToCache(Context c, String childDir, String name, byte[] data) {
        String dir = FileUtil.getCachDir(c, childDir);
        if (StringUtil.isEmpty(dir)) {
            return null;
        }
        String path = dir + name;
        String ret = null;
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream outputStream = null;
        try {
            file.createNewFile();
            outputStream = new FileOutputStream(file);
            outputStream.write(data);
            outputStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != outputStream) {
                try {
                    outputStream.close();
                    ret = path;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }
}

