/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.utils;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.gensee.common.GenseeConfig;
import com.gensee.common.ServiceType;
import com.gensee.report.ReportInfo;
import com.gensee.utils.FileUtil;
import com.gensee.utils.ThreadPool;
import com.gensee.utils.upload.LogProperty;
import com.gensee.utils.upload.UpLoadFileUtil;
import com.gensee.utils.upload.UploadItem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.zip.ZipOutputStream;

public class GenseeLog {
    public static ReportInfo reportInfo = null;
    private static final String GS_TAG = "Gensee";
    private static String MYLOG_PATH_SDCARD_DIR = "/sdcard/gensee/log/";
    private static SimpleDateFormat myLogFileNameSdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private static SimpleDateFormat myLogTimeSdf = new SimpleDateFormat("HH:mm:ss.SSS");
    public static boolean isWriteTestLog = false;
    private static boolean isInited = false;
    private static final String LOG_INFO = "info-";
    private static final String LOG_APP = "app-";
    private static final String LOG_STACK = "stack-";
    private static final String LOG_DIAGNOSE = "And-";
    public static final String LOG_DIAGNOSE_STACK = "stack-And-";
    public static String logInfoFileName = "";
    public static String logAppFileName = "";
    public static String logCrashFileName = "";
    private static String LOG_UPLOAD_DEF_URL = "http://traceupload.gensee.com/traupload";
    private static String LOG_DESC_DEF_URL = "http://xmlapi.gensee.com/xmlapi/apichannel?sc=%d";
    private static String curZipDest = "";
    private static WiteRunnable fRunnable;
    public static final String REPORT_NO_FILE = "REPORT_NO_FILE";

    public static boolean hasSdcard() {
        if (!"mounted".equals(Environment.getExternalStorageState())) {
            Log.w((String)"GenseeLog", (String)"sdcard is not exists ,write log failed!");
            return false;
        }
        return true;
    }

    public static void initLog() {
        GenseeLog.initLog(null);
    }

    public static boolean isInited() {
        return isInited;
    }

    public static void initLog(String fileName) {
        if (GenseeLog.hasSdcard()) {
            File f = new File(MYLOG_PATH_SDCARD_DIR);
            if (!f.exists() && !f.mkdirs()) {
                return;
            }
            FileUtil.deleteFileByTime(f, System.currentTimeMillis(), 259200000L);
            if (!isInited && !GenseeLog.loadlibrary()) {
                return;
            }
            logAppFileName = MYLOG_PATH_SDCARD_DIR + LOG_APP + myLogFileNameSdf.format(new Date()) + ".log";
            GenseeLog.stdLog(fileName == null ? logAppFileName : MYLOG_PATH_SDCARD_DIR + fileName);
            GenseeLog.i(GenseeConfig.getSDKVersionInfo());
            isInited = true;
        }
    }

    public static void v(String msg) {
        if (null == msg) {
            return;
        }
        if (GenseeLog.isLoggable(2)) {
            Log.v((String)GS_TAG, (String)msg);
        }
    }

    public static void v(String TAG, String msg) {
        GenseeLog.v(TAG + "][" + msg);
    }

    public static void d(String msg) {
        if (null == msg) {
            return;
        }
        msg = '[' + msg + ']';
        if (GenseeLog.isLoggable(3)) {
            Log.d((String)GS_TAG, (String)msg);
        }
        GenseeLog.writeLogtoFile("D", GS_TAG, msg);
    }

    public static void d(String TAG, String msg) {
        GenseeLog.d(TAG + "][" + msg);
    }

    public static void d(String TAG, String funcName, String msg) {
        GenseeLog.d(TAG, funcName + "][" + msg);
    }

    public static void w(String TAG, String msg) {
        GenseeLog.w(TAG + "][" + msg);
    }

    public static void w(String TAG, Throwable e) {
        GenseeLog.w(TAG + "][" + e.getMessage());
    }

    public static void w(String msg) {
        if (null == msg) {
            return;
        }
        msg = '[' + msg + ']';
        if (GenseeLog.isLoggable(5)) {
            Log.w((String)GS_TAG, (String)msg);
        }
        GenseeLog.writeLogtoFile("W", GS_TAG, msg);
    }

    private static boolean isLoggable(int level) {
        return Log.isLoggable((String)GS_TAG, (int)level);
    }

    public static void e(Throwable e) {
        GenseeLog.e(e.getMessage());
    }

    public static void e(String TAG, Throwable e) {
        GenseeLog.e(TAG, e.getMessage());
    }

    public static void e(String TAG, String msg) {
        GenseeLog.e(TAG + "][" + msg);
    }

    public static void e(String string) {
        if (null == string) {
            return;
        }
        string = '[' + string + ']';
        if (GenseeLog.isLoggable(6)) {
            Log.e((String)GS_TAG, (String)string);
        }
        GenseeLog.writeLogtoFile("E", GS_TAG, string);
    }

    public static void i(String TAG, String msg) {
        GenseeLog.i(TAG + "][" + msg);
    }

    public static void i(String string) {
        if (null == string) {
            return;
        }
        string = '[' + string + ']';
        Log.i((String)GS_TAG, (String)string);
        GenseeLog.writeLogtoFile("I", GS_TAG, string);
    }

    protected static void writeLogtoFile(final String level, final String tag, final String text) {
        if (!isInited) {
            return;
        }
        if (text == null) {
            return;
        }
        Date nowtime = new Date();
        final String time = myLogTimeSdf.format(nowtime);
        try {
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    StringBuilder sb = new StringBuilder().append('[').append(time).append(']').append('[').append(level).append(']').append('[').append(tag).append(']').append(text).append('\n');
                    GenseeLog.writeLog(sb.toString());
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wirteCrashInfo(String sCrashInfo) {
        logCrashFileName = MYLOG_PATH_SDCARD_DIR + LOG_STACK + myLogFileNameSdf.format(new Date()) + ".log";
        FileOutputStream stream = null;
        File path = new File(MYLOG_PATH_SDCARD_DIR);
        File file = new File(logCrashFileName);
        if (!path.exists()) {
            path.mkdirs();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            stream = new FileOutputStream(logCrashFileName);
            stream.write(sCrashInfo.getBytes());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAppInfo(String sJsonInfo) {
        logInfoFileName = MYLOG_PATH_SDCARD_DIR + LOG_INFO + myLogFileNameSdf.format(new Date()) + ".log";
        FileOutputStream stream = null;
        File path = new File(MYLOG_PATH_SDCARD_DIR);
        File file = new File(logInfoFileName);
        if (!path.exists() && !path.mkdirs()) {
            return;
        }
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        try {
            stream = new FileOutputStream(logInfoFileName);
            stream.write(sJsonInfo.getBytes());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != stream) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean containsStackFile() {
        File[] entries;
        boolean bStackFile = false;
        File fileOrDirectory = new File(MYLOG_PATH_SDCARD_DIR);
        if (fileOrDirectory.exists() && (entries = fileOrDirectory.listFiles()) != null && entries.length > 0) {
            for (int i = 0; i < entries.length; ++i) {
                File file = entries[i];
                if (!file.isFile() || !file.getName().startsWith(LOG_STACK)) continue;
                bStackFile = true;
                break;
            }
        }
        return bStackFile;
    }

    public static boolean containsZipStackFile() {
        File[] entries;
        boolean bZipStackFile = false;
        File fileOrDirectory = new File(MYLOG_PATH_SDCARD_DIR);
        if (fileOrDirectory.exists() && (entries = fileOrDirectory.listFiles()) != null && entries.length > 0) {
            for (int i = 0; i < entries.length; ++i) {
                File file = entries[i];
                if (!file.isFile() || !file.getName().startsWith(LOG_DIAGNOSE_STACK)) continue;
                bZipStackFile = true;
                break;
            }
        }
        return bZipStackFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFile(boolean isZipCurLog, String siteId, String liveId, String userId, String userNickName) {
        curZipDest = MYLOG_PATH_SDCARD_DIR + LOG_DIAGNOSE + siteId + "-" + liveId + "-" + userId + "-" + userNickName + "-" + myLogFileNameSdf.format(new Date()) + ".zip";
        if (GenseeLog.containsStackFile()) {
            curZipDest = MYLOG_PATH_SDCARD_DIR + LOG_DIAGNOSE_STACK + siteId + "-" + liveId + "-" + userId + "-" + userNickName + "-" + myLogFileNameSdf.format(new Date()) + ".zip";
        }
        ZipOutputStream out = null;
        try {
            File[] entries;
            File fileOrDirectory = new File(MYLOG_PATH_SDCARD_DIR);
            if (fileOrDirectory.exists() && (entries = fileOrDirectory.listFiles()) != null && entries.length > 0) {
                ArrayList<File> deleteFileList = new ArrayList<File>();
                for (int i = 0; i < entries.length; ++i) {
                    File file = entries[i];
                    if (!file.isFile() || !file.getName().startsWith(LOG_INFO) && !file.getName().startsWith(LOG_APP) && !file.getName().startsWith(LOG_STACK)) continue;
                    if (file.getName().startsWith(LOG_STACK) && !file.getAbsolutePath().equals(logCrashFileName)) {
                        if (null == out) {
                            out = new ZipOutputStream(new FileOutputStream(curZipDest));
                        }
                        FileUtil.zip(entries[i], out);
                        deleteFileList.add(file);
                        continue;
                    }
                    if (file.getName().startsWith(LOG_INFO)) {
                        if (file.getAbsolutePath().equals(logInfoFileName)) {
                            if (!isZipCurLog) continue;
                            if (null == out) {
                                out = new ZipOutputStream(new FileOutputStream(curZipDest));
                            }
                            FileUtil.zip(entries[i], out);
                            continue;
                        }
                        if (null == out) {
                            out = new ZipOutputStream(new FileOutputStream(curZipDest));
                        }
                        FileUtil.zip(entries[i], out);
                        deleteFileList.add(file);
                        continue;
                    }
                    if (!file.getName().startsWith(LOG_APP)) continue;
                    if (file.getAbsolutePath().equals(logAppFileName)) {
                        if (!isZipCurLog) continue;
                        if (null == out) {
                            out = new ZipOutputStream(new FileOutputStream(curZipDest));
                        }
                        FileUtil.zip(entries[i], out);
                        continue;
                    }
                    if (null == out) {
                        out = new ZipOutputStream(new FileOutputStream(curZipDest));
                    }
                    FileUtil.zip(entries[i], out);
                    deleteFileList.add(file);
                }
                for (File file : deleteFileList) {
                    file.delete();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private static String reportDiagonse(File uploadFile, String uploadUrl) {
        ArrayList<UploadItem> itemList = new ArrayList<UploadItem>();
        UploadItem uploadItem3 = new UploadItem();
        uploadItem3.setName("test");
        uploadItem3.setType("VALUE_TYPE");
        uploadItem3.setValue("value");
        UploadItem uploadItem2 = new UploadItem();
        uploadItem2.setName("submit");
        uploadItem2.setType("VALUE_TYPE");
        uploadItem2.setValue("Upload");
        UploadItem uploadItem1 = new UploadItem();
        uploadItem1.setName("file1");
        uploadItem1.setType("FILE_TYPE");
        uploadItem1.setValue(uploadFile.getAbsolutePath());
        itemList.add(uploadItem3);
        itemList.add(uploadItem2);
        itemList.add(uploadItem1);
        String url = new UpLoadFileUtil().uploadFile(itemList, uploadUrl);
        if (url != null && !"".equals(url)) {
            uploadFile.delete();
        }
        return url;
    }

    public static String reportDiagonse(Context context, String desc, ServiceType serviceType, boolean isZipCurLog) {
        return GenseeLog.reportDiagonse(context, desc, serviceType, isZipCurLog, true);
    }

    public static String reportDiagonse(Context context, String desc, ServiceType serviceType, boolean isZipCurLog, boolean isZipFile) {
        if (isZipFile) {
            Map<String, String> texts;
            String siteId = "";
            String liveId = "";
            String userId = "";
            String nickName = "";
            Map<String, String> datas = LogProperty.getIns().getPropertyList(context);
            if (null != datas) {
                String string = siteId = null == datas.get("siteid") ? "" : datas.get("siteid");
                if (siteId.equals("0")) {
                    siteId = "";
                }
                String string2 = userId = null == datas.get("userid") ? "" : datas.get("userid");
                if (userId.equals("0")) {
                    userId = "";
                }
                String string3 = liveId = null == datas.get("confid") ? "" : datas.get("confid");
            }
            if (null != (texts = LogProperty.getIns().getTextList(""))) {
                nickName = null == texts.get("username") ? "" : texts.get("username");
            }
            GenseeLog.zipFile(true, siteId, liveId, userId, nickName);
        }
        int sc = 0;
        switch (serviceType) {
            case TRAINING: 
            case ST_TRAINING: {
                sc = 1;
                break;
            }
            case WEBCAST: 
            case ST_CASTLINE: {
                sc = 0;
                break;
            }
            case ST_MEETING: {
                sc = 2;
                break;
            }
        }
        LogProperty property = LogProperty.getIns();
        return GenseeLog.reportDiagonse(LOG_UPLOAD_DEF_URL, null, property.getPropertyList(context), property.getTextList(desc), false, isZipCurLog);
    }

    public static String reportDiagonse(String uploadUrl, String notifyWebUrl, Map<String, String> propertyList, Map<String, String> textList, boolean bOnlyStatck, boolean isZipCurLog) {
        String ret = "";
        if (isZipCurLog) {
            if (!"".equals(curZipDest)) {
                File file = new File(curZipDest);
                if (file.exists()) {
                    String url = GenseeLog.reportDiagonse(file, uploadUrl);
                    if (TextUtils.isEmpty((CharSequence)notifyWebUrl)) {
                        return url;
                    }
                    if (!"".equals(url) && null != propertyList && null != textList) {
                        textList.put("file", url);
                        ret = new UpLoadFileUtil().notifyWeb(notifyWebUrl, propertyList, textList);
                    }
                } else {
                    return REPORT_NO_FILE;
                }
            }
            return ret;
        }
        File fileOrDirectory = new File(MYLOG_PATH_SDCARD_DIR);
        if (fileOrDirectory.exists()) {
            File[] entries = fileOrDirectory.listFiles();
            File file = null;
            if (null != entries && entries.length > 0) {
                for (int i = 0; i < entries.length; ++i) {
                    File tmpFile = entries[i];
                    if (bOnlyStatck) {
                        if (!tmpFile.getName().startsWith(LOG_DIAGNOSE_STACK)) continue;
                        file = tmpFile;
                        break;
                    }
                    if (!tmpFile.getName().startsWith(LOG_DIAGNOSE)) continue;
                    file = tmpFile;
                    break;
                }
            }
            if (file != null) {
                String url = GenseeLog.reportDiagonse(file, uploadUrl);
                if (TextUtils.isEmpty((CharSequence)notifyWebUrl)) {
                    return url;
                }
                if (!"".equals(url) && null != propertyList && null != textList) {
                    textList.put("file", url);
                    ret = new UpLoadFileUtil().notifyWeb(notifyWebUrl, propertyList, textList);
                }
            }
        }
        return ret;
    }

    private static native void stdLog(String var0);

    private static native void writeLog(String var0);

    private static boolean loadlibrary() {
        try {
            System.loadLibrary("stlport_shared");
            System.loadLibrary("gensee-log");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            GenseeLog.w("GenseeLog", e);
        }
        catch (Error e) {
            e.printStackTrace();
            GenseeLog.w("GenseeLog", e);
        }
        return false;
    }

    private static class WiteRunnable
    implements Runnable {
        private RandomAccessFile file;
        private String msg;

        private WiteRunnable() {
        }

        @Override
        public void run() {
            if (this.file == null) {
                try {
                    this.file = new RandomAccessFile("/sdcard/genseelog.log", "rw");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (this.file != null && this.msg != null) {
                try {
                    this.file.writeBytes(this.msg + "\n");
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
}

