/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.utils.upload;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.HashMap;
import java.util.Map;

public class LogProperty {
    private static final String LOG_PREFERENCE = "gensee.log.preference";
    private static final String LOG_USERNAME = "log_username";
    private static final String LOG_USERID = "log_userid";
    private static final String LOG_SITEID = "log_siteid";
    private static final String LOG_CONFID = "log_confid";
    private static final String LOG_DESC = "log_desc";
    private SharedPreferences mPreferences;
    private static LogProperty ins = null;

    public static LogProperty getIns() {
        if (ins == null) {
            ins = new LogProperty();
        }
        return ins;
    }

    public void setProperty(Context context, String userName, String confid, long userId, long siteId, String defDesc) {
        if (context == null) {
            return;
        }
        this.mPreferences = context.getApplicationContext().getSharedPreferences(LOG_PREFERENCE, 0);
        SharedPreferences.Editor e = this.mPreferences.edit().putString(LOG_USERNAME, userName).putString(LOG_CONFID, confid).putLong(LOG_USERID, userId).putLong(LOG_SITEID, siteId);
        if (defDesc != null) {
            e.putString(LOG_DESC, defDesc);
        }
        e.commit();
    }

    public void setDefDesc(String desc) {
        if (this.mPreferences != null) {
            this.mPreferences.edit().putString(LOG_DESC, desc).commit();
        }
    }

    public Map<String, String> getPropertyList(Context context) {
        if (context == null) {
            return null;
        }
        this.mPreferences = context.getApplicationContext().getSharedPreferences(LOG_PREFERENCE, 0);
        HashMap<String, String> propertyList = new HashMap<String, String>();
        propertyList.put("siteid", this.mPreferences.getLong(LOG_SITEID, 0L) + "");
        propertyList.put("userid", this.mPreferences.getLong(LOG_USERID, 0L) + "");
        propertyList.put("confid", this.mPreferences.getString(LOG_CONFID, ""));
        return propertyList;
    }

    public Map<String, String> getTextList(String desc) {
        if (desc == null) {
            desc = "";
        }
        HashMap<String, String> textList = new HashMap<String, String>();
        textList.put("username", this.mPreferences.getString(LOG_USERNAME, ""));
        textList.put("desc", "Android " + this.mPreferences.getString(LOG_DESC, "SDK") + " Diagonse " + desc);
        return textList;
    }
}

