/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.gensee.media.IVideoIndication;
import com.gensee.media.OnVideoDecodeListener;
import com.gensee.media.ViDecoder;
import com.gensee.media.VideoData;
import com.gensee.utils.GenseeLog;
import java.util.ArrayList;
import java.util.List;

public class GSAutoDecodeView
extends RelativeLayout
implements IVideoIndication,
OnVideoDecodeListener,
SurfaceHolder.Callback {
    private static final String TAG = "GSAutoDecodeView";
    private ViDecoder mViDecoder;
    private SurfaceView mSurfaceView;
    private int nVideoWidth;
    private int nVideoHeight;
    private long viewId = 0L;
    private ImageView ivDefault;
    private List<VideoData> cacheQueue = new ArrayList<VideoData>();

    public GSAutoDecodeView(Context context) {
        this(context, null);
    }

    public GSAutoDecodeView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.viewId = this.hashCode();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        ViDecoder decoder = new ViDecoder();
        decoder.setSurface(holder.getSurface());
        decoder.setDecodeListener(this.viewId, this);
        GenseeLog.d(TAG, "surfaceCreated cacheQueue size = " + this.cacheQueue.size());
        this.ivDefault.setVisibility(0);
        this.mViDecoder = decoder;
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        GenseeLog.d("GSAutoDecodeView surfaceChanged width = " + width + " heigth = " + height);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mViDecoder.release();
        this.mViDecoder = null;
    }

    private boolean isRBG565(int datalen, int width, int height) {
        int temWidth = width;
        int nWidthMod = width % 16;
        if (nWidthMod != 0) {
            temWidth += 16 - nWidthMod;
        }
        int temHeight = height;
        int nHeightMod = height % 16;
        if (nHeightMod != 0) {
            temHeight += 16 - nHeightMod;
        }
        return datalen == temWidth * temHeight * 2;
    }

    @Override
    public void onReceiveFrame(byte[] data, int width, int height) {
        if (this.isRBG565(data.length, width, height)) {
            GenseeLog.d(TAG, "onReceiveFrame rgb565 data, will be return");
            return;
        }
        int frameType = data[4] & 0x1F;
        if ((frameType == 7 || frameType == 8) && this.ivDefault.getVisibility() != 8) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    GSAutoDecodeView.this.ivDefault.setVisibility(8);
                }
            });
        }
        if (null != this.mViDecoder) {
            this.mViDecoder.decode(this.viewId, data, width, height, 0);
        }
    }

    public GSAutoDecodeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setBackgroundColor(-16777216);
        this.setGravity(17);
        this.mSurfaceView = new SurfaceView(this.getContext());
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
        lp.addRule(13);
        this.addView((View)this.mSurfaceView, (ViewGroup.LayoutParams)lp);
        this.ivDefault = new ImageView(this.getContext());
        RelativeLayout.LayoutParams lpDefualt = new RelativeLayout.LayoutParams(-1, -1);
        this.addView((View)this.ivDefault, (ViewGroup.LayoutParams)lpDefualt);
        SurfaceHolder holder = this.mSurfaceView.getHolder();
        holder.addCallback((SurfaceHolder.Callback)this);
        holder.setFormat(4);
    }

    public void setDefaultImg(int resId) {
        this.ivDefault.setBackgroundResource(resId);
    }

    protected void onSizeChanged(final int w, final int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                GSAutoDecodeView.this.calculateSurfaceViewSize(GSAutoDecodeView.this.nVideoWidth, GSAutoDecodeView.this.nVideoHeight, w, h);
            }
        }, 50L);
    }

    private void calculateSurfaceViewSize(int nVideoWidth, int nVideoHeight, int nViewWidth, int nViewHeight) {
        if (nVideoWidth <= 0 || nVideoHeight <= 0) {
            return;
        }
        float fWidthRation = (float)nViewWidth / (float)nVideoWidth;
        float fHeightRation = (float)nViewHeight / (float)nVideoHeight;
        float fRation = Math.min(fWidthRation, fHeightRation);
        int nNewSurfaceWidth = (int)((float)nVideoWidth * fRation);
        int nNewSurfaceHeight = (int)((float)nVideoHeight * fRation);
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.mSurfaceView.getLayoutParams();
        lp.width = nNewSurfaceWidth;
        lp.height = nNewSurfaceHeight;
        lp.addRule(13);
        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public void setVisibility(int visibility) {
        if (this.mSurfaceView.getVisibility() != visibility) {
            this.mSurfaceView.setVisibility(visibility);
        }
        super.setVisibility(visibility);
    }

    @Override
    public void renderDefault() {
        this.mSurfaceView.setVisibility(8);
        this.mSurfaceView.setVisibility(0);
    }

    @Override
    public void onReceiveFrame(VideoData data) {
        this.onReceiveFrame(data.getData(), data.getWidth(), data.getHeight());
    }

    @Override
    public void onDecodeData(byte[] data, final int width, final int height) {
        if (this.nVideoWidth != width || this.nVideoHeight != height) {
            this.nVideoWidth = width;
            this.nVideoHeight = height;
            this.post(new Runnable(){

                @Override
                public void run() {
                    GSAutoDecodeView.this.calculateSurfaceViewSize(width, height, GSAutoDecodeView.this.getWidth(), GSAutoDecodeView.this.getHeight());
                }
            });
        }
    }
}

