/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.gensee.media.ISurfaceHolder;
import com.gensee.media.IVideoIndication;
import com.gensee.media.RenderMode;
import com.gensee.media.ViSoftRender;
import com.gensee.media.VideoData;
import com.gensee.utils.GenseeLog;

public class GSVideoViewExs
extends SurfaceView
implements SurfaceHolder.Callback,
ISurfaceHolder,
IVideoIndication {
    private static final String TAG = "GSVideoViewExs";
    private ViSoftRender mRender;
    private SurfaceHolder holder;

    public GSVideoViewExs(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        SurfaceHolder holder = this.getHolder();
        holder.addCallback((SurfaceHolder.Callback)this);
        holder.setFormat(4);
        this.mRender = new ViSoftRender(this);
    }

    public GSVideoViewExs(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GSVideoViewExs(Context context) {
        this(context, null);
    }

    public RenderMode getRenderMode() {
        return this.mRender.getRenderMode();
    }

    public void setRenderMode(RenderMode renderMode) {
        GenseeLog.d(TAG, "setRenderMode renderMode = " + (Object)((Object)renderMode));
        this.mRender.setRenderMode(renderMode);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        GenseeLog.d(TAG, "surfaceCreated holder = " + holder.hashCode());
        this.mRender.surfaceCreated();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        GenseeLog.i(TAG, "surfaceChanged width = " + width + " height = " + height);
        this.holder = holder;
        this.mRender.surfaceChanged(width, height);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mRender.surfaceDestroyed();
        this.holder = null;
        GenseeLog.d(TAG, "surfaceDestroyed holder = " + holder.hashCode());
    }

    public void setBackgroundColor(int color) {
        this.setDefColor(color);
    }

    public void setDefColor(int defColor) {
        this.mRender.setDefColor(defColor);
    }

    @Override
    public void onReceiveFrame(byte[] data, int width, int height) {
        this.mRender.onReceiveFrame(data, width, height);
    }

    @Override
    public void onReceiveFrame(VideoData data) {
        this.mRender.onReceiveFrame(data);
    }

    @Override
    public void renderDefault() {
        this.mRender.renderDefault();
    }

    public void renderDrawble(Bitmap defBitmap, boolean isFillXY) {
        this.mRender.renderDrawble(defBitmap, isFillXY);
    }

    public byte[] getData() {
        return this.mRender.getData();
    }

    public int getVideoWidth() {
        return this.mRender.getVideoWidth();
    }

    public int getVideoHeight() {
        return this.mRender.getVideoHeight();
    }

    @Override
    public Canvas lockCanvas() {
        SurfaceHolder h = this.holder;
        return h == null ? null : h.lockCanvas();
    }

    @Override
    public void unlockCanvasAndPost(Canvas canvas) {
        SurfaceHolder h = this.holder;
        if (h != null && canvas != null) {
            h.unlockCanvasAndPost(canvas);
        }
    }
}

