/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.as;

import android.app.Activity;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.gensee.as.AsEventImpl;
import com.gensee.as.AsTransparentActivity;
import com.gensee.as.OnAsServiceListener;
import com.gensee.convert.VideoCoreLibrary;
import com.gensee.room.RTRoom;
import com.gensee.routine.IRTEvent;
import com.gensee.taskret.OnTaskRet;
import com.gensee.utils.GenseeLog;
import com.gensee.videoparam.OnVideoHardEncodeDataCallback;
import com.gensee.videoparam.VideoParam;
import com.gensee.view.VideoHardEncoded;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class AsSendService
extends Service
implements OnVideoHardEncodeDataCallback {
    private static final String TAG = "AsSendService";
    private MediaProjectionManager mProjectionManager;
    private MediaProjection sMediaProjection;
    private ImageReader mImageReader;
    private VirtualDisplay mVirtualDisplay;
    private int mDensity;
    private int mRealWidth;
    private int mRealHeight;
    private int mRotation;
    private Display mDisplay;
    private Handler mHandler;
    private boolean isAsHardEncoded = false;
    private OrientationChangeCallback mOrientationChangeCallback;
    protected VideoHardEncoded mVideoHardEncoded;
    private boolean isAsStarted = false;
    private View windowView;
    private WindowManager.LayoutParams wLayoutParams;
    private static final String SCREENCAP_NAME = "screencap";
    public static final String KEY_INTENT_MESSENGER = "KEY_INTENT_MESSENGER";
    private static final int VIRTUAL_DISPLAY_FLAGS = 9;
    private int fps = 5;
    private OnAsImplListener mOnAsImplListener;
    private OnAsServiceListener mOnAsServiceListener;
    private List<AsData> asDataList = null;
    private List<AsData> asRecoverDataList = null;
    private Looper mLooper;
    private AtomicInteger nAsSendFlag = new AtomicInteger(0);
    private static final int AS_SEND_BEGIN = 0;
    private static final int AS_SEND_FAILURE = -1;
    private static final int AS_SEND_SUCCESS = 1;
    private Thread mAsHardEncodeThread;
    private Object mAsHardEncodeObject = new Object();
    private Object mAsHardEncodeNotify = new Object();
    private List<AsHardEncodeData> asHardEncodeList = new ArrayList<AsHardEncodeData>();
    private AsHardEncodeData mPreHardEncodeData = null;
    private Bitmap mBitmapVideoPng;
    private int nVideoPngMarginTop;
    private int nVideoPngMarginRight;
    private AtomicBoolean bAsPushBegin = new AtomicBoolean(false);
    private AtomicBoolean bAsBegin = new AtomicBoolean(false);
    private Thread asSendThread = null;
    private AtomicBoolean bAsSendRunning = new AtomicBoolean(false);
    private AtomicBoolean bAsSendStop = new AtomicBoolean(false);
    private Object asObject = new Object();
    private AsData mLastData = null;
    private long nSendTime = Calendar.getInstance().getTimeInMillis();
    private int nSendFrameCount = 0;
    private Runnable asSendRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (AsSendService.this.bAsSendRunning.get()) {
                AsData mAsData;
                long nTimeStart = Calendar.getInstance().getTimeInMillis();
                if (AsSendService.this.bAsSendStop.get()) {
                    Object object = AsSendService.this.asObject;
                    synchronized (object) {
                        try {
                            AsSendService.this.asObject.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (null != (mAsData = AsSendService.this.removeData()) && null != mAsData.data) {
                    if (AsSendService.this.mLastData == null) {
                        AsSendService.this.mLastData = new AsData();
                    }
                    AsSendService.this.mLastData.width = mAsData.width;
                    AsSendService.this.mLastData.height = mAsData.height;
                    if (AsSendService.this.mLastData.data == null || AsSendService.this.mLastData.data.length != mAsData.data.length) {
                        AsData.access$402(AsSendService.this.mLastData, new byte[mAsData.data.length]);
                    }
                    if (null != AsSendService.this.mBitmapVideoPng) {
                        Bitmap bitmap = Bitmap.createBitmap((int)mAsData.width, (int)mAsData.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        bitmap.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(mAsData.data));
                        AsSendService.this.getVideoLogotBitmap(bitmap, AsSendService.this.mBitmapVideoPng, mAsData.width, mAsData.height, AsSendService.this.nVideoPngMarginTop, AsSendService.this.nVideoPngMarginRight);
                        bitmap.copyPixelsToBuffer((Buffer)ByteBuffer.wrap(AsSendService.this.mLastData.data));
                        if (null != bitmap && !bitmap.isRecycled()) {
                            bitmap.recycle();
                        }
                    } else {
                        System.arraycopy(mAsData.data, 0, AsSendService.this.mLastData.data, 0, mAsData.data.length);
                    }
                    AsSendService.this.addRecoverData(mAsData);
                }
                if (null != AsSendService.this.mLastData) {
                    long nSendTime1 = Calendar.getInstance().getTimeInMillis();
                    if (nSendTime1 - AsSendService.this.nSendTime > 1000L) {
                        GenseeLog.d((String)AsSendService.TAG, (String)("asSendRunnable send as data per coutn = " + AsSendService.this.nSendFrameCount));
                        AsSendService.this.nSendFrameCount = 0;
                        AsSendService.this.nSendTime = nSendTime1;
                    }
                    AsSendService.this.nSendFrameCount++;
                    AsSendService.this.sendAsData(AsSendService.this.mLastData);
                }
                long nTimeStart1 = Calendar.getInstance().getTimeInMillis();
                try {
                    int nSpendTime = (int)(nTimeStart1 - nTimeStart);
                    if (nSpendTime < 1000 / AsSendService.this.fps - 5) {
                        Thread.sleep(1000 / AsSendService.this.fps - 5);
                        continue;
                    }
                    GenseeLog.w((String)AsSendService.TAG, (String)("asSendRunnable spend time = " + nSpendTime));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            GenseeLog.i((String)AsSendService.TAG, (String)"asSendThread send thread exit");
        }
    };
    private List<byte[]> asSoftList = new ArrayList<byte[]>();
    private AtomicBoolean bSendAsFlag = new AtomicBoolean(false);
    private int nAsWidth = 540;
    private int nAsHegith = 960;
    long nTime = Calendar.getInstance().getTimeInMillis();
    int frameCount = 0;
    boolean bFirstFrame = false;
    long nPreTime = Calendar.getInstance().getTimeInMillis();
    private byte[] mImageData = null;
    private Runnable orientationRunnable = new Runnable(){

        @Override
        public void run() {
            if (null != AsSendService.this.mOrientationChangeCallback) {
                AsSendService.this.mOrientationChangeCallback.onOrientationChanged(0);
                AsSendService.this.mHandler.postDelayed((Runnable)this, 500L);
            }
        }
    };
    private Runnable mAsHardEncodeRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: while (AsSendService.this.isAsHardEncoded) {
                AsSendService.this.mPreHardEncodeData = AsSendService.this.removeHardEncodeData();
                if (null == AsSendService.this.mPreHardEncodeData) {
                    Object object = AsSendService.this.mAsHardEncodeNotify;
                    synchronized (object) {
                        try {
                            AsSendService.this.mAsHardEncodeNotify.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                }
                while (AsSendService.this.nAsSendFlag.get() != 1 && AsSendService.this.isAsHardEncoded) {
                    if (null == AsSendService.this.mPreHardEncodeData) continue;
                    IRTEvent.IAsEvent asEvent = RTRoom.getIns().getAsEvent();
                    final VideoParam p = AsSendService.this.mPreHardEncodeData.videoParam;
                    final AtomicBoolean bHaveSend = new AtomicBoolean(false);
                    boolean bTrue = ((AsEventImpl)asEvent).pushAsData(AsSendService.this.mPreHardEncodeData.data, AsSendService.this.fps, p.fmt, p.width, p.height, new OnTaskRet(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onTaskRet(boolean ret, int id, String desc) {
                            Object object = AsSendService.this.mAsHardEncodeObject;
                            synchronized (object) {
                                bHaveSend.set(true);
                                AsSendService.this.nAsSendFlag.set(ret ? 1 : -1);
                                AsSendService.this.mAsHardEncodeObject.notifyAll();
                                GenseeLog.i((String)AsSendService.TAG, (String)("pushAsData p.fmt1 = " + p.fmt + " nAsSendFlag = " + AsSendService.this.nAsSendFlag));
                            }
                        }
                    });
                    if (!bTrue) {
                        AsSendService.this.nAsSendFlag.set(1);
                    }
                    Object object = AsSendService.this.mAsHardEncodeObject;
                    synchronized (object) {
                        if (bHaveSend.get()) {
                            GenseeLog.i((String)AsSendService.TAG, (String)("pushAsData p.fmt2 = " + p.fmt + " nAsSendFlag = " + AsSendService.this.nAsSendFlag + " bHaveSend = " + bHaveSend.get()));
                        }
                        if (AsSendService.this.nAsSendFlag.get() != 1 && !bHaveSend.get()) {
                            try {
                                AsSendService.this.mAsHardEncodeObject.wait();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            GenseeLog.i((String)AsSendService.TAG, (String)("pushAsData p.fmt2 = " + p.fmt + " nAsSendFlag = " + AsSendService.this.nAsSendFlag));
                        }
                    }
                    if (AsSendService.this.nAsSendFlag.get() == 1) {
                        AsSendService.this.mPreHardEncodeData = null;
                        AsSendService.this.nAsSendFlag.set(0);
                        continue block12;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            GenseeLog.i((String)AsSendService.TAG, (String)"ashardencode send thread exit");
        }
    };

    public void setOnAsServiceListener(OnAsServiceListener mOnAsServiceListener) {
        this.mOnAsServiceListener = mOnAsServiceListener;
    }

    public void setOnAsImplListener(OnAsImplListener mOnAsImplListener) {
        this.mOnAsImplListener = mOnAsImplListener;
    }

    private synchronized void addAsSoftList(byte[] data) {
        this.asSoftList.add(data);
    }

    private synchronized byte[] removeAsSoft() {
        if (this.asSoftList.size() > 0) {
            return this.asSoftList.remove(0);
        }
        return null;
    }

    private void sendAsData(AsData mAsData) {
        if (!this.isAsHardEncoded) {
            if (this.bSendAsFlag.get()) {
                GenseeLog.w((String)TAG, (String)"sendAsData filter data");
                return;
            }
            this.bSendAsFlag.set(true);
            if (this.asDataList.size() >= 1) {
                GenseeLog.w((String)TAG, (String)("AsSoftData asDataList size = " + this.asDataList.size()));
            }
            IRTEvent.IAsEvent asEvent = RTRoom.getIns().getAsEvent();
            GenseeLog.i((String)TAG, (String)"pushAsData start");
            boolean bTrue = ((AsEventImpl)asEvent).pushAsData(mAsData.data, this.fps, 2, mAsData.width, mAsData.height, new OnTaskRet(){

                public void onTaskRet(boolean ret, int id, String desc) {
                    AsSendService.this.bSendAsFlag.set(false);
                    GenseeLog.i((String)AsSendService.TAG, (String)"pushAsData end");
                }
            });
            if (!bTrue) {
                this.bSendAsFlag.set(false);
            }
        } else if (this.bAsPushBegin.get() && this.bAsBegin.get()) {
            if (this.getHardEncodeDataSize() >= 2) {
                GenseeLog.w((String)TAG, (String)"AsHardEncodeData send exception");
                return;
            }
            this.onAsData(mAsData.width, mAsData.height, mAsData.data);
        } else {
            this.releaseHardEncoder();
        }
    }

    public void onAsPushModeEnd() {
        this.bAsPushBegin.set(false);
        this.bAsBegin.set(false);
    }

    public void onAsPushModeBegin() {
        this.bAsPushBegin.set(true);
    }

    public void onAsBegin() {
        this.bAsBegin.set(true);
    }

    public void setConnectActivity(Activity mActivity) {
        Intent notificationIntent = new Intent((Context)this, mActivity.getClass());
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)notificationIntent, (int)0);
        Notification notification = new Notification.Builder((Context)this).setContentTitle((CharSequence)"My title").setContentText((CharSequence)"My content").setContentIntent(pendingIntent).build();
        this.startForeground(1, notification);
    }

    public void onCreate() {
        super.onCreate();
        this.asDataList = new ArrayList<AsData>();
        this.asRecoverDataList = new ArrayList<AsData>();
        this.fps = 5;
        this.mProjectionManager = (MediaProjectionManager)this.getSystemService("media_projection");
        new Thread(){

            @Override
            public void run() {
                GenseeLog.i((String)AsSendService.TAG, (String)"handler looper finish1");
                Looper.prepare();
                AsSendService.this.mLooper = Looper.myLooper();
                AsSendService.this.mHandler = new Handler();
                Looper.loop();
                GenseeLog.i((String)AsSendService.TAG, (String)"handler looper finish");
            }
        }.start();
        this.asSendThread = new Thread(this.asSendRunnable);
        this.bAsSendRunning.set(true);
        this.asSendThread.start();
    }

    public void setAsHardEncoded(boolean isAsHardEncoded) {
        if (this.isAsHardEncoded != isAsHardEncoded) {
            this.isAsHardEncoded = isAsHardEncoded;
            this.releaseHardEncoder();
        }
        GenseeLog.d((String)TAG, (String)("setAsHardEncoded isAsHardEncoded = " + isAsHardEncoded));
    }

    public void asAuthorization() {
        if (this.isAsStarted) {
            RTRoom.getIns().getRoutine().asPushModeEnable(true, null);
            RTRoom.getIns().getRoutine().asBegin(false, null);
        } else {
            Intent intent = new Intent((Context)this, AsTransparentActivity.class);
            intent.setFlags(0x30000000);
            this.startActivity(intent);
        }
    }

    public void asAuthorizationFailure() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMediaProjection(int resultCode, Intent data, int mDensity, Display mDisplay) {
        this.mRotation = mDisplay.getRotation();
        if (null != this.mOnAsImplListener) {
            this.mOnAsImplListener.onAsStart();
        }
        this.asDataList.clear();
        this.isAsStarted = true;
        this.bAsSendStop.set(false);
        this.mLastData = null;
        Object object = this.asObject;
        synchronized (object) {
            this.asObject.notifyAll();
        }
        if (null != this.windowView && null != this.wLayoutParams) {
            this.asAddFloatWindowView(this.windowView, this.wLayoutParams);
        }
        RTRoom.getIns().getRoutine().asPushModeEnable(true, null);
        RTRoom.getIns().getRoutine().asBegin(false, null);
        this.sMediaProjection = this.mProjectionManager.getMediaProjection(resultCode, data);
        this.mDensity = mDensity;
        this.mDisplay = mDisplay;
        this.createVirtualDisplay();
        this.sMediaProjection.registerCallback((MediaProjection.Callback)new MediaProjectionStopCallback(), this.mHandler);
        this.mOrientationChangeCallback = new OrientationChangeCallback((Context)this);
        this.mHandler.post(this.orientationRunnable);
        if (this.mOrientationChangeCallback.canDetectOrientation()) {
            this.mOrientationChangeCallback.enable();
        }
    }

    public void rotationChanged() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (AsSendService.this.mVirtualDisplay != null) {
                        AsSendService.this.mVirtualDisplay.release();
                    }
                    if (AsSendService.this.mImageReader != null) {
                        AsSendService.this.mImageReader.setOnImageAvailableListener(null, null);
                    }
                    AsSendService.this.createVirtualDisplay();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void onlyStopProjection() {
        this.bAsSendStop.set(true);
        this.isAsStarted = false;
        this.releaseHardEncoder();
        RTRoom.getIns().getRoutine().asEnd(null);
        if (this.mOrientationChangeCallback != null) {
            this.mOrientationChangeCallback.disable();
        }
        this.removeOrientationRunnable();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (AsSendService.this.sMediaProjection != null) {
                    AsSendService.this.sMediaProjection.stop();
                }
            }
        });
        this.asDataList.clear();
    }

    public void stopProjection() {
        WindowManager windowManager = (WindowManager)this.getSystemService("window");
        if (null != this.windowView && this.windowView.getParent() != null) {
            windowManager.removeView(this.windowView);
        }
        this.onlyStopProjection();
        this.mBitmapVideoPng = null;
    }

    private void createVirtualDisplay() {
        int heigthMod;
        Point size = new Point();
        this.mDisplay.getSize(size);
        DisplayMetrics metrice = new DisplayMetrics();
        this.mDisplay.getRealMetrics(metrice);
        int width = metrice.widthPixels / 2;
        int height = metrice.heightPixels / 2;
        int widtMod = width % 16;
        if (widtMod != 0) {
            width += 16 - widtMod;
        }
        if ((heigthMod = height % 16) != 0) {
            height += 16 - heigthMod;
        }
        GenseeLog.d((String)TAG, (String)("createVirtualDisplay width = " + width + " height = " + height));
        this.mImageReader = ImageReader.newInstance((int)width, (int)height, (int)1, (int)2);
        this.mVirtualDisplay = this.sMediaProjection.createVirtualDisplay(SCREENCAP_NAME, width, height, this.mDensity, 9, this.mImageReader.getSurface(), null, this.mHandler);
        this.mImageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)new ImageAvailableListener(), this.mHandler);
    }

    private synchronized void addData(AsData asData) {
        if (this.asDataList.size() > 0) {
            this.asRecoverDataList.addAll(this.asDataList);
            this.asDataList.clear();
        }
        this.asDataList.add(asData);
    }

    private synchronized void addRecoverData(AsData asData) {
        this.asRecoverDataList.add(asData);
    }

    private synchronized AsData removeRecoverData() {
        if (this.asRecoverDataList.size() > 0) {
            return this.asRecoverDataList.remove(0);
        }
        return null;
    }

    private synchronized AsData removeData() {
        if (this.asDataList.size() > 0) {
            AsData mLastData = this.asDataList.remove(this.asDataList.size() - 1);
            return mLastData;
        }
        return null;
    }

    public void setVideoDataPng(Bitmap mBitmap, int desVideoLogoMarginTop, int desVideoLogoMarginRight) {
        this.mBitmapVideoPng = mBitmap;
        this.nVideoPngMarginTop = desVideoLogoMarginTop;
        this.nVideoPngMarginRight = desVideoLogoMarginRight;
    }

    private Bitmap getVideoLogotBitmap(Bitmap mBlendDesBitmap, Bitmap mBlendSrcBitmap, int nWidth, int nHeight, int topMargin, int rightMargin) {
        float sx;
        Canvas mCanvas = new Canvas(mBlendDesBitmap);
        BitmapDrawable d = new BitmapDrawable(mBlendSrcBitmap);
        d.setTargetDensity(mBlendSrcBitmap.getDensity());
        d.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
        Matrix matrix = new Matrix();
        float n1 = 0.2f;
        int nDes = 720 * mBlendSrcBitmap.getDensity() / 320;
        if (nWidth < nDes) {
            nDes = nWidth;
        }
        float sy = sx = (float)nDes * n1 / (float)mBlendSrcBitmap.getWidth();
        matrix.postScale(sx, sy);
        matrix.postTranslate((float)nWidth - n1 * (float)nDes - (float)rightMargin, (float)topMargin);
        mCanvas.concat(matrix);
        d.draw(mCanvas);
        return mBlendDesBitmap;
    }

    public void onDestroy() {
        super.onDestroy();
        this.releaseHardEncoder();
        if (this.mOrientationChangeCallback != null) {
            this.mOrientationChangeCallback.disable();
        }
        this.stopForeground(true);
        this.stopProjection();
        if (null != this.mLooper) {
            this.mLooper.quitSafely();
            this.mLooper = null;
        }
        this.bAsSendRunning.set(false);
        this.isAsHardEncoded = false;
        if (null != this.mAsHardEncodeThread) {
            this.mAsHardEncodeThread.interrupt();
            this.mAsHardEncodeThread = null;
        }
        if (null != this.asSendThread) {
            this.asSendThread.interrupt();
            this.asSendThread = null;
        }
    }

    public IBinder onBind(Intent intent) {
        return new AsServiceBinder();
    }

    private void removeOrientationRunnable() {
        this.mHandler.removeCallbacks(this.orientationRunnable);
    }

    private void initHardEncoder() {
        if (null == this.mVideoHardEncoded) {
            this.mVideoHardEncoded = new VideoHardEncoded(this.mRealWidth, this.mRealHeight, null);
            this.mVideoHardEncoded.setFps(this.fps);
            this.mVideoHardEncoded.setBitRate(400000);
            this.mVideoHardEncoded.setOnVideoHardEncodeDataCallback((OnVideoHardEncodeDataCallback)this);
            this.mVideoHardEncoded.start();
        }
    }

    private void releaseHardEncoder() {
        if (this.mVideoHardEncoded != null) {
            this.mVideoHardEncoded.release();
            this.mVideoHardEncoded = null;
        }
    }

    private void onAsData(int width, int height, byte[] data) {
        if (this.mRealWidth != width || this.mRealHeight != height) {
            this.mRealWidth = width;
            this.mRealHeight = height;
        }
        if (this.isAsHardEncoded && null == this.mVideoHardEncoded) {
            this.initHardEncoder();
        }
        byte[] yv12 = new byte[width * height * 3 / 2];
        VideoCoreLibrary.RGBABYTEtoYV12((byte[])data, (int)width, (int)height, (byte[])yv12);
        if (this.isAsHardEncoded && null != this.mVideoHardEncoded) {
            this.mVideoHardEncoded.sendEncodeFrame(yv12, width, height, 0);
        }
    }

    public void asAddFloatWindowView(View windowView, WindowManager.LayoutParams wLayoutParams) {
        this.windowView = windowView;
        this.wLayoutParams = wLayoutParams;
        WindowManager windowManager = (WindowManager)this.getSystemService("window");
        if (windowView.getParent() != null) {
            windowManager.removeView(windowView);
        }
        if (this.isAsStarted) {
            windowManager.addView(windowView, (ViewGroup.LayoutParams)wLayoutParams);
        }
    }

    public void stopAsConfirm() {
        if (null != this.mOnAsServiceListener) {
            this.mOnAsServiceListener.showAsStopConfirmDialog((Context)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onVideoHardEncodeData(byte[] data, VideoParam p) {
        if (null == this.mAsHardEncodeThread) {
            this.mAsHardEncodeThread = new Thread(this.mAsHardEncodeRunnable);
            this.mAsHardEncodeThread.start();
        }
        AsHardEncodeData mData = new AsHardEncodeData();
        AsHardEncodeData.access$3802(mData, data);
        mData.videoParam = p;
        this.addHardEncodeData(mData);
        Object object = this.mAsHardEncodeNotify;
        synchronized (object) {
            this.mAsHardEncodeNotify.notifyAll();
        }
    }

    private synchronized void addHardEncodeData(AsHardEncodeData mData) {
        this.asHardEncodeList.add(mData);
    }

    private synchronized AsHardEncodeData removeHardEncodeData() {
        if (this.asHardEncodeList.size() > 0) {
            return this.asHardEncodeList.remove(0);
        }
        return null;
    }

    private synchronized int getHardEncodeDataSize() {
        return null == this.asHardEncodeList ? 0 : this.asHardEncodeList.size();
    }

    static /* synthetic */ byte[] access$3202(AsSendService x0, byte[] x1) {
        x0.mImageData = x1;
        return x1;
    }

    private class AsHardEncodeData {
        private byte[] data;
        private VideoParam videoParam;

        private AsHardEncodeData() {
        }

        static /* synthetic */ byte[] access$3802(AsHardEncodeData x0, byte[] x1) {
            x0.data = x1;
            return x1;
        }
    }

    private class AsData {
        private int width;
        private int height;
        private byte[] data;

        private AsData() {
        }

        static /* synthetic */ byte[] access$402(AsData x0, byte[] x1) {
            x0.data = x1;
            return x1;
        }
    }

    public static interface OnAsImplListener {
        public void onAsStart();
    }

    private class OrientationChangeCallback
    extends OrientationEventListener {
        public OrientationChangeCallback(Context context) {
            super(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOrientationChanged(int orientation) {
            OrientationChangeCallback orientationChangeCallback = this;
            synchronized (orientationChangeCallback) {
                int rotation = AsSendService.this.mDisplay.getRotation();
                if (rotation != AsSendService.this.mRotation) {
                    AsSendService.this.mRotation = rotation;
                    if (null != AsSendService.this.mOnAsServiceListener) {
                        AsSendService.this.mOnAsServiceListener.onAsRotationChanged(AsSendService.this.mRotation);
                    }
                    AsSendService.this.rotationChanged();
                }
            }
        }
    }

    public class AsServiceBinder
    extends Binder {
        public AsSendService getService() {
            return AsSendService.this;
        }
    }

    private class ImageAvailableListener
    implements ImageReader.OnImageAvailableListener {
        private ImageAvailableListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onImageAvailable(ImageReader reader) {
            Image image = null;
            FileOutputStream fos = null;
            Object bitmap = null;
            try {
                image = AsSendService.this.mImageReader.acquireLatestImage();
                if (!AsSendService.this.bAsBegin.get() || !AsSendService.this.bAsPushBegin.get()) {
                    return;
                }
                if (image != null) {
                    long nTime1 = Calendar.getInstance().getTimeInMillis();
                    if (nTime1 - AsSendService.this.nTime > 1000L) {
                        GenseeLog.i((String)AsSendService.TAG, (String)("onImageAvailable read framecount count per = " + AsSendService.this.frameCount));
                        AsSendService.this.nTime = nTime1;
                        AsSendService.this.frameCount = 0;
                    }
                    ++AsSendService.this.frameCount;
                    Image.Plane[] planes = image.getPlanes();
                    ByteBuffer buffer = planes[0].getBuffer();
                    int pixelStride = planes[0].getPixelStride();
                    int rowStride = planes[0].getRowStride();
                    int mWidth = image.getWidth();
                    int mHeight = image.getHeight();
                    int rowPadding = rowStride - pixelStride * mWidth;
                    AsData asData = AsSendService.this.removeRecoverData();
                    if (null == asData) {
                        asData = new AsData();
                    }
                    int realWidth = image.getWidth() + rowPadding / pixelStride;
                    int realHeight = mHeight;
                    if (null == AsSendService.this.mImageData || AsSendService.this.mImageData.length != realWidth * realHeight * 4) {
                        AsSendService.access$3202(AsSendService.this, new byte[realHeight * realWidth * 4]);
                    }
                    buffer.get(AsSendService.this.mImageData, 0, AsSendService.this.mImageData.length);
                    asData.width = mWidth;
                    asData.height = mHeight;
                    if (null == asData.data || asData.data.length != asData.width * asData.height * 4) {
                        AsData.access$402(asData, new byte[asData.width * asData.height * 4]);
                    }
                    if (rowPadding > 0) {
                        for (int i = 0; i < asData.height; ++i) {
                            System.arraycopy(AsSendService.this.mImageData, i * realWidth * 4, asData.data, i * asData.width * 4, asData.width * 4);
                        }
                    } else {
                        System.arraycopy(AsSendService.this.mImageData, 0, asData.data, 0, asData.data.length);
                    }
                    AsSendService.this.addData(asData);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                if (bitmap != null) {
                    bitmap.recycle();
                }
                if (image != null) {
                    image.close();
                }
            }
        }
    }

    private class MediaProjectionStopCallback
    extends MediaProjection.Callback {
        private MediaProjectionStopCallback() {
        }

        public void onStop() {
            Log.e((String)"ScreenCapture", (String)"stopping projection.");
            AsSendService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (AsSendService.this.mVirtualDisplay != null) {
                        AsSendService.this.mVirtualDisplay.release();
                    }
                    if (AsSendService.this.mImageReader != null) {
                        AsSendService.this.mImageReader.setOnImageAvailableListener(null, null);
                    }
                    if (AsSendService.this.mOrientationChangeCallback != null) {
                        AsSendService.this.mOrientationChangeCallback.disable();
                    }
                    AsSendService.this.removeOrientationRunnable();
                    AsSendService.this.sMediaProjection.unregisterCallback((MediaProjection.Callback)MediaProjectionStopCallback.this);
                }
            });
        }
    }
}

