/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.common;

import android.content.Context;
import com.gensee.common.GenseeConfig;
import com.gensee.heartbeat.GSHBFactroy;
import com.gensee.heartbeat.IHeartBeat;
import com.gensee.net.NetChange;
import com.gensee.net.OnNetChangeListener;
import com.gensee.taskret.IGSTask;
import com.gensee.taskret.OnTaskRet;
import com.gensee.utils.GenseeLog;

public class PlayerEnv {
    private static final String TAG = "PlayerEnv";
    protected static boolean isInited = false;
    private static int initCount = 0;
    private static boolean isLibLoaded = false;

    public static boolean isHBInited() {
        return isInited;
    }

    public static void setUp(Context context) {
        NetChange ins = NetChange.getIns();
        ins.setUp(context);
        ins.addOnNetChangeListener(new OnNetChangeListener(){

            public void onNetChange(Context context) {
                if (isLibLoaded) {
                    PlayerEnv.onNetChange();
                }
            }
        });
    }

    public static boolean init(boolean isNeedInitLog, final int serviceType, final int sampleSize, final Context context, final OnTaskRet ret) {
        PlayerEnv.startHeartBeat(isNeedInitLog);
        return GSHBFactroy.instance().addTask(new IGSTask(){

            public int doTask() {
                int videoType = GenseeConfig.isPVHardDecode ? 255 : 1;
                PlayerEnv.initEnv(true, videoType, serviceType, sampleSize, !GenseeConfig.isDocDataPng, GenseeConfig.getDeviceType());
                GenseeLog.i((String)PlayerEnv.TAG, (String)"Env inited");
                PlayerEnv.setUp(context);
                OnTaskRet tRet = ret;
                if (null != tRet) {
                    tRet.onTaskRet(true, 1, "initOfflineComp");
                }
                return 1;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startHeartBeat(boolean isNeedInitLog) {
        if (isInited) {
            return;
        }
        if (isNeedInitLog) {
            GenseeLog.initLog();
        }
        String string = TAG;
        synchronized (TAG) {
            if (!isInited) {
                isInited = true;
                GenseeLog.w((String)("PlayerEnv startHeartBeat " + isInited));
                IHeartBeat hb = GSHBFactroy.instance();
                hb.setVodHBeat(new IHeartBeat.INativeHeartBeat(){

                    public void nativeHeartBeat() {
                        PlayerEnv.opHeartBeat();
                    }
                });
                hb.startHeartBeat();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void release() {
        isInited = false;
        NetChange.getIns().release();
        GSHBFactroy.instance().addTask(new IGSTask(){

            public int doTask() {
                PlayerEnv.clearEnv();
                return 2;
            }
        });
    }

    private static boolean onNetChange() {
        return GSHBFactroy.instance().addTask(new IGSTask(){

            public int doTask() {
                PlayerEnv.netChange();
                return 0;
            }
        });
    }

    private static native void initEnv(boolean var0, int var1, int var2, int var3, boolean var4, int var5);

    private static native void clearEnv();

    private static native void opHeartBeat();

    public static native void setTcpProxy(IProxy var0);

    public static native void netChange();

    public static boolean loadLibrary() {
        if (isLibLoaded) {
            return true;
        }
        try {
            System.loadLibrary("stlport_shared");
            System.loadLibrary("AVCDecoder");
            System.loadLibrary("uctinyxml");
            System.loadLibrary("SoundTouch");
            System.loadLibrary("ucbase");
            System.loadLibrary("speex");
            System.loadLibrary("ucamf");
            System.loadLibrary("ucflv");
            System.loadLibrary("ucnet");
            System.loadLibrary("ucts");
            System.loadLibrary("ucrtp");
            System.loadLibrary("ucrtmpcli");
            System.loadLibrary("ucdflvreader");
            System.loadLibrary("H264Android");
            System.loadLibrary("unidecoder");
            System.loadLibrary("ucoffplayer");
            System.loadLibrary("gsolcomp-jni");
            isLibLoaded = true;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            GenseeLog.w((String)TAG, (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            GenseeLog.w((String)TAG, (Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            GenseeLog.w((String)TAG, (Throwable)e);
        }
        catch (Error e) {
            GenseeLog.w((String)TAG, (Throwable)e);
            e.printStackTrace();
        }
        return isLibLoaded;
    }

    static {
        PlayerEnv.loadLibrary();
    }

    public static interface IProxy {
        public String getProxyIP(String var1);

        public int getProxyPort(int var1);
    }
}

