/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.media;

import android.content.Context;
import android.content.SharedPreferences;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import com.gensee.media.ViEncoder;

public class AVConfig {
    private static final String SP_FILE_NAME = "sp.gensee";
    private static final String SP_SAMPLERATE = "sp.samplerate";
    private static final String SP_VIDEO_EN_COLOR_FMT = "sp.video.en.color.fmt";
    public static final int M16K = 0;
    public static final int M32K = 1;
    public static final int M44K = 2;
    public static final int M48K = 3;
    public static final int S16K = 4;
    public static final int S32K = 5;
    public static final int S44K = 6;
    public static final int S48K = 7;
    public static final int GS_RGB24 = 0;
    public static final int GS_RGB16 = 1;
    public static final int GS_RGB32 = 2;
    public static final int GS_I420 = 3;
    public static final int GS_YUY2 = 4;
    public static final int GS_NV12 = 5;
    public static final int GS_YV12 = 6;
    public static final int GS_H264 = 255;

    public static int getSampleRate(Context context) {
        int mNativeOutputSampleRate = AVConfig.getAndroidSampleRate(context);
        int type = 0;
        switch (mNativeOutputSampleRate / 1000) {
            case 16: {
                type = 0;
                break;
            }
            case 32: {
                type = 1;
                break;
            }
            case 44: {
                type = 2;
                break;
            }
            case 48: {
                type = 3;
                break;
            }
        }
        return type;
    }

    public static int getAndroidSampleRate(Context context) {
        String sampleRateString;
        SharedPreferences sp = context.getSharedPreferences(SP_FILE_NAME, 0);
        int mNativeOutputSampleRate = 0;
        mNativeOutputSampleRate = sp.getInt(SP_SAMPLERATE, 0);
        if (mNativeOutputSampleRate != 0) {
            return mNativeOutputSampleRate;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        mNativeOutputSampleRate = AudioTrack.getNativeOutputSampleRate((int)3);
        if (Build.VERSION.SDK_INT >= 17 && (sampleRateString = audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE")) != null) {
            mNativeOutputSampleRate = Integer.parseInt(sampleRateString);
        }
        sp.edit().putInt(SP_SAMPLERATE, mNativeOutputSampleRate).commit();
        return mNativeOutputSampleRate;
    }

    public static boolean isEncodeVideo() {
        return false;
    }

    public boolean isDecodeVideo(Context context) {
        return false;
    }

    public static int encodeColorFmt(Context context, int width, int height) {
        SharedPreferences sp = context.getSharedPreferences(SP_FILE_NAME, 0);
        int colorFmt = sp.getInt(SP_VIDEO_EN_COLOR_FMT, 0);
        if (colorFmt == 0) {
            ViEncoder.isEnable((int)width, (int)height);
        }
        return colorFmt;
    }
}

