/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.media;

import android.media.AudioTrack;
import android.os.Handler;
import android.os.Process;
import com.gensee.common.GenseeConfig;
import com.gensee.heartbeat.GSWork;
import com.gensee.media.IVideoIndication;
import com.gensee.media.VideoData;
import com.gensee.parse.AnnotaionParse;
import com.gensee.pdu.AbsAnno;
import com.gensee.pdu.GSDocView;
import com.gensee.pdu.PduPage;
import com.gensee.utils.GenseeLog;
import com.gensee.view.GSDocViewGx;
import java.io.File;
import java.util.LinkedList;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class AbsPlayer
extends GSWork {
    private static final String TAG = "AbsPlayer";
    protected long nativeSink;
    protected String cachDir;
    protected IVideoIndication mVideoView;
    private int mH264Width;
    private int mH264Height;
    private int videoW;
    private int videoH;
    protected GSDocView mDocView;
    protected GSDocViewGx mGlDocView;
    protected PduPage mPage;
    protected AnnotaionParse parse;
    private AudioTrack mTrack;
    private int frequence = 16000;
    private int channelConfig = 2;
    private int audioEncoding = 2;
    private int nPlayerType = 0;
    private Handler mHandler;
    private ExecutorService service;
    private long lastAnnoReceiveTime = 0L;
    private AudioSynThread mSynThread;
    private int mAudioQueueSize = 0;
    private ViThread synViThread;

    protected void setPlayerType(int nPlayerType) {
        this.nPlayerType = nPlayerType;
    }

    public void setGSVideoView(IVideoIndication videoView) {
        GenseeLog.d((String)TAG, (String)("setGSVideoView " + videoView));
        this.mVideoView = videoView;
    }

    public void setDocView(GSDocView docView) {
        this.setGSDocView(docView);
    }

    public void setGSDocView(GSDocView docView) {
        GenseeLog.d((String)TAG, (String)("setGSDocView " + docView));
        this.mDocView = docView;
        if (null != this.mDocView) {
            this.setHandler(this.mDocView.getHandler());
            if (this.mPage != null) {
                this.mDocView.setDocPage(this.mPage);
            }
        } else {
            this.setHandler(null);
        }
    }

    public void setGSDocViewGx(GSDocViewGx glDocView) {
        GenseeLog.d((String)TAG, (String)("setGSDocViewGx " + glDocView));
        this.mGlDocView = glDocView;
        if (null != this.mGlDocView) {
            this.setHandler(this.mGlDocView.getHandler());
            if (this.mPage != null) {
                this.sendMessage(138, this.mPage);
            }
        } else {
            this.setHandler(null);
        }
    }

    protected void initAudioPlayer() {
        if (this.mSynThread == null) {
            this.mSynThread = new AudioSynThread("AudioSynThread-1");
            this.mSynThread.start();
        }
        if (this.mTrack == null) {
            this.frequence = 16000;
            int streamType = 3;
            this.frequence = AudioTrack.getNativeOutputSampleRate((int)streamType);
            int bufferSize = AudioTrack.getMinBufferSize((int)this.frequence, (int)this.channelConfig, (int)this.audioEncoding);
            this.mTrack = new AudioTrack(streamType, this.frequence, this.channelConfig, this.audioEncoding, bufferSize * 2, 1);
        }
        if (3 != this.mTrack.getPlayState()) {
            this.mTrack.play();
        }
    }

    protected int getAudioState() {
        return this.mTrack == null ? -1 : this.mTrack.getPlayState();
    }

    protected void audioResume() {
        int ps;
        if (this.mTrack != null && 2 == (ps = this.mTrack.getPlayState())) {
            this.mTrack.play();
            GenseeLog.d((String)"audioResume mTrack.play()");
        }
    }

    protected void audioPause() {
        if (this.mTrack != null && 3 == this.mTrack.getPlayState()) {
            this.mTrack.pause();
            GenseeLog.d((String)"audioPause pause mTrack.pause()");
        }
    }

    protected boolean audioDataPlay(byte[] buffer, int len) {
        if (buffer == null) {
            return false;
        }
        if (this.mSynThread != null) {
            return this.mSynThread.putPkg(new AudioPkg(0L, buffer));
        }
        return false;
    }

    private boolean audioDataWrite(byte[] buffer, int len) {
        try {
            int sp;
            if (len > 0 && this.mTrack != null && 3 == (sp = this.mTrack.getPlayState())) {
                this.mTrack.write(buffer, 0, buffer.length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    protected void audioStop() {
        int sp;
        if (this.mTrack != null && 1 != (sp = this.mTrack.getPlayState())) {
            this.mTrack.stop();
        }
    }

    protected void audioRelease() {
        this.mAudioQueueSize = 0;
        AudioSynThread tmp = this.mSynThread;
        this.mSynThread = null;
        if (tmp != null) {
            tmp.release();
        }
        if (this.mTrack != null) {
            this.mTrack.release();
        }
        this.mTrack = null;
    }

    protected int getAudioQueueLen() {
        return this.mAudioQueueSize;
    }

    protected void audioQueueClear() {
        if (this.mSynThread != null) {
            this.mSynThread.dataQueueClear();
        }
    }

    protected void setVideoSize(int w, int h, boolean isReal) {
        if (isReal) {
            this.mH264Width = w;
            this.mH264Height = h;
            if (this.videoW == 0 || this.videoH == 0) {
                this.videoW = w;
                this.videoH = h;
            }
        } else {
            this.videoW = w;
            this.videoH = h;
        }
        if (this.synViThread == null) {
            ViThread t = this.synViThread = new ViThread("SynViThread-1");
            t.start();
            this.synViThread = t;
        }
    }

    protected void renderVideo(byte[] videoData) {
        if (this.synViThread != null) {
            this.synViThread.putPkg(new VideoData(videoData, 0L, this.mH264Width, this.mH264Height, this.videoW, this.videoH));
        }
    }

    protected void renderPage(byte[] data, int dwLen, int dwPageW, int dwPageH) {
        if (data != null && dwLen > 0) {
            String path = new String(data);
            this.renderPage(path, dwPageW, dwPageH);
        } else {
            GenseeLog.w((String)"renderPage data is null");
        }
    }

    protected void renderPage(byte[] data, int dwLen, int dwPageW, int dwPageH, String sAnimationPath) {
        if (data != null && dwLen > 0) {
            String path = new String(data);
            this.renderPage(path, dwPageW, dwPageH, sAnimationPath);
            GenseeLog.d((String)TAG, (String)("renderPage swf swfpath = " + path + " sAnimationPath = " + sAnimationPath));
        } else {
            GenseeLog.w((String)"renderPage data is null");
        }
    }

    protected void renderPage(String path, int dwPageW, int dwPageH) {
        if (this.mPage != null) {
            this.mPage.clear();
        }
        this.mPage = new PduPage();
        if (this.nPlayerType == 0) {
            this.mPage.setSdkType(1);
        } else {
            this.mPage.setSdkType(2);
        }
        this.mPage.setPageId((int)System.currentTimeMillis());
        this.mPage.setImgWidth((short)dwPageW);
        this.mPage.setImgHeight((short)dwPageH);
        if (path != null) {
            this.mPage.setPath(this.checkPng(path));
        } else {
            GenseeLog.w((String)TAG, (String)"renderPage path data is null");
        }
        if (this.mDocView != null) {
            this.mDocView.setDocPage(this.mPage);
        }
    }

    private String checkPng(String oldPath) {
        File f;
        if (oldPath != null && oldPath.endsWith(".png.1") && !(f = new File(oldPath)).exists()) {
            return oldPath.substring(0, oldPath.length() - 2);
        }
        return oldPath;
    }

    protected void renderPage(String swfPath, int dwPageW, int dwPageH, String annimationPath) {
        GenseeLog.d((String)TAG, (String)("renderPage path = " + swfPath + " anim = " + annimationPath));
        PduPage tmp = this.mPage;
        if (tmp != null) {
            tmp.clear();
        }
        tmp = this.mPage = new PduPage();
        if (this.nPlayerType == 0) {
            tmp.setSdkType(1);
        } else {
            tmp.setSdkType(2);
        }
        tmp.setPageId((int)System.currentTimeMillis());
        tmp.setImgWidth((short)dwPageW);
        tmp.setImgHeight((short)dwPageH);
        if (swfPath != null) {
            tmp.setPath(this.checkPng(swfPath));
            tmp.setAnimationPath(annimationPath);
        } else {
            GenseeLog.w((String)TAG, (String)"renderPage path data is null");
        }
        this.sendMessage(138, tmp);
    }

    protected void renderPageAnimation(int step) {
        PduPage p = this.mPage;
        if (null != p) {
            p.setAniStep(step);
            this.sendMessage(142, p);
        }
    }

    protected void drawAnno(AbsAnno anno) {
        switch (anno.getType()) {
            case 16: {
                this.addAnno(anno);
                break;
            }
            case 3: {
                this.cleanAnno(anno);
                break;
            }
            case 1: 
            case 9: {
                PduPage p = this.mPage;
                if (p == null || !p.changePoint(anno)) break;
                this.removeMessages(135);
                this.sendMessage(135, null);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.addAnno(anno);
                break;
            }
        }
    }

    protected void renderAnno(String strAnnoXML) {
        AbsAnno anno;
        if (this.mPage == null) {
            return;
        }
        if (this.parse == null) {
            this.parse = new AnnotaionParse();
        }
        if ((anno = this.parse.parseAnnoXml(strAnnoXML)) == null) {
            GenseeLog.w((String)"onAnnotaion anno is null!");
            return;
        }
        this.drawAnno(anno);
    }

    private boolean cleanAnno(AbsAnno cleaner) {
        PduPage p = this.mPage;
        if (p != null && p.delAnno(cleaner)) {
            this.sendMessage(144, null);
            return true;
        }
        return false;
    }

    private boolean addAnno(AbsAnno anno) {
        PduPage p = this.mPage;
        if (p == null) {
            return false;
        }
        int addRet = p.addAnno(anno, false);
        if (addRet != -1) {
            if (anno.getType() == 16) {
                this.removeMessages(136);
                this.sendMessageDelayed(136, anno, 100L);
            } else if (addRet == 0) {
                this.sendMessage(136, anno);
            } else if (addRet == 1) {
                this.sendMessage(141, anno);
            }
        }
        return false;
    }

    protected int getIntValue(String value) {
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (Exception e) {
                GenseeLog.w((String)e.toString());
            }
        }
        return 0;
    }

    protected long getLongValue(String value) {
        if (value != null) {
            try {
                return Long.valueOf(value);
            }
            catch (Exception e) {
                GenseeLog.w((String)e.toString());
            }
        }
        return 0L;
    }

    private void setHandler(Handler handler) {
        this.mHandler = handler;
    }

    protected void sendMessage(int what, Object object) {
        Handler h = this.mHandler;
        if (h != null) {
            h.sendMessage(h.obtainMessage(what, object));
        } else {
            GenseeLog.w((String)("AbsPlayer there is a msg " + what + " arived,but the ui handler is null"));
        }
    }

    protected void sendMessageDelayed(int what, Object object, long delay) {
        Handler h = this.mHandler;
        if (h != null) {
            h.sendMessageDelayed(h.obtainMessage(what, object), delay);
        } else {
            GenseeLog.w((String)("AbsPlayer there is a msg " + what + " arived,but the ui handler is null"));
        }
    }

    protected void removeMessages(int what) {
        Handler h = this.mHandler;
        if (h != null) {
            h.removeMessages(what);
        } else {
            GenseeLog.w((String)("AbsPlayer there is a msg " + what + " arived,but the ui handler is null"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void postPool(Runnable r) {
        if (this.service == null) {
            Class<AbsPlayer> clazz = AbsPlayer.class;
            // MONITORENTER : com.gensee.media.AbsPlayer.class
            if (this.service == null) {
                this.service = Executors.newSingleThreadExecutor();
            }
            // MONITOREXIT : clazz
        }
        this.service.submit(r);
    }

    protected void shutdownTreadPool() {
        ExecutorService s = this.service;
        this.service = null;
        if (s != null) {
            s.shutdown();
        }
    }

    public boolean release() {
        this.mVideoView = null;
        this.mDocView = null;
        this.mGlDocView = null;
        this.mPage = null;
        this.videoW = 0;
        this.videoH = 0;
        this.setHandler(null);
        ViThread t = this.synViThread;
        this.synViThread = null;
        if (t != null) {
            t.release();
        }
        return true;
    }

    public class PlayerType {
        public static final int RTMP_PLAYER_TYPE = 0;
        public static final int VOD_PLAYER_TYPE = 1;
    }

    private class AudioSynThread
    extends DataThread<AudioPkg> {
        public AudioSynThread(String name) {
            super(name);
        }

        @Override
        protected void onOutData(AudioPkg pkg) {
            if (pkg.buffer != null) {
                AbsPlayer.this.audioDataWrite(pkg.buffer, pkg.buffer.length);
            }
        }

        @Override
        protected void onQueneSize(int size) {
            AbsPlayer.this.mAudioQueueSize = size;
        }
    }

    private class ViThread
    extends DataThread<VideoData> {
        private Random random;

        public ViThread(String name) {
            super(name);
        }

        @Override
        protected void onOutData(VideoData data) {
            byte[] buff = data.getData();
            IVideoIndication view = AbsPlayer.this.mVideoView;
            if (view != null && buff != null) {
                int videoLen = buff.length;
                if (videoLen == 0) {
                    GenseeLog.w((String)("renderVideo fail , videoData length err " + videoLen + " w = " + AbsPlayer.this.mH264Width + " h = " + AbsPlayer.this.mH264Height));
                } else {
                    view.onReceiveFrame(data);
                }
            }
        }

        @Override
        protected void onRunStart() {
            Process.setThreadPriority((int)-8);
        }

        @Override
        protected boolean onPutPkg(LinkedList<VideoData> dataQue, VideoData dataPkg) {
            int size = dataQue.size();
            if (!GenseeConfig.isPVHardDecode && size >= 3) {
                int rd = 0;
                if (this.random == null) {
                    this.random = new Random();
                }
                rd = this.random.nextInt(3);
                dataQue.remove(rd);
            }
            return super.onPutPkg(dataQue, dataPkg);
        }
    }

    private abstract class DataThread<T>
    extends Thread {
        private Object lock;
        private AtomicBoolean isRunning;
        private LinkedList<T> dataQue;

        public DataThread(String name) {
            super(name);
            this.lock = new Object();
            this.isRunning = new AtomicBoolean(false);
            this.dataQue = new LinkedList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.onRunStart();
            this.isRunning.set(true);
            this.dataQue.clear();
            while (this.isRunning.get()) {
                T pkg = null;
                Object object = this.lock;
                synchronized (object) {
                    block8: {
                        try {
                            int mQueueSize = this.dataQue.size();
                            this.onQueneSize(mQueueSize);
                            if (mQueueSize > 0) {
                                pkg = this.dataQue.pop();
                                Thread.sleep(1L);
                                break block8;
                            }
                            if (this.isRunning.get()) {
                                this.lock.wait();
                                break block8;
                            }
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (pkg == null || !this.isRunning.get()) continue;
                this.onOutData(pkg);
            }
            this.onRunEnd();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            this.isRunning.set(false);
            Object object = this.lock;
            synchronized (object) {
                this.dataQue.clear();
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean putPkg(T dataPkg) {
            Object object = this.lock;
            synchronized (object) {
                if (this.isRunning.get()) {
                    boolean ret = this.onPutPkg(this.dataQue, dataPkg);
                    this.lock.notifyAll();
                    return ret;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataQueueClear() {
            Object object = this.lock;
            synchronized (object) {
                this.dataQue.clear();
            }
        }

        protected boolean onPutPkg(LinkedList<T> dataQue, T dataPkg) {
            return dataQue.add(dataPkg);
        }

        protected void onQueneSize(int size) {
        }

        protected abstract void onOutData(T var1);

        protected void onRunStart() {
        }

        protected void onRunEnd() {
        }
    }

    private class AudioPkg {
        protected byte[] buffer;

        private AudioPkg(long timeStamp, byte[] buffer) {
            this.buffer = buffer;
        }
    }
}

