/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.media;

import android.media.AudioRecord;
import android.os.Process;
import com.gensee.media.AbsPlayer;
import com.gensee.parse.RtmpAnnotationParse;
import com.gensee.pdu.AbsAnno;
import com.gensee.utils.GenseeLog;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;

public class RtmpPlayer
extends AbsPlayer
implements RtmpAnnotationParse.IAnnotationDraw {
    private static final String TAG = "RtmpPlayer";
    private final ReentrantLock _recLock = new ReentrantLock();
    private AudioRecord _audioRecord = null;
    private int recBufSize = 0;
    private RecThread recThread;

    public RtmpPlayer() {
        this.setPlayerType(0);
    }

    protected void write(byte[] b, int f, int len) {
        if (this.recThread != null) {
            this.recThread.write(b, f, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int initRecording(int sampleRate) {
        int minRecBufSize;
        GenseeLog.d((String)TAG, (String)("initRecording + " + this._recLock.isLocked()));
        int ret = 0;
        this._recLock.lock();
        sampleRate = 16000;
        this.recBufSize = minRecBufSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)2, (int)2);
        if (this._audioRecord != null) {
            this._audioRecord.release();
            this._audioRecord = null;
        }
        try {
            this._audioRecord = new AudioRecord(7, sampleRate, 16, 2, this.recBufSize);
            ret = 1;
        }
        catch (Exception e) {
            ret = 3;
            GenseeLog.w((String)TAG, (String)("AudioRecord init fail " + e.toString()));
        }
        finally {
            this._recLock.unlock();
        }
        if (ret == 1) {
            if (this.recThread == null) {
                this.recThread = new RecThread();
            }
            GenseeLog.d((String)TAG, (String)("recThread id = " + this.recThread.getId() + " hashcode = " + this.recThread.hashCode()));
            this.recThread.start();
        }
        return ret;
    }

    protected int startRecording() {
        try {
            this._audioRecord.startRecording();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    protected boolean isRecording() {
        RecThread t = this.recThread;
        return t != null && t.isRecording;
    }

    protected int stopRecording() {
        GenseeLog.d((String)TAG, (String)"stopRecording");
        if (this.recThread != null) {
            this.recThread.isRecording = false;
        }
        this.recThread = null;
        int ret = 0;
        this._recLock.lock();
        try {
            if (this._audioRecord != null) {
                if (this._audioRecord.getRecordingState() == 3) {
                    this._audioRecord.stop();
                }
            } else {
                GenseeLog.d((String)TAG, (String)"stopRecording rec is null");
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            ret = -1;
        }
        finally {
            if (this._audioRecord != null) {
                this._audioRecord.release();
                this._audioRecord = null;
            }
            this._recLock.unlock();
            GenseeLog.d((String)TAG, (String)("stopRecording ret = " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int recordAudio(byte[] data) {
        this._recLock.lock();
        int readBytes = 0;
        try {
            if (this._audioRecord != null) {
                readBytes = this._audioRecord.read(data, 0, data.length);
            }
        }
        catch (Exception e) {
            GenseeLog.w((String)TAG, (String)("recordAudio " + e.toString()));
        }
        finally {
            this._recLock.unlock();
        }
        return readBytes;
    }

    protected void onAuidoRecord(byte[] data, int readBytes) {
    }

    protected void onMicNotify(int notify) {
    }

    @Override
    public void annoDraw(AbsAnno absAnno) {
        this.drawAnno(absAnno);
    }

    @Override
    protected void renderAnno(String strAnnoXML) {
        if (this.mPage == null) {
            return;
        }
        if (this.parse == null) {
            this.parse = new RtmpAnnotationParse(this);
        }
        this.parse.parseAnnoXml(strAnnoXML);
    }

    private class RecThread
    extends Thread {
        private boolean isRecording = false;
        private byte[] data;
        private DataOutputStream dos;

        private RecThread() {
        }

        @Override
        public void run() {
            try {
                Process.setThreadPriority((int)-19);
            }
            catch (Exception e) {
                GenseeLog.w((String)RtmpPlayer.TAG, (String)e.getMessage());
            }
            RtmpPlayer.this.startRecording();
            this.data = new byte[RtmpPlayer.this.recBufSize];
            if (this.data == null) {
                return;
            }
            int recLength = RtmpPlayer.this.recordAudio(this.data);
            if (recLength > 0) {
                RtmpPlayer.this.onMicNotify(1);
                this.isRecording = true;
                RtmpPlayer.this.onAuidoRecord(this.data, recLength);
                while (this.isRecording) {
                    recLength = RtmpPlayer.this.recordAudio(this.data);
                    if (recLength <= 0) continue;
                    RtmpPlayer.this.onAuidoRecord(this.data, recLength);
                }
            } else {
                RtmpPlayer.this.onMicNotify(3);
                GenseeLog.w((String)RtmpPlayer.TAG, (String)"run startRecording failed");
            }
        }

        void write(byte[] b, int f, int len) {
            if (this.dos != null) {
                try {
                    this.dos.write(b, f, len);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

