/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.vodsdk;

import android.content.Context;
import android.os.Handler;
import android.widget.Toast;
import com.gensee.entity.ChatMsg;
import com.gensee.entity.InitParam;
import com.gensee.entity.QAMsg;
import com.gensee.entity.VodObject;
import com.gensee.utils.GenseeLog;
import com.gensee.vod.VodSite;
import java.util.List;

public abstract class AbsVodInfoIniter
implements VodSite.OnVodListener {
    private static final String TAG = "AbsVodlistener";
    protected VodSite vodSite;
    private Handler handler;
    private Context context;

    protected AbsVodInfoIniter(Context context, Handler handler) {
        this.handler = handler;
        this.context = context;
    }

    public void getVodObject(InitParam initParam) {
        this.vodSite = new VodSite(this.context);
        this.vodSite.setVodListener((VodSite.OnVodListener)this);
        this.vodSite.getVodObject(initParam);
    }

    public void shutdown() {
        if (this.vodSite != null) {
            this.vodSite.setVodListener(null);
            this.vodSite = null;
        }
        this.context = null;
        this.handler = null;
    }

    public void onChatHistory(String vodId, List<ChatMsg> list, int pageIndex, boolean more) {
        GenseeLog.d((String)TAG, (String)("onChatHistory vodId = " + vodId + " " + list));
    }

    public void onQaHistory(String vodId, List<QAMsg> list, int pageIndex, boolean more) {
        GenseeLog.d((String)TAG, (String)("onQaHistory vodId = " + vodId + " " + list));
        if (more) {
            // empty if block
        }
    }

    public void onVodDetail(VodObject vodObj) {
        GenseeLog.d((String)TAG, (String)("onVodDetail " + vodObj));
        if (vodObj != null) {
            vodObj.getDuration();
            vodObj.getEndTime();
            vodObj.getStartTime();
            vodObj.getStorage();
        }
    }

    public void onVodErr(final int errCode) {
        if (this.handler != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    String msg = AbsVodInfoIniter.this.getErrMsg(errCode);
                    if (AbsVodInfoIniter.this.context != null) {
                        Toast.makeText((Context)AbsVodInfoIniter.this.context, (CharSequence)msg, (int)0).show();
                    }
                }
            });
        }
    }

    private String getErrMsg(int errCode) {
        String msg = "";
        switch (errCode) {
            case -100: {
                msg = "domain \u4e0d\u6b63\u786e";
                break;
            }
            case -101: {
                msg = "\u8d85\u65f6";
                break;
            }
            case -103: {
                msg = "\u7ad9\u70b9\u4e0d\u53ef\u7528";
                break;
            }
            case -104: {
                msg = "\u65e0\u7f51\u7edc\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5";
                break;
            }
            case -105: {
                msg = "\u6570\u636e\u8fc7\u671f";
                break;
            }
            case -106: {
                msg = "\u8bf7\u68c0\u67e5\u586b\u5199\u7684serviceType";
                break;
            }
            case -107: {
                msg = "\u8bf7\u68c0\u67e5\u53c2\u6570";
                break;
            }
            case -201: {
                msg = "\u8bf7\u5148\u8c03\u7528getVodObject";
                break;
            }
            case 14: {
                msg = "\u8c03\u7528getVodObject\u5931\u8d25";
                break;
            }
            case 15: {
                msg = "\u70b9\u64ad\u7f16\u53f7\u4e0d\u5b58\u5728\u6216\u70b9\u64ad\u4e0d\u5b58\u5728";
                break;
            }
            case 16: {
                msg = "\u70b9\u64ad\u5bc6\u7801\u9519\u8bef";
                break;
            }
            case 17: {
                msg = "\u767b\u5f55\u5e10\u53f7\u6216\u767b\u5f55\u5bc6\u7801\u9519\u8bef";
                break;
            }
            case 18: {
                msg = "\u4e0d\u652f\u6301\u79fb\u52a8\u8bbe\u5907";
                break;
            }
            case -108: {
                msg = "\u7b2c\u4e09\u65b9\u8ba4\u8bc1\u5931\u8d25";
                break;
            }
            default: {
                msg = "\u521d\u59cb\u5316\u9519\u8bef\uff0c\u9519\u8bef\u7801\uff1a" + errCode + " \u8bf7\u5bf9\u7167\u6587\u6863\u8bf4\u660e";
            }
        }
        return msg;
    }
}

