/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.vodsdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import com.gensee.doc.OnDocViewEventListener;
import com.gensee.entity.ChatMsg;
import com.gensee.entity.DocInfo;
import com.gensee.entity.PageInfo;
import com.gensee.fastsdk.R;
import com.gensee.media.GSOLPlayer;
import com.gensee.media.IVideoIndication;
import com.gensee.media.VODPlayer;
import com.gensee.pdu.IGSDocView;
import com.gensee.utils.StringUtil;
import com.gensee.view.GSDocViewGx;
import com.gensee.view.GSVideoView;
import com.gensee.vodsdk.ChapterInfo;
import java.util.ArrayList;
import java.util.List;

public class VodActivity
extends AppCompatActivity
implements OnDocViewEventListener,
VODPlayer.OnVodPlayListener,
View.OnClickListener,
SeekBar.OnSeekBarChangeListener {
    private static final int DEFAULT_FADE_OUT_TIME = 5000;
    private VODPlayer mGSOLPlayer;
    private GSVideoView mGSVideoView;
    private GSDocViewGx mDocView;
    private SeekBar mSeekBarPlayViedo;
    private Button btnDocList;
    private ImageView ivPlay;
    private ListView lvChapterList;
    private ChapterListAdapter chapterListAdapter;
    private Button stopVeidoPlay;
    private Button replyVedioPlay;
    private TextView mNowTimeTextview;
    private TextView mAllTimeTextView;
    private View llControllerBar;
    private View llToolbar;
    private ImageButton mPauseScreenplay;
    private boolean isTouch = false;
    private static final String DURATION = "DURATION";
    private int VIEDOPAUSEPALY = 0;
    private int SHOW = 0;
    private int HIDE = 1;
    private List<ChapterInfo> chapterList;
    private int mControllerStatus = this.SHOW;
    @SuppressLint(value={"HandlerLeak"})
    protected Handler myHandler = new Handler(){

        public void handleMessage(Message msg) {
            block0 : switch (msg.what) {
                case 1: {
                    int max = msg.getData().getInt(VodActivity.DURATION);
                    VodActivity.this.mSeekBarPlayViedo.setMax(max);
                    VodActivity.this.mAllTimeTextView.setText((CharSequence)VodActivity.this.getTime(max /= 1000));
                    VodActivity.this.mPauseScreenplay.setImageResource(R.drawable.icon_pause);
                    if (null == VodActivity.this.chapterListAdapter) break;
                    VodActivity.this.chapterList.clear();
                    if (null != msg.obj) {
                        List docInfoList = (List)msg.obj;
                        for (DocInfo docInfo : docInfoList) {
                            List pageInfoList = docInfo.getPages();
                            if (null == pageInfoList || pageInfoList.size() <= 0) continue;
                            for (PageInfo pageInfo : pageInfoList) {
                                ChapterInfo chapterInfo = new ChapterInfo();
                                chapterInfo.setDocId(docInfo.getDocId());
                                chapterInfo.setDocName(docInfo.getDocName());
                                chapterInfo.setDocPageNum(docInfo.getPageNum());
                                chapterInfo.setDocType(docInfo.getType());
                                chapterInfo.setPageTimeStamp(pageInfo.getTimeStamp());
                                chapterInfo.setPageTitle(pageInfo.getTitle());
                                VodActivity.this.chapterList.add(chapterInfo);
                            }
                        }
                    }
                    VodActivity.this.chapterListAdapter.notifyData(VodActivity.this.chapterList);
                    break;
                }
                case 2: {
                    VodActivity.this.VIEDOPAUSEPALY = 2;
                    VodActivity.this.ivPlay.setImageDrawable(VodActivity.this.getResources().getDrawable(R.drawable.play));
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    int position = (Integer)msg.obj;
                    int nSize = VodActivity.this.chapterList.size();
                    for (int i = 0; i < nSize; ++i) {
                        ChapterInfo chapterInfo = (ChapterInfo)VodActivity.this.chapterList.get(i);
                        if (chapterInfo.getPageTimeStamp() != position) continue;
                        if (null == VodActivity.this.chapterListAdapter) break block0;
                        VodActivity.this.chapterListAdapter.setSelectedPosition(i);
                        break block0;
                    }
                    break;
                }
                case 9: {
                    VodActivity.this.VIEDOPAUSEPALY = 1;
                    VodActivity.this.mPauseScreenplay.setImageResource(R.drawable.icon_play);
                    break;
                }
                case 10: {
                    VodActivity.this.VIEDOPAUSEPALY = 0;
                    VodActivity.this.mPauseScreenplay.setImageResource(R.drawable.icon_pause);
                    break;
                }
                case 3: {
                    if (VodActivity.this.isTouch) {
                        return;
                    }
                }
                case 6: {
                    VodActivity.this.isTouch = false;
                    int anyPosition = (Integer)msg.obj;
                    VodActivity.this.mSeekBarPlayViedo.setProgress(anyPosition);
                    VodActivity.this.mNowTimeTextview.setText((CharSequence)VodActivity.this.getTime(anyPosition /= 1000));
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    int errorCode = (Integer)msg.obj;
                    switch (errorCode) {
                        case 2: {
                            Toast.makeText((Context)VodActivity.this.getApplicationContext(), (CharSequence)"\u6682\u505c\u5931\u8d25", (int)0).show();
                            break block0;
                        }
                        case 1: {
                            Toast.makeText((Context)VodActivity.this.getApplicationContext(), (CharSequence)"\u64ad\u653e\u5931\u8d25", (int)0).show();
                            break block0;
                        }
                        case 3: {
                            Toast.makeText((Context)VodActivity.this.getApplicationContext(), (CharSequence)"\u6062\u590d\u5931\u8d25", (int)0).show();
                            break block0;
                        }
                        case 5: {
                            Toast.makeText((Context)VodActivity.this.getApplicationContext(), (CharSequence)"\u8fdb\u5ea6\u53d8\u5316\u5931\u8d25", (int)0).show();
                            break block0;
                        }
                        case 4: {
                            Toast.makeText((Context)VodActivity.this.getApplicationContext(), (CharSequence)"\u505c\u6b62\u5931\u8d25", (int)0).show();
                            break block0;
                        }
                    }
                    break;
                }
                case 11: {
                    VodActivity.this.llToolbar.setVisibility(0);
                    VodActivity.this.llControllerBar.setVisibility(0);
                    VodActivity.this.mControllerStatus = VodActivity.this.SHOW;
                    VodActivity.this.myHandler.sendEmptyMessageDelayed(12, 5000L);
                    break;
                }
                case 12: {
                    VodActivity.this.llToolbar.setVisibility(8);
                    VodActivity.this.llControllerBar.setVisibility(8);
                    VodActivity.this.mControllerStatus = VodActivity.this.HIDE;
                }
            }
            super.handleMessage(msg);
        }
    };

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_vod);
        this.getWindow().addFlags(128);
        this.mGSVideoView = (GSVideoView)this.findViewById(R.id.gsvideoview);
        this.mDocView = (GSDocViewGx)this.findViewById(R.id.palydoc);
        this.mSeekBarPlayViedo = (SeekBar)this.findViewById(R.id.seekbarpalyviedo);
        this.stopVeidoPlay = (Button)this.findViewById(R.id.stopveidoplay);
        this.mPauseScreenplay = (ImageButton)this.findViewById(R.id.pauseresumeplay);
        this.replyVedioPlay = (Button)this.findViewById(R.id.replayvedioplay);
        this.mNowTimeTextview = (TextView)this.findViewById(R.id.palynowtime);
        this.mAllTimeTextView = (TextView)this.findViewById(R.id.palyalltime);
        this.btnDocList = (Button)this.findViewById(R.id.doc_list_btn);
        this.llControllerBar = this.findViewById(R.id.ll_controller_bar);
        this.llToolbar = this.findViewById(R.id.ll_toolbar);
        this.ivPlay = (ImageView)this.findViewById(R.id.iv_play);
        this.findViewById(R.id.iv_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VodActivity.this.release();
                VodActivity.this.finish();
            }
        });
        this.btnDocList.setOnClickListener((View.OnClickListener)this);
        this.chapterListAdapter = new ChapterListAdapter();
        this.chapterList = new ArrayList<ChapterInfo>();
        this.lvChapterList = (ListView)this.findViewById(R.id.doc_lv);
        this.lvChapterList.setAdapter((ListAdapter)this.chapterListAdapter);
        this.lvChapterList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                ChapterInfo chapterInfo = (ChapterInfo)VodActivity.this.chapterList.get(position);
                if (null != VodActivity.this.mGSOLPlayer) {
                    VodActivity.this.mGSOLPlayer.seekTo(chapterInfo.getPageTimeStamp());
                }
            }
        });
        this.mSeekBarPlayViedo.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.mDocView.setOnDocViewClickedListener((OnDocViewEventListener)this);
        this.stopVeidoPlay.setOnClickListener((View.OnClickListener)this);
        this.replyVedioPlay.setOnClickListener((View.OnClickListener)this);
        this.ivPlay.setOnClickListener((View.OnClickListener)this);
        this.initPlayer();
        this.myHandler.sendEmptyMessageDelayed(12, 5000L);
    }

    private void initPlayer() {
        String vodIdOrLocalPath = this.getVodIdOrLocalPath();
        if (vodIdOrLocalPath == null) {
            Toast.makeText((Context)this, (CharSequence)"\u8def\u5f84\u4e0d\u5bf9", (int)0).show();
            return;
        }
        if (this.mGSOLPlayer == null) {
            this.mGSOLPlayer = new VODPlayer();
            this.mGSOLPlayer.setGSVideoView((IVideoIndication)this.mGSVideoView);
            this.mGSOLPlayer.setGSDocViewGx(this.mDocView);
            this.mGSOLPlayer.play(vodIdOrLocalPath, (GSOLPlayer.OnOLPlayListener)this, "", false);
        }
        this.mGSVideoView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0) {
                    if (VodActivity.this.mControllerStatus == VodActivity.this.HIDE) {
                        VodActivity.this.myHandler.sendEmptyMessage(11);
                    } else if (VodActivity.this.mControllerStatus == VodActivity.this.SHOW) {
                        VodActivity.this.myHandler.sendEmptyMessage(12);
                    }
                }
                return false;
            }
        });
        this.llToolbar.setVisibility(0);
    }

    private String getVodIdOrLocalPath() {
        String vodId = this.getIntent().getStringExtra("play_param");
        String localpath = this.getIntent().getStringExtra("play_path");
        String vodIdOrLocalPath = null;
        if (!StringUtil.isEmpty((String)localpath)) {
            vodIdOrLocalPath = localpath;
        } else if (!StringUtil.isEmpty((String)vodId)) {
            vodIdOrLocalPath = vodId;
        }
        return vodIdOrLocalPath;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.stopveidoplay) {
            boolean ret = this.mGSOLPlayer.stop();
            this.mSeekBarPlayViedo.setMax(0);
            if (ret) {
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"\u64ad\u653e\u6b63\u5e38\u505c\u6b62", (int)0).show();
            } else {
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"\u64ad\u653e\u975e\u6b63\u5e38\u505c\u6b62", (int)0).show();
            }
            Toast.makeText((Context)this, (CharSequence)(ret ? "\u64cd\u4f5c\u6210\u529f" : "\u64cd\u4f5c\u5931\u8d25"), (int)0).show();
        } else if (v.getId() == R.id.replayvedioplay) {
            this.isTouch = false;
            String vodIdOrLocalPath = this.getVodIdOrLocalPath();
            if (vodIdOrLocalPath == null) {
                Toast.makeText((Context)this, (CharSequence)"\u8def\u5f84\u4e0d\u5bf9", (int)0).show();
                return;
            }
            this.mGSOLPlayer.play(vodIdOrLocalPath, (GSOLPlayer.OnOLPlayListener)this, "", false);
        } else if (v.getId() == R.id.iv_play) {
            if (this.VIEDOPAUSEPALY == 0) {
                this.mGSOLPlayer.pause();
                this.ivPlay.setImageDrawable(this.getResources().getDrawable(R.drawable.play));
            } else if (this.VIEDOPAUSEPALY == 1) {
                this.mGSOLPlayer.resume();
                this.ivPlay.setImageDrawable(this.getResources().getDrawable(R.drawable.pause));
            } else if (this.VIEDOPAUSEPALY == 2) {
                this.ivPlay.setImageDrawable(this.getResources().getDrawable(R.drawable.pause));
                this.replyVedioPlay.performClick();
            }
        } else if (v.getId() == R.id.doc_list_btn) {
            if (this.lvChapterList.getVisibility() == 0) {
                this.lvChapterList.setVisibility(8);
            } else {
                this.lvChapterList.setVisibility(0);
            }
        }
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.isTouch = true;
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        if (null != this.mGSOLPlayer) {
            int pos = seekBar.getProgress();
            this.mGSOLPlayer.seekTo(pos);
        }
    }

    public boolean onDoubleClicked(IGSDocView igsDocView) {
        return false;
    }

    public boolean onSingleClicked(IGSDocView igsDocView) {
        return false;
    }

    public boolean onEndHDirection(IGSDocView igsDocView, int i, int i1) {
        return false;
    }

    public void onInit(int result, boolean haveVideo, int duration, List<DocInfo> docInfos) {
        Message message = new Message();
        message.what = 1;
        message.obj = docInfos;
        Bundle bundle = new Bundle();
        bundle.putInt(DURATION, duration);
        message.setData(bundle);
        this.myHandler.sendMessage(message);
    }

    public void onPlayStop() {
        this.myHandler.sendMessage(this.myHandler.obtainMessage(2, (Object)0));
    }

    public void onPlayPause() {
        this.myHandler.sendMessage(this.myHandler.obtainMessage(9, (Object)0));
    }

    public void onPlayResume() {
        this.myHandler.sendMessage(this.myHandler.obtainMessage(10, (Object)0));
    }

    public void onPosition(int position) {
        this.myHandler.sendMessage(this.myHandler.obtainMessage(3, (Object)position));
    }

    public void onVideoSize(int position, int videoWidth, int videoHeight) {
        this.myHandler.sendMessage(this.myHandler.obtainMessage(4, (Object)0));
    }

    public void onPageSize(int position, int i1, int i2) {
        this.myHandler.sendMessage(this.myHandler.obtainMessage(5, (Object)position));
    }

    public void onSeek(int position) {
        this.myHandler.sendMessage(this.myHandler.obtainMessage(6, (Object)position));
    }

    public void onAudioLevel(int level) {
        this.myHandler.sendMessage(this.myHandler.obtainMessage(7, (Object)level));
    }

    public void onCaching(boolean b) {
    }

    public void onVideoStart() {
    }

    public void onChat(List<ChatMsg> list) {
    }

    public void onDocInfo(List<DocInfo> list) {
    }

    public void onChatCensor(String s, String s1) {
    }

    public void onError(int errCode) {
        this.myHandler.sendMessage(this.myHandler.obtainMessage(8, (Object)errCode));
    }

    private void stopPlay() {
        if (this.mGSOLPlayer != null) {
            this.mGSOLPlayer.stop();
        }
    }

    private void release() {
        this.stopPlay();
        if (this.mGSOLPlayer != null) {
            this.mGSOLPlayer.release();
        }
    }

    public void onBackPressed() {
        this.release();
        super.onBackPressed();
    }

    private String getTime(int time) {
        return String.format("%02d", time / 3600) + ":" + String.format("%02d", time % 3600 / 60) + ":" + String.format("%02d", time % 3600 % 60);
    }

    private class ChapterListAdapter
    extends BaseAdapter {
        private List<ChapterInfo> pageList = new ArrayList<ChapterInfo>();
        private int selectedPosition = 0;

        public void setSelectedPosition(int position) {
            this.selectedPosition = position;
            this.notifyDataSetChanged();
            VodActivity.this.lvChapterList.setSelection(position);
        }

        public void notifyData(List<ChapterInfo> pageList) {
            this.pageList.clear();
            this.pageList.addAll(pageList);
            this.notifyDataSetChanged();
        }

        public int getCount() {
            return this.pageList.size();
        }

        public Object getItem(int position) {
            return this.pageList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder = null;
            if (null == convertView) {
                convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.doc_list_item_ly, null);
                viewHolder = new ViewHolder(convertView);
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag();
            }
            viewHolder.init((ChapterInfo)this.getItem(position), position);
            return convertView;
        }

        private class ViewHolder {
            private TextView tvChapter;
            private TextView tvTitle;
            private TextView tvTime;
            private LinearLayout lyChapter;

            private String getChapterTime(long time) {
                return String.format("%02d", time / 3600000L) + ":" + String.format("%02d", time % 3600000L / 60000L) + ":" + String.format("%02d", time % 3600000L % 60000L / 1000L);
            }

            public ViewHolder(View view) {
                this.tvChapter = (TextView)view.findViewById(R.id.chapter_title);
                this.tvTitle = (TextView)view.findViewById(R.id.doc_title);
                this.tvTime = (TextView)view.findViewById(R.id.chapter_time);
                this.lyChapter = (LinearLayout)view.findViewById(R.id.chapter_ly);
            }

            public void init(ChapterInfo chapterInfo, int position) {
                this.tvChapter.setText((CharSequence)chapterInfo.getPageTitle());
                this.tvTime.setText((CharSequence)this.getChapterTime(chapterInfo.getPageTimeStamp()));
                this.tvTitle.setText((CharSequence)chapterInfo.getDocName());
                if (ChapterListAdapter.this.selectedPosition == position) {
                    this.lyChapter.setBackgroundResource(R.color.red);
                } else {
                    this.lyChapter.setBackgroundResource(R.color.transparent);
                }
            }
        }
    }

    static interface MSG {
        public static final int MSG_ON_INIT = 1;
        public static final int MSG_ON_STOP = 2;
        public static final int MSG_ON_POSITION = 3;
        public static final int MSG_ON_VIDEOSIZE = 4;
        public static final int MSG_ON_PAGE = 5;
        public static final int MSG_ON_SEEK = 6;
        public static final int MSG_ON_AUDIOLEVEL = 7;
        public static final int MSG_ON_ERROR = 8;
        public static final int MSG_ON_PAUSE = 9;
        public static final int MSG_ON_RESUME = 10;
        public static final int SHOW_CONTROLLER = 11;
        public static final int FADE_OUT = 12;
    }
}

