/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.chat.gif;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.ImageSpan;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpanResource {
    private static final String RICH_BROW = "<IMG src=\"emotion\\%s\" custom=\"false\">";
    public static String matchString;
    private static Map<String, Drawable> uiMap;
    private static Map<String, Integer> browMap;
    private static Map<String, String> richSendMap;
    private static Map<String, String> textMap;
    private static Map<String, Drawable> gifMap;
    private static List<String> textTipList;
    public static final int CONTEXT_MAX = 512;
    public static final int CONTEXT_AVATAR_MAX = 20;
    private static Html.ImageGetter extraImageGetter;

    public static void setExtraImageGetter(Html.ImageGetter extraImageGetter) {
        SpanResource.extraImageGetter = extraImageGetter;
    }

    public static Map<String, Drawable> getBrowMap(Context context) {
        return uiMap;
    }

    public static void initTextTipList(List<String> textList) {
        if (null == textTipList) {
            textTipList = new ArrayList<String>();
        }
        textTipList.clear();
        textTipList.addAll(textList);
    }

    public static void initTextMap(HashMap<String, String> mapValue) {
        if (null == textMap) {
            textMap = new HashMap<String, String>(18);
        }
        textMap.clear();
        textMap.putAll(mapValue);
    }

    public static void initUiMap(HashMap<String, Drawable> mapValue) {
        if (null == uiMap) {
            uiMap = new LinkedHashMap<String, Drawable>(18);
        }
        uiMap.clear();
        uiMap.putAll(mapValue);
    }

    public static void initBrowSource(LinkedHashMap<String, Integer> mapValue) {
        if (browMap == null) {
            browMap = new LinkedHashMap<String, Integer>(18);
        }
        browMap.clear();
        browMap.putAll(mapValue);
    }

    public static void putGifDrawable(String key, Drawable gifDrawable) {
        if (gifMap == null) {
            gifMap = new HashMap<String, Drawable>(18);
        }
        gifMap.put(key, gifDrawable);
    }

    public static void initSendRichMap(HashMap<String, String> mapValue) {
        if (matchString == null) {
            matchString = SpanResource.initMachString(uiMap.keySet());
            matchString = matchString.substring(0, matchString.length() - 1);
        }
        if (richSendMap == null) {
            richSendMap = new HashMap<String, String>(18);
        }
        richSendMap.clear();
        richSendMap.putAll(mapValue);
    }

    private static synchronized String initMachString(Set<String> keyset) {
        StringBuilder sb = new StringBuilder();
        for (String key : keyset) {
            sb.append(key).append('|');
        }
        return sb.toString();
    }

    public static Spannable convetToSpan(String content, Context context) {
        StringBuilder sb = new StringBuilder();
        String strContent = sb.append(' ').append(content).toString();
        strContent = content;
        SpannableStringBuilder spBuilder = new SpannableStringBuilder((CharSequence)strContent);
        if (null == uiMap || uiMap.size() <= 0) {
            return spBuilder;
        }
        Pattern mPattern = Pattern.compile(matchString);
        Matcher matcher = mPattern.matcher(strContent);
        while (matcher.find()) {
            Drawable drawable = uiMap.get(matcher.group());
            drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
            ImageSpan ispan = new ImageSpan(drawable, 0);
            spBuilder.setSpan((Object)ispan, matcher.start(), matcher.end(), 33);
        }
        return spBuilder;
    }

    public static int[] getAvatarCount(String content) {
        int[] nCount = new int[3];
        if (null != matchString) {
            StringBuilder sb = new StringBuilder();
            String strContent = sb.append(' ').append(content).toString();
            strContent = content;
            Pattern mPattern = Pattern.compile(matchString);
            Matcher matcher = mPattern.matcher(strContent);
            while (matcher.find()) {
                nCount[0] = nCount[0] + 1;
                nCount[1] = nCount[1] + matcher.group().length();
                nCount[2] = matcher.group().length();
            }
        }
        return nCount;
    }

    public static Spanned convetRichToExpression(Context context, String rich, final Vector<Drawable> drawables) {
        if (null == uiMap || uiMap.size() <= 0) {
            SpannableStringBuilder spBuilder = new SpannableStringBuilder((CharSequence)rich);
            return spBuilder;
        }
        return Html.fromHtml((String)rich, (Html.ImageGetter)new Html.ImageGetter(){

            public Drawable getDrawable(String source) {
                if (null == source) {
                    return null;
                }
                int index = source.lastIndexOf("\\");
                String lastStr = source.substring(index + 1);
                String keyStr = "\u3010" + lastStr + "\u3011";
                Drawable mSmile = null;
                if (source.endsWith(".gif")) {
                    if (gifMap != null) {
                        mSmile = (Drawable)gifMap.get(keyStr);
                        if (null != drawables && mSmile != null && !drawables.contains(mSmile)) {
                            drawables.add(mSmile);
                        }
                    } else {
                        SpanResource.log("convetRichToExpression", "gifMap is null, that expression un install");
                    }
                } else if (uiMap != null) {
                    mSmile = (Drawable)uiMap.get(keyStr);
                } else {
                    SpanResource.log("convetRichToExpression", "uiMap is null, that expression un install");
                }
                if (mSmile == null && extraImageGetter != null) {
                    mSmile = extraImageGetter.getDrawable(source);
                }
                return mSmile;
            }
        }, null);
    }

    public static String convertToSendText(String content) {
        if (null == textMap || textMap.size() <= 0) {
            return content;
        }
        Pattern mPattern = Pattern.compile(matchString);
        Matcher matcher = mPattern.matcher(content);
        while (matcher.find()) {
            content = content.replace(matcher.group(), textMap.get(matcher.group()));
        }
        return content;
    }

    public static String convertToSendRichText(String content) {
        if (null == richSendMap || richSendMap.size() <= 0) {
            return content;
        }
        content = SpanResource.escapeStr(content);
        Pattern mPattern = Pattern.compile(matchString);
        Matcher matcher = mPattern.matcher(content);
        while (matcher.find()) {
            if (null != textTipList && textTipList.contains(matcher.group()) && !content.contains(matcher.group() + textMap.get(matcher.group()))) {
                content = content.replace(matcher.group(), String.format(RICH_BROW, richSendMap.get(matcher.group())) + textMap.get(matcher.group()));
                continue;
            }
            content = content.replace(matcher.group(), String.format(RICH_BROW, richSendMap.get(matcher.group())));
        }
        StringBuilder sReturn = new StringBuilder();
        sReturn.append("<SPAN>");
        sReturn.append(content);
        sReturn.append("</SPAN>");
        return sReturn.toString();
    }

    private static String escapeStr(String content) {
        String sReturn = content;
        if (sReturn.contains("&")) {
            sReturn = sReturn.replace("&", "&amp;");
        }
        if (sReturn.contains("<")) {
            sReturn = sReturn.replace("<", "&lt;");
        }
        if (sReturn.contains(">")) {
            sReturn = sReturn.replace(">", "&gt;");
        }
        if (sReturn.contains(" ")) {
            sReturn = sReturn.replace(" ", "&nbsp;");
        }
        if (content.contains("\n")) {
            sReturn = sReturn.replace("\n", "<br>");
        }
        return sReturn;
    }

    private static void log(String func, String msg) {
        Log.w((String)"Gensee", (String)(func + " > " + msg));
    }

    static {
        extraImageGetter = null;
    }
}

