/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.text.InputFilter;
import android.text.Spanned;
import android.util.AttributeSet;
import android.widget.EditText;
import com.gensee.chat.gif.SpanResource;

public class ChatEditText
extends EditText {
    public ChatEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public ChatEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ChatEditText(Context context) {
        super(context);
        this.init();
    }

    public void insertAvatar(String avatar, int resId) {
        this.getText().insert(this.getSelectionStart(), (CharSequence)SpanResource.convetToSpan(avatar.toString(), this.getContext()));
    }

    private void init() {
        this.setFilters(new InputFilter[]{new InputFilter(){

            public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
                int[] nAvatarCountOld = SpanResource.getAvatarCount(dest.toString());
                int totalCountOld = dest.toString().length() - nAvatarCountOld[1] + nAvatarCountOld[0];
                int[] nAvatarCountNew = SpanResource.getAvatarCount(source.toString());
                int totalCountNew = source.toString().length() - nAvatarCountNew[1] + nAvatarCountNew[0];
                int totalAvatarCount = nAvatarCountOld[0] + nAvatarCountNew[0];
                int totalCount = totalCountOld + totalCountNew;
                if (totalAvatarCount > 20 || totalCount > 512) {
                    return "";
                }
                return source;
            }
        }});
    }

    public String getChatText() {
        String text = this.getText().toString();
        if ("".equals(text)) {
            return "";
        }
        return SpanResource.convertToSendText(text);
    }

    public String getRichText() {
        String text = this.getText().toString();
        if ("".equals(text)) {
            return "";
        }
        return SpanResource.convertToSendRichText(text);
    }
}

