/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Spanned;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.TextView;
import com.gensee.chat.gif.GifDrawalbe;
import com.gensee.chat.gif.SpanResource;
import java.util.Vector;

public class MyTextViewEx
extends TextView
implements GifDrawalbe.UpdateUIListen {
    private Vector<Drawable> drawables = new Vector();
    private static final String SPAN_LOWER_START = "<span>";
    private static final String SPAN_LOWER_END = "</span>";
    private static final String SPAN_UPER_START = "<SPAN>";
    private static final String SPAN_UPER_END = "</SPAN>";

    public MyTextViewEx(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public MyTextViewEx(Context context, AttributeSet attr) {
        this(context, attr, 0);
    }

    public MyTextViewEx(Context context) {
        this(context, null);
    }

    public void setRichText(String richText) {
        this.insertGif(richText);
    }

    public void setChatContent(String text, String richText) {
        if (text == null && richText == null) {
            return;
        }
        if (richText == null) {
            this.setChatText(text);
            return;
        }
        if (richText.equals(text)) {
            this.setChatText(text);
        } else {
            this.setRichText(richText);
        }
    }

    private void setChatText(String text) {
        String string = text = text == null ? "" : text;
        if (text.startsWith(SPAN_LOWER_START) && text.endsWith(SPAN_LOWER_END) || text.startsWith(SPAN_UPER_START) && text.endsWith(SPAN_UPER_END)) {
            text = text.substring(SPAN_LOWER_START.length(), text.length() - SPAN_LOWER_END.length());
        }
        this.setText(text);
    }

    private void insertGif(String str) {
        if (str == null) {
            Log.w((String)"Gensee", (String)"MyTextViewEx insertGif chat message is null");
            return;
        }
        if (null == this.drawables) {
            this.drawables = new Vector();
        }
        Spanned spannableString = SpanResource.convetRichToExpression(this.getContext(), str, this.drawables);
        this.setText((CharSequence)spannableString);
        for (Drawable gifDrawable : this.drawables) {
            if (!(gifDrawable instanceof GifDrawalbe)) break;
            ((GifDrawalbe)gifDrawable).addListen(this);
            ((GifDrawalbe)gifDrawable).readFrames(true);
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == 8 && null != this.drawables) {
            for (Drawable gifDrawable : this.drawables) {
                if (!(gifDrawable instanceof GifDrawalbe)) break;
                ((GifDrawalbe)gifDrawable).removeListen(this);
            }
            this.destroy();
        }
    }

    private void destroy() {
        this.drawables.clear();
        this.drawables = null;
    }

    @Override
    public void updateUI() {
        this.invalidate();
    }
}

