/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.WindowManager;
import android.widget.TextView;

public class AutoScrollTextView
extends TextView {
    private float textLength = 0.0f;
    private float tx = 0.0f;
    private float ty = 0.0f;
    private Paint paint = null;
    private String text = "";
    private boolean bLeft = false;

    public AutoScrollTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void initScrollTextView(WindowManager windowManager, String text) {
        this.paint = this.getPaint();
        this.text = text;
        this.textLength = this.paint.measureText(text);
        this.ty = this.getTextSize() + (float)this.getPaddingTop();
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawText(this.text, this.tx, this.ty, this.paint);
        int moveLength = (int)(this.textLength - (float)this.getWidth());
        if (moveLength > 0) {
            if (!this.bLeft) {
                this.tx = (float)((double)this.tx - 0.6);
                if (Math.abs(this.tx) >= (float)moveLength) {
                    this.bLeft = true;
                }
            } else {
                this.tx = (float)((double)this.tx + 0.6);
                if (this.tx >= 0.0f) {
                    this.bLeft = false;
                }
            }
            this.invalidate();
        }
        super.onDraw(canvas);
    }
}

