/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.AbsListView;
import android.widget.PopupWindow;
import com.gensee.view.xlistview.XListView;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BaseLvView
extends Handler
implements XListView.IXListViewListener,
AbsListView.OnScrollListener {
    public static final int NOTIFY_DATA = 500;
    public static final String LATEST = "LATEST";
    protected String TAG = this.getClass().getSimpleName();
    protected XListView lvChat;
    private AtomicBoolean bLvBottom;
    protected boolean bRefreshing = false;
    private AtomicBoolean bLvIdle = new AtomicBoolean(true);
    private PopupWindow popupWindow;

    protected void initView(View view) {
        this.lvChat = (XListView)view.findViewById(this.getLvId());
        this.lvChat.setXListViewListener(this);
        this.lvChat.setOnScrollListener(this);
        this.lvChat.setPullLoadEnable(false);
        this.lvChat.setHeaderDividersEnabled(false);
        this.lvChat.setFooterDividersEnabled(false);
        this.bLvBottom = new AtomicBoolean(true);
    }

    public void sendMessage(int what, Object object) {
        this.sendMessage(this.obtainMessage(what, object));
    }

    public final void handleMessage(Message msg) {
        this.onMessage(msg.what, msg.obj, msg.getData());
    }

    public void onMessage(int what, Object object, Bundle bundle) {
    }

    public void updateXListViewUi(boolean bLatest) {
        if (!bLatest) {
            this.lvChat.addFootView();
            this.lvChat.setPullLoadEnable(true);
        } else {
            this.unEnableFootView();
        }
    }

    private void unEnableFootView() {
        this.lvChat.removeFootView();
        this.lvChat.setPullLoadEnable(false);
    }

    public void onLvReLoad() {
        this.lvChat.stopRefresh();
        this.onRefreshTime();
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.lvChat.getLastVisiblePosition() == this.lvChat.getCount() - 1) {
            this.bLvBottom.set(true);
            this.onScrollToBottom(true);
        } else {
            this.bLvBottom.set(false);
            this.onScrollToBottom(false);
        }
        switch (scrollState) {
            case 0: {
                this.bLvIdle.set(true);
                break;
            }
            case 1: {
                this.bLvBottom.set(false);
                this.onScrollToBottom(false);
                break;
            }
            case 2: {
                this.bLvBottom.set(false);
                this.onScrollToBottom(false);
            }
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (!this.bLvIdle.get()) {
            if (firstVisibleItem + visibleItemCount == totalItemCount) {
                this.bLvBottom.set(true);
                this.onScrollToBottom(true);
            } else {
                this.bLvBottom.set(false);
                this.onScrollToBottom(false);
            }
        }
    }

    protected void onRefreshTime() {
        this.lvChat.setRefreshTime(BaseLvView.getStringDate());
    }

    public static String getStringDate() {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
        String dateString = formatter.format(currentTime);
        return dateString;
    }

    public boolean getLvBottom() {
        return this.bLvBottom.get();
    }

    protected void setLvBottom(boolean bTrue) {
        this.bLvBottom.set(bTrue);
        this.onScrollToBottom(bTrue);
    }

    @Override
    public void onRefresh() {
        if (this.bRefreshing) {
            this.onLvReLoad();
            return;
        }
        this.bRefreshing = true;
        this.refresh();
    }

    @Override
    public void onLoadMore() {
        if (this.bRefreshing) {
            this.lvChat.stopLoadMore();
            return;
        }
        this.bRefreshing = true;
        this.loadMore();
    }

    protected abstract void refresh();

    protected abstract void loadMore();

    protected abstract int getLvId();

    public String replaceGifToText(String richText) {
        if (richText.startsWith("<SPAN>") && richText.endsWith("</SPAN>")) {
            richText = richText.substring(6, richText.length() - 7);
        }
        String startStr = "<IMG src=";
        String endStr = "custom=\"false\">";
        if (richText.indexOf(startStr) != -1) {
            String leftPart = richText.substring(0, richText.indexOf(startStr));
            String rightPart = richText.substring(richText.indexOf(endStr) + endStr.length(), richText.length());
            richText = leftPart + " [Emoji] " + rightPart;
            richText = this.replaceGifToText(richText);
        }
        return richText;
    }

    protected void onScrollToBottom(boolean bScroolBottom) {
    }
}

