/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view.xlistview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.Scroller;
import android.widget.TextView;
import com.gensee.utils.GenseeLog;
import com.gensee.view.xlistview.XListViewFooter;
import com.gensee.view.xlistview.XListViewHeader;

public abstract class XListView
extends ListView
implements AbsListView.OnScrollListener {
    private float mLastY = -1.0f;
    private Scroller mScroller;
    private AbsListView.OnScrollListener mScrollListener;
    private IXListViewListener mListViewListener;
    private XListViewHeader mHeaderView;
    private RelativeLayout mHeaderViewContent;
    private TextView mHeaderTimeView;
    private int mHeaderViewHeight;
    private boolean mEnablePullRefresh = true;
    private boolean mPullRefreshing = false;
    private XListViewFooter mFooterView;
    private boolean mEnablePullLoad;
    private boolean mPullLoading;
    private boolean mIsFooterReady = false;
    private int mTotalItemCount;
    private int mScrollBack;
    private static final int SCROLLBACK_HEADER = 0;
    private static final int SCROLLBACK_FOOTER = 1;
    private static final int SCROLL_DURATION = 400;
    private static final int PULL_LOAD_MORE_DELTA = 50;
    private static final float OFFSET_RADIO = 1.8f;

    public XListView(Context context) {
        super(context);
        this.initWithContext(context);
    }

    public XListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initWithContext(context);
    }

    public XListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initWithContext(context);
    }

    private void initWithContext(Context context) {
        this.mScroller = new Scroller(context, (Interpolator)new DecelerateInterpolator());
        super.setOnScrollListener((AbsListView.OnScrollListener)this);
        this.mHeaderView = this.getHeaderView(context);
        this.mHeaderViewContent = (RelativeLayout)this.mHeaderView.findViewById(this.getHeadContentTvId());
        this.mHeaderTimeView = (TextView)this.mHeaderView.findViewById(this.getHeadTimeTvId());
        this.addHeaderView((View)this.mHeaderView);
        this.mFooterView = this.getFooterView(context);
        this.mHeaderView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                XListView.this.mHeaderViewHeight = XListView.this.mHeaderViewContent.getHeight();
                XListView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    public void setAdapter(ListAdapter adapter) {
        super.setAdapter(adapter);
    }

    public void addFootView() {
        if (this.getFooterViewsCount() >= 1) {
            return;
        }
        if (null != this.mFooterView) {
            this.addFooterView((View)this.mFooterView);
        }
    }

    public void removeFootView() {
        if (this.getFooterViewsCount() <= 0) {
            return;
        }
        if (null != this.mFooterView) {
            this.removeFooterView((View)this.mFooterView);
        }
    }

    public void setPullRefreshEnable(boolean enable) {
        this.mEnablePullRefresh = enable;
        if (!this.mEnablePullRefresh) {
            this.mHeaderViewContent.setVisibility(4);
        } else {
            this.mHeaderViewContent.setVisibility(0);
        }
    }

    public void setPullLoadEnable(boolean enable) {
        this.mEnablePullLoad = enable;
        if (!this.mEnablePullLoad) {
            this.mFooterView.hide();
            this.mFooterView.setOnClickListener(null);
        } else {
            this.mPullLoading = false;
            this.mFooterView.show();
            this.mFooterView.setState(0);
            this.mFooterView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XListView.this.startLoadMore();
                }
            });
        }
    }

    public void stopRefresh() {
        if (this.mPullRefreshing) {
            this.mPullRefreshing = false;
            this.resetHeaderHeight();
        }
    }

    public void stopLoadMore() {
        if (this.mPullLoading) {
            this.mPullLoading = false;
            this.mFooterView.setState(0);
        }
    }

    public void setRefreshTime(String time) {
        this.mHeaderTimeView.setText((CharSequence)time);
    }

    private void invokeOnScrolling() {
        if (this.mScrollListener instanceof OnXScrollListener) {
            OnXScrollListener l = (OnXScrollListener)this.mScrollListener;
            l.onXScrolling((View)this);
        }
    }

    private void updateHeaderHeight(float delta) {
        this.mHeaderView.setVisiableHeight((int)delta + this.mHeaderView.getVisiableHeight());
        if (this.mEnablePullRefresh && !this.mPullRefreshing) {
            if (this.mHeaderView.getVisiableHeight() > this.mHeaderViewHeight) {
                this.mHeaderView.setState(1);
            } else {
                this.mHeaderView.setState(0);
            }
        }
        this.setSelection(0);
    }

    private void resetHeaderHeight() {
        int height = this.mHeaderView.getVisiableHeight();
        if (height == 0) {
            return;
        }
        if (this.mPullRefreshing && height <= this.mHeaderViewHeight) {
            return;
        }
        int finalHeight = 0;
        if (this.mPullRefreshing && height > this.mHeaderViewHeight) {
            finalHeight = this.mHeaderViewHeight;
        }
        this.mScrollBack = 0;
        this.mScroller.startScroll(0, height, 0, finalHeight - height, 400);
        this.invalidate();
    }

    private void updateFooterHeight(float delta) {
        int height = this.mFooterView.getBottomMargin() + (int)delta;
        if (this.mEnablePullLoad && !this.mPullLoading) {
            if (height > 50) {
                this.mFooterView.setState(1);
            } else {
                this.mFooterView.setState(0);
            }
        }
        this.mFooterView.setBottomMargin(height);
    }

    private void resetFooterHeight() {
        int bottomMargin = this.mFooterView.getBottomMargin();
        if (bottomMargin > 0) {
            this.mScrollBack = 1;
            this.mScroller.startScroll(0, bottomMargin, 0, -bottomMargin, 400);
            this.invalidate();
        }
    }

    private void startLoadMore() {
        this.mPullLoading = true;
        if (null != this.mFooterView) {
            this.mFooterView.setState(2);
        }
        if (this.mListViewListener != null) {
            this.mListViewListener.onLoadMore();
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mLastY == -1.0f) {
            this.mLastY = ev.getRawY();
        }
        switch (ev.getAction()) {
            case 0: {
                int position = this.pointToPosition((int)ev.getX(), (int)ev.getY());
                GenseeLog.d((String)("GSChatView onTouchEvent ACTION_DOWN position = " + position + " footviewsize = " + this.getFooterViewsCount() + " headerviewsize = " + this.getHeaderViewsCount() + " adapter.count = " + (this.getAdapter() != null ? this.getAdapter().getCount() : -1) + " chilCount = " + this.getChildCount() + " count = " + this.getCount()));
                this.mLastY = ev.getRawY();
                break;
            }
            case 2: {
                float deltaY = ev.getRawY() - this.mLastY;
                this.mLastY = ev.getRawY();
                if (this.getFirstVisiblePosition() == 0 && (this.mHeaderView.getVisiableHeight() > 0 || deltaY > 0.0f)) {
                    this.updateHeaderHeight(deltaY / 1.8f);
                    this.invokeOnScrolling();
                    break;
                }
                if (this.getLastVisiblePosition() != this.mTotalItemCount - 1 || this.mFooterView.getBottomMargin() <= 0 && !(deltaY < 0.0f)) break;
                this.updateFooterHeight(-deltaY / 1.8f);
                break;
            }
            default: {
                this.mLastY = -1.0f;
                if (this.getFirstVisiblePosition() == 0) {
                    if (this.mEnablePullRefresh && this.mHeaderView.getVisiableHeight() > this.mHeaderViewHeight) {
                        this.mPullRefreshing = true;
                        this.mHeaderView.setState(2);
                        if (this.mListViewListener != null) {
                            this.mListViewListener.onRefresh();
                        }
                    }
                    this.resetHeaderHeight();
                    break;
                }
                if (this.getLastVisiblePosition() != this.mTotalItemCount - 1) break;
                if (this.mEnablePullLoad && this.mFooterView.getBottomMargin() > 50 && !this.mPullLoading) {
                    this.startLoadMore();
                }
                this.resetFooterHeight();
            }
        }
        boolean result = false;
        try {
            result = super.onTouchEvent(ev);
        }
        catch (Exception e) {
            GenseeLog.w((String)"XListView", (Throwable)e);
        }
        return result;
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            if (this.mScrollBack == 0) {
                this.mHeaderView.setVisiableHeight(this.mScroller.getCurrY());
            } else {
                this.mFooterView.setBottomMargin(this.mScroller.getCurrY());
            }
            this.postInvalidate();
            this.invokeOnScrolling();
        }
        super.computeScroll();
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        this.mScrollListener = l;
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (this.mScrollListener != null) {
            this.mScrollListener.onScrollStateChanged(view, scrollState);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        this.mTotalItemCount = totalItemCount;
        if (this.mScrollListener != null) {
            this.mScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
        }
    }

    public void setXListViewListener(IXListViewListener l) {
        this.mListViewListener = l;
    }

    protected abstract int getHeadContentTvId();

    protected abstract int getHeadTimeTvId();

    protected abstract XListViewFooter getFooterView(Context var1);

    protected abstract XListViewHeader getHeaderView(Context var1);

    public static interface IXListViewListener {
        public void onRefresh();

        public void onLoadMore();
    }

    public static interface OnXScrollListener
    extends AbsListView.OnScrollListener {
        public void onXScrolling(View var1);
    }
}

