/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.beauty;

import android.graphics.Bitmap;
import com.gensee.beauty.GPUImageRenderer;
import com.gensee.beauty.PixelBuffer;
import com.gensee.beauty.filter.FilterSetting;
import com.gensee.beauty.filter.utils.Rotation;
import com.gensee.convert.VideoCoreLibrary;
import com.gensee.utils.GenseeLog;
import com.gensee.videoparam.VideoParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GPUFilterDataRead
implements GPUImageRenderer.OnDataPrepareListener,
Runnable {
    private static final String TAG = "GPUFilterDataRead";
    private Object object = new Object();
    private Thread sendThread;
    private boolean bSendFlag = true;
    private List<FileterYuvData> dataList = new ArrayList<FileterYuvData>();
    private List<FileterYuvData> recoverDataList = new ArrayList<FileterYuvData>();
    private GPUImageRenderer mGpuImageRenderer;
    private PixelBuffer pixelBuffer;
    private FilterSetting mFilterSetting;
    private int width;
    private int height;
    private Rotation rotation;
    private boolean flipVertical;
    private boolean flipHorizontal;
    private int realWidth;
    private int realHeigth;
    private OnPrepareDataSendListener mOnPrepareDataSendListener;
    private int orientation;
    private Thread mConvertThread;
    private List<RGBData> rgbDataList = new ArrayList<RGBData>();
    private List<RGBData> rgbRecoverDataList = new ArrayList<RGBData>();
    private Object rgbObject = new Object();
    private boolean bConvert = false;
    byte[] yv12;
    private final int RECOVER_SIZE = 5;
    private final int DATA_SIZE = 2;
    private VideoParam videoParam;
    private GPUImageRenderer.ScaleType mScaleType = GPUImageRenderer.ScaleType.CENTER_CROP;
    private Runnable mConvertRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (GPUFilterDataRead.this.bConvert) {
                RGBData data = null;
                Object object = GPUFilterDataRead.this.rgbObject;
                synchronized (object) {
                    if (GPUFilterDataRead.this.rgbDataList.size() <= 0) {
                        try {
                            GPUFilterDataRead.this.rgbObject.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } else {
                        data = (RGBData)GPUFilterDataRead.this.rgbDataList.remove(0);
                    }
                }
                if (data == null) continue;
                int mHeight = data.height;
                int mWidth = data.width;
                if (null == GPUFilterDataRead.this.yv12 || GPUFilterDataRead.this.yv12.length != mWidth * mHeight * 3 / 2) {
                    GPUFilterDataRead.this.yv12 = new byte[mWidth * mHeight * 3 / 2];
                }
                VideoCoreLibrary.RGBAtoYV12(data.rgb, mWidth, mHeight, GPUFilterDataRead.this.yv12);
                GPUFilterDataRead.this.addRecoverDataRgb(data);
                if (null == GPUFilterDataRead.this.mOnPrepareDataSendListener) continue;
                GPUFilterDataRead.this.mOnPrepareDataSendListener.onSendData(GPUFilterDataRead.this.yv12, mWidth, mHeight);
            }
        }
    };
    private FileOutputStream streamYuv2 = null;

    public void setOnPrepareDataSendListener(OnPrepareDataSendListener mOnPrepareDataSendListener) {
        this.mOnPrepareDataSendListener = mOnPrepareDataSendListener;
    }

    public GPUFilterDataRead() {
        this.mFilterSetting = new FilterSetting();
        this.mGpuImageRenderer = new GPUImageRenderer(this.mFilterSetting.getFilter());
        this.mFilterSetting.setRenderer(this.mGpuImageRenderer);
    }

    public void setVideoDataPng(Bitmap mBitmap) {
        this.mFilterSetting.setVideoDataPng(mBitmap);
        if (this.realWidth > 0 && this.realHeigth > 0) {
            this.mFilterSetting.resolveVideoDataPng(this.realWidth, this.realHeigth);
        }
    }

    public void setVideoDataPng(Bitmap mBitmap, int desVideologoMarginTop, int desVideologoMarginRight) {
        this.mFilterSetting.setVideoDataPng(mBitmap, desVideologoMarginTop, desVideologoMarginRight);
        if (this.realWidth > 0 && this.realHeigth > 0) {
            this.mFilterSetting.resolveVideoDataPng(this.realWidth, this.realHeigth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ontDataPrepare(byte[] yuvData, int width, int height, Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
        FileterYuvData recoverYuvData = null;
        Object object = this.object;
        synchronized (object) {
            if (this.recoverDataList.size() > 0) {
                recoverYuvData = this.recoverDataList.remove(0);
            }
        }
        if (null == recoverYuvData) {
            GenseeLog.d((String)TAG, (String)"allocate yuvData recoverData");
            this.addData(new FileterYuvData(yuvData, width, height, rotation, flipHorizontal, flipVertical));
        } else {
            recoverYuvData.flipHorizontal = flipHorizontal;
            recoverYuvData.flipVertical = flipVertical;
            recoverYuvData.height = height;
            recoverYuvData.width = width;
            recoverYuvData.rotation = rotation;
            if (recoverYuvData.yuvData.length != yuvData.length) {
                FileterYuvData.access$502(recoverYuvData, new byte[yuvData.length]);
            }
            System.arraycopy(yuvData, 0, recoverYuvData.yuvData, 0, yuvData.length);
            this.addData(recoverYuvData);
        }
    }

    public void switchBeauty(boolean bOpen) {
        if (null != this.mGpuImageRenderer) {
            this.mFilterSetting.switchBeauty(bOpen);
        }
    }

    public void setVideoParam(VideoParam videoParam) {
        this.videoParam = videoParam;
    }

    public void startSendThread() {
        if (null != this.sendThread) {
            GenseeLog.w((String)TAG, (String)"startSendThread have thread is running");
            return;
        }
        try {
            this.initFile2();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.dataList.clear();
        this.width = -1;
        this.height = -1;
        this.rotation = Rotation.NORMAL;
        this.flipHorizontal = false;
        this.flipVertical = false;
        this.bSendFlag = true;
        if (null == this.sendThread) {
            this.sendThread = new Thread((Runnable)this, TAG);
            this.sendThread.start();
        }
    }

    public void releaseSendThread() {
        if (null != this.sendThread) {
            this.bConvert = false;
            this.bSendFlag = false;
            try {
                if (null != this.sendThread) {
                    this.sendThread.interrupt();
                    this.sendThread.join();
                }
                if (null != this.mConvertThread) {
                    this.mConvertThread.interrupt();
                    this.mConvertThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (null != this.dataList) {
                this.dataList.clear();
                this.dataList = null;
            }
            if (null != this.recoverDataList) {
                this.recoverDataList.clear();
                this.recoverDataList = null;
            }
            if (null != this.rgbDataList) {
                this.rgbDataList.clear();
                this.rgbDataList = null;
            }
            if (null != this.rgbRecoverDataList) {
                this.rgbRecoverDataList.clear();
                this.rgbRecoverDataList = null;
            }
            this.sendThread = null;
            this.mConvertThread = null;
        }
        if (null != this.mFilterSetting) {
            this.mFilterSetting.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addData(FileterYuvData data) {
        if (null != data) {
            Object object = this.object;
            synchronized (object) {
                if (this.dataList.size() >= 2) {
                    this.addRecoverDataYuv(data);
                    return;
                }
                this.dataList.add(data);
                this.object.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileterYuvData sendData() {
        Object object = this.object;
        synchronized (object) {
            if (this.dataList.size() > 0) {
                return this.dataList.remove(0);
            }
            try {
                this.object.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setOrientation(int ortation) {
        if (this.orientation != ortation) {
            this.orientation = ortation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.bSendFlag) {
            FileterYuvData data = this.sendData();
            if (null == data) continue;
            if (this.width != data.width || this.height != data.height || this.rotation != data.getRotation() || this.flipHorizontal != data.isFlipHorizontal() || this.flipVertical != data.isFlipVertical()) {
                if (null != this.mGpuImageRenderer) {
                    this.mGpuImageRenderer.destroyCameraFrameBuffer();
                }
                this.width = data.getWidth();
                this.height = data.getHeight();
                this.rotation = data.getRotation();
                this.flipHorizontal = data.isFlipHorizontal();
                this.flipVertical = data.isFlipVertical();
                int needWidth = null != this.videoParam ? this.videoParam.width : 320;
                int needHeight = null != this.videoParam ? this.videoParam.height : 240;
                int tmepWidth = needWidth;
                int tmepHeight = needHeight;
                if (this.realWidth != tmepWidth || this.realHeigth != tmepHeight) {
                    this.mFilterSetting.resolveVideoDataPng(tmepWidth, tmepHeight);
                }
                this.realWidth = tmepWidth;
                this.realHeigth = tmepHeight;
                this.mGpuImageRenderer.setScaleType(this.mScaleType);
                this.mGpuImageRenderer.setRotation(this.rotation, this.flipHorizontal, this.flipVertical);
                this.mGpuImageRenderer.setImageWH(this.width, this.height);
                if (null == this.pixelBuffer) {
                    this.pixelBuffer = new PixelBuffer(tmepWidth, tmepHeight);
                    this.pixelBuffer.setRenderer(this.mGpuImageRenderer);
                } else {
                    this.pixelBuffer.releaseEglSurface();
                    this.pixelBuffer.updateElgSurface(tmepWidth, tmepHeight);
                }
                this.mGpuImageRenderer.initCameraFrameBuffer(this.width, this.height);
                this.mGpuImageRenderer.setFlipHorizontalAndVertical(this.flipHorizontal, this.flipVertical);
                this.mGpuImageRenderer.onInputSizeChanged(this.width, this.height);
            }
            this.mGpuImageRenderer.setYuvData(data.getYuvData());
            int[] rgb = this.pixelBuffer.getBitmap();
            if (null == this.mConvertThread) {
                this.mConvertThread = new Thread(this.mConvertRunnable, "convertThread");
                this.mConvertThread.start();
                this.bConvert = true;
            }
            Object object = this.rgbObject;
            synchronized (object) {
                RGBData recoverData = null;
                if (this.rgbRecoverDataList.size() > 0) {
                    recoverData = this.rgbRecoverDataList.remove(0);
                }
                if (null == recoverData) {
                    GenseeLog.d((String)TAG, (String)"allocate recoverData RGBData");
                    recoverData = new RGBData();
                    RGBData.access$602(recoverData, new int[rgb.length]);
                }
                recoverData.width = this.realWidth;
                recoverData.height = this.realHeigth;
                if (recoverData.rgb.length != rgb.length) {
                    RGBData.access$602(recoverData, new int[rgb.length]);
                }
                System.arraycopy(rgb, 0, recoverData.rgb, 0, rgb.length);
                if (this.rgbDataList.size() <= 2) {
                    this.rgbDataList.add(recoverData);
                } else {
                    GenseeLog.d((String)TAG, (String)("rgbDataList filter list size = " + this.rgbDataList.size()));
                    this.addRecoverDataRgb(recoverData);
                }
                this.rgbObject.notifyAll();
            }
            this.addRecoverDataYuv(data);
        }
        if (null != this.pixelBuffer) {
            this.pixelBuffer.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecoverDataYuv(FileterYuvData data) {
        Object object = this.object;
        synchronized (object) {
            if (this.recoverDataList.size() <= 5) {
                this.recoverDataList.add(data);
            } else {
                GenseeLog.d((String)TAG, (String)("allocate recoverData yuvdata recoverDataList size = " + this.recoverDataList.size()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRecoverDataRgb(RGBData data) {
        Object object = this.rgbObject;
        synchronized (object) {
            if (this.rgbRecoverDataList.size() <= 5) {
                this.rgbRecoverDataList.add(data);
            } else {
                GenseeLog.d((String)TAG, (String)("filter allocate recoverData rgbdata rgbRecoverDataList size = " + this.rgbRecoverDataList.size()));
            }
        }
    }

    private void initFile2() throws IOException {
        File f = new File("/sdcard/android-yuv2.yuv");
        if (!f.exists()) {
            f.createNewFile();
        }
        this.streamYuv2 = new FileOutputStream(f);
    }

    public static interface OnPrepareDataSendListener {
        public void onSendData(byte[] var1, int var2, int var3);
    }

    private class FileterYuvData {
        private byte[] yuvData;
        private int width;
        private int height;
        private Rotation rotation;
        private boolean flipVertical;
        private boolean flipHorizontal;

        public FileterYuvData(byte[] yuvData, int width, int height, Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
            this.yuvData = yuvData;
            this.width = width;
            this.height = height;
            this.rotation = rotation;
            this.flipVertical = flipVertical;
            this.flipHorizontal = flipHorizontal;
        }

        public byte[] getYuvData() {
            return this.yuvData;
        }

        public void setYuvData(byte[] yuvData) {
            this.yuvData = yuvData;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public Rotation getRotation() {
            return this.rotation;
        }

        public void setRotation(Rotation rotation) {
            this.rotation = rotation;
        }

        public boolean isFlipVertical() {
            return this.flipVertical;
        }

        public void setFlipVertical(boolean flipVertical) {
            this.flipVertical = flipVertical;
        }

        public boolean isFlipHorizontal() {
            return this.flipHorizontal;
        }

        public void setFlipHorizontal(boolean flipHorizontal) {
            this.flipHorizontal = flipHorizontal;
        }

        public String toString() {
            return "FileterYuvData [yuvData=" + Arrays.toString(this.yuvData) + ", width=" + this.width + ", height=" + this.height + ", rotation=" + (Object)((Object)this.rotation) + ", flipVertical=" + this.flipVertical + ", flipHorizontal=" + this.flipHorizontal + "]";
        }

        static /* synthetic */ byte[] access$502(FileterYuvData x0, byte[] x1) {
            x0.yuvData = x1;
            return x1;
        }
    }

    private class RGBData {
        private int[] rgb;
        private int width;
        private int height;

        public RGBData(int[] rgb, int widht, int height) {
            this.rgb = rgb;
            this.width = widht;
            this.height = height;
        }

        public RGBData() {
        }

        static /* synthetic */ int[] access$602(RGBData x0, int[] x1) {
            x0.rgb = x1;
            return x1;
        }
    }
}

