/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.beauty;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import com.gensee.beauty.filter.gpuimage.GPUCameraInputFilter;
import com.gensee.beauty.filter.gpuimage.GPUImageFilter;
import com.gensee.beauty.filter.utils.OpenGlUtils;
import com.gensee.beauty.filter.utils.Rotation;
import com.gensee.beauty.filter.utils.TextureRotationUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import java.util.Queue;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

@TargetApi(value=11)
public class GPUImageRenderer
implements GLSurfaceView.Renderer {
    private static final String TAG = "GPUImageRenderer";
    public static final int NO_IMAGE = -1;
    static final float[] CUBE = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    private GPUImageFilter mFilter;
    private GPUCameraInputFilter mCameraInputFilter;
    public final Object mSurfaceChangedWaiter = new Object();
    private int mGLTextureId = -1;
    private SurfaceTexture mSurfaceTexture = null;
    private final FloatBuffer mGLCubeBuffer;
    private final FloatBuffer mGLTextureBuffer;
    private IntBuffer mGLRgbBuffer;
    private byte[] yuvData;
    private int mOutputWidth;
    private int mOutputHeight;
    private int mImageWidth;
    private int mImageHeight;
    private int mAddedPadding;
    private final Queue<Runnable> mRunOnDraw;
    private final Queue<Runnable> mRunOnDrawEnd;
    private Rotation mRotation;
    private boolean mFlipHorizontal;
    private boolean mFlipVertical;
    private ScaleType mScaleType = ScaleType.CENTER_CROP;
    private float mBackgroundRed = 0.0f;
    private float mBackgroundGreen = 0.0f;
    private float mBackgroundBlue = 0.0f;
    private OnDataPrepareListener mOnDataPrepareListener;
    private OnDataNotifyListener mOnDataNotifyListener;
    private FileOutputStream streamYuv2 = null;

    public void setOnDataPrepareListener(OnDataPrepareListener mOnDataPrepareListener) {
        this.mOnDataPrepareListener = mOnDataPrepareListener;
    }

    public void setOnDataNotifyListener(OnDataNotifyListener mOnDataNotifyListener) {
        this.mOnDataNotifyListener = mOnDataNotifyListener;
    }

    public GPUImageRenderer(GPUImageFilter filter) {
        this.mCameraInputFilter = new GPUCameraInputFilter();
        this.mFilter = filter;
        this.mRunOnDraw = new LinkedList<Runnable>();
        this.mRunOnDrawEnd = new LinkedList<Runnable>();
        this.mGLCubeBuffer = ByteBuffer.allocateDirect(CUBE.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mGLCubeBuffer.put(CUBE).position(0);
        this.mGLTextureBuffer = ByteBuffer.allocateDirect(TextureRotationUtil.TEXTURE_NO_ROTATION.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.setRotation(Rotation.NORMAL, false, false);
        try {
            this.initFile2();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onSurfaceCreated(GL10 unused, EGLConfig config) {
        this.destroy();
        GLES20.glClearColor((float)this.mBackgroundRed, (float)this.mBackgroundGreen, (float)this.mBackgroundBlue, (float)1.0f);
        GLES20.glDisable((int)2929);
        if (this.mCameraInputFilter == null) {
            this.mCameraInputFilter = new GPUCameraInputFilter();
        }
        this.mCameraInputFilter.init();
        if (null != this.mFilter) {
            this.mFilter.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.mOutputWidth = width;
        this.mOutputHeight = height;
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        if (null != this.mCameraInputFilter) {
            GLES20.glUseProgram((int)this.mCameraInputFilter.getProgram());
            this.mCameraInputFilter.onDisplaySizeChanged(width, height);
            this.mCameraInputFilter.initCameraFrameBuffer(this.mImageWidth, this.mImageHeight);
        }
        if (null != this.mFilter) {
            this.mFilter.onDisplaySizeChanged(width, height);
            this.mFilter.onInputSizeChanged(this.mImageWidth, this.mImageHeight);
        }
        this.adjustImageScaling();
        Object object = this.mSurfaceChangedWaiter;
        synchronized (object) {
            this.mSurfaceChangedWaiter.notifyAll();
        }
    }

    public void onDrawFrame(GL10 gl) {
        GLES20.glClear((int)16640);
        this.runAll(this.mRunOnDraw);
        byte[] data = this.yuvData;
        if (null != data && data.length > 0) {
            if (this.mFilter == null) {
                this.mCameraInputFilter.onDrawFrame(data, this.mGLCubeBuffer, this.mGLTextureBuffer);
            } else {
                int id = this.mCameraInputFilter.onDrawFrame(data);
                this.mFilter.onDrawFrame(id, this.mGLCubeBuffer, this.mGLTextureBuffer);
            }
        }
        this.runAll(this.mRunOnDrawEnd);
        try {
            if (this.mSurfaceTexture != null) {
                this.mSurfaceTexture.updateTexImage();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBackgroundColor(float red, float green, float blue) {
        this.mBackgroundRed = red;
        this.mBackgroundGreen = green;
        this.mBackgroundBlue = blue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAll(Queue<Runnable> queue) {
        Queue<Runnable> queue2 = queue;
        synchronized (queue2) {
            while (!queue.isEmpty()) {
                queue.poll().run();
            }
        }
    }

    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        this.yuvData = null;
        this.mSurfaceTexture = surfaceTexture;
    }

    public void notifyData(final byte[] data, final int width, final int height) {
        if (null == this.yuvData) {
            this.yuvData = new byte[width * height * 3 / 2];
        }
        if (this.mRunOnDraw.isEmpty()) {
            this.runOnDraw(new Runnable(){

                @Override
                public void run() {
                    byte[] dst = GPUImageRenderer.this.yuvData;
                    if (dst != null) {
                        System.arraycopy(data, 0, dst, 0, height * width * 3 / 2);
                        if (GPUImageRenderer.this.mImageWidth != width) {
                            GPUImageRenderer.this.mImageWidth = width;
                            GPUImageRenderer.this.mImageHeight = height;
                            GPUImageRenderer.this.adjustImageScaling();
                            if (null != GPUImageRenderer.this.mCameraInputFilter) {
                                GPUImageRenderer.this.mCameraInputFilter.initCameraFrameBuffer(GPUImageRenderer.this.mImageWidth, GPUImageRenderer.this.mImageHeight);
                            }
                            if (null != GPUImageRenderer.this.mFilter) {
                                GPUImageRenderer.this.mFilter.onInputSizeChanged(GPUImageRenderer.this.mImageWidth, GPUImageRenderer.this.mImageHeight);
                            }
                        }
                    }
                }
            });
        }
        if (null != this.mOnDataNotifyListener) {
            this.mOnDataNotifyListener.onNotifyData();
        }
        if (null != this.mOnDataPrepareListener) {
            this.mOnDataPrepareListener.ontDataPrepare(data, width, height, this.mRotation, this.mFlipHorizontal, this.mFlipVertical);
        }
    }

    public void setFilter(final GPUImageFilter filter) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GPUImageFilter oldFilter = GPUImageRenderer.this.mFilter;
                GPUImageRenderer.this.mFilter = filter;
                if (oldFilter != null) {
                    oldFilter.destroy();
                }
                if (null != GPUImageRenderer.this.mFilter) {
                    GPUImageRenderer.this.mFilter.init();
                    GLES20.glUseProgram((int)GPUImageRenderer.this.mFilter.getProgram());
                    GPUImageRenderer.this.mFilter.onDisplaySizeChanged(GPUImageRenderer.this.mOutputWidth, GPUImageRenderer.this.mOutputHeight);
                    GPUImageRenderer.this.mFilter.onInputSizeChanged(GPUImageRenderer.this.mImageWidth, GPUImageRenderer.this.mImageHeight);
                }
            }
        });
    }

    public void deleteImage() {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glDeleteTextures((int)1, (int[])new int[]{GPUImageRenderer.this.mGLTextureId}, (int)0);
                GPUImageRenderer.this.mGLTextureId = -1;
            }
        });
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.setImageBitmap(bitmap, true);
    }

    public void setYuvData(final byte[] yuvData) {
        if (yuvData == null) {
            return;
        }
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GPUImageRenderer.access$002(GPUImageRenderer.this, yuvData);
                GPUImageRenderer.this.adjustImageScaling();
            }
        });
    }

    public void setImageBitmap(final Bitmap bitmap, final boolean recycle) {
        if (bitmap == null) {
            return;
        }
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                Bitmap resizedBitmap = null;
                if (bitmap.getWidth() % 2 == 1) {
                    resizedBitmap = Bitmap.createBitmap((int)(bitmap.getWidth() + 1), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas can = new Canvas(resizedBitmap);
                    can.drawARGB(0, 0, 0, 0);
                    can.drawBitmap(bitmap, 0.0f, 0.0f, null);
                    GPUImageRenderer.this.mAddedPadding = 1;
                } else {
                    GPUImageRenderer.this.mAddedPadding = 0;
                }
                GPUImageRenderer.this.mGLTextureId = OpenGlUtils.loadTexture(resizedBitmap != null ? resizedBitmap : bitmap, GPUImageRenderer.this.mGLTextureId, recycle);
                if (resizedBitmap != null) {
                    resizedBitmap.recycle();
                }
                GPUImageRenderer.this.mImageWidth = bitmap.getWidth();
                GPUImageRenderer.this.mImageHeight = bitmap.getHeight();
                GPUImageRenderer.this.adjustImageScaling();
            }
        });
    }

    public void setScaleType(ScaleType scaleType) {
        this.mScaleType = scaleType;
    }

    protected int getFrameWidth() {
        return this.mOutputWidth;
    }

    protected int getFrameHeight() {
        return this.mOutputHeight;
    }

    private void adjustImageScaling() {
        float outputWidth = this.mOutputWidth;
        float outputHeight = this.mOutputHeight;
        if (this.mRotation == Rotation.ROTATION_270 || this.mRotation == Rotation.ROTATION_90) {
            outputWidth = this.mOutputHeight;
            outputHeight = this.mOutputWidth;
        }
        float ratio1 = outputWidth / (float)this.mImageWidth;
        float ratio2 = outputHeight / (float)this.mImageHeight;
        float ratioMax = Math.max(ratio1, ratio2);
        int imageWidthNew = Math.round((float)this.mImageWidth * ratioMax);
        int imageHeightNew = Math.round((float)this.mImageHeight * ratioMax);
        float ratioWidth = (float)imageWidthNew / outputWidth;
        float ratioHeight = (float)imageHeightNew / outputHeight;
        float[] cube = CUBE;
        float[] textureCords = TextureRotationUtil.getRotation(this.mRotation, this.mFlipHorizontal, this.mFlipVertical);
        if (this.mScaleType == ScaleType.CENTER_CROP) {
            float distHorizontal = (1.0f - 1.0f / ratioWidth) / 2.0f;
            float distVertical = (1.0f - 1.0f / ratioHeight) / 2.0f;
            textureCords = new float[]{this.addDistance(textureCords[0], distHorizontal), this.addDistance(textureCords[1], distVertical), this.addDistance(textureCords[2], distHorizontal), this.addDistance(textureCords[3], distVertical), this.addDistance(textureCords[4], distHorizontal), this.addDistance(textureCords[5], distVertical), this.addDistance(textureCords[6], distHorizontal), this.addDistance(textureCords[7], distVertical)};
        } else {
            cube = new float[]{CUBE[0] / ratioHeight, CUBE[1] / ratioWidth, CUBE[2] / ratioHeight, CUBE[3] / ratioWidth, CUBE[4] / ratioHeight, CUBE[5] / ratioWidth, CUBE[6] / ratioHeight, CUBE[7] / ratioWidth};
        }
        this.mGLCubeBuffer.clear();
        this.mGLCubeBuffer.put(cube).position(0);
        this.mGLTextureBuffer.clear();
        this.mGLTextureBuffer.put(textureCords).position(0);
    }

    private float addDistance(float coordinate, float distance) {
        return coordinate == 0.0f ? distance : 1.0f - distance;
    }

    public void setRotationCamera(Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
        this.setRotation(rotation, flipHorizontal, flipVertical);
    }

    public void setRotation(Rotation rotation) {
        this.mRotation = rotation;
        this.adjustImageScaling();
    }

    public void setRotation(Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
        this.mFlipHorizontal = flipHorizontal;
        this.mFlipVertical = flipVertical;
        this.setRotation(rotation);
    }

    public Rotation getRotation() {
        return this.mRotation;
    }

    public boolean isFlippedHorizontally() {
        return this.mFlipHorizontal;
    }

    public boolean isFlippedVertically() {
        return this.mFlipVertical;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOnDraw(Runnable runnable) {
        Queue<Runnable> queue = this.mRunOnDraw;
        synchronized (queue) {
            this.mRunOnDraw.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOnDrawEnd(Runnable runnable) {
        Queue<Runnable> queue = this.mRunOnDrawEnd;
        synchronized (queue) {
            this.mRunOnDrawEnd.add(runnable);
        }
    }

    public void initCameraFrameBuffer(final int mImageWidth, final int mImageHeight) {
        if (null != this.mCameraInputFilter) {
            this.runOnDraw(new Runnable(){

                @Override
                public void run() {
                    GPUImageRenderer.this.mCameraInputFilter.initCameraFrameBuffer(mImageWidth, mImageHeight);
                }
            });
        }
    }

    public void destroyCameraFrameBuffer() {
        if (null != this.mCameraInputFilter) {
            this.runOnDraw(new Runnable(){

                @Override
                public void run() {
                    GPUImageRenderer.this.mCameraInputFilter.destroyFramebuffers();
                }
            });
        }
    }

    public void setFlipHorizontalAndVertical(final boolean flipHorizontal, final boolean flipVertical) {
        if (null != this.mCameraInputFilter) {
            this.runOnDraw(new Runnable(){

                @Override
                public void run() {
                    GPUImageRenderer.this.mCameraInputFilter.setFlipHorizontalAndVertical(flipHorizontal, flipVertical);
                }
            });
        }
    }

    public void onInputSizeChanged(final int mImageWidth, final int mImageHeight) {
        if (null != this.mFilter) {
            this.runOnDraw(new Runnable(){

                @Override
                public void run() {
                    GPUImageRenderer.this.mFilter.onInputSizeChanged(mImageWidth, mImageHeight);
                }
            });
        }
    }

    public void setImageWH(int mWidth, int mHeigth) {
        this.mImageWidth = mWidth;
        this.mImageHeight = mHeigth;
    }

    private void initFile2() throws IOException {
        File f = new File("/sdcard/android-yuv2.yuv");
        if (!f.exists()) {
            f.createNewFile();
        }
        this.streamYuv2 = new FileOutputStream(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRunOnDraw() {
        Queue<Runnable> queue = this.mRunOnDraw;
        synchronized (queue) {
            this.mRunOnDraw.clear();
        }
        this.yuvData = null;
    }

    public void destroy() {
        this.yuvData = null;
        if (null != this.mFilter) {
            this.mFilter.destroy();
        }
        if (null != this.mCameraInputFilter) {
            this.mCameraInputFilter.destroy();
        }
    }

    static /* synthetic */ byte[] access$002(GPUImageRenderer x0, byte[] x1) {
        x0.yuvData = x1;
        return x1;
    }

    public static enum ScaleType {
        CENTER_INSIDE,
        CENTER_CROP;

    }

    public static interface OnDataPrepareListener {
        public void ontDataPrepare(byte[] var1, int var2, int var3, Rotation var4, boolean var5, boolean var6);
    }

    public static interface OnDataNotifyListener {
        public void onNotifyData();
    }
}

