/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.beauty;

import android.graphics.Bitmap;
import android.opengl.GLSurfaceView;
import android.util.Log;
import com.gensee.beauty.GPUImageRenderer;
import com.gensee.utils.GenseeLog;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL10;

public class PixelBuffer {
    static final String TAG = "PixelBuffer";
    static final boolean LIST_CONFIGS = false;
    GLSurfaceView.Renderer mRenderer;
    int mWidth;
    int mHeight;
    Bitmap mBitmap;
    EGL10 mEGL;
    EGLDisplay mEGLDisplay;
    EGLConfig[] mEGLConfigs;
    EGLConfig mEGLConfig;
    EGLContext mEGLContext;
    EGLSurface mEGLSurface;
    GL10 mGL;
    String mThreadOwner;
    private IntBuffer ib;

    public PixelBuffer(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.initEglContext();
        this.initEglSurface();
    }

    private void initEglContext() {
        int[] version = new int[2];
        this.mEGL = (EGL10)EGLContext.getEGL();
        this.mEGLDisplay = this.mEGL.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        this.mEGL.eglInitialize(this.mEGLDisplay, version);
        this.mEGLConfig = this.chooseConfig();
        int EGL_CONTEXT_CLIENT_VERSION = 12440;
        int[] attrib_list = new int[]{EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
        this.mEGLContext = this.mEGL.eglCreateContext(this.mEGLDisplay, this.mEGLConfig, EGL10.EGL_NO_CONTEXT, attrib_list);
    }

    public void updateElgSurface(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.initEglSurface();
        this.mRenderer.onSurfaceChanged(this.mGL, this.mWidth, this.mHeight);
    }

    private void initEglSurface() {
        int[] attribList = new int[]{12375, this.mWidth, 12374, this.mHeight, 12344};
        this.mEGLSurface = this.mEGL.eglCreatePbufferSurface(this.mEGLDisplay, this.mEGLConfig, attribList);
        this.mEGL.eglMakeCurrent(this.mEGLDisplay, this.mEGLSurface, this.mEGLSurface, this.mEGLContext);
        this.mGL = (GL10)this.mEGLContext.getGL();
        this.mThreadOwner = Thread.currentThread().getName();
    }

    public void setRenderer(GLSurfaceView.Renderer renderer) {
        this.mRenderer = renderer;
        if (!Thread.currentThread().getName().equals(this.mThreadOwner)) {
            Log.e((String)TAG, (String)"setRenderer: This thread does not own the OpenGL context.");
            return;
        }
        this.mRenderer.onSurfaceCreated(this.mGL, this.mEGLConfig);
        this.mRenderer.onSurfaceChanged(this.mGL, this.mWidth, this.mHeight);
    }

    public int[] getBitmap() {
        if (this.mRenderer == null) {
            Log.e((String)TAG, (String)"getBitmap: Renderer was not set.");
            return null;
        }
        if (!Thread.currentThread().getName().equals(this.mThreadOwner)) {
            Log.e((String)TAG, (String)"getBitmap: This thread does not own the OpenGL context.");
            return null;
        }
        this.mRenderer.onDrawFrame(this.mGL);
        return this.convertToBitmap();
    }

    public void destroy() {
        this.mRenderer.onDrawFrame(this.mGL);
        this.mRenderer.onDrawFrame(this.mGL);
        ((GPUImageRenderer)this.mRenderer).destroy();
        GenseeLog.d((String)TAG, (String)"destroy 1");
        this.releaseEglSurface();
        GenseeLog.d((String)TAG, (String)"destroy 2");
        this.mEGL.eglDestroyContext(this.mEGLDisplay, this.mEGLContext);
        GenseeLog.d((String)TAG, (String)"destroy 3");
        this.mEGL.eglTerminate(this.mEGLDisplay);
        GenseeLog.d((String)TAG, (String)"destroy 4");
    }

    public void releaseEglSurface() {
        this.mEGL.eglMakeCurrent(this.mEGLDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        this.mEGL.eglDestroySurface(this.mEGLDisplay, this.mEGLSurface);
    }

    private EGLConfig chooseConfig() {
        int[] attribList = new int[]{12325, 0, 12326, 0, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12344};
        int[] numConfig = new int[1];
        this.mEGL.eglChooseConfig(this.mEGLDisplay, attribList, null, 0, numConfig);
        int configSize = numConfig[0];
        this.mEGLConfigs = new EGLConfig[configSize];
        this.mEGL.eglChooseConfig(this.mEGLDisplay, attribList, this.mEGLConfigs, configSize, numConfig);
        return this.mEGLConfigs[0];
    }

    private void listConfig() {
        Log.i((String)TAG, (String)"Config List {");
        for (EGLConfig config : this.mEGLConfigs) {
            int d = this.getConfigAttrib(config, 12325);
            int s = this.getConfigAttrib(config, 12326);
            int r = this.getConfigAttrib(config, 12324);
            int g = this.getConfigAttrib(config, 12323);
            int b = this.getConfigAttrib(config, 12322);
            int a = this.getConfigAttrib(config, 12321);
            Log.i((String)TAG, (String)("    <d,s,r,g,b,a> = <" + d + "," + s + "," + r + "," + g + "," + b + "," + a + ">"));
        }
        Log.i((String)TAG, (String)"}");
    }

    private int getConfigAttrib(EGLConfig config, int attribute) {
        int[] value = new int[1];
        return this.mEGL.eglGetConfigAttrib(this.mEGLDisplay, config, attribute, value) ? value[0] : 0;
    }

    private int[] convertToBitmap() {
        if (this.ib == null || this.ib.array().length != this.mWidth * this.mHeight) {
            this.ib = IntBuffer.allocate(this.mWidth * this.mHeight);
        }
        this.ib.position(0);
        this.mGL.glReadPixels(0, 0, this.mWidth, this.mHeight, 6408, 5121, (Buffer)this.ib);
        int[] ia = this.ib.array();
        return ia;
    }
}

