/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.beauty;

import android.graphics.SurfaceTexture;
import android.opengl.GLSurfaceView;
import android.opengl.GLUtils;
import android.util.Log;
import com.gensee.utils.GenseeLog;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL10;

public class TextureViewRender
implements Runnable {
    private static final String TAG = "TextureViewRender";
    private SurfaceTexture surfaceTexture;
    static final boolean LIST_CONFIGS = false;
    GLSurfaceView.Renderer mRenderer;
    int mWidth;
    int mHeight;
    EGL10 mEGL;
    EGLDisplay mEGLDisplay;
    EGLConfig[] mEGLConfigs;
    EGLConfig mEGLConfig;
    EGLContext mEGLContext;
    EGLSurface mEGLSurface;
    GL10 mGL;
    String mThreadOwner;
    Thread glThread;
    private AtomicBoolean bRunning = new AtomicBoolean(false);
    private Object object;
    private AtomicBoolean bSurfaceChange = new AtomicBoolean(false);
    private AtomicBoolean bSurfaceUpdate = new AtomicBoolean(false);

    public TextureViewRender(SurfaceTexture surfaceTexture, int mWidth, int mHeight, GLSurfaceView.Renderer mRenderer) {
        this.surfaceTexture = surfaceTexture;
        this.mWidth = mWidth;
        this.mHeight = mHeight;
        this.mRenderer = mRenderer;
        this.object = new Object();
        this.bRunning.set(true);
        this.glThread = new Thread((Runnable)this, "texturerender");
        this.glThread.start();
    }

    public void updateSurfaceTexture(SurfaceTexture surfaceTexture, int mWidth, int mHeight) {
        this.mWidth = mWidth;
        this.mHeight = mHeight;
        this.surfaceTexture = surfaceTexture;
        this.bSurfaceUpdate.set(true);
        this.requestRender();
    }

    private EGLConfig chooseConfig() {
        int[] attribList = new int[]{12325, 0, 12326, 0, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12344};
        int[] numConfig = new int[1];
        this.mEGL.eglChooseConfig(this.mEGLDisplay, attribList, null, 0, numConfig);
        int configSize = numConfig[0];
        this.mEGLConfigs = new EGLConfig[configSize];
        this.mEGL.eglChooseConfig(this.mEGLDisplay, attribList, this.mEGLConfigs, configSize, numConfig);
        return this.mEGLConfigs[0];
    }

    private void listConfig() {
        Log.i((String)TAG, (String)"Config List {");
        for (EGLConfig config : this.mEGLConfigs) {
            int d = this.getConfigAttrib(config, 12325);
            int s = this.getConfigAttrib(config, 12326);
            int r = this.getConfigAttrib(config, 12324);
            int g = this.getConfigAttrib(config, 12323);
            int b = this.getConfigAttrib(config, 12322);
            int a = this.getConfigAttrib(config, 12321);
            Log.i((String)TAG, (String)("    <d,s,r,g,b,a> = <" + d + "," + s + "," + r + "," + g + "," + b + "," + a + ">"));
        }
        Log.i((String)TAG, (String)"}");
    }

    private EGLContext createContext(EGL10 egl, EGLDisplay eglDisplay, EGLConfig eglConfig) {
        int EGL_CONTEXT_CLIENT_VERSION = 12440;
        int[] attrs = new int[]{EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
        return egl.eglCreateContext(eglDisplay, eglConfig, EGL10.EGL_NO_CONTEXT, attrs);
    }

    private void initEglContext() {
        int[] version = new int[2];
        this.mEGL = (EGL10)EGLContext.getEGL();
        this.mEGLDisplay = this.mEGL.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        this.mEGL.eglInitialize(this.mEGLDisplay, version);
        this.mEGLConfig = this.chooseConfig();
        this.mEGLContext = this.createContext(this.mEGL, this.mEGLDisplay, this.mEGLConfig);
    }

    private void initEglSurface() {
        this.mEGLSurface = this.mEGL.eglCreateWindowSurface(this.mEGLDisplay, this.mEGLConfig, (Object)this.surfaceTexture, null);
        this.mGL = (GL10)this.mEGLContext.getGL();
        try {
            if (this.mEGLSurface == null || this.mEGLSurface == EGL10.EGL_NO_SURFACE) {
                throw new RuntimeException("GL error:" + GLUtils.getEGLErrorString((int)this.mEGL.eglGetError()));
            }
            if (!this.mEGL.eglMakeCurrent(this.mEGLDisplay, this.mEGLSurface, this.mEGLSurface, this.mEGLContext)) {
                throw new RuntimeException("GL Make current Error" + GLUtils.getEGLErrorString((int)this.mEGL.eglGetError()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mThreadOwner = Thread.currentThread().getName();
    }

    public synchronized void release() {
        this.bRunning.set(false);
        if (null != this.glThread) {
            try {
                this.requestRender();
                GenseeLog.d((String)TAG, (String)"release");
                this.glThread.interrupt();
                this.glThread = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void destroyEglSurface() {
        if (!this.mEGL.eglMakeCurrent(this.mEGLDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT)) {
            GenseeLog.w((String)TAG, (String)"eglMakeCurrent failure");
        }
        if (!this.mEGL.eglDestroySurface(this.mEGLDisplay, this.mEGLSurface)) {
            GenseeLog.w((String)TAG, (String)"eglDestroySurface failure");
        }
    }

    private void destroy() {
        this.destroyEglSurface();
        GenseeLog.d((String)TAG, (String)"release destroy3 ");
        if (!this.mEGL.eglDestroyContext(this.mEGLDisplay, this.mEGLContext)) {
            GenseeLog.w((String)TAG, (String)"eglDestroyContext failure");
        }
        GenseeLog.d((String)TAG, (String)"release destroy4 ");
        if (!this.mEGL.eglTerminate(this.mEGLDisplay)) {
            GenseeLog.w((String)TAG, (String)"eglTerminate failure");
        }
        GenseeLog.d((String)TAG, (String)"release destroy5 ");
    }

    private int getConfigAttrib(EGLConfig config, int attribute) {
        int[] value = new int[1];
        return this.mEGL.eglGetConfigAttrib(this.mEGLDisplay, config, attribute, value) ? value[0] : 0;
    }

    private void setRenderer(GLSurfaceView.Renderer renderer) {
        this.mRenderer = renderer;
        if (!Thread.currentThread().getName().equals(this.mThreadOwner)) {
            Log.e((String)TAG, (String)"setRenderer: This thread does not own the OpenGL context.");
            return;
        }
        this.mRenderer.onSurfaceCreated(this.mGL, this.mEGLConfig);
        this.mRenderer.onSurfaceChanged(this.mGL, this.mWidth, this.mHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRender() {
        Object object = this.object;
        synchronized (object) {
            this.object.notifyAll();
        }
    }

    public void surfaceChange(int width, int height) {
        if (this.mWidth != width || this.mHeight != height) {
            this.mWidth = width;
            this.mHeight = height;
            this.bSurfaceChange.set(true);
            this.requestRender();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.initEglContext();
        this.initEglSurface();
        this.setRenderer(this.mRenderer);
        while (this.bRunning.get()) {
            if (this.bSurfaceUpdate.get()) {
                this.bSurfaceUpdate.set(false);
                this.destroyEglSurface();
                this.initEglSurface();
                this.mRenderer.onSurfaceChanged(this.mGL, this.mWidth, this.mHeight);
            }
            if (this.bSurfaceChange.get()) {
                this.bSurfaceChange.set(false);
                this.mRenderer.onSurfaceChanged(this.mGL, this.mWidth, this.mHeight);
            }
            this.mRenderer.onDrawFrame(this.mGL);
            this.mEGL.eglSwapBuffers(this.mEGLDisplay, this.mEGLSurface);
            Object object = this.object;
            synchronized (object) {
                try {
                    if (this.bRunning.get()) {
                        this.object.wait();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.destroy();
    }
}

