/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.beauty.filter;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import com.gensee.beauty.GPUImageRenderer;
import com.gensee.beauty.filter.advanced.GPUBaseGroupFilter;
import com.gensee.beauty.filter.advanced.GPUImageNormalBlendFilter;
import com.gensee.beauty.filter.advanced.MagicBeautyFilter;
import com.gensee.beauty.filter.gpuimage.GPUImageFilter;
import java.util.ArrayList;

public class FilterSetting {
    private Bitmap mBlendSrcBitmap;
    private Bitmap mBlendDesBitmap;
    private GPUImageNormalBlendFilter mBlendFilter;
    private GPUImageFilter mFilter;
    private boolean bBeautyOpen = true;
    private GPUImageRenderer mRenderer;
    private int nVideoLogoMarignTop;
    private int nVideoLogoMarginRight;

    public FilterSetting() {
        this.init();
    }

    private ArrayList<GPUImageFilter> init() {
        ArrayList<GPUImageFilter> filters = new ArrayList<GPUImageFilter>();
        filters.add(new MagicBeautyFilter());
        this.mFilter = new GPUBaseGroupFilter(filters);
        return filters;
    }

    public GPUImageFilter getFilter() {
        if (null == this.mFilter) {
            this.mFilter = new GPUImageFilter();
        }
        return this.mFilter;
    }

    public void setVideoDataPng(Bitmap mBitmap) {
        this.mBlendSrcBitmap = mBitmap;
    }

    public void setVideoDataPng(Bitmap mBitmap, int nVideoLogoMarginTop, int nVideoLogoMarginRight) {
        this.nVideoLogoMarginRight = nVideoLogoMarginRight;
        this.nVideoLogoMarignTop = nVideoLogoMarginTop;
        this.mBlendSrcBitmap = mBitmap;
    }

    public void resolveVideoDataPng(int nWidth, int nHeight) {
        if (null != this.mBlendSrcBitmap && nWidth > 0 && nHeight > 0) {
            float sx;
            if (null != this.mBlendDesBitmap) {
                this.mBlendDesBitmap.recycle();
                this.mBlendDesBitmap = null;
            }
            this.mBlendDesBitmap = Bitmap.createBitmap((int)nWidth, (int)nHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas mCanvas = new Canvas(this.mBlendDesBitmap);
            BitmapDrawable d = new BitmapDrawable(this.mBlendSrcBitmap);
            d.setTargetDensity(this.mBlendSrcBitmap.getDensity());
            d.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
            Matrix matrix = new Matrix();
            float n1 = 0.2f;
            int nDes = 720 * this.mBlendSrcBitmap.getDensity() / 320;
            if (nWidth < nDes) {
                nDes = nWidth;
            }
            float sy = sx = (float)nDes * n1 / (float)this.mBlendSrcBitmap.getWidth();
            matrix.postScale(sx, sy);
            matrix.postTranslate((float)nWidth - n1 * (float)nDes - (float)this.nVideoLogoMarginRight, (float)this.nVideoLogoMarignTop);
            mCanvas.concat(matrix);
            d.draw(mCanvas);
            if (null == this.mBlendFilter) {
                this.mBlendFilter = new GPUImageNormalBlendFilter();
            }
            this.mBlendFilter.setBitmap(this.mBlendDesBitmap);
            ArrayList<GPUImageFilter> filters = this.init();
            if (!filters.contains(this.mBlendFilter)) {
                filters.add(this.mBlendFilter);
            }
            this.mRenderer.setFilter(this.mFilter);
        }
    }

    public void switchBeauty(boolean bOpen) {
        if (!bOpen) {
            if (null != this.mBlendDesBitmap) {
                if (null == this.mBlendFilter) {
                    this.mBlendFilter = new GPUImageNormalBlendFilter();
                }
                this.mBlendFilter.setBitmap(this.mBlendDesBitmap);
                this.mRenderer.setFilter(this.mBlendFilter);
            } else {
                this.mRenderer.setFilter(new GPUImageFilter());
            }
        } else {
            ArrayList<GPUImageFilter> filters = this.init();
            if (null != this.mBlendDesBitmap) {
                if (null == this.mBlendFilter) {
                    this.mBlendFilter = new GPUImageNormalBlendFilter();
                }
                this.mBlendFilter.setBitmap(this.mBlendDesBitmap);
                if (!filters.contains(this.mBlendFilter)) {
                    filters.add(this.mBlendFilter);
                }
            } else if (filters.contains(this.mBlendFilter)) {
                filters.remove(this.mBlendFilter);
            }
            this.mRenderer.setFilter(this.mFilter);
        }
        this.bBeautyOpen = bOpen;
    }

    public void release() {
        if (null != this.mBlendDesBitmap) {
            this.mBlendDesBitmap.recycle();
            this.mBlendDesBitmap = null;
        }
    }

    public void setRenderer(GPUImageRenderer mRenderer) {
        this.mRenderer = mRenderer;
    }
}

