/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.beauty.filter.gpuimage;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.opengl.GLES20;
import android.os.Environment;
import com.gensee.beauty.filter.utils.OpenGlUtils;
import com.gensee.beauty.filter.utils.Rotation;
import com.gensee.beauty.filter.utils.TextureRotationUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Calendar;
import java.util.LinkedList;

public class GPUImageFilter {
    public static final String NO_FILTER_VERTEX_SHADER = "attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}";
    public static final String NO_FILTER_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n \nuniform sampler2D inputImageTexture;\n \nvoid main()\n{\n     gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n}";
    private final LinkedList<Runnable> mRunOnDraw = new LinkedList();
    private final String mVertexShader;
    private final String mFragmentShader;
    protected int mGLProgId;
    protected int mGLAttribPosition;
    protected int mGLUniformTexture;
    protected int mGLAttribTextureCoordinate;
    protected int mIntputWidth;
    protected int mIntputHeight;
    protected boolean mIsInitialized;
    protected FloatBuffer mGLCubeBuffer;
    protected FloatBuffer mGLTextureBuffer;
    protected int mOutputWidth;
    protected int mOutputHeight;

    public GPUImageFilter() {
        this(NO_FILTER_VERTEX_SHADER, NO_FILTER_FRAGMENT_SHADER);
    }

    public GPUImageFilter(String vertexShader, String fragmentShader) {
        this.mVertexShader = vertexShader;
        this.mFragmentShader = fragmentShader;
        this.mGLCubeBuffer = ByteBuffer.allocateDirect(TextureRotationUtil.CUBE.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mGLCubeBuffer.put(TextureRotationUtil.CUBE).position(0);
        this.mGLTextureBuffer = ByteBuffer.allocateDirect(TextureRotationUtil.TEXTURE_NO_ROTATION.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mGLTextureBuffer.put(TextureRotationUtil.getRotation(Rotation.NORMAL, false, true)).position(0);
    }

    public void init() {
        this.onInit();
        this.mIsInitialized = true;
        this.onInitialized();
    }

    protected void onInit() {
        this.mGLProgId = OpenGlUtils.loadProgram(this.mVertexShader, this.mFragmentShader);
        this.mGLAttribPosition = GLES20.glGetAttribLocation((int)this.mGLProgId, (String)"position");
        this.mGLUniformTexture = GLES20.glGetUniformLocation((int)this.mGLProgId, (String)"inputImageTexture");
        this.mGLAttribTextureCoordinate = GLES20.glGetAttribLocation((int)this.mGLProgId, (String)"inputTextureCoordinate");
        this.mIsInitialized = true;
    }

    protected void onInitialized() {
    }

    public final void destroy() {
        this.mIsInitialized = false;
        GLES20.glDeleteProgram((int)this.mGLProgId);
        this.onDestroy();
    }

    protected void onDestroy() {
    }

    public void onInputSizeChanged(int width, int height) {
        this.mIntputWidth = width;
        this.mIntputHeight = height;
    }

    public int onDrawFrame(int textureId, FloatBuffer cubeBuffer, FloatBuffer textureBuffer) {
        GLES20.glUseProgram((int)this.mGLProgId);
        this.runPendingOnDrawTasks();
        if (!this.mIsInitialized) {
            return -1;
        }
        cubeBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mGLAttribPosition, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)cubeBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mGLAttribPosition);
        textureBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mGLAttribTextureCoordinate, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)textureBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mGLAttribTextureCoordinate);
        if (textureId != -1) {
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)textureId);
            GLES20.glUniform1i((int)this.mGLUniformTexture, (int)0);
        }
        this.onDrawArraysPre();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.mGLAttribPosition);
        GLES20.glDisableVertexAttribArray((int)this.mGLAttribTextureCoordinate);
        this.onDrawArraysAfter();
        GLES20.glBindTexture((int)3553, (int)0);
        return 1;
    }

    private String saveBitmap(Bitmap bitmap) {
        File file;
        File fileRoot = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + "/magiccamera/");
        if (!fileRoot.exists()) {
            fileRoot.mkdirs();
        }
        if ((file = new File(fileRoot.getPath(), Calendar.getInstance().getTimeInMillis() + ".png")).exists()) {
            file.delete();
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
            out.flush();
            out.close();
            bitmap.recycle();
            return file.toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public int onDrawFrame(int textureId) {
        GLES20.glUseProgram((int)this.mGLProgId);
        this.runPendingOnDrawTasks();
        if (!this.mIsInitialized) {
            return -1;
        }
        this.mGLCubeBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mGLAttribPosition, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mGLCubeBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mGLAttribPosition);
        this.mGLTextureBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mGLAttribTextureCoordinate, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mGLTextureBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mGLAttribTextureCoordinate);
        if (textureId != -1) {
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)textureId);
            GLES20.glUniform1i((int)this.mGLUniformTexture, (int)0);
        }
        this.onDrawArraysPre();
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.mGLAttribPosition);
        GLES20.glDisableVertexAttribArray((int)this.mGLAttribTextureCoordinate);
        this.onDrawArraysAfter();
        GLES20.glBindTexture((int)3553, (int)0);
        return 1;
    }

    protected void onDrawArraysPre() {
    }

    protected void onDrawArraysAfter() {
    }

    protected void runPendingOnDrawTasks() {
        while (!this.mRunOnDraw.isEmpty()) {
            this.mRunOnDraw.removeFirst().run();
        }
    }

    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public int getIntputWidth() {
        return this.mIntputWidth;
    }

    public int getIntputHeight() {
        return this.mIntputHeight;
    }

    public int getProgram() {
        return this.mGLProgId;
    }

    public int getAttribPosition() {
        return this.mGLAttribPosition;
    }

    public int getAttribTextureCoordinate() {
        return this.mGLAttribTextureCoordinate;
    }

    public int getUniformTexture() {
        return this.mGLUniformTexture;
    }

    protected void setInteger(final int location, final int intValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform1i((int)location, (int)intValue);
            }
        });
    }

    protected void setFloat(final int location, final float floatValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform1f((int)location, (float)floatValue);
            }
        });
    }

    protected void setFloatVec2(final int location, final float[] arrayValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform2fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
            }
        });
    }

    protected void setFloatVec3(final int location, final float[] arrayValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform3fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
            }
        });
    }

    protected void setFloatVec4(final int location, final float[] arrayValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform4fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
            }
        });
    }

    protected void setFloatArray(final int location, final float[] arrayValue) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform1fv((int)location, (int)arrayValue.length, (FloatBuffer)FloatBuffer.wrap(arrayValue));
            }
        });
    }

    protected void setPoint(final int location, final PointF point) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                float[] vec2 = new float[]{point.x, point.y};
                GLES20.glUniform2fv((int)location, (int)1, (float[])vec2, (int)0);
            }
        });
    }

    protected void setUniformMatrix3f(final int location, final float[] matrix) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniformMatrix3fv((int)location, (int)1, (boolean)false, (float[])matrix, (int)0);
            }
        });
    }

    protected void setUniformMatrix4f(final int location, final float[] matrix) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniformMatrix4fv((int)location, (int)1, (boolean)false, (float[])matrix, (int)0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOnDraw(Runnable runnable) {
        LinkedList<Runnable> linkedList = this.mRunOnDraw;
        synchronized (linkedList) {
            this.mRunOnDraw.addLast(runnable);
        }
    }

    public void onDisplaySizeChanged(int width, int height) {
        this.mOutputWidth = width;
        this.mOutputHeight = height;
    }
}

