/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.view.TextureView;
import com.gensee.utils.GenseeLog;
import com.gensee.videoparam.IVideoCoreInterface;
import com.gensee.videoparam.OnVideoHardEncodeDataCallback;
import com.gensee.view.ILocalVideoView;
import com.gensee.view.VideoCamera2Capture;
import com.gensee.view.VideoCameraCapture;
import com.gensee.view.VideoCapture;
import java.io.IOException;

public class LocalTextureVideoView
extends TextureView
implements TextureView.SurfaceTextureListener,
VideoCapture.OnCaptureCallBack,
ILocalVideoView {
    private static final String TAG = "LocalTextureVideoView";
    private VideoCapture capture = VideoCapture.isUseCamera2() ? new VideoCamera2Capture() : new VideoCameraCapture();
    private SurfaceTexture mHolder;

    public LocalTextureVideoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.capture.setOnCaptureCallBack(this);
        this.setSurfaceTextureListener(this);
    }

    public LocalTextureVideoView(Context context) {
        this(context, null);
    }

    public LocalTextureVideoView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        this.mHolder = surface;
        GenseeLog.i((String)("videocapture onSurfaceTextureAvailable capture.isPreviewing() = " + this.capture.isPreviewing()));
        this.capture.surfaceAvailable();
        this.configureTransform(width, height);
        GenseeLog.d((String)TAG, (String)("onSurfaceTextureAvailable width = " + width + " height = " + height));
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        GenseeLog.d((String)TAG, (String)("onSurfaceTextureSizeChanged width = " + width + " height = " + height));
        this.configureTransform(width, height);
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        this.capture.releaseCamera();
        this.mHolder = null;
        GenseeLog.d((String)TAG, (String)"onSurfaceTextureDestroyed ");
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    public boolean isCameraSwitchEnable() {
        return this.capture.isCameraSwitchEnable();
    }

    public void doCameraSwitch() {
        this.capture.doCameraSwitch();
    }

    public int getOrientation() {
        return this.capture.getOrientation();
    }

    public void setOrientation(int ortation) {
        this.capture.setOrientation(ortation);
    }

    private void configureTransform(int viewWidth, int viewHeight) {
        if (VideoCapture.isUseCamera2()) {
            GenseeLog.d((String)TAG, (String)("configureTransform viewWidth = " + viewWidth + " viewHeight = " + viewHeight));
            Matrix matrix = this.capture.getConfigureMatrix(viewWidth, viewHeight);
            if (null != matrix) {
                float[] vlaues = new float[9];
                matrix.getValues(vlaues);
                String sValues = "";
                for (float value : vlaues) {
                    sValues = sValues + ":" + value;
                }
                GenseeLog.d((String)TAG, (String)("configureTransform sValues = " + sValues));
                this.setTransform(matrix);
            }
        }
    }

    @Override
    public boolean isHolderCreated() {
        return this.mHolder != null;
    }

    public boolean close() {
        return this.capture.close();
    }

    public boolean open(Object param, IVideoCoreInterface iVideoCoreInterface) {
        this.capture.open(param, iVideoCoreInterface);
        this.post(new Runnable(){

            @Override
            public void run() {
                if (LocalTextureVideoView.this.getVisibility() != 0) {
                    LocalTextureVideoView.this.setVisibility(0);
                }
                LocalTextureVideoView.this.capture.cameraOpen();
            }
        });
        return false;
    }

    public Camera getCamera() {
        return this.capture.getCamera();
    }

    public void setHardEncode(boolean isHardEncode) {
        this.capture.setHardEncode(isHardEncode);
    }

    public boolean isVideoHardEncode() {
        return this.capture.isVideoHardEncode();
    }

    public void setOnCameraPermissionListener(ILocalVideoView.OnCameraPermissionListener onCameraPermissionListener) {
        this.capture.setOnCameraPermissionListener(onCameraPermissionListener);
    }

    public void setOnCameraInfoListener(ILocalVideoView.OnCameraInfoListener onCameraInfoListener) {
        this.capture.setOnCameraInfoListener(onCameraInfoListener);
    }

    @Override
    public boolean onSetPreviewHolder(Camera camera) throws IOException {
        if (camera != null && this.mHolder != null) {
            camera.setPreviewTexture(this.mHolder);
            return true;
        }
        return false;
    }

    @Override
    public SurfaceTexture getSurfaceTexTure() {
        return this.mHolder;
    }

    public void setVideoSize(int width, int height) {
        this.capture.setVideoSize(this.getContext(), width, height);
    }

    public void release() {
        this.capture.release();
    }

    public void setVideoCore(IVideoCoreInterface iVideoCoreInterface) {
        this.capture.setVideoCore(iVideoCoreInterface);
    }

    public void setHardEncodeDataCallback(OnVideoHardEncodeDataCallback callback) {
        this.capture.setHardEncodeDataCallback(callback);
    }

    public void setFps(int fps) {
        this.capture.setFps(fps);
    }

    public void setBitRate(int bitRate) {
        this.capture.setBitRate(bitRate);
    }

    public void switchFlashOnOrOff(boolean bOpen) {
        this.capture.switchFlashOnOrOff(bOpen);
    }

    public boolean isSupportFlashOnOrOff() {
        return this.capture.isSupportFlashOnOrOff();
    }

    public void focusOnTouch(double x, double y, int focusWidth, int focusHeight, int viewWidth, int viewHeight) {
        this.capture.focusOnTouch(x, y, focusWidth, focusHeight, viewWidth, viewHeight);
    }

    public boolean isSupportFocusAuto() {
        return this.capture.isSupportFocusAuto();
    }
}

