/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.gensee.utils.GenseeLog;
import com.gensee.videoparam.IVideoCoreInterface;
import com.gensee.videoparam.OnVideoHardEncodeDataCallback;
import com.gensee.view.ILocalVideoView;
import com.gensee.view.LocalTextureVideoView;
import com.gensee.view.LocalVideoView;

public class LocalVideoViewEx
extends FrameLayout
implements ILocalVideoView,
ILocalVideoView.OnCameraInfoListener {
    public static final int PREVIEW_SURFACE = 1;
    public static final int PREVIEW_TEXTURE = 2;
    private static final String TAG = "LocalVideoViewEx";
    private int mW;
    private int mH;
    private int mVideoW;
    private int mVideoH;
    private ILocalVideoView mVideoView;
    private FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
    private ILocalVideoView.OnCameraInfoListener onAppCameraInfoListener;

    public LocalVideoViewEx(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.addPreviewView(2);
    }

    public LocalVideoViewEx(Context context) {
        this(context, null);
    }

    public LocalVideoViewEx(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        GenseeLog.d((String)TAG, (String)("onSizeChanged w = " + w + " h = " + h + " mW = " + this.mW + " mH = " + this.mH));
        if (this.mW != w || this.mH != h) {
            this.mW = w;
            this.mH = h;
            this.post(new Runnable(){

                @Override
                public void run() {
                    LocalVideoViewEx.this.updateParam();
                }
            });
        }
    }

    private void updateParam() {
        GenseeLog.d((String)TAG, (String)("updateParam  mVideoW=" + this.mVideoW + " mVideoH=" + this.mVideoH + " mW=" + this.mW + " mH=" + this.mH + " videoView=" + this.mVideoView));
        if (this.mW > 0 && this.mH > 0 && this.mVideoH > 0 && this.mVideoW > 0) {
            float sx = (float)this.mW / (float)this.mVideoW;
            float sy = (float)this.mH / (float)this.mVideoH;
            float s = sx < sy ? sy : sx;
            this.params.width = (int)((float)this.mVideoW * s);
            this.params.height = (int)((float)this.mVideoH * s);
            this.params.leftMargin = this.params.rightMargin = (this.mW - this.params.width) / 2;
            this.params.bottomMargin = this.params.topMargin = (this.mH - this.params.height) / 2;
            if (this.mVideoView != null) {
                this.updateViewLayout((View)this.mVideoView, (ViewGroup.LayoutParams)this.params);
            }
        }
    }

    public void switchPreview(int viewType) {
        GenseeLog.d((String)TAG, (String)("switchPreview type" + viewType));
        if (viewType == 1) {
            if (!(this.mVideoView instanceof LocalVideoView)) {
                this.addPreviewView(viewType);
            }
        } else if (viewType == 2 && !(this.mVideoView instanceof LocalTextureVideoView)) {
            this.addPreviewView(viewType);
        }
    }

    private void addPreviewView(int viewType) {
        if (this.getChildCount() > 0) {
            this.removeAllViews();
        }
        Context context = this.getContext();
        this.mVideoView = viewType == 1 ? new LocalVideoView(context) : new LocalTextureVideoView(context);
        this.mVideoView.setOnCameraInfoListener((ILocalVideoView.OnCameraInfoListener)this);
        this.addView((View)this.mVideoView, (ViewGroup.LayoutParams)this.params);
    }

    public boolean isCameraSwitchEnable() {
        return this.mVideoView.isCameraSwitchEnable();
    }

    public void doCameraSwitch() {
        this.mVideoView.doCameraSwitch();
    }

    public int getOrientation() {
        return this.mVideoView.getOrientation();
    }

    public void setOrientation(int ortation) {
        this.mVideoView.setOrientation(ortation);
    }

    public boolean isHolderCreated() {
        return this.mVideoView.isHolderCreated();
    }

    public boolean close() {
        return this.mVideoView.close();
    }

    public boolean open(Object param, IVideoCoreInterface iVideoCoreInterface) {
        return this.mVideoView.open(param, iVideoCoreInterface);
    }

    public Camera getCamera() {
        return this.mVideoView.getCamera();
    }

    public void setHardEncode(boolean isHardEncode) {
        this.mVideoView.setHardEncode(isHardEncode);
    }

    public boolean isVideoHardEncode() {
        return this.mVideoView.isVideoHardEncode();
    }

    public void setVideoSize(int width, int height) {
        this.mVideoView.setVideoSize(width, height);
    }

    public void setOnCameraPermissionListener(ILocalVideoView.OnCameraPermissionListener onCameraPermissionListener) {
        this.mVideoView.setOnCameraPermissionListener(onCameraPermissionListener);
    }

    public void setOnCameraInfoListener(ILocalVideoView.OnCameraInfoListener onCameraInfoListener) {
        this.onAppCameraInfoListener = onCameraInfoListener;
    }

    public void onCameraInfo(Camera mCamera, Camera.CameraInfo cameraInfo, int cameraIndex) {
        if (this.onAppCameraInfoListener != null) {
            this.onAppCameraInfoListener.onCameraInfo(mCamera, cameraInfo, cameraIndex);
        }
    }

    public void onCameraOpen(boolean bOpenSuccess) {
        if (null != this.onAppCameraInfoListener) {
            this.onAppCameraInfoListener.onCameraOpen(bOpenSuccess);
        }
    }

    public void onManualFocus(boolean bFocused) {
        if (null != this.onAppCameraInfoListener) {
            this.onAppCameraInfoListener.onManualFocus(bFocused);
        }
    }

    public void onPreviewSize(int w, int h) {
        GenseeLog.d((String)TAG, (String)("onPreviewSize w=" + w + " mVideoW=" + this.mVideoW + " h=" + h + " mVideoH=" + this.mVideoH));
        if (w != this.mVideoW || h != this.mVideoH) {
            this.mVideoW = w;
            this.mVideoH = h;
            this.post(new Runnable(){

                @Override
                public void run() {
                    GenseeLog.d((String)LocalVideoViewEx.TAG, (String)("onPreviewSize  mVideoW=" + LocalVideoViewEx.this.mVideoW + " mVideoH=" + LocalVideoViewEx.this.mVideoH));
                    LocalVideoViewEx.this.updateParam();
                }
            });
            if (this.onAppCameraInfoListener != null) {
                this.onAppCameraInfoListener.onPreviewSize(w, h);
            }
        }
    }

    public void release() {
        this.mVideoView.release();
    }

    public void setZOrderOnTop(boolean isTop) {
        if (this.mVideoView instanceof LocalVideoView) {
            ((LocalVideoView)this.mVideoView).setZOrderOnTop(isTop);
        }
    }

    public void setZOrderMediaOverlay(boolean isTop) {
        if (this.mVideoView instanceof LocalVideoView) {
            ((LocalVideoView)this.mVideoView).setZOrderMediaOverlay(isTop);
        }
    }

    public void setVideoCore(IVideoCoreInterface iVideoCoreInterface) {
        this.mVideoView.setVideoCore(iVideoCoreInterface);
    }

    public void setHardEncodeDataCallback(OnVideoHardEncodeDataCallback callback) {
        this.mVideoView.setHardEncodeDataCallback(callback);
    }

    public void setFps(int fps) {
        this.mVideoView.setFps(fps);
    }

    public void setBitRate(int bitRate) {
        this.mVideoView.setBitRate(bitRate);
    }

    public void switchFlashOnOrOff(boolean bOpen) {
        this.mVideoView.switchFlashOnOrOff(bOpen);
    }

    public boolean isSupportFlashOnOrOff() {
        return this.mVideoView.isSupportFlashOnOrOff();
    }

    public void focusOnTouch(double x, double y, int focusWidth, int focusHeight, int viewWidth, int viewHeight) {
        this.mVideoView.focusOnTouch(x, y, focusWidth, focusHeight, viewWidth, viewHeight);
    }

    public boolean isSupportFocusAuto() {
        return this.mVideoView.isSupportFocusAuto();
    }
}

