/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.telephony.TelephonyManager;
import com.gensee.utils.GenseeLog;

public class PhoneStateReceiver
extends BroadcastReceiver {
    public static final String B_PHONE_STATE = "android.intent.action.PHONE_STATE";
    private OnPhoneStateListener onPhoneStateListener;

    public void setOnPhoneStateListener(OnPhoneStateListener onPhoneStateListener) {
        this.onPhoneStateListener = onPhoneStateListener;
    }

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (action.equals(B_PHONE_STATE)) {
            this.doReceivePhone(context, intent);
        }
    }

    public void doReceivePhone(Context context, Intent intent) {
        String phoneNumber = intent.getStringExtra("incoming_number");
        TelephonyManager telephony = (TelephonyManager)context.getSystemService("phone");
        int state = telephony.getCallState();
        switch (state) {
            case 1: {
                if (null != this.onPhoneStateListener) {
                    this.onPhoneStateListener.callRinging();
                }
                GenseeLog.i((String)("[Broadcast]callringing\u7b49\u5f85\u63a5\u7535\u8bdd=" + phoneNumber));
                break;
            }
            case 0: {
                GenseeLog.i((String)("[Broadcast]callringing\u7535\u8bdd\u6302\u65ad=" + phoneNumber));
                if (null == this.onPhoneStateListener) break;
                this.onPhoneStateListener.callOffHook();
                break;
            }
            case 2: {
                GenseeLog.i((String)("[Broadcast]callringing\u901a\u8bdd\u4e2d=" + phoneNumber));
                if (null == this.onPhoneStateListener) break;
                this.onPhoneStateListener.callRinging();
            }
        }
    }

    public static interface OnPhoneStateListener {
        public void callRinging();

        public void callOffHook();
    }
}

