/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import android.widget.TextView;
import com.gensee.db.PlayerChatDataBaseManager;
import com.gensee.db.PlayerQaDataBaseManager;
import com.gensee.fastsdk.core.RTLive;
import com.gensee.fastsdk.receiver.ConnectionReceiver;
import com.gensee.fastsdk.receiver.PhoneStateReceiver;
import com.gensee.fastsdk.service.LogCatService;
import com.gensee.fastsdk.ui.holder.LoadingViewHolder;
import com.gensee.fastsdk.ui.holder.chat.AbsChatImpl;
import com.gensee.fastsdk.ui.holder.chat.SimpleChatHolder;
import com.gensee.fastsdk.ui.view.CustomCloseBtnDialog;
import com.gensee.fastsdk.ui.view.CustomDialog;
import com.gensee.fastsdk.ui.view.CustomProgressDialog;
import com.gensee.fastsdk.ui.view.Danmaku;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.holder.chat.impl.MsgQueue;
import com.gensee.holder.qa.impl.QaMsgQueue;
import com.gensee.utils.GenseeLog;
import java.util.HashMap;

public class BaseActivity
extends Activity {
    protected View linLoadView;
    protected View linloadPb;
    protected View linLoadNetDisconnected;
    protected View relExit;
    protected View lyLoadText;
    protected TextView loadText;
    protected String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private CustomProgressDialog progressDialog;
    protected CustomDialog customDialog;
    protected CustomCloseBtnDialog customCloseBtnDialog;
    protected CustomDialog.Builder builder;
    protected CustomCloseBtnDialog.Builder builder2;
    private HashMap<Integer, Integer> errMap;
    private Intent serviceIntent;
    private SimpleChatHolder mChatHolder;
    protected AbsChatImpl chatImpl;
    protected int netStatus = 4;
    private ConnectionReceiver connectionReceiver;
    private PhoneStateReceiver phoneStateReceiver;
    protected Danmaku mDanmaku;
    protected LoadingViewHolder mLoadingViewHolder;

    public AbsChatImpl getChatImpl() {
        return this.chatImpl;
    }

    public void setSimpleChatHolder(SimpleChatHolder mChatHolder) {
        this.mChatHolder = mChatHolder;
    }

    public SimpleChatHolder getSimpleChatHolder() {
        return this.mChatHolder;
    }

    public CustomDialog.Builder getCustomDialogBuilder() {
        return this.builder;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        GenseeLog.i((String)"fast-sdk activity onCreate, now version is 7.0");
        this.getWindow().setFlags(128, 128);
        this.startLogService();
        try {
            this.deleteDatabase("GsPlayerChat.db");
            this.deleteDatabase("GsPlayerQa.db");
        }
        catch (Throwable e) {
            GenseeLog.i((String)("try catch removeCache deleteDataBase " + (null != e ? e.getMessage() : "")));
        }
        PlayerChatDataBaseManager playerDataBaseManager = new PlayerChatDataBaseManager(this.getApplicationContext());
        MsgQueue.getIns().initMsgDbHelper(playerDataBaseManager);
        PlayerQaDataBaseManager qaDataBaseManager = new PlayerQaDataBaseManager(this.getApplicationContext());
        QaMsgQueue.getIns().initMsgDbHelper(qaDataBaseManager);
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unRegisterReceiver();
        if (null != this.chatImpl) {
            this.chatImpl.release();
        }
    }

    public void startLoading() {
        this.showProgressDialog("");
    }

    public void startLoading(boolean canceledOnTouchOutside) {
        this.showProgressDialog("", canceledOnTouchOutside);
    }

    public void stopLoading() {
        this.dismissProgressDialog();
    }

    public void showProgressDialog(int resId) {
        if (resId > 0) {
            this.showProgressDialog(this.getString(resId));
        }
    }

    public void showProgressDialog(String msg) {
        this.showProgressDialog(msg, false);
    }

    public void showProgressDialog(String msg, boolean canceledOnTouchOutside) {
        if (null != this.progressDialog) {
            this.progressDialog.dismiss();
        } else {
            this.progressDialog = new CustomProgressDialog((Context)this, ResManager.getStyleId("Custom_Progress"));
        }
        this.progressDialog.show(msg, false, null);
        this.progressDialog.setCanceledOnTouchOutside(canceledOnTouchOutside);
    }

    public void dismissProgressDialog() {
        if (this.progressDialog != null && this.progressDialog.isShowing()) {
            this.progressDialog.dismiss();
        }
    }

    public void showDialog(String title, String msg) {
        this.showDialog(title, msg, this.getString(ResManager.getStringId("gs_sure")), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                BaseActivity.this.finish();
            }
        }, new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                dialog.dismiss();
                BaseActivity.this.finish();
            }
        });
    }

    public void showDialog(String title, String msg, String btnText, DialogInterface.OnClickListener l) {
        this.showDialog(title, msg, btnText, l, null);
    }

    public void showDialog(String title, String msg, String btnText, DialogInterface.OnClickListener l, DialogInterface.OnCancelListener cancelListener) {
        this.showDialog(title, msg, null, null, btnText, l, cancelListener);
    }

    public void cancelCustomDialog() {
        if (null != this.customDialog && this.customDialog.isShowing()) {
            this.customDialog.dismiss();
        }
    }

    public void cancelCustomBtnDialog() {
        if (null != this.customCloseBtnDialog && this.customCloseBtnDialog.isShowing()) {
            this.customCloseBtnDialog.dismiss();
        }
    }

    public void showDialog(String title, String msg, String btnText, DialogInterface.OnClickListener l, String cancelText, DialogInterface.OnClickListener cancelClickListener, DialogInterface.OnCancelListener cancelListener, int colorMode) {
        this.showDialog(title, msg, btnText, l, cancelText, cancelClickListener, cancelListener, colorMode, false);
    }

    public void showDialog(String title, String msg, String btnText, DialogInterface.OnClickListener l, String cancelText, DialogInterface.OnClickListener cancelClickListener, DialogInterface.OnCancelListener cancelListener, int colorMode, boolean isShowCloseBtn) {
        int nagativeColor;
        int positiveColor;
        if (this.isFinishing()) {
            return;
        }
        this.cancelCustomDialog();
        this.builder = new CustomDialog.Builder((Context)this);
        if (!"".equals(title) && title != null) {
            this.builder.setTitle(title);
        }
        this.builder.setIsShowCloseBtn(isShowCloseBtn);
        this.builder.setMessage(msg);
        this.builder.setPositiveButtonText("");
        this.builder.setPositiveButton(btnText, l);
        if (cancelText != null && !"".equals(cancelText)) {
            this.builder.setNegativeButton(cancelText, cancelClickListener);
        }
        this.customDialog = this.builder.create();
        if (colorMode == 1) {
            positiveColor = this.getResources().getColor(ResManager.getColorId("gs_dialog_btn_text_black"));
            nagativeColor = this.getResources().getColor(ResManager.getColorId("gs_dialog_btn_text_red"));
        } else if (colorMode == 2) {
            positiveColor = this.getResources().getColor(ResManager.getColorId("gs_dialog_btn_text_red"));
            nagativeColor = this.getResources().getColor(ResManager.getColorId("gs_dialog_btn_text_black"));
        } else {
            positiveColor = this.getResources().getColor(ResManager.getColorId("gs_dialog_btn_text_black"));
            nagativeColor = this.getResources().getColor(ResManager.getColorId("gs_dialog_btn_text_black"));
        }
        this.builder.setPositiveButtonTextColor(positiveColor);
        this.builder.setNegativeButtonTextColor(nagativeColor);
        this.customDialog.setCancelable(false);
        if (cancelListener != null) {
            this.customDialog.setOnCancelListener(cancelListener);
        }
        this.customDialog.show();
        WindowManager windowManager = this.getWindowManager();
        Display display = windowManager.getDefaultDisplay();
        WindowManager.LayoutParams lp = this.customDialog.getWindow().getAttributes();
        lp.width = display.getWidth();
        this.customDialog.getWindow().setAttributes(lp);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (null != this.customDialog && this.customDialog.isShowing()) {
            this.customDialog.onConfigChanged(this);
        }
    }

    public void showDialogWithTwoMsg(String msg2, String msg, String btnText, DialogInterface.OnClickListener l, String cancelText, DialogInterface.OnClickListener cancelClickListener, DialogInterface.OnCancelListener cancelListener, int colorMode, boolean isShowCloseBtn) {
        int nagativeColor;
        int positiveColor;
        if (this.isFinishing()) {
            return;
        }
        this.cancelCustomBtnDialog();
        this.builder2 = new CustomCloseBtnDialog.Builder((Context)this);
        this.builder2.setIsShowCloseBtn(isShowCloseBtn);
        this.builder2.setMessage(msg);
        this.builder2.setMessage2(msg2);
        this.builder2.setPositiveButtonText("");
        this.builder2.setPositiveButton(btnText, l);
        if (cancelText != null && !"".equals(cancelText)) {
            this.builder2.setNegativeButton(cancelText, cancelClickListener);
        }
        this.customCloseBtnDialog = this.builder2.create();
        if (colorMode == 1) {
            positiveColor = this.getResources().getColor(ResManager.getColorId("gs_dialog_btn_text_black"));
            nagativeColor = this.getResources().getColor(ResManager.getColorId("gs_dialog_btn_text_red"));
        } else if (colorMode == 2) {
            positiveColor = this.getResources().getColor(ResManager.getColorId("gs_dialog_btn_text_red"));
            nagativeColor = this.getResources().getColor(ResManager.getColorId("gs_dialog_btn_text_black"));
        } else {
            positiveColor = this.getResources().getColor(ResManager.getColorId("gs_dialog_btn_text_black"));
            nagativeColor = this.getResources().getColor(ResManager.getColorId("gs_dialog_btn_text_black"));
        }
        this.builder2.setPositiveButtonTextColor(positiveColor);
        this.builder2.setNegativeButtonTextColor(nagativeColor);
        this.customCloseBtnDialog.setCancelable(false);
        if (cancelListener != null) {
            this.customCloseBtnDialog.setOnCancelListener(cancelListener);
        }
        this.customCloseBtnDialog.show();
        WindowManager windowManager = this.getWindowManager();
        Display display = windowManager.getDefaultDisplay();
        WindowManager.LayoutParams lp = this.customCloseBtnDialog.getWindow().getAttributes();
        lp.width = display.getWidth();
        this.customCloseBtnDialog.getWindow().setAttributes(lp);
    }

    public void showDialog(String title, String msg, String btnText, DialogInterface.OnClickListener l, String cancelText, DialogInterface.OnClickListener cancelClickListener, DialogInterface.OnCancelListener cancelListener) {
        this.showDialog(title, msg, btnText, l, cancelText, cancelClickListener, cancelListener, 1);
    }

    public void showDialog(String msg) {
        this.showDialog("", msg);
    }

    public void showCancelErrMsg(String msg, String btnText) {
        this.showDialog("", msg, btnText, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
    }

    @SuppressLint(value={"UseSparseArrays"})
    private void initErrMap() {
        if (null == this.errMap) {
            this.errMap = new HashMap();
            this.errMap.put(-100, ResManager.getStringId("gs_domain_error"));
            this.errMap.put(-101, ResManager.getStringId("gs_domain_error"));
            this.errMap.put(-102, ResManager.getStringId("gs_domain_error"));
            this.errMap.put(-103, ResManager.getStringId("gs_domain_error"));
            this.errMap.put(-109, ResManager.getStringId("gs_domain_error"));
            this.errMap.put(-1, ResManager.getStringId("gs_domain_error"));
            this.errMap.put(-104, ResManager.getStringId("gs_net_disconnect"));
            this.errMap.put(-105, ResManager.getStringId("gs_error_data_timeout"));
            this.errMap.put(-106, ResManager.getStringId("gs_error_service"));
            this.errMap.put(-107, ResManager.getStringId("gs_error_param"));
            this.errMap.put(0, ResManager.getStringId("gs_error_number_unexist"));
            this.errMap.put(4, ResManager.getStringId("gs_error_token"));
            this.errMap.put(5, ResManager.getStringId("gs_error_login"));
            this.errMap.put(2, ResManager.getStringId("gs_error_role"));
            this.errMap.put(3, ResManager.getStringId("gs_error_fail_webcast"));
            this.errMap.put(6, ResManager.getStringId("gs_error_webcast_unstart"));
            this.errMap.put(7, ResManager.getStringId("gs_error_isonly_web"));
            this.errMap.put(8, ResManager.getStringId("gs_error_room_unenable"));
            this.errMap.put(9, ResManager.getStringId("gs_error_owner_error"));
            this.errMap.put(10, ResManager.getStringId("gs_error_invalid_address"));
            this.errMap.put(11, ResManager.getStringId("gs_error_room_overdue"));
            this.errMap.put(12, ResManager.getStringId("gs_error_authourization_not_enough"));
            this.errMap.put(13, ResManager.getStringId("gs_error_untimely"));
            this.errMap.put(18, ResManager.getStringId("gs_error_unsupport_mobile"));
        }
    }

    public String getErrStr(int resId) {
        this.initErrMap();
        if (null != this.errMap.get(resId)) {
            int resId1 = this.errMap.get(resId);
            if (resId1 <= 0) {
                return "";
            }
            String sReturn = this.getString(resId1);
            if (null == sReturn) {
                sReturn = "";
            }
            return sReturn;
        }
        return "";
    }

    protected void showErrDialog(String errorMsg, String sTip) {
        this.showDialog("", errorMsg, sTip, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                BaseActivity.this.finish();
            }
        });
    }

    protected void startLogService() {
        this.serviceIntent = new Intent((Context)this, LogCatService.class);
        this.startService(this.serviceIntent);
    }

    protected void stopLogService() {
        if (null != this.serviceIntent) {
            this.stopService(this.serviceIntent);
        }
    }

    protected void registerAppReceiver() {
        IntentFilter filter;
        if (null == this.connectionReceiver) {
            this.connectionReceiver = new ConnectionReceiver();
            filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            this.registerReceiver(this.connectionReceiver, filter);
        }
        if (null == this.phoneStateReceiver) {
            this.phoneStateReceiver = new PhoneStateReceiver();
            filter = new IntentFilter();
            filter.addAction("android.intent.action.PHONE_STATE");
            this.registerReceiver(this.phoneStateReceiver, filter);
            this.phoneStateReceiver.setOnPhoneStateListener(RTLive.getIns());
        }
    }

    protected void unRegisterReceiver() {
        if (null != this.connectionReceiver) {
            this.unregisterReceiver(this.connectionReceiver);
            this.connectionReceiver = null;
        }
        if (null != this.phoneStateReceiver) {
            this.unregisterReceiver(this.phoneStateReceiver);
            this.phoneStateReceiver = null;
        }
    }

    public void addDanmakuShowListener(Danmaku.OnShowDanmakuListener onShowDanmakuListener) {
        this.mDanmaku.addOnShowDanmakuListener(onShowDanmakuListener);
    }
}

