/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.alipay.sdk.app.PayTask;
import com.gensee.entity.InitParam;
import com.gensee.entity.PayInfo;
import com.gensee.entity.Reward;
import com.gensee.entity.RewardResult;
import com.gensee.fastsdk.core.GSFastConfig;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.receiver.ConnectionReceiver;
import com.gensee.fastsdk.ui.BaseActivity;
import com.gensee.fastsdk.ui.holder.RewardHolder;
import com.gensee.fastsdk.ui.holder.chat.impl.PlayerChatImpl;
import com.gensee.fastsdk.ui.holder.idc.IdcWhiteHolder;
import com.gensee.fastsdk.util.PayResult;
import com.gensee.fastsdk.util.PreferUtil;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.media.IVideoIndication;
import com.gensee.player.Player;
import com.gensee.utils.GenseeLog;
import com.gensee.view.GSDocViewGx;
import java.util.ArrayList;

public abstract class BaseWatchActivity
extends BaseActivity
implements ConnectionReceiver.OnNetSwitchListener {
    private Player mPlayer;
    private boolean bJoinSuccess;
    private Handler mHandler;
    private ArrayList<IdcWhiteHolder.FastIdc> idcList;
    public static final int STATUS_ON_VIDEO = 1001;
    public static final int LIVE_STATUS_NOT_START = 0;
    public static final int LIVE_STATUS_ING = 1;
    public static final int LIVE_STATUS_PAUSE = 2;
    public static final int LIVE_STATUS_END = 3;
    protected int live_status;
    protected RewardHolder rewardHolder;

    public int getLiveStatus() {
        return this.live_status;
    }

    public boolean isLiveStart() {
        return this.live_status != 0;
    }

    public void setRewardHolder(RewardHolder rewardHolder) {
        this.rewardHolder = rewardHolder;
    }

    public RewardHolder getRewardHolder() {
        return this.rewardHolder;
    }

    public ArrayList<IdcWhiteHolder.FastIdc> getIdcList() {
        return this.idcList;
    }

    public Player getmPlayer() {
        return this.mPlayer;
    }

    protected abstract int getContentViewResId();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        PreferUtil.initPref((Context)this);
        ResManager.getIns().init((Context)this);
        this.setContentView(this.getContentViewResId());
        GSFastConfig config = null;
        InitParam initParam = null;
        if (this.getIntent() != null) {
            config = (GSFastConfig)this.getIntent().getSerializableExtra("GS_FAST_CONFIG");
            initParam = (InitParam)this.getIntent().getSerializableExtra("GS_INIT_PARAM");
        }
        PlayerLive.getIns().init((Context)this, config, initParam);
        this.mPlayer = PlayerLive.getIns().getmPlayer();
        this.chatImpl = PlayerLive.getIns().getChatImpl();
        this.findViews(savedInstanceState);
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                switch (msg.what) {
                    case 1: {
                        BaseWatchActivity.this.onError((Integer)msg.obj);
                        break;
                    }
                    case 15: {
                        Bundle bundle = (Bundle)msg.obj;
                        boolean isOpen = bundle.getBoolean("isOpen");
                        if (!isOpen) {
                            if (BaseWatchActivity.this.customDialog != null && BaseWatchActivity.this.customDialog.isShowing()) {
                                BaseWatchActivity.this.customDialog.dismiss();
                            }
                            PlayerLive.getIns().micControl(false);
                            break;
                        }
                        BaseWatchActivity.this.acceptInviteMic();
                        break;
                    }
                    case 16: {
                        break;
                    }
                    case 2: {
                        BaseWatchActivity.this.onRoomJoinStatus();
                        BaseWatchActivity.this.onRoomJoin((Integer)msg.obj);
                        break;
                    }
                    case 3: {
                        BaseWatchActivity.this.onRoomReconnect();
                        break;
                    }
                    case 7: {
                        BaseWatchActivity.this.updateTitle((String)msg.obj);
                        break;
                    }
                    case 5: {
                        BaseWatchActivity.this.onVideoStart();
                        break;
                    }
                    case 6: {
                        BaseWatchActivity.this.onVideoOver();
                        break;
                    }
                    case 10: {
                        BaseWatchActivity.this.onRoomLeave((Integer)msg.obj);
                        break;
                    }
                    case 8: {
                        BaseWatchActivity.this.live_status = (Integer)msg.obj;
                        BaseWatchActivity.this.receiveState((Integer)msg.obj);
                        break;
                    }
                    case 11: {
                        BaseWatchActivity.this.adjustReceiverUI((Float)msg.obj);
                        break;
                    }
                    case 12: {
                        if (((Boolean)msg.obj).booleanValue()) {
                            if (BaseWatchActivity.this.live_status == 2) break;
                            BaseWatchActivity.this.showLoadingView(true);
                            break;
                        }
                        BaseWatchActivity.this.showLoadingView(false);
                        break;
                    }
                    case 20: {
                        BaseWatchActivity.this.onLiveInfo(msg.obj);
                    }
                }
            }
        };
        PlayerLive.getIns().setRoomHandler(this.mHandler);
        this.joinCheckNetwork();
    }

    protected void onLiveInfo(Object obj) {
    }

    private void join() {
        GenseeLog.i((String)this.TAG, (String)"start playerJoin");
        this.joinLoading();
        PlayerLive.getIns().playerJoin();
    }

    protected void joinCheckNetwork() {
        int netClassType;
        if (PlayerLive.getIns().getLiveStatus() != 1) {
            GenseeLog.e((String)this.TAG, (String)"joinCheckNetwork getLiveStatus() != PlayerLive.S_IDLE return!");
            return;
        }
        this.netStatus = netClassType = ConnectionReceiver.getNetType((Context)this);
        if (netClassType == 4) {
            this.join();
        } else if (netClassType == 5) {
            this.showErrDialog(this.getString(ResManager.getStringId("gs_net_no_network")), this.getString(ResManager.getStringId("gs_i_known")));
        } else {
            this.showDialogByNet(this.getNetTip(netClassType), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    BaseWatchActivity.this.join();
                }
            });
        }
    }

    @Override
    public void onSwitchMobile(int netClass) {
        GenseeLog.d((String)this.TAG, (String)("onSwitchMobile newStatus:" + netClass + ",netStatus:" + this.netStatus));
        if (netClass != this.netStatus) {
            this.netStatus = netClass;
            if (netClass != 4) {
                if (netClass == 5) {
                    this.showReconnectText(netClass);
                    return;
                }
                if (!this.isLiveStart()) {
                    this.showReconnectText(netClass);
                }
                this.showDialogByNet(this.getNetTip(netClass), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                    }
                });
            } else {
                this.showReconnectView(false);
            }
        }
    }

    private void showDialogByNet(String msg, DialogInterface.OnClickListener l) {
        this.showDialog(null, msg, this.getString(ResManager.getStringId("gs_exit")), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                BaseWatchActivity.this.finish();
            }
        }, this.getString(ResManager.getStringId("gs_continues")), l, null);
    }

    private String getNetTip(int netClassType) {
        switch (netClassType) {
            case 1: {
                return this.getString(ResManager.getStringId("gs_net_2g"));
            }
            case 2: {
                return this.getString(ResManager.getStringId("gs_net_3g"));
            }
            case 3: {
                return this.getString(ResManager.getStringId("gs_net_4g"));
            }
            case 5: {
                return this.getString(ResManager.getStringId("gs_net_disconnect"));
            }
        }
        return this.getString(ResManager.getStringId("gs_net_2g"));
    }

    public void onBackPressed() {
        if (!this.bJoinSuccess) {
            super.onBackPressed();
        } else {
            String title = this.getString(ResManager.getStringId("gs_exit_webcast"));
            this.showDialog("", title, this.getString(ResManager.getStringId("gs_cancel")), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            }, this.getString(ResManager.getStringId("gs_exit")), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    BaseWatchActivity.this.exit();
                    BaseWatchActivity.this.relExit.setVisibility(0);
                }
            }, null);
        }
    }

    @Override
    protected void onDestroy() {
        this.mHandler.removeMessages(8);
        this.stopLogService();
        this.bJoinSuccess = false;
        PlayerLive.getIns().release();
        super.onDestroy();
    }

    private void acceptInviteMic() {
        this.showDialog("", this.getString(ResManager.getStringId("gs_reminder_open_mic")), this.getString(ResManager.getStringId("gs_accept_mic_refuse")), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                PlayerLive.getIns().micControl(false);
            }
        }, this.getString(ResManager.getStringId("gs_accept_mic_open")), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                PlayerLive.getIns().micControl(true);
            }
        }, null);
    }

    private void onRoomJoin(int result) {
        int resId = 0;
        this.bJoinSuccess = false;
        switch (result) {
            case 7: {
                resId = 1;
                break;
            }
            case 8: {
                resId = ResManager.getStringId("gs_net_disconnect");
                break;
            }
            case 9: {
                resId = ResManager.getStringId("gs_join_webcast_timeout");
                break;
            }
            case 11: {
                this.receiveState(0);
                resId = ResManager.getStringId("gs_join_webcast_err_too_early");
                break;
            }
            case 12: {
                resId = ResManager.getStringId("gs_join_webcast_err_license");
                break;
            }
            case 6: {
                break;
            }
            case 17: {
                resId = ResManager.getStringId("gs_join_webcast_err_ip");
                break;
            }
        }
        if (resId == 0) {
            PlayerLive.getIns().setLiveStatus(result == 6 ? 3 : 1);
            this.bJoinSuccess = true;
            this.showLoadingView(false);
            this.onRoomJoinSuccess();
            this.registerAppReceiver();
        } else if (resId != 1) {
            this.showErrDialog(this.getString(resId), this.getString(ResManager.getStringId("gs_i_known")));
        }
    }

    public void onError(final int errorCode) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String errStr = "";
                errStr = errorCode == -108 ? BaseWatchActivity.this.getString(ResManager.getStringId("gs_join_webcast_err_third_auth")) : BaseWatchActivity.this.getErrStr(errorCode);
                BaseWatchActivity.this.showErrDialog(errStr, BaseWatchActivity.this.getString(ResManager.getStringId("gs_i_known")));
            }
        });
    }

    private void onRoomLeave(int result) {
        int resId = 0;
        if (result == 1) {
            this.relExit.setVisibility(8);
            this.exit();
            return;
        }
        String sTip = this.getString(ResManager.getStringId("gs_i_known"));
        if (result == 2) {
            resId = ResManager.getStringId("gs_leave_err_eject_tip");
        } else if (result == 4) {
            this.receiveState(3);
            resId = ResManager.getStringId("gs_leave_err_close_tip");
        } else {
            resId = result == 14 ? ResManager.getStringId("gs_leave_other_place_login") : (result == 5 ? ResManager.getStringId("gs_leave_unknow_reason") : ResManager.getStringId("gs_leave_unknow_reason"));
        }
        this.unRegisterReceiver();
        this.showErrDialog(this.getString(resId), sTip);
    }

    public void onRedBagTip(RewardResult rewardResult) {
        GenseeLog.i((String)this.TAG, (String)("onRedBagTip rewardResult:" + rewardResult));
        if (null != rewardResult && "tip".equals(rewardResult.getMsgType())) {
            String msg = rewardResult.getName() + this.getString(ResManager.getStringId("gs_tip_tiped"));
            if (null != this.chatImpl) {
                ((PlayerChatImpl)this.chatImpl).addTipMessage(msg);
            }
            this.addTipDanma(rewardResult.getName(), rewardResult.getTotal());
        }
    }

    public void onGotoPay(PayInfo payInfo) {
        GenseeLog.i((String)this.TAG, (String)("onGotoPay payInfo:" + payInfo));
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                BaseWatchActivity.this.stopLoading();
            }
        });
        if (null == payInfo) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    BaseWatchActivity.this.showCancelErrMsg(BaseWatchActivity.this.getString(ResManager.getStringId("gs_tip_server_fail")), BaseWatchActivity.this.getString(ResManager.getStringId("gs_i_known")));
                }
            });
            return;
        }
        String orderInfo = payInfo.getOrderInfo();
        PayTask alipay = new PayTask((Activity)this);
        String result = alipay.pay(orderInfo, true);
        GenseeLog.i((String)this.TAG, (String)("alipay.pay result:" + result));
        PayResult payResult = new PayResult(result);
        String resultStatus = payResult.getResultStatus();
        if (TextUtils.equals((CharSequence)resultStatus, (CharSequence)"9000")) {
            this.hideRewardPanel();
            GenseeLog.i((String)this.TAG, (String)"alipay success");
        } else if (TextUtils.equals((CharSequence)resultStatus, (CharSequence)"8000")) {
            GenseeLog.i((String)this.TAG, (String)"alipay not complete...");
        } else {
            GenseeLog.i((String)this.TAG, (String)"alipay fail");
        }
    }

    public void startAliPay(int money, String info) {
        this.startLoading();
        if (null != this.mPlayer) {
            GenseeLog.i((String)this.TAG, (String)("startAliPay money:" + money + ",info:" + info));
            Reward reward = new Reward();
            reward.setMoney(money);
            reward.setComment("congratulation");
            reward.setDesc("goodluck");
            this.mPlayer.reward(reward);
        }
    }

    protected void exit() {
        this.finish();
    }

    public void setVideoView(IVideoIndication gsVideoView) {
        if (null != this.mPlayer) {
            this.mPlayer.setGSVideoView(gsVideoView);
        }
    }

    public void setDocView(GSDocViewGx docViewGx) {
        if (null != this.mPlayer) {
            this.mPlayer.setGSDocViewGx(docViewGx);
        }
    }

    public void closeMic(boolean isOpen) {
        PlayerLive.getIns().micControl(isOpen);
    }

    protected void onPause() {
        if (this.mPlayer != null && this.bJoinSuccess) {
            this.mPlayer.audioSet(true);
        }
        super.onPause();
    }

    protected void onResume() {
        if (this.mPlayer != null && this.bJoinSuccess) {
            this.mPlayer.audioSet(false);
        }
        super.onResume();
    }

    public void showLinLoadPbView(boolean bTrue) {
        this.showLinLoadPbView(this.netStatus, bTrue);
    }

    protected void showLinLoadPbView(int netStatus, boolean bTrue) {
    }

    protected void onRoomReconnect() {
        this.live_status = 0;
        this.showLinLoadPbView(true);
    }

    public boolean isNoNet() {
        return this.netStatus == 5;
    }

    protected void onVideoStart() {
    }

    protected void onVideoOver() {
    }

    protected void receiveState(int state) {
    }

    protected void adjustReceiverUI(Float size) {
    }

    public void audioOpenUI() {
    }

    public void audioCloseUI() {
    }

    public void onAudioMicInvite(boolean bOpen) {
    }

    public void onVideoCameraInvite(boolean bOpen) {
    }

    public void videoOpenUI() {
    }

    public void videoCloseUI() {
    }

    protected void joinLoading() {
    }

    public void showRewardBtn(boolean isShow) {
    }

    protected void addTipDanma(String name, long total) {
    }

    protected void hideRewardPanel() {
    }

    protected void onRoomJoinSuccess() {
    }

    protected void onRoomJoinStatus() {
        this.showReconnectView(false);
    }

    protected abstract void updateTitle(String var1);

    protected abstract void findViews(Bundle var1);

    protected abstract void showLoadingView(boolean var1);

    protected abstract void showReconnectView(boolean var1);

    protected abstract void showReconnectText(int var1);
}

