/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder;

import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.gensee.chat.gif.SpanResource;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.fastsdk.ui.view.ResizeLayout;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.routine.UserInfo;
import com.gensee.view.ChatEditText;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;

public abstract class InputBottomHolder
extends BaseHolder
implements View.OnFocusChangeListener,
ResizeLayout.OnResizeListener {
    private static final int BOTTOM_TIP_LENGHT = 3000;
    public static final int SELECT_PUBLIC_INDEX = 0;
    public static final int SELECT_PRIVATE_INDEX = 1;
    public static final int SELECT_QA_INDEX = 2;
    public static final int SELECT_DOC_INDEX = 3;
    public static final int SELECT_INTRO_INDEX = 4;
    protected static final int KEYBOARD_SHOW = 1;
    protected static final int KEYBOARD_HIDE = 0;
    protected int keyBoradStatus = 0;
    protected int nCurSelectIndex;
    protected OnPublicChatBottomListener onPublicChatBottomListener;
    protected OnPrivateChatBottomListener onPrivateChatBottomListener;
    protected OnQaBottomListener onQaBottomListener;
    protected ChatEditText edtChat;
    protected ImageView ivAvatar;
    protected TextView tvSend;
    protected LinearLayout lyChat;
    protected View lyBottomTop;
    protected TextView tvChatTip;
    private InputMethodManager inputMethodManager;
    private long chatPreTime = 0L;
    private LinearLayout lyMsgBottom;
    private TextView tvMsgBottom;
    private int nSelelctSelfStatus = 0;
    private static final int PUBLIC_CHAT_SELECT_SELF = 1;
    private static final int QA_SELECT_SELF = 2;
    private String sPublicContent = "";
    protected String sQaContent = "";
    protected UserInfo tmpToUser = null;
    protected boolean bResume = true;
    protected String tmpQaName = null;
    protected ImageView ivSelectSelf;
    private Runnable msgBottomRunnable = new Runnable(){

        @Override
        public void run() {
            InputBottomHolder.this.lyMsgBottom.setVisibility(8);
        }
    };

    public InputBottomHolder(View rootView, Object value) {
        super(rootView, value);
    }

    public void setCurSelectIndex(int nCurSelectIndex) {
        if (this.nCurSelectIndex == 0) {
            this.sPublicContent = this.edtChat.getText().toString();
        } else if (this.nCurSelectIndex == 2) {
            this.sQaContent = this.edtChat.getText().toString();
        }
        this.nCurSelectIndex = nCurSelectIndex;
        if (this.nCurSelectIndex == 3 || this.nCurSelectIndex == 4) {
            return;
        }
        switch (nCurSelectIndex) {
            case 1: {
                this.ivSelectSelf.setVisibility(8);
                this.ivAvatar.setVisibility(0);
                this.edtChat.setText((CharSequence)"");
                this.emotionPanel(false);
                break;
            }
            case 0: {
                this.ivSelectSelf.setVisibility(0);
                this.ivSelectSelf.setSelected((this.nSelelctSelfStatus & 1) == 1);
                this.ivAvatar.setVisibility(0);
                this.emotionPanel(false);
                break;
            }
            case 2: {
                this.ivSelectSelf.setVisibility(0);
                this.ivSelectSelf.setSelected((this.nSelelctSelfStatus & 2) == 2);
                this.ivAvatar.setVisibility(8);
                this.emotionPanel(false);
            }
        }
        this.show(true);
    }

    @Override
    public void show(boolean bVisible) {
        this.rootView.setVisibility(bVisible ? 0 : 8);
    }

    public void onClick(View v) {
        if (v.getId() == ResManager.getId("gs_chat_send_tv")) {
            this.send();
        } else if (v.getId() == ResManager.getId("chat_bottom_self_iv")) {
            this.querySelf();
        }
    }

    @Override
    protected void initData(Object value) {
    }

    public void onStop() {
        this.bResume = false;
    }

    @Override
    protected void initComp(Object value) {
        if (null != this.rootView && this.rootView instanceof ResizeLayout) {
            ((ResizeLayout)this.rootView).setOnResizeListener(this);
        }
        this.lyBottomTop = this.findViewById(ResManager.getId("input_bottom_top_ly"));
        this.lyBottomTop.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                GenseeUtils.hideSoftInputmethod(InputBottomHolder.this.getContext());
                InputBottomHolder.this.emotionPanel(false);
                return false;
            }
        });
        this.edtChat = (ChatEditText)this.findViewById(ResManager.getId("gs_chat_content_edt"));
        this.edtChat.setOnClickListener((View.OnClickListener)this);
        this.edtChat.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.edtChat.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                InputBottomHolder.this.tvSend.setSelected(!TextUtils.isEmpty((CharSequence)s));
            }

            public void afterTextChanged(Editable s) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }
        });
        this.edtChat.setTextColor(this.getContext().getResources().getColorStateList(ResManager.getDrawableId("gs_selector_bottom_input_edt")));
        this.tvChatTip = (TextView)this.findViewById(ResManager.getId("gs_chat_tip_tv"));
        this.tvChatTip.setTextColor(this.getContext().getResources().getColor(ResManager.getColorId("chat_edit_view_unenaable")));
        this.ivAvatar = (ImageView)this.findViewById(ResManager.getId("gs_chat_avatar_iv"));
        this.ivAvatar.setOnClickListener((View.OnClickListener)this);
        this.ivAvatar.setBackground(this.getContext().getResources().getDrawable(ResManager.getDrawableId("gs_selector_chat_select_avatar_iv")));
        this.lyChat = (LinearLayout)this.findViewById(ResManager.getId("gs_chat_ly"));
        this.lyChat.setBackground(this.getContext().getResources().getDrawable(ResManager.getDrawableId("gs_chat_input_bg")));
        this.findViewById(ResManager.getId("chat_bottom_top_line")).setBackground(this.getContext().getResources().getDrawable(ResManager.getColorId("bottom_chat_top")));
        this.tvSend = (TextView)this.findViewById(ResManager.getId("gs_chat_send_tv"));
        this.tvSend.setOnClickListener((View.OnClickListener)this);
        this.tvSend.setTextColor(this.getContext().getResources().getColorStateList(ResManager.getDrawableId("gs_selector_send_tv")));
        this.initAvatar(this.rootView);
        this.lyMsgBottom = (LinearLayout)this.findViewById(ResManager.getId("gs_msg_bottom_ly"));
        this.lyMsgBottom.setBackground(this.getContext().getResources().getDrawable(ResManager.getColorId("msg_bottom_bg")));
        this.tvMsgBottom = (TextView)this.findViewById(ResManager.getId("gs_msg_bottom_tv"));
        this.tvMsgBottom.setTextColor(this.getContext().getResources().getColor(ResManager.getColorId("msg_bottom_text")));
        this.findViewById(ResManager.getId("chat_bottom_ll")).setBackground(this.getContext().getResources().getDrawable(ResManager.getColorId("chat_bottom_bg")));
        this.nCurSelectIndex = 3;
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (v.getId() == ResManager.getId("gs_chat_content_edt")) {
            // empty if block
        }
    }

    protected void chatLyBg() {
        if (this.lyChat.isEnabled()) {
            this.lyChat.setBackgroundResource(ResManager.getDrawableId("gs_chat_input_bg"));
        } else {
            this.lyChat.setBackgroundResource(ResManager.getDrawableId("gs_chat_input_bg_unable"));
        }
    }

    public void hideKeyBoard() {
        if (null == this.inputMethodManager && this.inputMethodManager == null) {
            this.inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        }
        this.inputMethodManager.hideSoftInputFromWindow(this.edtChat.getWindowToken(), 0);
    }

    public void showKeyBoard() {
        this.edtChat.setFocusable(true);
        this.edtChat.setFocusableInTouchMode(true);
        this.edtChat.requestFocus();
        if (this.inputMethodManager == null) {
            this.inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
        }
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                InputBottomHolder.this.inputMethodManager.toggleSoftInputFromWindow(InputBottomHolder.this.edtChat.getWindowToken(), 1, 0);
            }
        }, 100L);
    }

    protected void hide() {
        this.edtChat.setText((CharSequence)"");
        this.hideKeyBoard();
    }

    protected void initAvatar(View view) {
    }

    private void send() {
        String sContent = this.edtChat.getRichText();
        if ("".equals(sContent)) {
            return;
        }
        if (PlayerLive.getIns().isReconnecting()) {
            this.showMsgBottom(this.getString(ResManager.getStringId("gs_net_have_disconnect_tip")));
            return;
        }
        if (this.processPublicChatDisable()) {
            return;
        }
        long nCurrent = Calendar.getInstance().getTimeInMillis();
        if (nCurrent - this.chatPreTime > 2000L) {
            String sText = (this.nCurSelectIndex == 2 ? this.edtChat.getText() : this.edtChat.getChatText()).toString();
            this.send(sText, sContent);
            this.hide();
            if (this.nCurSelectIndex == 0) {
                this.sPublicContent = "";
            } else if (this.nCurSelectIndex == 2) {
                this.sQaContent = "";
            }
            this.chatPreTime = nCurrent;
        } else {
            this.showMsgBottom(this.getString(ResManager.getStringId("gs_chat_quickly")));
        }
    }

    protected abstract boolean processPublicChatDisable();

    protected void insertValue(String sValue) {
        this.edtChat.insertAvatar(sValue, 0);
    }

    private void querySelf() {
        this.ivSelectSelf.setSelected(!this.ivSelectSelf.isSelected());
        switch (this.nCurSelectIndex) {
            case 0: {
                int n = this.nSelelctSelfStatus = this.ivSelectSelf.isSelected() ? this.nSelelctSelfStatus | 1 : this.nSelelctSelfStatus & 0xFFFFFFFE;
                if (null != this.onPublicChatBottomListener) {
                    this.onPublicChatBottomListener.querySelfMsg(this.ivSelectSelf.isSelected());
                }
                if (this.ivSelectSelf.isSelected() || !this.getString(ResManager.getStringId("gs_chat_only_me")).equals(this.tvMsgBottom.getText())) break;
                if (null != this.msgBottomRunnable) {
                    this.removeCallbacks(this.msgBottomRunnable);
                }
                this.lyMsgBottom.setVisibility(8);
                break;
            }
            case 2: {
                int n = this.nSelelctSelfStatus = this.ivSelectSelf.isSelected() ? this.nSelelctSelfStatus | 2 : this.nSelelctSelfStatus & 0xFFFFFFFD;
                if (null == this.onQaBottomListener) break;
                this.onQaBottomListener.querySelfMsg(this.ivSelectSelf.isSelected());
            }
        }
    }

    protected void send(String text, String rich) {
    }

    public void setOnPublicChatBottomListener(OnPublicChatBottomListener onPublicChatBottomListener) {
        this.onPublicChatBottomListener = onPublicChatBottomListener;
    }

    public void setOnPrivateChatBottomListener(OnPrivateChatBottomListener onPrivateChatBottomListener) {
        this.onPrivateChatBottomListener = onPrivateChatBottomListener;
    }

    public void onChatMode(final int nChatMode) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (nChatMode == 0) {
                    InputBottomHolder.this.chatEnable(true, 0);
                } else if (nChatMode == 1) {
                    InputBottomHolder.this.chatEnable(true, 0);
                }
            }
        });
    }

    protected void showMsgBottom(String msg) {
        if (this.lyMsgBottom.getVisibility() != 0) {
            this.lyMsgBottom.setVisibility(0);
        }
        this.tvMsgBottom.setText((CharSequence)msg);
        if (null != this.msgBottomRunnable) {
            this.removeCallbacks(this.msgBottomRunnable);
            this.postDelayed(this.msgBottomRunnable, 3000L);
        }
    }

    public void showChatEdt() {
        this.edtChat.setText((CharSequence)SpanResource.convetToSpan((String)this.sPublicContent, (Context)this.getContext()));
    }

    protected void chatEnable(boolean bTrue, int chatTip) {
        this.edtChat.setVisibility(bTrue ? 0 : 8);
        this.tvSend.setEnabled(bTrue);
        this.lyChat.setEnabled(bTrue);
        this.ivAvatar.setEnabled(bTrue);
        this.tvChatTip.setVisibility(bTrue ? 8 : 0);
        this.chatLyBg();
        if (bTrue) {
            this.edtChat.setText((CharSequence)SpanResource.convetToSpan((String)this.sPublicContent, (Context)this.getContext()));
            this.edtChat.setSelection(this.edtChat.getText().length());
        } else {
            this.tvChatTip.setText(chatTip);
            this.ivAvatar.setSelected(false);
            this.emotionPanel(false);
            this.hideKeyBoard();
        }
    }

    public void setOnQaBottomListener(OnQaBottomListener onQaBottomListener) {
        this.onQaBottomListener = onQaBottomListener;
    }

    @Override
    public void OnResize(int h, int oldh) {
        if (h < oldh) {
            if (this.keyBoradStatus != 1) {
                this.keyBoradStatus = 1;
                this.lyChat.setTag((Object)true);
                this.chatLyBg();
                this.keyBoardShow(true);
            }
        } else if (this.keyBoradStatus != 0) {
            this.keyBoradStatus = 0;
            this.lyChat.setTag((Object)false);
            this.chatLyBg();
            this.keyBoardShow(false);
        }
    }

    public void onResume() {
        this.bResume = true;
        this.onHistoryPrivateMsg();
        this.onHistoryQaMsg();
    }

    public void onHistoryPrivateMsg() {
        if (null != this.tmpToUser && (this.nCurSelectIndex == 0 || this.nCurSelectIndex == 1)) {
            this.removeMessages(40001);
            UserInfo info = new UserInfo();
            info.setId(this.tmpToUser.getId());
            info.setName(this.tmpToUser.getName());
            this.sendMessage(40001, info);
            this.tmpToUser = null;
        }
    }

    public void onHistoryQaMsg() {
        if (null != this.tmpQaName && this.nCurSelectIndex == 2) {
            this.removeMessages(40002);
            String info = new String(this.tmpQaName);
            this.sendMessage(40002, info);
            this.tmpQaName = null;
        }
    }

    protected void keyBoardShow(boolean bVisible) {
    }

    protected void emotionPanel(boolean bVisible) {
    }

    public boolean isSelfSelected() {
        return this.ivSelectSelf.isSelected();
    }

    public static interface OnPublicChatBottomListener {
        public void querySelfMsg(boolean var1);

        public void sendPublicMsg(String var1, String var2);

        public boolean isLvBottom();

        public boolean isSelfLvBottom();

        public int getChatMode();
    }

    public static interface OnQaBottomListener {
        public boolean isSelfLvBottom();

        public boolean isLvBottom();

        public void sendQaMsg(String var1);

        public void querySelfMsg(boolean var1);
    }

    public static interface OnPrivateChatBottomListener {
        public void sendPrivateMsg(String var1, String var2);

        public long getToUserId();

        public boolean isLvBottom();
    }
}

