/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder;

import android.app.Activity;
import android.content.DialogInterface;
import android.util.DisplayMetrics;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.BaseActivity;
import com.gensee.fastsdk.ui.LiveActivity;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.utils.GenseeLog;
import com.gensee.view.ILocalVideoView;
import com.gensee.view.LocalTextureVideoView;
import java.util.Calendar;

public class ReceiverLocalVideoHolder
extends BaseHolder
implements ILocalVideoView.OnCameraPermissionListener,
View.OnTouchListener {
    private static final String TAG = "ReceiverLocalVideoHolder";
    private LocalTextureVideoView localTextureVideoView;
    private ImageView ivClose;
    private RelativeLayout rlBorder;
    private RelativeLayout.LayoutParams portraitLayoutParams;
    private RelativeLayout.LayoutParams landScapeLayoutParams;
    private RelativeLayout parentRootView;
    private int portraitLeft = -1;
    private int portraitTop = -1;
    private GestureDetector detector;
    private GSListener gsListener;
    private Runnable dismissRunnable = new Runnable(){

        @Override
        public void run() {
            ReceiverLocalVideoHolder.this.showBorder(false);
        }
    };
    private ImageView ivSwitchCamera;
    private int nBottomMargin = 0;
    private int nLeftMargin = 0;
    private int lastLeft = 0;
    private int lastTop = 0;
    private static int SINGLE_CLICK_TIME_INTERVER = 300;
    private static int SINGLE_CLICK_DISTANCE = 10;
    private int nDownx;
    private int nDowny;
    private long nDownTimeStamp;
    private boolean bRemoveFlag = false;

    public void setBottomAndLeftMargin(int bottomMargin, int leftMargin) {
        this.nBottomMargin = bottomMargin;
        this.nLeftMargin = leftMargin;
        if (PlayerLive.getIns().isVideoCameraOpen()) {
            if (this.portraitLeft < this.nLeftMargin) {
                this.portraitLeft = this.nLeftMargin;
            }
            if (this.portraitTop + this.rootView.getHeight() > this.parentRootView.getBottom() - this.nBottomMargin) {
                this.portraitTop = this.parentRootView.getBottom() - this.rootView.getBottom() - this.nBottomMargin;
            }
            this.setPosition();
        }
    }

    private void delayDismissRunnable() {
        this.postDelayed(this.dismissRunnable, 3000L);
    }

    private void showBorder(boolean bVisible) {
        this.rlBorder.setVisibility(bVisible ? 0 : 8);
        if (bVisible) {
            this.delayDismissRunnable();
        } else {
            this.removeCallbacks(this.dismissRunnable);
        }
    }

    public void onCameraPermission() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (!GenseeUtils.checkPackagePermission(ReceiverLocalVideoHolder.this.getContext(), "android.permission.CAMERA")) {
                    ((BaseActivity)ReceiverLocalVideoHolder.this.getContext()).showCancelErrMsg(ReceiverLocalVideoHolder.this.getString(ResManager.getStringId("package_no_camera_perssmion")), ReceiverLocalVideoHolder.this.getString(ResManager.getStringId("gs_i_known")));
                }
            }
        });
    }

    public ReceiverLocalVideoHolder(View rootView, Object value) {
        super(rootView, value);
        this.parentRootView = (RelativeLayout)value;
    }

    public void onClick(View v) {
        if (v.getId() == ResManager.getId("receiverLocalVideoCloseIv")) {
            PlayerLive.getIns().acceptOpenCamera(false);
            this.rootView.setVisibility(8);
        } else if (v.getId() == ResManager.getId("receiverLocalVideoSwitchIv") && null != this.localTextureVideoView) {
            this.localTextureVideoView.doCameraSwitch();
        }
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        this.localTextureVideoView = (LocalTextureVideoView)this.findViewById(ResManager.getId("receiverlocalvideoview"));
        this.localTextureVideoView.setOnCameraPermissionListener((ILocalVideoView.OnCameraPermissionListener)this);
        this.ivClose = (ImageView)this.findViewById(ResManager.getId("receiverLocalVideoCloseIv"));
        this.ivSwitchCamera = (ImageView)this.findViewById(ResManager.getId("receiverLocalVideoSwitchIv"));
        this.setOrientation(1);
        if (this.detector == null) {
            this.gsListener = new GSListener();
            this.detector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)this.gsListener);
        }
        this.rlBorder = (RelativeLayout)this.findViewById(ResManager.getId("border_rl"));
        this.rootView.setOnTouchListener((View.OnTouchListener)this);
    }

    public void setLocalTextureVideoView() {
        PlayerLive.getIns().setLocalTextureVideoView(this.localTextureVideoView);
    }

    public void setOrientation(int orientation) {
        GenseeLog.i((String)TAG, (String)("setOrientation orientation:" + orientation));
        GenseeLog.i((String)TAG, (String)("setOrientation isVideoCameraOpen:" + PlayerLive.getIns().isVideoCameraOpen()));
        GenseeLog.i((String)TAG, (String)("setOrientation bRemoveFlag:" + this.bRemoveFlag));
        this.localTextureVideoView.setOrientation(GenseeUtils.getVideoCaptureOrientation(orientation));
        if (PlayerLive.getIns().isVideoCameraOpen() && !this.bRemoveFlag) {
            if (orientation == 1) {
                this.setPotraitLayoutParams();
            } else {
                this.setLandScapeParams();
            }
            this.initDefaultPosition();
        }
    }

    private void setPotraitLayoutParams() {
        this.portraitLayoutParams = new RelativeLayout.LayoutParams(this.localTextureVideoView.getLayoutParams());
        DisplayMetrics mDisplayMetrics = new DisplayMetrics();
        ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getMetrics(mDisplayMetrics);
        int screenWidth = Math.max(mDisplayMetrics.widthPixels, mDisplayMetrics.heightPixels);
        screenWidth = (int)((double)screenWidth * 0.3);
        int modWidth = screenWidth % 16;
        if (modWidth > 0) {
            screenWidth += 16 - modWidth;
        }
        this.portraitLayoutParams.width = screenWidth;
        int needHeight = this.portraitLayoutParams.width * 4 / 3;
        int nHeigth = this.portraitLayoutParams.width * 9 / 16;
        int margin = (needHeight - nHeigth) / 2;
        this.portraitLayoutParams.height = needHeight;
        this.portraitLayoutParams.topMargin = -margin;
        this.portraitLayoutParams.bottomMargin = -margin;
        this.portraitLayoutParams.addRule(13, 1);
        this.localTextureVideoView.setLayoutParams((ViewGroup.LayoutParams)this.portraitLayoutParams);
    }

    private void setLandScapeParams() {
        this.landScapeLayoutParams = new RelativeLayout.LayoutParams(this.localTextureVideoView.getLayoutParams());
        DisplayMetrics mDisplayMetrics = new DisplayMetrics();
        ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getMetrics(mDisplayMetrics);
        int screenWidth = Math.max(mDisplayMetrics.widthPixels, mDisplayMetrics.heightPixels);
        screenWidth = (int)((double)screenWidth * 0.3);
        int modWidth = screenWidth % 16;
        if (modWidth > 0) {
            screenWidth += 16 - modWidth;
        }
        this.landScapeLayoutParams.width = screenWidth;
        int needHeight = this.landScapeLayoutParams.width * 3 / 4;
        int nHeigth = this.landScapeLayoutParams.width * 9 / 16;
        int margin = (needHeight - nHeigth) / 2;
        this.landScapeLayoutParams.height = needHeight;
        this.landScapeLayoutParams.topMargin = -margin;
        this.landScapeLayoutParams.bottomMargin = -margin;
        this.landScapeLayoutParams.addRule(13, 1);
        this.localTextureVideoView.setLayoutParams((ViewGroup.LayoutParams)this.landScapeLayoutParams);
    }

    private void processLocalViewSize() {
        DisplayMetrics mDisplayMetrics = new DisplayMetrics();
        ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getMetrics(mDisplayMetrics);
        int screenWidth = Math.max(mDisplayMetrics.widthPixels, mDisplayMetrics.heightPixels);
        screenWidth = (int)((double)screenWidth * 0.3);
        int modWidth = screenWidth % 16;
        if (modWidth > 0) {
            screenWidth += 16 - modWidth;
        }
        int nWidth = screenWidth;
        int nHeigth = nWidth * 9 / 16;
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.rootView.getLayoutParams();
        lp.width = nWidth;
        lp.height = nHeigth;
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public void initDefaultPosition() {
        Activity act = (Activity)this.getContext();
        int uimode = ((LiveActivity)this.getContext()).getUIMode();
        if (act.getRequestedOrientation() == 1 && (uimode & 1) != 1) {
            this.portraitLeft = 0;
            this.portraitTop = ((LiveActivity)this.getContext()).getReceiveLocalVideoTop();
        } else {
            int nInitLeftMargin = this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("fullscreen_small_show_left"));
            this.portraitLeft = Math.max(this.nLeftMargin, nInitLeftMargin);
            int screenWidth = Math.max(this.getContext().getResources().getDisplayMetrics().widthPixels, this.getContext().getResources().getDisplayMetrics().heightPixels);
            int nWidth = screenWidth * 3 / 10;
            int nHeight = nWidth * 9 / 16;
            this.portraitTop = this.getContext().getResources().getDisplayMetrics().heightPixels - nHeight * 2 - this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("fullscreen_small_show_bottom")) - this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("fullscreen_small_show_mid"));
        }
        this.setPosition();
    }

    public void onVideoOpen() {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (ReceiverLocalVideoHolder.this.bRemoveFlag) {
                    return;
                }
                ReceiverLocalVideoHolder.this.processLocalViewSize();
                Activity act = (Activity)ReceiverLocalVideoHolder.this.getContext();
                if (act.getRequestedOrientation() == 1) {
                    ReceiverLocalVideoHolder.this.setPotraitLayoutParams();
                } else {
                    ReceiverLocalVideoHolder.this.setLandScapeParams();
                }
                ReceiverLocalVideoHolder.this.initDefaultPosition();
                ReceiverLocalVideoHolder.this.show(true);
                ReceiverLocalVideoHolder.this.delayDismissRunnable();
            }
        });
    }

    @Override
    public void show(boolean isShow) {
        if (!isShow) {
            if (null != this.rootView.getParent()) {
                RelativeLayout.LayoutParams lp;
                if (null != this.localTextureVideoView && null != this.localTextureVideoView.getParent()) {
                    lp = new RelativeLayout.LayoutParams(1, 1);
                    this.localTextureVideoView.setLayoutParams((ViewGroup.LayoutParams)lp);
                }
                lp = (RelativeLayout.LayoutParams)this.rootView.getLayoutParams();
                lp.width = 1;
                lp.height = 1;
                this.rootView.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        } else {
            super.show(isShow);
        }
    }

    private void setPosition() {
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.rootView.getLayoutParams();
        lp.leftMargin = this.portraitLeft;
        lp.topMargin = this.portraitTop;
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.lastLeft = (int)event.getRawX();
                this.lastTop = (int)event.getRawY();
                this.nDownx = this.lastLeft;
                this.nDowny = this.lastTop;
                this.nDownTimeStamp = Calendar.getInstance().getTimeInMillis();
                break;
            }
            case 2: {
                int x = (int)event.getRawX();
                int y = (int)event.getRawY();
                int moveX = x - this.lastLeft;
                int moveY = y - this.lastTop;
                this.portraitLeft += moveX;
                if (this.portraitLeft < this.nLeftMargin) {
                    this.portraitLeft = this.nLeftMargin;
                }
                if (this.portraitLeft + this.rootView.getWidth() > this.parentRootView.getRight()) {
                    this.portraitLeft = this.parentRootView.getRight() - this.rootView.getWidth();
                }
                this.portraitTop += moveY;
                if (this.portraitTop < 0) {
                    this.portraitTop = 0;
                }
                if (this.portraitTop + this.rootView.getHeight() > this.parentRootView.getBottom() - this.nBottomMargin) {
                    this.portraitTop = this.parentRootView.getBottom() - this.rootView.getHeight() - this.nBottomMargin;
                }
                this.lastLeft = x;
                this.lastTop = y;
                this.setPosition();
                break;
            }
            case 1: 
            case 3: {
                if (this.rlBorder.getVisibility() != 0) break;
                int nUpx = (int)event.getRawX();
                int nUpy = (int)event.getRawY();
                long nUpTimeStamp = Calendar.getInstance().getTimeInMillis();
                if (Math.abs(nUpx - this.nDownx) > SINGLE_CLICK_DISTANCE || Math.abs(nUpy - this.nDowny) > SINGLE_CLICK_DISTANCE || nUpTimeStamp - this.nDownTimeStamp > (long)SINGLE_CLICK_TIME_INTERVER) break;
                boolean bTrue = false;
                int[] closeScreenPosition = new int[2];
                this.ivClose.getLocationOnScreen(closeScreenPosition);
                if (this.nDownx >= closeScreenPosition[0] && this.nDownx <= closeScreenPosition[0] + this.ivClose.getWidth() && this.nDowny >= closeScreenPosition[1] && this.nDowny <= closeScreenPosition[1] + this.ivClose.getHeight()) {
                    this.onClick((View)this.ivClose);
                    bTrue = true;
                }
                if (bTrue) break;
                int[] switchScreenPosition = new int[2];
                this.ivSwitchCamera.getLocationOnScreen(switchScreenPosition);
                if (this.nDownx < switchScreenPosition[0] || this.nDownx > switchScreenPosition[0] + this.ivSwitchCamera.getWidth() || this.nDowny < switchScreenPosition[1] || this.nDowny > switchScreenPosition[1] + this.ivSwitchCamera.getHeight()) break;
                this.onClick((View)this.ivSwitchCamera);
            }
        }
        this.detector.onTouchEvent(event);
        return true;
    }

    public void removeView() {
        this.showBorder(false);
        this.rootView.setOnTouchListener(null);
        this.parentRootView.removeView(this.rootView);
        this.bRemoveFlag = true;
    }

    public void restoreView() {
        if (this.bRemoveFlag) {
            this.showBorder(true);
            this.rootView.setOnTouchListener((View.OnTouchListener)this);
            RelativeLayout.LayoutParams rp = new RelativeLayout.LayoutParams(-2, -2);
            Activity act = (Activity)this.getContext();
            if (act.getRequestedOrientation() == 1) {
                this.setPotraitLayoutParams();
            } else {
                this.setLandScapeParams();
            }
            rp.topMargin = this.portraitTop;
            rp.leftMargin = this.portraitLeft;
            View lotterView = this.parentRootView.findViewById(ResManager.getId("lottery_ly"));
            int index = this.parentRootView.indexOfChild(lotterView);
            if (index >= 0) {
                this.parentRootView.addView(this.rootView, index, (ViewGroup.LayoutParams)rp);
            } else {
                this.parentRootView.addView(this.rootView, (ViewGroup.LayoutParams)rp);
            }
            this.bRemoveFlag = false;
        }
    }

    public LocalTextureVideoView getlocalTextureVideoView() {
        return this.localTextureVideoView;
    }

    public void doCameraSwitch() {
        if (null != this.localTextureVideoView) {
            this.localTextureVideoView.doCameraSwitch();
        }
    }

    public void showLocalVideoScreen(boolean isShow) {
        this.localTextureVideoView.setVisibility(isShow ? 0 : 8);
    }

    public void onVideoCameraOpen() {
        this.post(new Runnable(){

            @Override
            public void run() {
                ReceiverLocalVideoHolder.this.show(true);
            }
        });
    }

    public void onVideoCameraClose() {
        this.post(new Runnable(){

            @Override
            public void run() {
                ReceiverLocalVideoHolder.this.show(false);
            }
        });
    }

    public void onVideoCameraInvite(final boolean bOpen) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (bOpen) {
                    ((BaseActivity)ReceiverLocalVideoHolder.this.getContext()).showDialog("", ReceiverLocalVideoHolder.this.getString(ResManager.getStringId("gs_reminder_open_camera_normal")), ReceiverLocalVideoHolder.this.getString(ResManager.getStringId("gs_accept_mic_refuse")), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            PlayerLive.getIns().cameraControl(false);
                            PlayerLive.getIns().restoreAudioMicInvite();
                        }
                    }, ReceiverLocalVideoHolder.this.getString(ResManager.getStringId("gs_accept_mic_open")), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            PlayerLive.getIns().cameraControl(true);
                            PlayerLive.getIns().restoreAudioMicInvite();
                        }
                    }, null);
                } else {
                    ((BaseActivity)ReceiverLocalVideoHolder.this.getContext()).cancelCustomDialog();
                    PlayerLive.getIns().restoreAudioMicInvite();
                }
            }
        });
    }

    private class GSListener
    extends GestureDetector.SimpleOnGestureListener {
        private GSListener() {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            ReceiverLocalVideoHolder.this.showBorder(ReceiverLocalVideoHolder.this.rlBorder.getVisibility() != 0);
            return false;
        }
    }
}

